/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageModel;
import com.applozic.mobicommons.json.GsonUtils;
import com.bumptech.glide.Glide;
import java.util.Arrays;
import java.util.List;

public class AlImageAdapter
extends RecyclerView.Adapter {
    private Context context;
    private ALRichMessageModel model;
    private ALRichMessageListener listener;
    private Message message;
    private List<ALRichMessageModel.ALPayloadModel> payloadList;
    private AlCustomizationSettings alCustomizationSettings;

    public AlImageAdapter(Context context, ALRichMessageModel model, ALRichMessageListener listener, Message message, AlCustomizationSettings alCustomizationSettings) {
        this.context = context;
        this.model = model;
        this.listener = listener;
        this.message = message;
        this.alCustomizationSettings = alCustomizationSettings;
        if (model.getPayload() != null) {
            this.payloadList = Arrays.asList((ALRichMessageModel.ALPayloadModel[])GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel[].class));
        }
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_image_rich_message_layout, parent, false);
        return new ImageViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (this.payloadList != null && !this.payloadList.isEmpty()) {
            ALRichMessageModel.ALPayloadModel payloadModel = this.payloadList.get(position);
            ImageViewHolder imageViewHolder = (ImageViewHolder)holder;
            if (payloadModel != null) {
                if (this.alCustomizationSettings != null) {
                    GradientDrawable bgShape = (GradientDrawable)imageViewHolder.rootLayout.getBackground();
                    bgShape.setColor(Color.parseColor((String)(this.message.isTypeOutbox() ? this.alCustomizationSettings.getSentMessageBackgroundColor() : this.alCustomizationSettings.getReceivedMessageBackgroundColor())));
                    bgShape.setStroke(3, this.message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageBorderColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageBackgroundColor()));
                }
                if (!TextUtils.isEmpty((CharSequence)payloadModel.getUrl())) {
                    Glide.with((Context)this.context).load(payloadModel.getUrl()).into(imageViewHolder.imageView);
                } else {
                    Glide.with((Context)this.context).load(Integer.valueOf(R.drawable.mobicom_attachment_file)).into(imageViewHolder.imageView);
                }
                if (payloadModel.getCaption() != null && !TextUtils.isEmpty((CharSequence)payloadModel.getCaption().trim())) {
                    imageViewHolder.captionText.setVisibility(0);
                    imageViewHolder.captionText.setText((CharSequence)payloadModel.getCaption());
                    imageViewHolder.captionText.setTextColor(Color.parseColor((String)(this.message.isTypeOutbox() ? this.alCustomizationSettings.getSentMessageTextColor() : this.alCustomizationSettings.getReceivedMessageTextColor())));
                } else {
                    imageViewHolder.captionText.setVisibility(8);
                }
            }
        }
    }

    public int getItemCount() {
        return this.payloadList != null ? this.payloadList.size() : 0;
    }

    public class ImageViewHolder
    extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView captionText;
        LinearLayout rootLayout;

        public ImageViewHolder(View itemView) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.alImageView);
            this.captionText = (TextView)itemView.findViewById(R.id.alCaptionText);
            this.rootLayout = (LinearLayout)itemView.findViewById(R.id.rootLayout);
            if (AlImageAdapter.this.listener != null) {
                this.imageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        AlImageAdapter.this.listener.onAction(AlImageAdapter.this.context, "templateId_" + AlImageAdapter.this.model.getTemplateId(), AlImageAdapter.this.message, (Object)(AlImageAdapter.this.payloadList != null ? (ALRichMessageModel.ALPayloadModel)((Object)AlImageAdapter.this.payloadList.get(ImageViewHolder.this.getLayoutPosition())) : null), null);
                    }
                });
            }
        }
    }
}

