/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.content.Context;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.AlLinearLayoutManager;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.DividerItemDecoration;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.QuickConversationAdapter;
import com.applozic.mobicomkit.uiwidgets.uilistener.CustomToolbarListener;
import com.applozic.mobicommons.ALSpecificSettings;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.contact.Contact;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobiComQuickConversationFragment
extends Fragment
implements SearchListFragment {
    public static final String QUICK_CONVERSATION_EVENT = "quick_conversation";
    protected RecyclerView recyclerView = null;
    protected ImageButton fabButton;
    protected TextView emptyTextView;
    protected SwipeRefreshLayout swipeLayout;
    protected int listIndex;
    protected Map<String, Message> latestMessageForEachContact = new HashMap<String, Message>();
    protected List<Message> messageList = new ArrayList<Message>();
    protected QuickConversationAdapter recyclerAdapter = null;
    protected boolean loadMore = false;
    protected SyncCallService syncCallService;
    ConversationUIService conversationUIService;
    AlCustomizationSettings alCustomizationSettings;
    String searchString;
    private Long minCreatedAtTime;
    private DownloadConversation downloadConversation;
    private BaseContactService baseContactService;
    private Toolbar toolbar;
    private MessageDatabaseService messageDatabaseService;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private AlLinearLayoutManager linearLayoutManager;
    boolean isAlreadyLoading = false;
    int pastVisiblesItems;
    int visibleItemCount;
    int totalItemCount;

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)ApplozicService.getContext((Context)this.getContext()));
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.syncCallService = SyncCallService.getInstance((Context)this.getActivity());
        this.conversationUIService = new ConversationUIService(this.getActivity());
        this.baseContactService = new AppContactService((Context)this.getActivity());
        this.messageDatabaseService = new MessageDatabaseService((Context)this.getActivity());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComUserPreference.getInstance((Context)MobiComQuickConversationFragment.this.getActivity()).setDeviceTimeOffset(DateUtils.getTimeDiffFromUtc());
            }
        });
        thread.setPriority(10);
        thread.start();
        this.setHasOptionsMenu(true);
        BroadcastService.lastIndexForChats = 0;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View list = inflater.inflate(R.layout.mobicom_message_list, container, false);
        this.recyclerView = (RecyclerView)list.findViewById(R.id.messageList);
        this.recyclerView.setBackgroundColor(this.getResources().getColor(R.color.conversation_list_all_background));
        if (this.messageList != null && !this.messageList.contains(null)) {
            this.messageList.add(null);
        }
        this.recyclerAdapter = new QuickConversationAdapter(this.getContext(), this.messageList, null);
        this.recyclerAdapter.setAlCustomizationSettings(this.alCustomizationSettings);
        this.linearLayoutManager = new AlLinearLayoutManager(this.getContext());
        this.linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration(this.recyclerView.getContext());
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapter);
        this.toolbar = (Toolbar)this.getActivity().findViewById(R.id.my_toolbar);
        this.toolbar.setClickable(false);
        this.fabButton = (ImageButton)list.findViewById(R.id.fab_start_new);
        this.loading = true;
        LinearLayout individualMessageSendLayout = (LinearLayout)list.findViewById(R.id.individual_message_send_layout);
        LinearLayout extendedSendingOptionLayout = (LinearLayout)list.findViewById(R.id.extended_sending_option_layout);
        individualMessageSendLayout.setVisibility(8);
        extendedSendingOptionLayout.setVisibility(8);
        this.emptyTextView = (TextView)list.findViewById(R.id.noConversations);
        this.emptyTextView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getNoConversationLabelTextColor().trim()));
        this.fabButton.setVisibility(this.alCustomizationSettings.isStartNewFloatingButton() ? 0 : 8);
        this.swipeLayout = (SwipeRefreshLayout)list.findViewById(R.id.swipe_container);
        this.swipeLayout.setColorScheme(new int[]{17170459, 17170452, 17170456, 0x1060016});
        this.recyclerView.setLongClickable(true);
        this.registerForContextMenu((View)this.recyclerView);
        ((CustomToolbarListener)this.getActivity()).setToolbarTitle(ApplozicService.getContext((Context)this.getContext()).getString(R.string.conversation));
        return list;
    }

    protected View.OnClickListener startNewConversation() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                ((MobiComKitActivityInterface)MobiComQuickConversationFragment.this.getActivity()).startContactActivityForResult();
            }
        };
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        if (this.alCustomizationSettings.isStartNewButton() || ApplozicSetting.getInstance(this.getContext()).isStartNewButtonVisible()) {
            menu2.findItem(R.id.start_new).setVisible(true);
        }
        if (this.alCustomizationSettings.isStartNewGroup() || ApplozicSetting.getInstance(this.getContext()).isStartNewGroupButtonVisible()) {
            menu2.findItem(R.id.conversations).setVisible(true);
        }
        if (this.alCustomizationSettings.isRefreshOption()) {
            menu2.findItem(R.id.refresh).setVisible(true);
        }
        if (this.alCustomizationSettings.isProfileOption()) {
            menu2.findItem(R.id.applozicUserProfile).setVisible(true);
        }
        if (this.alCustomizationSettings.isMessageSearchOption()) {
            menu2.findItem(R.id.menu_search).setVisible(true);
        }
        if (this.alCustomizationSettings.isBroadcastOption()) {
            menu2.findItem(R.id.broadcast).setVisible(true);
        }
        if (this.alCustomizationSettings.isLogoutOption()) {
            menu2.findItem(R.id.logout).setVisible(true);
        }
        if (ALSpecificSettings.getInstance((Context)this.getContext()).isTextLoggingEnabled() && this.getContext() != null && 0 != (this.getContext().getApplicationInfo().flags & 2)) {
            menu2.findItem(R.id.sendTextLogs).setVisible(true);
        }
    }

    public void addMessage(final Message message) {
        if (this.getActivity() == null) {
            return;
        }
        if (message.isIgnoreMessageAdding((Context)this.getActivity()) || !TextUtils.isEmpty((CharSequence)this.searchString)) {
            return;
        }
        FragmentActivity context = this.getActivity();
        this.getActivity().runOnUiThread(new Runnable((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            @Override
            public void run() {
                message.processContactIds(this.val$context);
                Message recentMessage = message.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + message.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(message.getContactIds());
                if (recentMessage != null && message.getCreatedAtTime() >= recentMessage.getCreatedAtTime()) {
                    MobiComQuickConversationFragment.this.messageList.remove(recentMessage);
                } else if (recentMessage != null) {
                    return;
                }
                if (message.getGroupId() != null) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + message.getGroupId(), message);
                } else {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put(message.getContactIds(), message);
                }
                MobiComQuickConversationFragment.this.messageList.add(0, message);
                MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.emptyTextView.setVisibility(8);
                MobiComQuickConversationFragment.this.emptyTextView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)MobiComQuickConversationFragment.this.alCustomizationSettings.getNoConversationLabel()) ? MobiComQuickConversationFragment.this.alCustomizationSettings.getNoConversationLabel() : MobiComQuickConversationFragment.this.getResources().getString(R.string.no_conversation)));
            }
        });
    }

    public void refreshView() {
        if (!this.getUserVisibleHint()) {
            return;
        }
        if (this.getActivity() == null) {
            return;
        }
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (MobiComQuickConversationFragment.this.getActivity() != null && MobiComQuickConversationFragment.this.recyclerAdapter != null) {
                        MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                    }
                }
            });
        }
        catch (Exception e) {
            Utils.printLog((Context)this.getActivity(), (String)"AL", (String)"Exception while updating view .");
        }
    }

    public void updateUserInfo(final String userId) {
        if (!this.getUserVisibleHint()) {
            return;
        }
        if (this.getActivity() == null) {
            return;
        }
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Message message = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(userId);
                        if (message != null) {
                            int index = MobiComQuickConversationFragment.this.messageList.indexOf(message);
                            View view = MobiComQuickConversationFragment.this.recyclerView.getChildAt(index - MobiComQuickConversationFragment.this.linearLayoutManager.findFirstVisibleItemPosition());
                            Contact contact = MobiComQuickConversationFragment.this.baseContactService.getContactById(userId);
                            if (view != null && contact != null) {
                                ImageView contactImage = (ImageView)view.findViewById(R.id.contactImage);
                                TextView displayNameTextView = (TextView)view.findViewById(R.id.smReceivers);
                                displayNameTextView.setText((CharSequence)contact.getDisplayName());
                                MobiComQuickConversationFragment.this.recyclerAdapter.contactImageLoader.loadImage((Object)contact, contactImage);
                                MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                            }
                        }
                    }
                    catch (Exception ex) {
                        Utils.printLog((Context)MobiComQuickConversationFragment.this.getActivity(), (String)"AL", (String)"Exception while updating view .");
                    }
                }
            });
        }
    }

    public void updateLastMessage(String keyString, String userId) {
        for (Message message : this.messageList) {
            if (message.getKeyString() == null || !message.getKeyString().equals(keyString)) continue;
            List lastMessage = message.getGroupId() != null ? this.messageDatabaseService.getLatestMessageByChannelKey(message.getGroupId()) : this.messageDatabaseService.getLatestMessage(message.getContactIds());
            if (lastMessage.isEmpty()) {
                this.removeConversation(message, userId);
                break;
            }
            this.deleteMessage((Message)lastMessage.get(0), userId);
            break;
        }
    }

    public void updateLastMessage(Message message) {
        if (message == null) {
            return;
        }
        List lastMessage = new ArrayList();
        lastMessage = message.getGroupId() != null ? this.messageDatabaseService.getLatestMessageByChannelKey(message.getGroupId()) : this.messageDatabaseService.getLatestMessage(message.getContactIds());
        if (lastMessage.isEmpty()) {
            this.removeConversation(message, message.getContactIds());
        } else {
            this.deleteMessage((Message)lastMessage.get(0), message.getContactIds());
        }
    }

    public String getLatestContact() {
        if (this.messageList != null && !this.messageList.isEmpty()) {
            Message message = this.messageList.get(0);
            return message.getTo();
        }
        return null;
    }

    public void updateChannelName() {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteMessage(final Message message, String userId) {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Message recentMessage = message.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + message.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(message.getContactIds());
                if (recentMessage != null && message.getCreatedAtTime() <= recentMessage.getCreatedAtTime()) {
                    if (message.getGroupId() != null) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + message.getGroupId(), message);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put(message.getContactIds(), message);
                    }
                    MobiComQuickConversationFragment.this.messageList.set(MobiComQuickConversationFragment.this.messageList.indexOf(recentMessage), message);
                    MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                    if (MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        MobiComQuickConversationFragment.this.emptyTextView.setVisibility(0);
                    }
                }
            }
        });
    }

    public void updateLatestMessage(Message message, String userId) {
        this.deleteMessage(message, userId);
    }

    public void removeConversation(final Message message, String userId) {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (message.getGroupId() != null && message.getGroupId() != 0) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.remove("group-" + message.getGroupId());
                } else {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(message.getContactIds());
                }
                MobiComQuickConversationFragment.this.messageList.remove(message);
                MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.checkForEmptyConversations();
            }
        });
    }

    public void removeConversation(final Contact contact, final Integer channelKey, String response) {
        if (this.getActivity() == null) {
            return;
        }
        if ("success".equals(response)) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Message message = null;
                    message = channelKey != null && channelKey != 0 ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + channelKey) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(contact.getUserId());
                    if (message == null) {
                        return;
                    }
                    MobiComQuickConversationFragment.this.messageList.remove(message);
                    if (channelKey != null && channelKey != 0) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.remove("group-" + channelKey);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(contact.getUserId());
                    }
                    MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                    MobiComQuickConversationFragment.this.checkForEmptyConversations();
                }
            });
        } else if (!Utils.isInternetAvailable((Context)this.getActivity())) {
            Toast.makeText((Context)ApplozicService.getContext((Context)this.getActivity()), (CharSequence)ApplozicService.getContext((Context)this.getContext()).getString(R.string.you_need_network_access_for_delete), (int)0).show();
        } else {
            Toast.makeText((Context)ApplozicService.getContext((Context)this.getActivity()), (CharSequence)ApplozicService.getContext((Context)this.getContext()).getString(R.string.delete_conversation_failed), (int)0).show();
        }
    }

    public void checkForEmptyConversations() {
        boolean isLodingConversation;
        boolean bl = isLodingConversation = this.downloadConversation != null && this.downloadConversation.getStatus() == AsyncTask.Status.RUNNING;
        if (this.latestMessageForEachContact.isEmpty() && !isLodingConversation) {
            this.emptyTextView.setVisibility(0);
            this.emptyTextView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getNoConversationLabel()) ? this.alCustomizationSettings.getNoConversationLabel() : ApplozicService.getContext((Context)this.getContext()).getResources().getString(R.string.no_conversation)));
        } else {
            this.emptyTextView.setVisibility(8);
        }
    }

    public void setLoadMore(boolean loadMore) {
        this.loadMore = loadMore;
    }

    public void onPause() {
        super.onPause();
        this.listIndex = this.linearLayoutManager.findFirstVisibleItemPosition();
        BroadcastService.currentUserId = null;
        if (this.recyclerView != null) {
            BroadcastService.lastIndexForChats = this.linearLayoutManager.findFirstVisibleItemPosition();
        }
        if (this.recyclerAdapter != null) {
            this.recyclerAdapter.contactImageLoader.setPauseWork(false);
            this.recyclerAdapter.channelImageLoader.setPauseWork(false);
        }
    }

    public void onResume() {
        this.toolbar.setTitle((CharSequence)ApplozicService.getContext((Context)this.getContext()).getResources().getString(R.string.chats));
        this.toolbar.setSubtitle((CharSequence)"");
        BroadcastService.selectMobiComKitAll();
        super.onResume();
        if (this.recyclerView != null && this.recyclerView.getChildCount() > this.listIndex) {
            this.recyclerView.scrollToPosition(this.listIndex);
        }
        if (!this.isAlreadyLoading) {
            this.latestMessageForEachContact.clear();
            this.messageList.clear();
            this.downloadConversations(false, this.searchString);
        }
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    SyncMessages syncMessages = new SyncMessages();
                    syncMessages.execute(new Void[0]);
                }
            });
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.fabButton.setOnClickListener(this.startNewConversation());
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (MobiComQuickConversationFragment.this.recyclerAdapter != null) {
                    MobiComQuickConversationFragment.this.recyclerAdapter.contactImageLoader.setPauseWork(newState == 1);
                    MobiComQuickConversationFragment.this.recyclerAdapter.channelImageLoader.setPauseWork(newState == 1);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0 && TextUtils.isEmpty((CharSequence)MobiComQuickConversationFragment.this.searchString)) {
                    MobiComQuickConversationFragment.this.visibleItemCount = MobiComQuickConversationFragment.this.linearLayoutManager.getChildCount();
                    MobiComQuickConversationFragment.this.totalItemCount = MobiComQuickConversationFragment.this.linearLayoutManager.getItemCount();
                    MobiComQuickConversationFragment.this.pastVisiblesItems = MobiComQuickConversationFragment.this.linearLayoutManager.findFirstVisibleItemPosition();
                    if (MobiComQuickConversationFragment.this.loading && MobiComQuickConversationFragment.this.totalItemCount > MobiComQuickConversationFragment.this.previousTotalItemCount) {
                        if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                            MobiComQuickConversationFragment.this.loading = false;
                        }
                        MobiComQuickConversationFragment.this.previousTotalItemCount = MobiComQuickConversationFragment.this.totalItemCount;
                    }
                    if (MobiComQuickConversationFragment.this.totalItemCount - MobiComQuickConversationFragment.this.visibleItemCount == 0) {
                        return;
                    }
                    if (MobiComQuickConversationFragment.this.totalItemCount <= 5) {
                        return;
                    }
                    if (MobiComQuickConversationFragment.this.loadMore && !MobiComQuickConversationFragment.this.loading && MobiComQuickConversationFragment.this.visibleItemCount + MobiComQuickConversationFragment.this.pastVisiblesItems >= MobiComQuickConversationFragment.this.totalItemCount) {
                        DownloadConversation downloadConversation = new DownloadConversation(MobiComQuickConversationFragment.this.getContext(), false, MobiComQuickConversationFragment.this.listIndex);
                        downloadConversation.setQuickConversationAdapterWeakReference(MobiComQuickConversationFragment.this.recyclerAdapter);
                        downloadConversation.setTextViewWeakReference(MobiComQuickConversationFragment.this.emptyTextView);
                        downloadConversation.setSwipeRefreshLayoutWeakReference(MobiComQuickConversationFragment.this.swipeLayout);
                        downloadConversation.setRecyclerView(recyclerView);
                        downloadConversation.setConversationLabelStrings(MobiComQuickConversationFragment.this.getContext() != null ? ApplozicService.getContext((Context)MobiComQuickConversationFragment.this.getContext()).getString(R.string.no_conversation) : "", MobiComQuickConversationFragment.this.getContext() != null ? ApplozicService.getContext((Context)MobiComQuickConversationFragment.this.getContext()).getString(R.string.no_conversation) : "");
                        downloadConversation.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                        MobiComQuickConversationFragment.this.loading = true;
                        MobiComQuickConversationFragment.this.loadMore = false;
                    }
                }
            }
        });
    }

    public void downloadConversations() {
        this.downloadConversations(false, null);
    }

    public void downloadConversations(boolean showInstruction, String searchString) {
        this.minCreatedAtTime = null;
        this.downloadConversation = new DownloadConversation(this.getContext(), true, 1, searchString);
        this.downloadConversation.setQuickConversationAdapterWeakReference(this.recyclerAdapter);
        this.downloadConversation.setConversationLabelStrings(this.getContext() != null ? ApplozicService.getContext((Context)this.getContext()).getString(R.string.no_conversation) : "", this.getContext() != null ? ApplozicService.getContext((Context)this.getContext()).getString(R.string.no_conversation) : "");
        this.downloadConversation.setTextViewWeakReference(this.emptyTextView);
        this.downloadConversation.setRecyclerView(this.recyclerView);
        this.downloadConversation.setSwipeRefreshLayoutWeakReference(this.swipeLayout);
        this.downloadConversation.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        if (this.recyclerAdapter != null) {
            this.recyclerAdapter.searchString = searchString;
        }
    }

    public void updateLastSeenStatus(String userId) {
        if (this.alCustomizationSettings == null) {
            return;
        }
        if (!this.alCustomizationSettings.isOnlineStatusMasterList()) {
            return;
        }
        if (this.getActivity() == null) {
            return;
        }
        if (MobiComUserPreference.getInstance((Context)this.getContext()).getUserId().equals(userId)) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MobiComQuickConversationFragment.this.recyclerAdapter != null) {
                        MobiComQuickConversationFragment.this.recyclerAdapter.notifyDataSetChanged();
                    }
                }
                catch (Exception ex) {
                    Utils.printLog((Context)MobiComQuickConversationFragment.this.getActivity(), (String)"AL", (String)"Exception while updating online status.");
                }
            }
        });
    }

    public void updateConversationRead(final String currentId, final boolean isGroup) {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    View view;
                    int index;
                    Message message = null;
                    message = isGroup ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + currentId) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(currentId);
                    if (message != null && (index = MobiComQuickConversationFragment.this.messageList.indexOf(message)) != -1 && (view = MobiComQuickConversationFragment.this.recyclerView.getChildAt(index - MobiComQuickConversationFragment.this.linearLayoutManager.findFirstVisibleItemPosition())) != null) {
                        TextView unreadCountTextView = (TextView)view.findViewById(R.id.unreadSmsCount);
                        unreadCountTextView.setVisibility(8);
                    }
                }
                catch (Exception ex) {
                    Utils.printLog((Context)MobiComQuickConversationFragment.this.getActivity(), (String)"AL", (String)"Exception while updating Unread count...");
                }
            }
        });
    }

    public boolean onQueryTextChange(String newText) {
        this.searchString = newText;
        this.downloadConversations(false, newText);
        return true;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void stopSearching() {
        this.searchString = null;
        if (!this.isAlreadyLoading && this.recyclerView.getScrollState() == 0) {
            this.latestMessageForEachContact.clear();
            this.messageList.clear();
            this.downloadConversations(false, this.searchString);
        }
    }

    private class SyncMessages
    extends AsyncTask<Void, Integer, Long> {
        SyncMessages() {
        }

        protected Long doInBackground(Void ... params) {
            MobiComQuickConversationFragment.this.syncCallService.syncMessages(null);
            return 1L;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(false);
        }
    }

    public class DownloadConversation
    extends AsyncTask<Void, Integer, Long> {
        private int firstVisibleItem;
        private boolean initial;
        private List<Message> nextMessageList = new ArrayList<Message>();
        private WeakReference<Context> context;
        private boolean loadMoreMessages;
        private String searchString;
        private WeakReference<RecyclerView> recyclerViewWr;
        private String conversationLabel;
        private String noConversationFound;
        private WeakReference<SwipeRefreshLayout> swipeRefreshLayoutWeakReference;
        private WeakReference<QuickConversationAdapter> quickConversationAdapterWeakReference;
        private WeakReference<TextView> textViewWeakReference;

        public void setQuickConversationAdapterWeakReference(QuickConversationAdapter quickConversationAdapterWeakReference) {
            this.quickConversationAdapterWeakReference = new WeakReference<QuickConversationAdapter>(quickConversationAdapterWeakReference);
        }

        public void setTextViewWeakReference(TextView emptyTextViewWeakReference) {
            this.textViewWeakReference = new WeakReference<TextView>(emptyTextViewWeakReference);
        }

        public void setSwipeRefreshLayoutWeakReference(SwipeRefreshLayout swipeRefreshLayout) {
            this.swipeRefreshLayoutWeakReference = new WeakReference<SwipeRefreshLayout>(swipeRefreshLayout);
        }

        public void setRecyclerView(RecyclerView recyclerView) {
            this.recyclerViewWr = new WeakReference<RecyclerView>(recyclerView);
        }

        public DownloadConversation(Context context, boolean initial, int firstVisibleItem, String searchString) {
            this.context = new WeakReference<Context>(context);
            this.initial = initial;
            this.firstVisibleItem = firstVisibleItem;
            this.searchString = searchString;
        }

        public void setConversationLabelStrings(String conversationLabel, String noConversationFound) {
            this.conversationLabel = conversationLabel;
            this.noConversationFound = noConversationFound;
        }

        public DownloadConversation(Context context, boolean initial, int firstVisibleItem) {
            this(context, initial, firstVisibleItem, null);
            this.loadMoreMessages = true;
        }

        protected void onPreExecute() {
            SwipeRefreshLayout swipeRefreshLayout;
            super.onPreExecute();
            MobiComQuickConversationFragment.this.isAlreadyLoading = true;
            if (this.loadMoreMessages) {
                if (!MobiComQuickConversationFragment.this.messageList.contains(null)) {
                    MobiComQuickConversationFragment.this.messageList.add(null);
                }
                ((QuickConversationAdapter)((Object)this.quickConversationAdapterWeakReference.get())).notifyItemInserted(MobiComQuickConversationFragment.this.messageList.size() - 1);
            } else if (this.swipeRefreshLayoutWeakReference != null && (swipeRefreshLayout = (SwipeRefreshLayout)this.swipeRefreshLayoutWeakReference.get()) != null) {
                swipeRefreshLayout.setEnabled(true);
                swipeRefreshLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        swipeRefreshLayout.setRefreshing(true);
                    }
                });
            }
        }

        protected Long doInBackground(Void ... voids) {
            if (this.initial) {
                this.nextMessageList = MobiComQuickConversationFragment.this.syncCallService.getLatestMessagesGroupByPeople(this.searchString, MobiComUserPreference.getInstance((Context)ApplozicService.getContextFromWeak(this.context)).getParentGroupKey());
                if (!this.nextMessageList.isEmpty()) {
                    MobiComQuickConversationFragment.this.minCreatedAtTime = this.nextMessageList.get(this.nextMessageList.size() - 1).getCreatedAtTime();
                }
            } else if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                MobiComQuickConversationFragment.this.listIndex = this.firstVisibleItem;
                Long createdAt = MobiComQuickConversationFragment.this.messageList.size() >= 2 && MobiComQuickConversationFragment.this.messageList.contains(null) ? (MobiComQuickConversationFragment.this.messageList.isEmpty() ? null : MobiComQuickConversationFragment.this.messageList.get(MobiComQuickConversationFragment.this.messageList.size() - 2).getCreatedAtTime()) : (MobiComQuickConversationFragment.this.messageList.isEmpty() ? null : MobiComQuickConversationFragment.this.messageList.get(MobiComQuickConversationFragment.this.messageList.size() - 1).getCreatedAtTime());
                MobiComQuickConversationFragment.this.minCreatedAtTime = MobiComQuickConversationFragment.this.minCreatedAtTime == null ? createdAt : Math.min(MobiComQuickConversationFragment.this.minCreatedAtTime, createdAt);
                this.nextMessageList = MobiComQuickConversationFragment.this.syncCallService.getLatestMessagesGroupByPeople(MobiComQuickConversationFragment.this.minCreatedAtTime, this.searchString, MobiComUserPreference.getInstance((Context)ApplozicService.getContextFromWeak(this.context)).getParentGroupKey());
            }
            return 0L;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Long result) {
            Object swipeRefreshLayout;
            if (!this.loadMoreMessages && this.swipeRefreshLayoutWeakReference != null && (swipeRefreshLayout = (SwipeRefreshLayout)this.swipeRefreshLayoutWeakReference.get()) != null) {
                swipeRefreshLayout.setEnabled(true);
                swipeRefreshLayout.post(new Runnable((SwipeRefreshLayout)swipeRefreshLayout){
                    final /* synthetic */ SwipeRefreshLayout val$swipeRefreshLayout;
                    {
                        this.val$swipeRefreshLayout = swipeRefreshLayout;
                    }

                    @Override
                    public void run() {
                        this.val$swipeRefreshLayout.setRefreshing(false);
                    }
                });
            }
            if (!this.loadMoreMessages) {
                MobiComQuickConversationFragment.this.messageList.clear();
                MobiComQuickConversationFragment.this.latestMessageForEachContact.clear();
            }
            if (!TextUtils.isEmpty((CharSequence)this.searchString)) {
                MobiComQuickConversationFragment.this.messageList.addAll(this.nextMessageList);
            } else {
                for (Message currentMessage : this.nextMessageList) {
                    if (currentMessage.isSentToMany()) continue;
                    Message recentSms = currentMessage.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + currentMessage.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(currentMessage.getContactIds());
                    if (recentSms != null) {
                        if (currentMessage.getCreatedAtTime() < recentSms.getCreatedAtTime()) continue;
                        if (currentMessage.getGroupId() != null) {
                            MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + currentMessage.getGroupId(), currentMessage);
                        } else {
                            MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                        }
                        MobiComQuickConversationFragment.this.messageList.remove(recentSms);
                        MobiComQuickConversationFragment.this.messageList.add(currentMessage);
                        continue;
                    }
                    if (currentMessage.getGroupId() != null) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + currentMessage.getGroupId(), currentMessage);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                    }
                    MobiComQuickConversationFragment.this.messageList.add(currentMessage);
                }
            }
            if (this.loadMoreMessages && MobiComQuickConversationFragment.this.messageList.contains(null)) {
                MobiComQuickConversationFragment.this.messageList.remove(null);
            }
            if (this.quickConversationAdapterWeakReference != null && this.quickConversationAdapterWeakReference.get() != null) {
                ((QuickConversationAdapter)((Object)this.quickConversationAdapterWeakReference.get())).notifyDataSetChanged();
            }
            if (this.initial) {
                QuickConversationAdapter adapter;
                TextView emptyTextView;
                if (this.textViewWeakReference != null && (emptyTextView = (TextView)this.textViewWeakReference.get()) != null) {
                    emptyTextView.setVisibility(MobiComQuickConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                    if (!TextUtils.isEmpty((CharSequence)this.searchString) && MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        emptyTextView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)MobiComQuickConversationFragment.this.alCustomizationSettings.getNoSearchFoundForChatMessages()) ? MobiComQuickConversationFragment.this.alCustomizationSettings.getNoSearchFoundForChatMessages() : this.noConversationFound));
                    } else if (TextUtils.isEmpty((CharSequence)this.searchString) && MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        emptyTextView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)MobiComQuickConversationFragment.this.alCustomizationSettings.getNoConversationLabel()) ? MobiComQuickConversationFragment.this.alCustomizationSettings.getNoConversationLabel() : this.conversationLabel));
                    }
                }
                if (!MobiComQuickConversationFragment.this.messageList.isEmpty() && this.recyclerViewWr != null && this.recyclerViewWr.get() != null && this.quickConversationAdapterWeakReference != null && (adapter = (QuickConversationAdapter)((Object)this.quickConversationAdapterWeakReference.get())) != null) {
                    if (adapter.getItemCount() > BroadcastService.lastIndexForChats) {
                        ((RecyclerView)this.recyclerViewWr.get()).scrollToPosition(BroadcastService.lastIndexForChats);
                        BroadcastService.lastIndexForChats = 0;
                    } else {
                        ((RecyclerView)this.recyclerViewWr.get()).scrollToPosition(0);
                    }
                }
            } else if (!this.loadMoreMessages && this.recyclerViewWr != null && this.recyclerViewWr.get() != null) {
                ((RecyclerView)this.recyclerViewWr.get()).scrollToPosition(this.firstVisibleItem);
            }
            if (!this.nextMessageList.isEmpty()) {
                MobiComQuickConversationFragment.this.loadMore = true;
            }
            MobiComQuickConversationFragment.this.isAlreadyLoading = false;
        }
    }
}

