/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class AlTypingIndicator
extends LinearLayout {
    private ALTypingReceiver mReceiver;
    String typerUserId;
    boolean isTyping = false;
    private TextView typingText;

    public AlTypingIndicator(Context context) {
        super(context);
    }

    public AlTypingIndicator(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AlTypingIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void createView() {
        Contact contact = new AppContactService(this.getContext()).getContactById(this.typerUserId);
        this.removeAllViews();
        if (this.typingText == null) {
            this.typingText = new TextView(this.getContext());
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
            this.typingText.setLayoutParams((ViewGroup.LayoutParams)params);
            this.typingText.setTextSize(14.0f);
            this.typingText.setTextColor(this.getContext().getResources().getColor(R.color.apploizc_black_color));
        }
        this.addView((View)this.typingText);
        if (this.isTyping) {
            this.typingText.setText((CharSequence)((contact != null ? contact.getDisplayName() : "") + " is Typing..."));
        } else {
            this.typingText.setText((CharSequence)((contact != null ? contact.getDisplayName() : "") + " is not Typing..."));
        }
    }

    public boolean isTyping() {
        return this.isTyping;
    }

    public String getTyperUserId() {
        return this.typerUserId;
    }

    public void subscribe(Channel channel, Contact contact) {
        Applozic.subscribeToTyping((Context)this.getContext(), (Channel)channel, (Contact)contact);
        if (this.mReceiver == null) {
            this.mReceiver = new ALTypingReceiver();
        }
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter(BroadcastService.INTENT_ACTIONS.UPDATE_TYPING_STATUS.toString()));
    }

    public void unSubscribe(Channel channel, Contact contact) {
        Applozic.unSubscribeToTyping((Context)this.getContext(), (Channel)channel, (Contact)contact);
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mReceiver = null;
        }
    }

    private class ALTypingReceiver
    extends BroadcastReceiver {
        private ALTypingReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            AlTypingIndicator.this.typerUserId = intent.getStringExtra("userId");
            String typing = intent.getStringExtra("isTyping");
            AlTypingIndicator.this.isTyping = "1".equals(typing);
            AlTypingIndicator.this.createView();
        }
    }
}

