/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.DimensionsUtils;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageModel;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AlRichMessage {
    private Context context;
    private RecyclerView recyclerView;
    private Message message;
    private ALRichMessageListener listener;
    private LinearLayout containerView;
    private LinearLayout listItemLayout;

    public AlRichMessage(Context context, RecyclerView recyclerView, LinearLayout containerView, Message message, ALRichMessageListener listener) {
        this.context = context;
        this.recyclerView = recyclerView;
        this.message = message;
        this.listener = listener;
        this.containerView = containerView;
        this.setupRichMessage();
    }

    private void setupRichMessage() {
        ALRichMessageModel model = (ALRichMessageModel)((Object)GsonUtils.getObjectFromJson((String)GsonUtils.getJsonFromObject((Object)this.message.getMetadata(), Map.class), ALRichMessageModel.class));
        this.listItemLayout = (LinearLayout)this.containerView.findViewById(R.id.listItemLayout);
        if (model.getTemplateId() == 8) {
            this.listItemLayout.setVisibility(0);
            this.recyclerView.setVisibility(8);
            this.setupListItemView(this.listItemLayout, model);
        } else {
            this.listItemLayout.setVisibility(8);
            this.recyclerView.setVisibility(0);
            LinearLayoutManager layoutManager = new LinearLayoutManager(this.context, 0, false);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            ALRichMessageAdapter adapter = new ALRichMessageAdapter(this.context, model, this.listener, this.message);
            this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        }
    }

    private void setupListItemView(LinearLayout layout2, ALRichMessageModel model) {
        if (model != null) {
            layout2.removeAllViews();
            if (!TextUtils.isEmpty((CharSequence)model.getHeaderText())) {
                TextView headerTv = new TextView(this.context);
                LinearLayout.LayoutParams textViewParams = new LinearLayout.LayoutParams(-1, -2);
                headerTv.setLetterSpacing(0.04f);
                headerTv.setText((CharSequence)model.getHeaderText());
                headerTv.setTextColor(Color.parseColor((String)"#646262"));
                headerTv.setBackgroundColor(Color.parseColor((String)"#e6e5ec"));
                headerTv.setPadding(DimensionsUtils.dp(9.0f), DimensionsUtils.dp(9.0f), DimensionsUtils.dp(9.0f), DimensionsUtils.dp(9.0f));
                headerTv.setTextSize(2, 14.0f);
                headerTv.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
                layout2.addView((View)headerTv);
            }
            if (!TextUtils.isEmpty((CharSequence)model.getPayload())) {
                List<ALRichMessageModel.ALPayloadModel> payLoadList = Arrays.asList((ALRichMessageModel.ALPayloadModel[])GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel[].class));
                for (final ALRichMessageModel.ALPayloadModel payload : payLoadList) {
                    View view = new View(this.context);
                    LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, DimensionsUtils.dp(1.0f));
                    view.setLayoutParams((ViewGroup.LayoutParams)viewParams);
                    view.setBackgroundColor(Color.parseColor((String)"#e7e4e4"));
                    TextView textView = new TextView(this.context);
                    LinearLayout.LayoutParams textViewParams = new LinearLayout.LayoutParams(-1, -2);
                    textView.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
                    textView.setGravity(17);
                    textView.setLetterSpacing(0.05f);
                    textView.setPadding(DimensionsUtils.dp(9.0f), DimensionsUtils.dp(7.0f), DimensionsUtils.dp(9.0f), DimensionsUtils.dp(7.0f));
                    textView.setTextSize(2, 12.0f);
                    textView.setTextColor(this.context.getResources().getColor(R.color.applozic_theme_color_primary));
                    textView.setText((CharSequence)payload.getTitle());
                    textView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            AlRichMessage.this.listener.onAction(AlRichMessage.this.context, "listItemClick", null, payload.getMessage());
                        }
                    });
                    layout2.addView(view);
                    layout2.addView((View)textView);
                }
            }
        }
    }
}

