/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.attachmentview.AlBitmapUtils;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobiComAttachmentGridViewAdapter;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class MobiComAttachmentSelectorActivity
extends AppCompatActivity {
    public static final String MULTISELECT_SELECTED_FILES = "multiselect.selectedFiles";
    public static final String MULTISELECT_MESSAGE = "multiselect.message";
    public static final String URI_LIST = "URI_LIST";
    public static String USER_ID = "USER_ID";
    public static String DISPLAY_NAME = "DISPLAY_NAME";
    public static String GROUP_ID = "GROUP_ID";
    public static String GROUP_NAME = "GROUP_NAME";
    private static int REQUEST_CODE_ATTACH_PHOTO = 10;
    AlCustomizationSettings alCustomizationSettings;
    FileClientService fileClientService;
    Uri imageUri;
    String userID;
    String displayName;
    String groupName;
    Integer groupID;
    Message message;
    MobiComUserPreference userPreferences;
    private String TAG = "MultiAttActivity";
    private Button sendAttachment;
    private Button cancelAttachment;
    private EditText messageEditText;
    private ConnectivityReceiver connectivityReceiver;
    private GridView galleryImagesGridView;
    private ArrayList<Uri> attachmentFileList = new ArrayList();
    private MobiComAttachmentGridViewAdapter imagesAdapter;
    private boolean isActivityDestroyed;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mobicom_multi_attachment_activity);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.fileClientService = new FileClientService((Context)this);
        this.userPreferences = MobiComUserPreference.getInstance((Context)this);
        Intent intent = this.getIntent();
        if (intent.getExtras() != null) {
            this.userID = intent.getExtras().getString(USER_ID);
            this.displayName = intent.getExtras().getString(DISPLAY_NAME);
            this.groupID = intent.getExtras().getInt(GROUP_ID, 0);
            this.groupName = intent.getExtras().getString(GROUP_NAME);
            this.imageUri = (Uri)intent.getParcelableExtra(URI_LIST);
            if (this.imageUri != null) {
                this.attachmentFileList.add(this.imageUri);
            }
        }
        this.initViews();
        this.setUpGridView();
        this.fileClientService = new FileClientService((Context)this);
        if (this.imageUri == null) {
            Intent getContentIntent = FileUtils.createGetContentIntent();
            getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
            Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)this.getString(R.string.select_file));
            this.startActivityForResult(intentPick, REQUEST_CODE_ATTACH_PHOTO);
        }
        this.connectivityReceiver = new ConnectivityReceiver();
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void initViews() {
        this.sendAttachment = (Button)this.findViewById(R.id.mobicom_attachment_send_btn);
        this.cancelAttachment = (Button)this.findViewById(R.id.mobicom_attachment_cancel_btn);
        this.galleryImagesGridView = (GridView)this.findViewById(R.id.mobicom_attachment_grid_View);
        this.messageEditText = (EditText)this.findViewById(R.id.mobicom_attachment_edit_text);
        this.cancelAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                MobiComAttachmentSelectorActivity.this.setResult(0, intent);
                MobiComAttachmentSelectorActivity.this.finish();
            }
        });
        this.sendAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MobiComAttachmentSelectorActivity.this.attachmentFileList.isEmpty()) {
                    Toast.makeText((Context)MobiComAttachmentSelectorActivity.this.getApplicationContext(), (int)R.string.mobicom_select_attachment_text, (int)0).show();
                    return;
                }
                if (MobiComAttachmentSelectorActivity.this.imageUri != null) {
                    for (Uri uri : MobiComAttachmentSelectorActivity.this.attachmentFileList) {
                        try {
                            String filePath = uri.getPath();
                            if (TextUtils.isEmpty((CharSequence)filePath)) {
                                Toast.makeText((Context)MobiComAttachmentSelectorActivity.this, (int)R.string.info_file_attachment_error, (int)1).show();
                                return;
                            }
                            Message messageToSend = new Message();
                            if (MobiComAttachmentSelectorActivity.this.groupID != 0) {
                                messageToSend.setGroupId(MobiComAttachmentSelectorActivity.this.groupID);
                            } else {
                                messageToSend.setTo(MobiComAttachmentSelectorActivity.this.userID);
                                messageToSend.setContactIds(MobiComAttachmentSelectorActivity.this.userID);
                            }
                            messageToSend.setContentType(Message.ContentType.ATTACHMENT.getValue().shortValue());
                            messageToSend.setRead(Boolean.TRUE);
                            messageToSend.setStoreOnDevice(Boolean.TRUE.booleanValue());
                            if (messageToSend.getCreatedAtTime() == null) {
                                messageToSend.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + MobiComAttachmentSelectorActivity.this.userPreferences.getDeviceTimeOffset()));
                            }
                            messageToSend.setSendToDevice(Boolean.FALSE.booleanValue());
                            messageToSend.setType(Message.MessageType.MT_OUTBOX.getValue());
                            messageToSend.setMessage(MobiComAttachmentSelectorActivity.this.messageEditText.getText().toString());
                            messageToSend.setDeviceKeyString(MobiComAttachmentSelectorActivity.this.userPreferences.getDeviceKeyString());
                            messageToSend.setSource(Message.Source.MT_MOBILE_APP.getValue());
                            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                                ArrayList<String> filePaths = new ArrayList<String>();
                                filePaths.add(filePath);
                                messageToSend.setFilePaths(filePaths);
                            }
                            Intent startConversationActivity = new Intent((Context)MobiComAttachmentSelectorActivity.this, ConversationActivity.class);
                            if (MobiComAttachmentSelectorActivity.this.groupID != 0) {
                                startConversationActivity.putExtra("groupId", (Serializable)MobiComAttachmentSelectorActivity.this.groupID);
                                startConversationActivity.putExtra("groupName", MobiComAttachmentSelectorActivity.this.groupName);
                                startConversationActivity.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)messageToSend, messageToSend.getClass()));
                            } else {
                                startConversationActivity.putExtra("userId", MobiComAttachmentSelectorActivity.this.userID);
                                startConversationActivity.putExtra("displayName", MobiComAttachmentSelectorActivity.this.displayName);
                                startConversationActivity.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)messageToSend, messageToSend.getClass()));
                            }
                            MobiComAttachmentSelectorActivity.this.startActivity(startConversationActivity);
                            MobiComAttachmentSelectorActivity.this.finish();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    Intent intent = new Intent();
                    intent.putParcelableArrayListExtra(MobiComAttachmentSelectorActivity.MULTISELECT_SELECTED_FILES, MobiComAttachmentSelectorActivity.this.attachmentFileList);
                    intent.putExtra(MobiComAttachmentSelectorActivity.MULTISELECT_MESSAGE, MobiComAttachmentSelectorActivity.this.messageEditText.getText().toString());
                    MobiComAttachmentSelectorActivity.this.setResult(-1, intent);
                    MobiComAttachmentSelectorActivity.this.finish();
                }
            }
        });
    }

    private void addUri(Uri uri) {
        this.attachmentFileList.add(uri);
        Utils.printLog((Context)this, (String)this.TAG, (String)("attachmentFileList  :: " + this.attachmentFileList));
    }

    private void setUpGridView() {
        this.imagesAdapter = new MobiComAttachmentGridViewAdapter((Context)this, this.attachmentFileList, this.alCustomizationSettings, this.imageUri != null);
        this.galleryImagesGridView.setAdapter((ListAdapter)this.imagesAdapter);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (resultCode == -1) {
            Uri selectedFileUri = intent == null ? null : intent.getData();
            Utils.printLog((Context)this, (String)this.TAG, (String)("selectedFileUri :: " + selectedFileUri));
            if (selectedFileUri != null) {
                String fileName = null;
                try {
                    String fileNameToWrite;
                    String mimeType;
                    long maxFileSize = this.alCustomizationSettings.getMaxAttachmentSizeAllowed() * 1024 * 1024;
                    Cursor returnCursor = this.getContentResolver().query(selectedFileUri, null, null, null, null);
                    if (returnCursor != null) {
                        int sizeIndex = returnCursor.getColumnIndex("_size");
                        returnCursor.moveToFirst();
                        Long fileSize = returnCursor.getLong(sizeIndex);
                        returnCursor.close();
                        if (fileSize > maxFileSize) {
                            Toast.makeText((Context)this, (int)R.string.info_attachment_max_allowed_file_size, (int)1).show();
                            return;
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)(mimeType = FileUtils.getMimeTypeByContentUriOrOther((Context)this, (Uri)selectedFileUri)))) {
                        return;
                    }
                    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                    fileName = FileUtils.getFileName((Context)this, (Uri)selectedFileUri);
                    String fileFormat = FileUtils.getFileFormat((String)fileName);
                    if (TextUtils.isEmpty((CharSequence)fileFormat)) {
                        String format = FileUtils.getFileFormat((String)FileUtils.getFile((Context)this, (Uri)selectedFileUri).getAbsolutePath());
                        if (TextUtils.isEmpty((CharSequence)format)) {
                            return;
                        }
                        fileNameToWrite = timeStamp + "." + format;
                    } else {
                        fileNameToWrite = timeStamp + "." + fileFormat;
                    }
                    File mediaFile = FileClientService.getFilePath((String)fileNameToWrite, (Context)this.getApplicationContext(), (String)mimeType);
                    new FileTaskAsync(mediaFile, selectedFileUri, (Context)this).execute(new Void[]{null});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, intent);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.isActivityDestroyed = true;
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class FileTaskAsync
    extends AsyncTask<Void, Integer, Boolean> {
        WeakReference<Context> context;
        FileClientService fileClientService;
        File file;
        Uri uri;
        ProgressDialog progressDialog;

        public FileTaskAsync(File file, Uri uri, Context context) {
            this.context = new WeakReference<Context>(context);
            this.file = file;
            this.uri = uri;
            this.fileClientService = new FileClientService((Context)this.context.get());
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)((Context)this.context.get()), (CharSequence)"", (CharSequence)((Context)this.context.get()).getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Boolean doInBackground(Void ... params) {
            String format = URLConnection.guessContentTypeFromName(this.file.getName());
            if (this.fileClientService != null) {
                this.fileClientService.writeFile(this.uri, this.file);
            }
            if (format == null) {
                return true;
            }
            if (MobiComAttachmentSelectorActivity.this.alCustomizationSettings != null && MobiComAttachmentSelectorActivity.this.alCustomizationSettings.isImageCompressionEnabled() && format.contains("image")) {
                boolean bl = AlBitmapUtils.compress(this.uri, this.file, (Context)this.context.get());
            }
            return true;
        }

        protected void onPostExecute(Boolean b) {
            super.onPostExecute((Object)b);
            if (MobiComAttachmentSelectorActivity.this.isFinishing() || MobiComAttachmentSelectorActivity.this.isActivityDestroyed || this.context == null || this.context.get() == null) {
                return;
            }
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (this.file == null) {
                return;
            }
            Uri uri = Uri.parse((String)this.file.getAbsolutePath());
            MobiComAttachmentSelectorActivity.this.addUri(uri);
            MobiComAttachmentSelectorActivity.this.imagesAdapter.notifyDataSetChanged();
        }
    }
}

