/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.content.Context;
import android.media.MediaRecorder;
import android.support.v4.app.FragmentActivity;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import java.io.File;

public class ApplozicAudioRecordManager
implements MediaRecorder.OnInfoListener,
MediaRecorder.OnErrorListener {
    FragmentActivity context;
    String audioFileName;
    String timeStamp;
    ConversationUIService conversationUIService;
    private MediaRecorder audioRecorder;
    private String outputFile = null;
    private boolean isRecordring;

    public ApplozicAudioRecordManager(FragmentActivity context) {
        this.conversationUIService = new ConversationUIService(context);
        this.context = context;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setAudioFileName(String audioFileName) {
        this.audioFileName = audioFileName;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void recordAudio() {
        try {
            if (this.isRecordring) {
                this.stopRecording();
            } else {
                if (this.audioRecorder == null) {
                    this.prepareMediaRecorder();
                }
                this.audioRecorder.prepare();
                this.audioRecorder.start();
                this.isRecordring = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelAudio() {
        File file;
        if (this.isRecordring) {
            this.stopRecording();
        }
        if (this.outputFile != null && (file = new File(this.outputFile)) != null && file.exists()) {
            Utils.printLog((Context)this.context, (String)"AudioFRG:", (String)"File deleted...");
            file.delete();
        }
    }

    public void sendAudio() {
        if (this.isRecordring) {
            this.stopRecording();
        }
        if (this.outputFile != null) {
            if (!new File(this.outputFile).exists()) {
                Toast.makeText((Context)this.context, (int)R.string.tap_on_mic_button_to_record_audio, (int)0).show();
                return;
            }
            this.conversationUIService.sendAudioMessage(this.outputFile);
        }
    }

    public void stopRecording() {
        if (this.audioRecorder != null) {
            try {
                this.audioRecorder.stop();
            }
            catch (RuntimeException stopException) {
                Utils.printLog((Context)this.context, (String)"AudioMsgFrag:", (String)"Runtime exception.This is thrown intentionally if stop is called just after start");
            }
            finally {
                this.audioRecorder.release();
                this.audioRecorder = null;
                this.isRecordring = false;
            }
        }
    }

    public MediaRecorder prepareMediaRecorder() {
        this.audioRecorder = new MediaRecorder();
        this.audioRecorder.setAudioSource(1);
        this.audioRecorder.setOutputFormat(2);
        this.audioRecorder.setAudioEncoder(3);
        this.audioRecorder.setAudioEncodingBitRate(256);
        this.audioRecorder.setAudioChannels(1);
        this.audioRecorder.setAudioSamplingRate(44100);
        this.audioRecorder.setOutputFile(this.outputFile);
        this.audioRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
        this.audioRecorder.setOnErrorListener((MediaRecorder.OnErrorListener)this);
        return this.audioRecorder;
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
    }

    public void onError(MediaRecorder mr, int what, int extra) {
    }
}

