/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentTask;
import com.applozic.mobicomkit.api.attachment.AttachmentViewProperties;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.attachmentview.ApplozicAudioManager;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import java.io.File;

public class ApplozicDocumentView {
    private static final String TAG = "ApplozicDocumentView";
    RelativeLayout mainLayout;
    RelativeLayout downloadInProgressLayout;
    RelativeLayout downloadedLayout;
    RelativeLayout previewLayout;
    RelativeLayout retryLayout;
    TextView sizeTextView;
    TextView fileText;
    Message message;
    Context context;
    AttachmentViewProperties attachmentViewProperties;
    ProgressBar progressBar;
    ImageView uploadDownloadImage;
    SeekBar audioseekbar;
    Uri uri;
    String filePath;
    String mimeType = null;
    ImageView docIcon;
    TextView audio_duration_textView;
    String audio_duration;
    private AttachmentTask mDownloadThread;
    private boolean mCacheFlag = false;
    private Handler mHandler = new Handler();

    public ApplozicDocumentView(Context context) {
        this.context = context;
    }

    public void inflateViewWithMessage(View rootview, Message message) {
        this.message = message;
        this.mainLayout = (RelativeLayout)rootview.findViewById(R.id.attachment_doc_relative_layout);
        this.downloadInProgressLayout = (RelativeLayout)rootview.findViewById(R.id.applozic_doc_download_progress_rl);
        this.downloadedLayout = (RelativeLayout)rootview.findViewById(R.id.applozic_doc_downloaded);
        this.previewLayout = (RelativeLayout)rootview.findViewById(R.id.download_doc_relative_layout);
        this.retryLayout = (RelativeLayout)rootview.findViewById(R.id.retry_doc_relative_layout);
        this.progressBar = (ProgressBar)rootview.findViewById(R.id.applozic_doc_download_progress);
        this.sizeTextView = (TextView)rootview.findViewById(R.id.applozic_doc_file_size);
        this.fileText = (TextView)rootview.findViewById(R.id.applozic_doc_file_name);
        this.uploadDownloadImage = (ImageView)rootview.findViewById(R.id.applozic_download_image);
        this.docIcon = (ImageView)rootview.findViewById(R.id.doc_icon);
        ImageView cancelIcon = (ImageView)rootview.findViewById(R.id.download_calcle_icon);
        this.audioseekbar = (SeekBar)rootview.findViewById(R.id.applozic_audio_seekbar);
        this.audio_duration_textView = (TextView)rootview.findViewById(R.id.audio_duration_textView);
        if (message.isTypeOutbox()) {
            this.progressBar.getIndeterminateDrawable().setColorFilter(R.color.applozic_green_color, PorterDuff.Mode.MULTIPLY);
            cancelIcon.setColorFilter(R.color.white, PorterDuff.Mode.MULTIPLY);
            if (message.getFileMetas() != null) {
                if (message.getFileMetas().getContentType().contains("audio")) {
                    this.setAudioIcons();
                    this.updateApplozicSeekBar();
                }
            } else if (message.getFilePaths() != null) {
                this.filePath = (String)message.getFilePaths().get(0);
                this.mimeType = FileUtils.getMimeType((String)this.filePath);
                if (this.mimeType != null && this.mimeType.contains("audio")) {
                    this.setAudioIcons();
                    this.updateApplozicSeekBar();
                }
            }
            this.fileText.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.message_text_color));
            this.audioseekbar.getProgressDrawable().setColorFilter(-1, PorterDuff.Mode.MULTIPLY);
            cancelIcon.setVisibility(8);
            this.docIcon.setColorFilter(-1);
        } else {
            this.progressBar.getIndeterminateDrawable().setColorFilter(R.color.black, PorterDuff.Mode.MULTIPLY);
            if (message.getFileMetas() != null) {
                if (message.getFileMetas().getContentType().contains("audio")) {
                    this.setAudioIcons();
                    this.updateApplozicSeekBar();
                }
            } else if (message.getFilePaths() != null) {
                this.filePath = (String)message.getFilePaths().get(0);
                this.mimeType = FileUtils.getMimeType((String)this.filePath);
                if (this.mimeType != null && this.mimeType.contains("audio")) {
                    this.setAudioIcons();
                    this.updateApplozicSeekBar();
                }
            }
            cancelIcon.setVisibility(0);
            cancelIcon.setColorFilter(R.color.black, PorterDuff.Mode.MULTIPLY);
            this.fileText.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.message_text_color));
            this.audioseekbar.getProgressDrawable().setColorFilter(-19902, PorterDuff.Mode.MULTIPLY);
        }
        if (!message.hasAttachment()) {
            return;
        }
        this.setupAttachmentView();
        this.registerEvents();
        if (message.isCanceled()) {
            this.showRetry();
        } else if (message.isAttachmentUploadInProgress() && !message.isCanceled()) {
            this.showUploadingProgress();
        } else if (AttachmentManager.isAttachmentInProgress((String)message.getKeyString())) {
            this.mDownloadThread = AttachmentManager.getBGThreadForAttachment((String)message.getKeyString());
            this.mDownloadThread.setAttachementViewNew(this.attachmentViewProperties);
            this.showDownloadInProgress();
        } else if (message.isAttachmentDownloaded()) {
            this.showDownloaded();
        } else {
            this.showPreview();
        }
        if (message.getFileMetas() != null && message.getFilePaths() == null) {
            this.sizeTextView.setText((CharSequence)message.getFileMetas().getSizeInReadableFormat());
            if (!message.getFileMetas().getContentType().contains("audio")) {
                this.fileText.setText((CharSequence)message.getFileMetas().getName());
                this.audioseekbar.setVisibility(8);
            } else {
                this.fileText.setVisibility(8);
                if (message.isAttachmentDownloaded()) {
                    this.audio_duration = ApplozicAudioManager.getInstance(this.context).refreshAudioDuration(this.filePath);
                    this.audio_duration_textView.setVisibility(0);
                    this.audio_duration_textView.setText((CharSequence)this.audio_duration);
                } else {
                    this.audio_duration_textView.setVisibility(0);
                    this.audio_duration_textView.setText((CharSequence)"00:00");
                }
                this.setAudioIcons();
                this.audioseekbar.setVisibility(0);
            }
        } else if (message.getFilePaths() != null) {
            this.filePath = (String)message.getFilePaths().get(0);
            this.mimeType = FileUtils.getMimeType((String)this.filePath);
            if (this.mimeType != null && !this.mimeType.contains("audio")) {
                String fileName = new File(this.filePath).getName();
                this.fileText.setText((CharSequence)fileName);
                this.audioseekbar.setVisibility(8);
            } else {
                if (message.isAttachmentDownloaded()) {
                    this.audio_duration = ApplozicAudioManager.getInstance(this.context).refreshAudioDuration(this.filePath);
                    this.audio_duration_textView.setVisibility(0);
                    this.audio_duration_textView.setText((CharSequence)this.audio_duration);
                } else {
                    this.audio_duration_textView.setVisibility(0);
                    this.audio_duration_textView.setText((CharSequence)"00:00");
                }
                this.fileText.setVisibility(8);
                this.audioseekbar.setVisibility(0);
                this.setAudioIcons();
            }
        }
    }

    private void showRetry() {
        if (this.isDownloadRequire()) {
            this.showPreview();
        } else {
            this.mainLayout.setVisibility(0);
            this.retryLayout.setVisibility(0);
            this.uploadDownloadImage.setImageResource(R.drawable.circle_arrow_upload);
            this.downloadInProgressLayout.setVisibility(8);
            this.downloadedLayout.setVisibility(8);
            this.previewLayout.setVisibility(8);
        }
    }

    private void showUploadingProgress() {
        Utils.printLog((Context)this.context, (String)TAG, (String)"showUploadingProgress :: ");
        this.showDownloadInProgress();
    }

    private void setupAttachmentView() {
        this.attachmentViewProperties = new AttachmentViewProperties(this.mainLayout.getWidth(), this.mainLayout.getHeight(), this.context, this.message);
        if (this.mDownloadThread == null && AttachmentManager.isAttachmentInProgress((String)this.message.getKeyString())) {
            this.mDownloadThread = AttachmentManager.getBGThreadForAttachment((String)this.message.getKeyString());
            if (this.mDownloadThread != null) {
                this.mDownloadThread.setAttachementViewNew(this.attachmentViewProperties);
            }
        }
    }

    public void hideView(boolean hideView) {
        this.mainLayout.setVisibility(hideView ? 8 : 0);
    }

    public void showPreview() {
        this.mainLayout.setVisibility(0);
        this.previewLayout.setVisibility(0);
        this.uploadDownloadImage.setImageResource(R.drawable.circle_arrow_down_download);
        this.downloadInProgressLayout.setVisibility(8);
        this.downloadedLayout.setVisibility(8);
        this.retryLayout.setVisibility(8);
    }

    public void showDownloadInProgress() {
        Utils.printLog((Context)this.context, (String)TAG, (String)"showDownloadInProgress :: ");
        this.mainLayout.setVisibility(0);
        this.downloadInProgressLayout.setVisibility(0);
        this.previewLayout.setVisibility(8);
        this.downloadedLayout.setVisibility(8);
        this.retryLayout.setVisibility(8);
    }

    public void showDownloaded() {
        Utils.printLog((Context)this.context, (String)TAG, (String)"showDownloaded :: ");
        this.mainLayout.setVisibility(0);
        this.downloadedLayout.setVisibility(0);
        this.previewLayout.setVisibility(8);
        this.downloadInProgressLayout.setVisibility(8);
        this.retryLayout.setVisibility(8);
    }

    public void registerEvents() {
        this.previewLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!AttachmentManager.isAttachmentInProgress((String)ApplozicDocumentView.this.message.getKeyString())) {
                    ApplozicDocumentView.this.mDownloadThread = AttachmentManager.startDownload((AttachmentViewProperties)ApplozicDocumentView.this.attachmentViewProperties, (boolean)ApplozicDocumentView.this.mCacheFlag);
                    ApplozicDocumentView.this.showDownloadInProgress();
                }
                if (ApplozicDocumentView.this.mDownloadThread == null) {
                    ApplozicDocumentView.this.mDownloadThread = AttachmentManager.getBGThreadForAttachment((String)ApplozicDocumentView.this.message.getKeyString());
                    if (ApplozicDocumentView.this.mDownloadThread != null) {
                        ApplozicDocumentView.this.mDownloadThread.setAttachementViewNew(ApplozicDocumentView.this.attachmentViewProperties);
                    }
                }
            }
        });
        this.downloadedLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String mimeType = FileUtils.getMimeType((String)ApplozicDocumentView.this.message.getFileMetas().getName());
                if (Utils.hasNougat()) {
                    ApplozicDocumentView.this.uri = FileProvider.getUriForFile((Context)ApplozicDocumentView.this.context, (String)(Utils.getMetaDataValue((Context)ApplozicDocumentView.this.context, (String)"com.package.name") + ".provider"), (File)new File((String)ApplozicDocumentView.this.message.getFilePaths().get(0)));
                } else {
                    ApplozicDocumentView.this.uri = Uri.fromFile((File)new File((String)ApplozicDocumentView.this.message.getFilePaths().get(0)));
                    Log.i((String)ApplozicDocumentView.TAG, (String)ApplozicDocumentView.this.uri.toString());
                }
                if (mimeType != null && mimeType.contains("audio")) {
                    if (ActivityCompat.checkSelfPermission((Context)ApplozicDocumentView.this.context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                        ActivityCompat.requestPermissions((Activity)((Activity)ApplozicDocumentView.this.context), (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)10);
                    } else {
                        ApplozicAudioManager.getInstance(ApplozicDocumentView.this.context).play(ApplozicDocumentView.this.uri, ApplozicDocumentView.this);
                        ApplozicDocumentView.this.setAudioIcons();
                        ApplozicDocumentView.this.updateApplozicSeekBar();
                    }
                } else {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    intent.setDataAndType(ApplozicDocumentView.this.uri, mimeType);
                    intent.addFlags(1);
                    if (intent.resolveActivity(ApplozicDocumentView.this.context.getPackageManager()) != null) {
                        ApplozicDocumentView.this.context.startActivity(intent);
                    } else {
                        Toast.makeText((Context)ApplozicDocumentView.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                    }
                }
            }
        });
        this.downloadInProgressLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ApplozicDocumentView.this.cancelDownload();
            }
        });
        this.retryLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ApplozicDocumentView.this.message.setCanceled(false);
                MessageDatabaseService messageDatabaseService = new MessageDatabaseService(ApplozicDocumentView.this.context);
                messageDatabaseService.updateCanceledFlag(ApplozicDocumentView.this.message.getMessageId().longValue(), 0);
                Intent intent = new Intent(ApplozicDocumentView.this.context, MessageIntentService.class);
                intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)ApplozicDocumentView.this.message, Message.class));
                MessageIntentService.enqueueWork((Context)ApplozicDocumentView.this.context, (Intent)intent);
                ApplozicDocumentView.this.showDownloadInProgress();
            }
        });
    }

    public void setAudioIcons() {
        int state = ApplozicAudioManager.getInstance(this.context).getAudioState(this.message.getKeyString());
        Utils.printLog((Context)this.context, (String)"statee:", (String)String.valueOf(state));
        if (state == 1) {
            this.docIcon.setImageResource(R.drawable.ic_pause_circle_outline);
        } else {
            this.docIcon.setImageResource(R.drawable.ic_play_circle_outline);
        }
    }

    public boolean isUploadRequire() {
        return this.message.hasAttachment() && this.message.isTypeOutbox() && !this.message.isSentToServer();
    }

    public boolean isDownloadRequire() {
        return this.message.hasAttachment() && this.message.isSentToServer() && this.message.getFileMetas() != null && this.message.getFilePaths() != null;
    }

    public void cancelDownload() {
        if (this.mDownloadThread == null) {
            if (this.message.isAttachmentUploadInProgress()) {
                this.message.setCanceled(true);
            }
            return;
        }
        AttachmentManager.removeDownload((AttachmentTask)this.mDownloadThread, (boolean)true);
        this.getDownloadProgressLayout().setVisibility(8);
        this.showPreview();
    }

    public View getDownloadProgressLayout() {
        return this.downloadInProgressLayout;
    }

    public void updateApplozicSeekBar() {
        MediaPlayer mediaplayer = ApplozicAudioManager.getInstance(this.context).getMediaPlayer(this.message.getKeyString());
        if (mediaplayer == null) {
            this.audioseekbar.setProgress(0);
        } else if (mediaplayer.isPlaying()) {
            this.audioseekbar.setMax(mediaplayer.getDuration());
            this.audioseekbar.setProgress(mediaplayer.getCurrentPosition());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ApplozicDocumentView.this.updateApplozicSeekBar();
                }
            };
            this.mHandler.postDelayed(runnable, 500L);
        } else {
            this.audioseekbar.setMax(mediaplayer.getDuration());
            this.audioseekbar.setProgress(mediaplayer.getCurrentPosition());
        }
    }
}

