/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALBookingDetailsModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALGuestCountModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.AlHotelBookingModel;
import com.applozic.mobicommons.json.GsonUtils;
import com.bumptech.glide.Glide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ALRichMessageAdapter
extends RecyclerView.Adapter {
    private Context context;
    private ALRichMessageModel model;
    private List<AlHotelBookingModel> hotelList;
    private List<AlHotelBookingModel> roomList;
    private List<ALGuestCountModel> guestList;
    private ALRichMessageListener listener;
    private List<ALRichMessageModel.ALPayloadModel> payloadList;
    private Message message;
    List<String> titleList;

    public ALRichMessageAdapter(Context context, ALRichMessageModel model, ALRichMessageListener listener, Message message) {
        this.model = model;
        this.context = context;
        this.model = model;
        this.listener = listener;
        this.message = message;
        if (model.getHotelList() != null) {
            this.hotelList = Arrays.asList((AlHotelBookingModel[])GsonUtils.getObjectFromJson((String)model.getHotelList(), AlHotelBookingModel[].class));
        }
        if (model.getPayload() != null) {
            this.payloadList = Arrays.asList((ALRichMessageModel.ALPayloadModel[])GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel[].class));
        }
        if (model.getTemplateId() == 1) {
            ALGuestCountModel guestCount = new ALGuestCountModel();
            this.guestList = new ArrayList<ALGuestCountModel>();
            this.guestList.add(guestCount);
        }
        if (model.getHotelRoomDetail() != null) {
            AlHotelBookingModel.RoomDetailModel roomDetailModel = (AlHotelBookingModel.RoomDetailModel)((Object)GsonUtils.getObjectFromJson((String)model.getHotelRoomDetail(), AlHotelBookingModel.RoomDetailModel.class));
            this.roomList = roomDetailModel.getHotelRoomsDetails();
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.model != null && this.model.getHotelRoomDetail() != null) {
            View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_hotel_details_layout, parent, false);
            return new HotelDetailHolder(itemView);
        }
        if (this.model != null && this.model.getTemplateId() == 5) {
            View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_booking_details_layout, parent, false);
            return new BookingDetailsHolder(itemView);
        }
        if (this.model != null && this.model.getTemplateId() == 1) {
            View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_guest_details_layout, parent, false);
            return new GuestCountHolder(itemView);
        }
        if (this.hotelList != null) {
            View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_rich_message_item, parent, false);
            return new MyViewHolder(itemView);
        }
        if (this.model != null && this.model.getTemplateId() == 2) {
            View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_rich_message_item, parent, false);
            return new MyViewHolder(itemView);
        }
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_rich_message_single_text_item, parent, false);
        return new SingleTextViewHolder(itemView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.model.getHotelRoomDetail() != null) {
            HotelDetailHolder detailHolder = (HotelDetailHolder)holder;
            this.bindRoomDetailView(detailHolder, position);
        } else if (this.model.getTemplateId() == 5) {
            BookingDetailsHolder bookingDetailsHolder = (BookingDetailsHolder)holder;
            this.bindBookingDetailHolder(bookingDetailsHolder, position);
        } else if (this.hotelList != null || this.model != null && this.model.getTemplateId() == 2) {
            MyViewHolder viewHolder = (MyViewHolder)holder;
            this.bindHotelView(viewHolder, position);
        } else if (this.model != null && this.model.getTemplateId() == 1) {
            GuestCountHolder guestCountHolder = (GuestCountHolder)holder;
            this.bindGuestInfoView(guestCountHolder, position);
        } else if (this.model != null && (this.model.getTemplateId() == 6 || this.model.getTemplateId() == 3)) {
            SingleTextViewHolder singleTextViewHolder = (SingleTextViewHolder)holder;
            this.bindSingleTextItem(singleTextViewHolder, position);
        }
    }

    public int getItemCount() {
        if (this.hotelList != null) {
            return this.hotelList.size();
        }
        if (this.model.getTemplateId() == 1) {
            return this.guestList.size();
        }
        if (this.model.getTemplateId() == 6 || this.model.getTemplateId() == 3) {
            return this.payloadList.size();
        }
        if (this.roomList != null) {
            return this.roomList.size();
        }
        if (this.model.getTemplateId() == 5) {
            return 1;
        }
        if (this.model.getTemplateId() == 2) {
            return this.payloadList.size();
        }
        return 0;
    }

    private void setGuestInfoClickListeners(final GuestCountHolder holder, final int position) {
        holder.adultCountDecBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int count = Integer.parseInt(holder.adultCountTv.getText().toString());
                ALGuestCountModel guestModel = (ALGuestCountModel)((Object)ALRichMessageAdapter.this.guestList.get(position));
                if (count > 1) {
                    holder.adultCountTv.setText((CharSequence)String.valueOf(count - 1));
                    guestModel.setNoOfAdults(String.valueOf(count - 1));
                }
            }
        });
        holder.adultCountIncrementBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int count = Integer.parseInt(holder.adultCountTv.getText().toString());
                ALGuestCountModel guestModel = (ALGuestCountModel)((Object)ALRichMessageAdapter.this.guestList.get(position));
                if (count < 5) {
                    holder.adultCountTv.setText((CharSequence)String.valueOf(count + 1));
                    guestModel.setNoOfAdults(String.valueOf(count + 1));
                }
            }
        });
        holder.childCountDecBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int count = Integer.parseInt(holder.childCountTv.getText().toString());
                ALGuestCountModel guestModel = (ALGuestCountModel)((Object)ALRichMessageAdapter.this.guestList.get(position));
                if (count > 0) {
                    holder.childCountTv.setText((CharSequence)String.valueOf(count - 1));
                    guestModel.getChildAge().remove(guestModel.getChildAge().size() - 1);
                    guestModel.setNoOfChild(String.valueOf(count - 1));
                }
            }
        });
        holder.childCountIncrementBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int count = Integer.parseInt(holder.childCountTv.getText().toString());
                ALGuestCountModel guestModel = (ALGuestCountModel)((Object)ALRichMessageAdapter.this.guestList.get(position));
                if (count < 2) {
                    holder.childCountTv.setText((CharSequence)String.valueOf(count + 1));
                    guestModel.getChildAge().add(10);
                    guestModel.setNoOfChild(String.valueOf(count + 1));
                }
            }
        });
        holder.addRoomTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ALGuestCountModel model = new ALGuestCountModel();
                ALRichMessageAdapter.this.guestList.add(model);
                ALRichMessageAdapter.this.notifyDataSetChanged();
            }
        });
        holder.removeRoomTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ALRichMessageAdapter.this.guestList.remove(position);
                ALRichMessageAdapter.this.notifyDataSetChanged();
            }
        });
        holder.doneTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "sendGuestList", null, ALRichMessageAdapter.this.guestList);
            }
        });
    }

    private void bindGuestInfoView(GuestCountHolder holder, int position) {
        ALGuestCountModel guestModel = this.guestList.get(position);
        if (guestModel != null) {
            holder.roomDetailTv.setText((CharSequence)("ROOM " + String.valueOf(position + 1)));
            holder.adultCountTv.setText((CharSequence)guestModel.getNoOfAdults());
            holder.childCountTv.setText((CharSequence)guestModel.getNoOfChild());
            if (position == this.guestList.size() - 1) {
                holder.addRoomTv.setVisibility(0);
                holder.doneTv.setVisibility(0);
            } else {
                holder.addRoomTv.setVisibility(8);
                holder.doneTv.setVisibility(8);
            }
            if (this.guestList.size() > 1 && position == 0) {
                holder.selectionActionLayout.setVisibility(8);
            } else {
                holder.selectionActionLayout.setVisibility(0);
            }
            if (position == 0) {
                holder.removeRoomTv.setVisibility(8);
            } else {
                holder.removeRoomTv.setVisibility(0);
            }
            this.setGuestInfoClickListeners(holder, position);
        }
    }

    private void bindHotelView(MyViewHolder viewHolder, int position) {
        if (this.hotelList != null) {
            final AlHotelBookingModel hotel = this.hotelList.get(position);
            if (!TextUtils.isEmpty((CharSequence)hotel.getHotelName())) {
                viewHolder.productNameSingleLine.setText((CharSequence)(hotel.getHotelName() + " (" + hotel.getStarRating() + "/5)"));
            } else {
                viewHolder.productNameSingleLine.setText((CharSequence)("Name Unavailable (" + hotel.getStarRating() + "/5)"));
            }
            viewHolder.productPrice.setText((CharSequence)(this.context.getString(R.string.rupee_symbol) + " " + hotel.getPrice().getRoomPrice()));
            if (!TextUtils.isEmpty((CharSequence)hotel.getHotelPicture())) {
                Glide.with((Context)this.context).load(hotel.getHotelPicture()).into(viewHolder.productImage);
            } else {
                viewHolder.productImage.setImageBitmap(null);
            }
            if (!TextUtils.isEmpty((CharSequence)hotel.getHotelAddress())) {
                viewHolder.productLocation.setText((CharSequence)hotel.getHotelAddress());
            } else {
                viewHolder.productLocation.setText((CharSequence)"Address unavailable");
            }
            if (!TextUtils.isEmpty((CharSequence)hotel.getHotelDescription())) {
                viewHolder.productDescription.setText((CharSequence)hotel.getHotelDescription());
            } else {
                viewHolder.productDescription.setText((CharSequence)"Description unavailable");
            }
            viewHolder.bookAction2.setVisibility(8);
            viewHolder.bookAction3.setVisibility(8);
            viewHolder.viewAction2.setVisibility(8);
            viewHolder.viewAction3.setVisibility(8);
            viewHolder.bookAction1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    hotel.setSessionId(ALRichMessageAdapter.this.model.getSessionId());
                    ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "sendHotelDetails", null, (Object)hotel);
                }
            });
        } else if (this.payloadList != null) {
            ALRichMessageModel.ALPayloadModel payload = this.payloadList.get(position);
            if (!TextUtils.isEmpty((CharSequence)payload.getHeaderImageUrl())) {
                Glide.with((Context)this.context).load(payload.getHeaderImageUrl()).into(viewHolder.productImage);
                viewHolder.productImage.setVisibility(0);
                viewHolder.productImageOverlay.setVisibility(0);
                viewHolder.productPrice.setBackground(this.context.getResources().getDrawable(R.drawable.al_rich_messaging_price_border));
            } else {
                viewHolder.productImage.setVisibility(8);
                viewHolder.productImageOverlay.setVisibility(8);
                viewHolder.productPrice.setBackground(this.context.getResources().getDrawable(R.drawable.al_imageless_rich_message_price_border));
            }
            if (!TextUtils.isEmpty((CharSequence)payload.getOverlayText())) {
                viewHolder.productPrice.setText((CharSequence)payload.getOverlayText());
                viewHolder.productPrice.setVisibility(0);
            } else {
                viewHolder.productPrice.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)payload.getRating())) {
                viewHolder.productNameSplitLayout.setVisibility(8);
                if (!TextUtils.isEmpty((CharSequence)payload.getTitle())) {
                    viewHolder.productNameSingleLine.setVisibility(0);
                    viewHolder.productNameSingleLine.setText((CharSequence)payload.getTitle());
                } else {
                    viewHolder.productNameSingleLine.setVisibility(8);
                }
            } else {
                viewHolder.productNameSplitLayout.setVisibility(0);
                viewHolder.productNameSingleLine.setVisibility(8);
                viewHolder.productName.setVisibility(0);
                viewHolder.productRating.setText((CharSequence)payload.getRating());
                if (!TextUtils.isEmpty((CharSequence)payload.getTitle())) {
                    viewHolder.productName.setText((CharSequence)payload.getTitle());
                } else {
                    viewHolder.productName.setText((CharSequence)"");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)payload.getSubtitle())) {
                viewHolder.productLocation.setVisibility(0);
                viewHolder.productLocation.setText((CharSequence)payload.getSubtitle());
            } else {
                viewHolder.productLocation.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)payload.getDescription())) {
                viewHolder.productDescription.setVisibility(0);
                viewHolder.productDescription.setText((CharSequence)payload.getDescription());
            } else {
                viewHolder.productDescription.setVisibility(8);
            }
            viewHolder.bookAction1.setVisibility(8);
            viewHolder.bookAction2.setVisibility(8);
            viewHolder.bookAction3.setVisibility(8);
            viewHolder.viewAction1.setVisibility(8);
            viewHolder.viewAction2.setVisibility(8);
            viewHolder.viewAction3.setVisibility(8);
            if (payload.getActions() != null && !payload.getActions().isEmpty()) {
                try {
                    List<ALRichMessageModel.AlActionModel> actionsList = payload.getActions();
                    for (int i = 0; i < actionsList.size(); ++i) {
                        if (i == 0) {
                            viewHolder.bookAction1.setVisibility(0);
                            viewHolder.viewAction1.setVisibility(0);
                            viewHolder.bookAction1.setText((CharSequence)actionsList.get(0).getName());
                            viewHolder.bookAction1.setOnClickListener(this.getActionClickListener(actionsList.get(0)));
                        }
                        if (i == 1) {
                            viewHolder.bookAction2.setVisibility(0);
                            viewHolder.viewAction2.setVisibility(0);
                            viewHolder.bookAction2.setText((CharSequence)actionsList.get(1).getName());
                            viewHolder.bookAction2.setOnClickListener(this.getActionClickListener(actionsList.get(1)));
                        }
                        if (i != 2) continue;
                        viewHolder.bookAction3.setVisibility(0);
                        viewHolder.viewAction3.setVisibility(0);
                        viewHolder.bookAction3.setText((CharSequence)actionsList.get(2).getName());
                        viewHolder.bookAction3.setOnClickListener(this.getActionClickListener(actionsList.get(2)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void bindSingleTextItem(SingleTextViewHolder holder, int position) {
        if (this.model.getTemplateId() == 3) {
            if (this.payloadList.get(position).getName() != null) {
                holder.singleTextItem.setText((CharSequence)this.payloadList.get(position).getName().trim());
            } else {
                holder.singleTextItem.setText((CharSequence)"");
            }
        } else if (this.payloadList.get(position).getTitle() != null) {
            holder.singleTextItem.setText((CharSequence)this.payloadList.get(position).getTitle().trim());
        } else {
            holder.singleTextItem.setText((CharSequence)"");
        }
    }

    private void bindRoomDetailView(HotelDetailHolder holder, int position) {
        final AlHotelBookingModel hotel = this.roomList.get(position);
        if (hotel != null) {
            if (!TextUtils.isEmpty((CharSequence)hotel.getRoomTypeName())) {
                holder.roomTypeTv.setText((CharSequence)hotel.getRoomTypeName());
            } else {
                holder.roomTypeTv.setText((CharSequence)"Room name unavailable");
            }
            if (!TextUtils.isEmpty((CharSequence)hotel.getHotelPicture())) {
                Glide.with((Context)this.context).load(hotel.getHotelPicture()).into(holder.productImage);
            } else {
                holder.productImage.setImageDrawable(null);
            }
            holder.noOfGuestTv.setText((CharSequence)String.valueOf(hotel.getNoOfGuest()));
            String text = "(1 Room for " + String.valueOf(hotel.getNoOfNights()) + " Nights)";
            holder.totalPriceHeaderTv.setText((CharSequence)text);
            holder.priceTv.setText((CharSequence)(this.context.getString(R.string.rupee_symbol) + " " + String.valueOf(hotel.getPrice().getRoomPrice())));
            holder.totalPriceTv.setText((CharSequence)(this.context.getString(R.string.rupee_symbol) + " " + String.valueOf(hotel.getPrice().getRoomPrice() * (float)hotel.getNoOfNights())));
            holder.bookAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    hotel.setSessionId(ALRichMessageAdapter.this.model.getSessionId());
                    ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "sendRoomDetailsMessage", null, (Object)hotel);
                }
            });
        }
    }

    private void bindBookingDetailHolder(final BookingDetailsHolder holder, int position) {
        final ALBookingDetailsModel detailsModel = new ALBookingDetailsModel();
        detailsModel.setSessionId(this.model.getSessionId());
        final ALBookingDetailsModel.ALBookingDetails bookingDetails = detailsModel.getPersonInfo();
        holder.titleSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                bookingDetails.setTitle(ALRichMessageAdapter.this.titleList.get(position));
            }

            public void onNothingSelected(AdapterView<?> parent) {
                bookingDetails.setTitle("Title *");
            }
        });
        holder.submitAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.isEmpty((CharSequence)holder.firstNameEt.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)holder.lastNameEt.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)holder.emailIdEt.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)holder.firstNameEt.getText().toString().trim()) || "Title *".equals(ALRichMessageAdapter.this.titleList.get(holder.titleSpinner.getSelectedItemPosition()))) {
                    Toast.makeText((Context)ALRichMessageAdapter.this.context, (CharSequence)"Mandatory fields required...", (int)0).show();
                } else {
                    bookingDetails.setTitle(ALRichMessageAdapter.this.titleList.get(holder.titleSpinner.getSelectedItemPosition()));
                    bookingDetails.setFirstName(holder.firstNameEt.getText().toString().trim());
                    bookingDetails.setLastName(holder.lastNameEt.getText().toString().trim());
                    bookingDetails.setEmailId(holder.emailIdEt.getText().toString().trim());
                    bookingDetails.setPhoneNo(holder.contactNumberEt.getText().toString().trim());
                    ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "sendBookingDetails", null, (Object)detailsModel);
                }
            }
        });
    }

    private View.OnClickListener getActionClickListener(final ALRichMessageModel.AlActionModel action) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (ALRichMessageAdapter.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                    ((ALRichMessageListener)ALRichMessageAdapter.this.context.getApplicationContext()).onAction(ALRichMessageAdapter.this.context, action.getAction(), ALRichMessageAdapter.this.message, action.getData());
                }
                if (ALRichMessageAdapter.this.listener != null) {
                    ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, action.getAction(), ALRichMessageAdapter.this.message, action.getData());
                }
            }
        };
    }

    private class SingleTextViewHolder
    extends RecyclerView.ViewHolder {
        TextView singleTextItem;
        LinearLayout rootLayout;

        public SingleTextViewHolder(View itemView) {
            super(itemView);
            this.singleTextItem = (TextView)itemView.findViewById(R.id.singleTextItem);
            this.rootLayout = (LinearLayout)itemView.findViewById(R.id.rootLayout);
            this.singleTextItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ALRichMessageAdapter.this.model != null && ALRichMessageAdapter.this.model.getTemplateId() == 6) {
                        if (ALRichMessageAdapter.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                            ((ALRichMessageListener)ALRichMessageAdapter.this.context.getApplicationContext()).onAction(ALRichMessageAdapter.this.context, "Click", ALRichMessageAdapter.this.message, ((ALRichMessageModel.ALPayloadModel)((Object)ALRichMessageAdapter.this.payloadList.get(SingleTextViewHolder.this.getLayoutPosition()))).getMessage().trim());
                        }
                        ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "sendHotelRating", null, ((ALRichMessageModel.ALPayloadModel)((Object)ALRichMessageAdapter.this.payloadList.get(SingleTextViewHolder.this.getLayoutPosition()))).getMessage().trim());
                    } else {
                        if (ALRichMessageAdapter.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                            ((ALRichMessageListener)ALRichMessageAdapter.this.context.getApplicationContext()).onAction(ALRichMessageAdapter.this.context, "Click", ALRichMessageAdapter.this.message, (Object)ALRichMessageAdapter.this.model);
                        }
                        ALRichMessageAdapter.this.listener.onAction(ALRichMessageAdapter.this.context, "makePayment", null, (Object)ALRichMessageAdapter.this.model);
                    }
                }
            });
        }
    }

    private class GuestCountHolder
    extends RecyclerView.ViewHolder {
        TextView adultCountTv;
        TextView childCountTv;
        Button adultCountDecBt;
        Button childCountDecBt;
        Button adultCountIncrementBt;
        Button childCountIncrementBt;
        TextView roomDetailTv;
        TextView addRoomTv;
        TextView removeRoomTv;
        TextView doneTv;
        LinearLayout selectionActionLayout;
        LinearLayout selectionRootLayout;

        public GuestCountHolder(View itemView) {
            super(itemView);
            this.adultCountTv = (TextView)itemView.findViewById(R.id.adultCountTv);
            this.childCountTv = (TextView)itemView.findViewById(R.id.childCountTv);
            this.adultCountIncrementBt = (Button)itemView.findViewById(R.id.adultCountIncrementBt);
            this.childCountIncrementBt = (Button)itemView.findViewById(R.id.childCountIncrementBt);
            this.adultCountDecBt = (Button)itemView.findViewById(R.id.adultCountDecBt);
            this.childCountDecBt = (Button)itemView.findViewById(R.id.childCountDecBt);
            this.roomDetailTv = (TextView)itemView.findViewById(R.id.alRoomDetailsTv);
            this.addRoomTv = (TextView)itemView.findViewById(R.id.addRoomTv);
            this.removeRoomTv = (TextView)itemView.findViewById(R.id.removeRoomTv);
            this.doneTv = (TextView)itemView.findViewById(R.id.doneButtonTv);
            this.selectionActionLayout = (LinearLayout)itemView.findViewById(R.id.actionLayout);
            this.selectionRootLayout = (LinearLayout)itemView.findViewById(R.id.rootSelectionLayout);
        }
    }

    private class BookingDetailsHolder
    extends RecyclerView.ViewHolder {
        Spinner titleSpinner;
        EditText firstNameEt;
        EditText lastNameEt;
        EditText emailIdEt;
        EditText contactNumberEt;
        TextView submitAction;

        public BookingDetailsHolder(View itemView) {
            super(itemView);
            this.titleSpinner = (Spinner)itemView.findViewById(R.id.titleSpinner);
            this.firstNameEt = (EditText)itemView.findViewById(R.id.firstNameEt);
            this.lastNameEt = (EditText)itemView.findViewById(R.id.lastNameEt);
            this.emailIdEt = (EditText)itemView.findViewById(R.id.emailIdEt);
            this.contactNumberEt = (EditText)itemView.findViewById(R.id.contactNumberEt);
            this.submitAction = (TextView)itemView.findViewById(R.id.submitDetails);
            ALRichMessageAdapter.this.titleList = new ArrayList<String>();
            ALRichMessageAdapter.this.titleList.add("Title *");
            ALRichMessageAdapter.this.titleList.add("Mr.");
            ALRichMessageAdapter.this.titleList.add("Ms.");
            ALRichMessageAdapter.this.titleList.add("Mrs");
            ArrayAdapter adapter = new ArrayAdapter(ALRichMessageAdapter.this.context, 17367048, ALRichMessageAdapter.this.titleList);
            this.titleSpinner.setAdapter((SpinnerAdapter)adapter);
        }
    }

    private class HotelDetailHolder
    extends RecyclerView.ViewHolder {
        ImageView productImage;
        TextView roomTypeTv;
        TextView noOfGuestTv;
        TextView priceTv;
        TextView totalPriceHeaderTv;
        TextView totalPriceTv;
        TextView bookAction;

        public HotelDetailHolder(View itemView) {
            super(itemView);
            this.productImage = (ImageView)itemView.findViewById(R.id.productImage);
            this.roomTypeTv = (TextView)itemView.findViewById(R.id.roomTypeTv);
            this.noOfGuestTv = (TextView)itemView.findViewById(R.id.noOfGuestsTv);
            this.priceTv = (TextView)itemView.findViewById(R.id.hotelPriceTv);
            this.totalPriceHeaderTv = (TextView)itemView.findViewById(R.id.totalPriceDistTv);
            this.totalPriceTv = (TextView)itemView.findViewById(R.id.totalPriceTv);
            this.bookAction = (TextView)itemView.findViewById(R.id.bookingAction);
        }
    }

    private class MyViewHolder
    extends RecyclerView.ViewHolder {
        LinearLayout roomRootLayout;
        TextView productNameSingleLine;
        TextView productPrice;
        ImageView productImage;
        TextView productRating;
        TextView productLocation;
        TextView productDescription;
        RelativeLayout productNameSplitLayout;
        TextView productName;
        View productImageOverlay;
        TextView bookAction1;
        TextView bookAction2;
        TextView bookAction3;
        View viewAction1;
        View viewAction2;
        View viewAction3;

        public MyViewHolder(View itemView) {
            super(itemView);
            this.roomRootLayout = (LinearLayout)itemView.findViewById(R.id.roomRootLayout);
            this.productNameSingleLine = (TextView)itemView.findViewById(R.id.productNameSingleLine);
            this.productImage = (ImageView)itemView.findViewById(R.id.productImage);
            this.productRating = (TextView)itemView.findViewById(R.id.productRating);
            this.productLocation = (TextView)itemView.findViewById(R.id.productLocation);
            this.productPrice = (TextView)itemView.findViewById(R.id.productPrice);
            this.productDescription = (TextView)itemView.findViewById(R.id.productDescription);
            this.productName = (TextView)itemView.findViewById(R.id.productName);
            this.productImageOverlay = itemView.findViewById(R.id.productImageOverlay);
            this.productNameSplitLayout = (RelativeLayout)itemView.findViewById(R.id.productNameSplitLayout);
            this.productRating = (TextView)itemView.findViewById(R.id.productRating);
            this.bookAction1 = (TextView)itemView.findViewById(R.id.bookingAction1);
            this.bookAction2 = (TextView)itemView.findViewById(R.id.bookingAction2);
            this.bookAction3 = (TextView)itemView.findViewById(R.id.bookingAction3);
            this.viewAction1 = itemView.findViewById(R.id.viewAction1);
            this.viewAction2 = itemView.findViewById(R.id.viewAction2);
            this.viewAction3 = itemView.findViewById(R.id.viewAction3);
        }
    }
}

