/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class RecyclerViewPositionHelper {
    RecyclerView recyclerView;
    LinearLayoutManager linearLayoutManager;

    public RecyclerViewPositionHelper(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public RecyclerViewPositionHelper(RecyclerView recyclerView, LinearLayoutManager linearLayoutManager) {
        this.recyclerView = recyclerView;
        this.linearLayoutManager = linearLayoutManager;
    }

    public static RecyclerViewPositionHelper createHelper(RecyclerView recyclerView) {
        if (recyclerView == null) {
            throw new NullPointerException("Recycler View is null");
        }
        return new RecyclerViewPositionHelper(recyclerView);
    }

    public int getItemCount() {
        return this.linearLayoutManager == null ? 0 : this.linearLayoutManager.getItemCount();
    }

    public int findFirstVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.linearLayoutManager.getChildCount(), false, true);
        return child == null ? -1 : this.recyclerView.getChildAdapterPosition(child);
    }

    public int findFirstCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.linearLayoutManager.getChildCount(), true, false);
        return child == null ? -1 : this.recyclerView.getChildAdapterPosition(child);
    }

    public int findLastVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.linearLayoutManager.getChildCount() - 1, -1, false, true);
        return child == null ? -1 : this.recyclerView.getChildAdapterPosition(child);
    }

    public int findLastCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.linearLayoutManager.getChildCount() - 1, -1, true, false);
        return child == null ? -1 : this.recyclerView.getChildAdapterPosition(child);
    }

    View findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible, boolean acceptPartiallyVisible) {
        OrientationHelper helper = this.linearLayoutManager.canScrollVertically() ? OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this.linearLayoutManager) : OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this.linearLayoutManager);
        int start = helper.getStartAfterPadding();
        int end = helper.getEndAfterPadding();
        int next = toIndex > fromIndex ? 1 : -1;
        View partiallyVisible = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.linearLayoutManager.getChildAt(i);
            int childStart = helper.getDecoratedStart(child);
            int childEnd = helper.getDecoratedEnd(child);
            if (childStart >= end || childEnd <= start) continue;
            if (completelyVisible) {
                if (childStart >= start && childEnd <= end) {
                    return child;
                }
                if (!acceptPartiallyVisible || partiallyVisible != null) continue;
                partiallyVisible = child;
                continue;
            }
            return child;
        }
        return partiallyVisible;
    }
}

