/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.FileProvider;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.RegisteredUsersAsyncTask;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.RemoveInterfaceListener;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.PictureUploadPopUpFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicomkit.uiwidgets.uilistener.MobicomkitUriListener;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChannelCreateActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback,
MobicomkitUriListener,
RemoveInterfaceListener {
    public static final String ACTION_FINISH_CHANNEL_CREATE = "channelCreateActivity.ACTION_FINISH";
    private static final int REQUEST_CODE_ATTACH_PHOTO = 901;
    private static final String TAG = "ChannelCreateActivity";
    public static String GROUP_TYPE = "GroupType";
    public static String CONTACTS_GROUP_ID = "ContactsGroupId";
    public String contactsGroupId;
    MobiComUserPreference userPreference;
    AlCustomizationSettings alCustomizationSettings;
    ConnectivityReceiver connectivityReceiver;
    File profilePhotoFile;
    FileClientService fileClientService;
    private EditText channelName;
    private CircleImageView circleImageView;
    private View focus;
    private ActionBar mActionBar;
    private ImageView uploadImageButton;
    private Uri imageChangeUri;
    private String groupIconImageLink;
    private int groupType;
    private LinearLayout layout;
    private Snackbar snackbar;
    private ApplozicPermissions applozicPermissions;
    private FinishActivityReceiver finishActivityReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.channel_create_activty_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.connectivityReceiver = new ConnectivityReceiver();
        this.userPreference = MobiComUserPreference.getInstance((Context)this);
        this.mActionBar = this.getSupportActionBar();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimary()) && !TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimaryDark())) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimary())));
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimaryDark()));
            }
        }
        this.mActionBar.setTitle(R.string.channel_create_title);
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.finishActivityReceiver = new FinishActivityReceiver();
        this.registerReceiver(this.finishActivityReceiver, new IntentFilter(ACTION_FINISH_CHANNEL_CREATE));
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermissions = new ApplozicPermissions((Activity)this, this.layout);
        this.channelName = (EditText)this.findViewById(R.id.channelName);
        this.circleImageView = (CircleImageView)this.findViewById(R.id.channelIcon);
        this.uploadImageButton = (CircleImageView)this.findViewById(R.id.applozic_channel_profile_camera);
        this.uploadImageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelCreateActivity.this.processImagePicker();
            }
        });
        int drawableResourceId = this.getResources().getIdentifier(this.alCustomizationSettings.getAttachCameraIconName(), "drawable", this.getPackageName());
        this.uploadImageButton.setImageResource(drawableResourceId);
        this.fileClientService = new FileClientService((Context)this);
        if (this.getIntent() != null) {
            this.groupType = this.getIntent().getIntExtra(GROUP_TYPE, Channel.GroupType.PUBLIC.getValue().intValue());
            this.contactsGroupId = this.getIntent().getStringExtra(CONTACTS_GROUP_ID);
        }
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.group_create_menu, menu2);
        menu2.removeItem(R.id.Done);
        menu2.findItem(R.id.menu_search).setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.Next) {
            boolean check = true;
            if (this.channelName.getText().toString().trim().length() == 0 || TextUtils.isEmpty((CharSequence)this.channelName.getText().toString())) {
                this.focus = this.channelName;
                this.focus.requestFocus();
                check = false;
            }
            if (check) {
                Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
                if (this.alCustomizationSettings.getTotalRegisteredUserToFetch() > 0 && (this.alCustomizationSettings.isRegisteredUserContactListCall() || ApplozicSetting.getInstance((Context)this).isRegisteredUsersContactCall()) && !this.userPreference.getWasContactListServerCallAlreadyDone()) {
                    this.processDownloadRegisteredUsers();
                } else {
                    Intent intent = new Intent((Context)this, ContactSelectionActivity.class);
                    intent.putExtra("CHANNEL_NAME", this.channelName.getText().toString());
                    if (!TextUtils.isEmpty((CharSequence)this.groupIconImageLink)) {
                        intent.putExtra("IMAGE_LINK", this.groupIconImageLink);
                    }
                    if (this.contactsGroupId != null) {
                        intent.putExtra("CONTACTS_GROUP_ID", this.contactsGroupId);
                    }
                    intent.putExtra("GROUP_TYPE", this.groupType);
                    this.startActivity(intent);
                }
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void processDownloadRegisteredUsers() {
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        RegisteredUsersAsyncTask.TaskListener usersAsyncTaskTaskListener = new RegisteredUsersAsyncTask.TaskListener(){

            public void onSuccess(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                ChannelCreateActivity.this.userPreference.setWasContactListServerCallAlreadyDone(Boolean.valueOf(true));
                Intent intent = new Intent((Context)ChannelCreateActivity.this, ContactSelectionActivity.class);
                intent.putExtra("CHANNEL_NAME", ChannelCreateActivity.this.channelName.getText().toString());
                if (!TextUtils.isEmpty((CharSequence)ChannelCreateActivity.this.groupIconImageLink)) {
                    intent.putExtra("IMAGE_LINK", ChannelCreateActivity.this.groupIconImageLink);
                }
                intent.putExtra("GROUP_TYPE", ChannelCreateActivity.this.groupType);
                ChannelCreateActivity.this.startActivity(intent);
            }

            public void onFailure(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray, Exception exception) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                String error = ChannelCreateActivity.this.getString(Utils.isInternetAvailable((Context)ChannelCreateActivity.this) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)ChannelCreateActivity.this, (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
            }
        };
        RegisteredUsersAsyncTask usersAsyncTask = new RegisteredUsersAsyncTask((Context)this, usersAsyncTaskTaskListener, this.alCustomizationSettings.getTotalRegisteredUserToFetch(), this.userPreference.getRegisteredUsersLastFetchTime(), null, null, true);
        usersAsyncTask.execute((Object[])new Void[]{null});
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        try {
            if (requestCode == 203) {
                CropImage.ActivityResult result = CropImage.getActivityResult((Intent)intent);
                if (resultCode == -1) {
                    if (intent == null) {
                        return;
                    }
                    if (this.imageChangeUri != null) {
                        this.imageChangeUri = result.getUri();
                        this.circleImageView.setImageDrawable(null);
                        this.circleImageView.setImageURI(this.imageChangeUri);
                        new ProfilePictureUpload(true, this.profilePhotoFile, this.imageChangeUri, (Context)this).execute(null);
                    } else {
                        this.imageChangeUri = result.getUri();
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
                        this.circleImageView.setImageDrawable(null);
                        this.circleImageView.setImageURI(this.imageChangeUri);
                        this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this, (String)"image/jpeg");
                        new ProfilePictureUpload(true, this.profilePhotoFile, this.imageChangeUri, (Context)this).execute(null);
                    }
                } else if (resultCode == 204) {
                    Toast.makeText((Context)this, (CharSequence)(this.getString(R.string.applozic_Cropping_failed) + result.getError()), (int)1).show();
                }
            }
            if (resultCode == -1) {
                this.handleOnActivityResult(requestCode, intent);
            }
        }
        catch (Exception e) {
            Utils.printLog((Context)this, (String)TAG, (String)"exception in profile image");
        }
    }

    public void handleOnActivityResult(int requestCode, Intent intent) {
        switch (requestCode) {
            case 101: {
                Uri selectedFileUri = intent == null ? null : intent.getData();
                this.imageChangeUri = null;
                this.beginCrop(selectedFileUri);
                break;
            }
            case 102: {
                this.beginCrop(this.imageChangeUri);
            }
        }
    }

    void beginCrop(Uri imageUri) {
        try {
            CropImage.activity((Uri)imageUri).setGuidelines(CropImageView.Guidelines.OFF).setMultiTouchEnabled(true).start((Activity)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeCallBack() {
        try {
            this.imageChangeUri = null;
            this.groupIconImageLink = null;
            this.circleImageView.setImageDrawable(null);
            this.circleImageView.setImageResource(R.drawable.applozic_group_icon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                this.processImagePicker();
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.finishActivityReceiver != null) {
                this.unregisterReceiver(this.finishActivityReceiver);
            }
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processImagePicker() {
        if (PermissionsUtils.isCameraPermissionGranted((Context)this) && !PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    FragmentManager supportFragmentManager = ChannelCreateActivity.this.getSupportFragmentManager();
                    PictureUploadPopUpFragment fragment = PictureUploadPopUpFragment.newInstance(true, ChannelCreateActivity.this.imageChangeUri == null);
                    FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
                    Fragment prev = ChannelCreateActivity.this.getSupportFragmentManager().findFragmentByTag("PhotosAttachmentFragment");
                    if (prev != null) {
                        fragmentTransaction.remove(prev);
                    }
                    fragmentTransaction.addToBackStack(null);
                    fragment.show(fragmentTransaction, "PhotosAttachmentFragment");
                }
            });
        } else if (Utils.hasMarshmallow()) {
            if (PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermissions.requestCameraPermission();
            } else {
                this.applozicPermissions.requestStoragePermissions();
            }
        } else {
            this.processImagePicker();
        }
    }

    @Override
    public Uri getCurrentImageUri() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
        this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
        this.imageChangeUri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)this.profilePhotoFile);
        return this.imageChangeUri;
    }

    private final class FinishActivityReceiver
    extends BroadcastReceiver {
        private FinishActivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && intent.getAction().equals(ChannelCreateActivity.ACTION_FINISH_CHANNEL_CREATE)) {
                ChannelCreateActivity.this.finish();
            }
        }
    }

    class ProfilePictureUpload
    extends AsyncTask<Void, Void, Boolean> {
        Context context;
        Uri fileUri;
        String displayName;
        File file;
        boolean isSaveFile;
        FileClientService fileClientService;
        private ProgressDialog progressDialog;

        public ProfilePictureUpload(boolean isSaveFile, File file, Uri fileUri, Context context) {
            this.context = context;
            this.fileUri = fileUri;
            this.file = file;
            this.isSaveFile = isSaveFile;
            this.fileClientService = new FileClientService(context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Boolean doInBackground(Void ... params) {
            try {
                if (this.fileUri != null) {
                    String filePath = this.file.getAbsolutePath();
                    if (this.isSaveFile) {
                        this.fileClientService.writeFile(this.fileUri, this.file);
                    }
                    ChannelCreateActivity.this.groupIconImageLink = this.fileClientService.uploadProfileImage(filePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
        }
    }
}

