/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;

public class MobicomLocationActivity
extends AppCompatActivity
implements OnMapReadyCallback,
LocationListener,
GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks,
ActivityCompat.OnRequestPermissionsResultCallback {
    SupportMapFragment mapFragment;
    LatLng position;
    RelativeLayout sendLocation;
    private LinearLayout layout;
    public Snackbar snackbar;
    Location mCurrentLocation;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    protected static final long UPDATE_INTERVAL = 5L;
    protected static final long FASTEST_INTERVAL = 1L;
    private ConnectivityReceiver connectivityReceiver;
    AlCustomizationSettings alCustomizationSettings;
    Marker myLocationMarker;
    ApplozicPermissions applozicPermissions;
    static final String TAG = "MobicomLocationActivity";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_applozic_location);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_map_screen);
        toolbar.setTitle((CharSequence)"Send Location");
        this.setSupportActionBar(toolbar);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimary()) && !TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimaryDark())) {
            this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimary())));
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimaryDark()));
            }
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.sendLocation = (RelativeLayout)this.findViewById(R.id.sendLocation);
        this.mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        this.applozicPermissions = new ApplozicPermissions((Activity)this, this.layout);
        this.googleApiClient = new GoogleApiClient.Builder(this.getApplicationContext()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.processLocation();
        this.onNewIntent(this.getIntent());
        this.connectivityReceiver = new ConnectivityReceiver();
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void onMapReady(final GoogleMap googleMap) {
        try {
            if (this.mCurrentLocation != null) {
                this.position = new LatLng(this.mCurrentLocation.getLatitude(), this.mCurrentLocation.getLongitude());
                googleMap.clear();
                MarkerOptions markerOptions = new MarkerOptions();
                markerOptions.draggable(true);
                if (this.myLocationMarker == null) {
                    this.myLocationMarker = googleMap.addMarker(markerOptions.position(this.position).title(""));
                    googleMap.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)this.position, (float)20.0f));
                    googleMap.animateCamera(CameraUpdateFactory.zoomTo((float)17.0f), 2000, null);
                } else {
                    googleMap.addMarker(markerOptions.position(this.myLocationMarker.getPosition()).title(""));
                }
                googleMap.setMyLocationEnabled(true);
                googleMap.getUiSettings().setZoomGesturesEnabled(true);
                googleMap.setOnMarkerDragListener(new GoogleMap.OnMarkerDragListener(){

                    public void onMarkerDragStart(Marker marker) {
                    }

                    public void onMarkerDrag(Marker marker) {
                    }

                    public void onMarkerDragEnd(Marker marker) {
                        if (MobicomLocationActivity.this.myLocationMarker != null) {
                            MobicomLocationActivity.this.myLocationMarker.remove();
                        }
                        MarkerOptions newMarkerOptions = new MarkerOptions();
                        newMarkerOptions.draggable(true);
                        MobicomLocationActivity.this.myLocationMarker = googleMap.addMarker(newMarkerOptions.position(marker.getPosition()).title(""));
                    }
                });
            }
            this.sendLocation.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Utils.printLog((Context)MobicomLocationActivity.this, (String)MobicomLocationActivity.TAG, (String)"On click of send location button");
                    if (MobicomLocationActivity.this.myLocationMarker != null) {
                        Intent intent = new Intent();
                        intent.putExtra("latitude", MobicomLocationActivity.this.myLocationMarker.getPosition().latitude);
                        intent.putExtra("longitude", MobicomLocationActivity.this.myLocationMarker.getPosition().longitude);
                        MobicomLocationActivity.this.setResult(-1, intent);
                        MobicomLocationActivity.this.finish();
                    }
                }
            });
        }
        catch (Exception e) {
            Utils.printLog((Context)this, (String)TAG, (String)"Check if location permission are added");
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        new ConversationUIService((FragmentActivity)this).onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void processingLocation() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    MobicomLocationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)MobicomLocationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    public void processLocation() {
        if (Utils.hasMarshmallow()) {
            this.applozicPermissions.checkRuntimePermissionForLocationActivity();
        } else {
            this.processingLocation();
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.googleApiClient != null) {
            this.googleApiClient.connect();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.googleApiClient != null) {
            this.googleApiClient.disconnect();
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)TAG, (String)"onConnectionSuspended() called.");
    }

    public void onConnected(Bundle bundle) {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return;
            }
            this.mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
            if (this.mCurrentLocation == null) {
                Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
                this.locationRequest = new LocationRequest();
                this.locationRequest.setPriority(102);
                this.locationRequest.setInterval(5L);
                this.locationRequest.setFastestInterval(1L);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
            }
            if (this.mCurrentLocation != null) {
                this.mapFragment.getMapAsync((OnMapReadyCallback)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onLocationChanged(Location location) {
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            if (location != null) {
                this.mCurrentLocation = location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSnackBar(int resId) {
        try {
            this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
            this.snackbar.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.location_permission_granted);
                this.processingLocation();
            } else {
                this.showSnackBar(R.string.location_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}

