/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.FileProvider;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.RemoveInterfaceListener;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.PictureUploadPopUpFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicomkit.uiwidgets.uilistener.MobicomkitUriListener;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChannelNameActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback,
MobicomkitUriListener,
RemoveInterfaceListener {
    public static final String CHANNEL_NAME = "CHANNEL_NAME";
    public static final String CHANNEL_IMAGE_URL = "IMAGE_URL";
    public static final int REQUEST_CODE_ATTACH_PHOTO = 101;
    private static final String TAG = "ChannelNameActivity";
    String oldChannelName;
    ActionBar mActionBar;
    GroupInfoUpdate groupInfoUpdate;
    File profilePhotoFile;
    FileClientService fileClientService;
    private EditText channelName;
    private Button ok;
    private Button cancel;
    private ImageView selectImageProfileIcon;
    private ImageView applozicGroupProfileIcon;
    private LinearLayout layout;
    private Uri imageChangeUri;
    private Snackbar snackbar;
    private ApplozicPermissions applozicPermissions;
    private AlCustomizationSettings alCustomizationSettings;
    private ConnectivityReceiver connectivityReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.update_channel_name_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.mActionBar = this.getSupportActionBar();
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermissions = new ApplozicPermissions((Activity)this, this.layout);
        this.mActionBar.setTitle((CharSequence)this.getString(R.string.update_channel_title_name));
        this.selectImageProfileIcon = (CircleImageView)this.findViewById(R.id.applozic_group_profile_camera);
        this.applozicGroupProfileIcon = (ImageView)this.findViewById(R.id.applozic_group_profile);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.fileClientService = new FileClientService((Context)this);
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimary()) && !TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimaryDark())) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimary())));
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimaryDark()));
            }
        }
        int drawableResourceId = this.getResources().getIdentifier(this.alCustomizationSettings.getAttachCameraIconName(), "drawable", this.getPackageName());
        this.selectImageProfileIcon.setImageResource(drawableResourceId);
        if (this.getIntent().getExtras() != null) {
            String groupInfoJson = this.getIntent().getExtras().getString("GROUP_UPDTAE_INFO");
            this.groupInfoUpdate = (GroupInfoUpdate)GsonUtils.getObjectFromJson((String)groupInfoJson, GroupInfoUpdate.class);
        }
        if (this.groupInfoUpdate != null && !TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getLocalImagePath())) {
            File file = new File(this.groupInfoUpdate.getLocalImagePath());
            Uri uri = Uri.parse((String)file.getAbsolutePath());
            if (uri != null) {
                Log.i((String)"ChannelNameActivity::", (String)uri.toString());
                this.applozicGroupProfileIcon.setImageURI(uri);
            }
        } else {
            this.applozicGroupProfileIcon.setImageResource(R.drawable.applozic_group_icon);
        }
        this.channelName = (EditText)this.findViewById(R.id.newChannelName);
        this.channelName.setText((CharSequence)this.groupInfoUpdate.getNewName());
        this.ok = (Button)this.findViewById(R.id.channelNameOk);
        this.cancel = (Button)this.findViewById(R.id.channelNameCancel);
        this.selectImageProfileIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelNameActivity.this.processImagePicker();
            }
        });
        this.ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelNameActivity.this.channelName.getText().toString().equals(ChannelNameActivity.this.groupInfoUpdate.getNewName()) && ChannelNameActivity.this.imageChangeUri == null || ChannelNameActivity.this.groupInfoUpdate.getNewName() == null) {
                    ChannelNameActivity.this.finish();
                }
                if (TextUtils.isEmpty((CharSequence)ChannelNameActivity.this.channelName.getText().toString()) || ChannelNameActivity.this.channelName.getText().toString().trim().length() == 0) {
                    Toast.makeText((Context)ChannelNameActivity.this, (CharSequence)ChannelNameActivity.this.getString(R.string.channel_name_empty), (int)0).show();
                    ChannelNameActivity.this.finish();
                } else {
                    Intent intent = new Intent();
                    ChannelNameActivity.this.groupInfoUpdate.setNewName(ChannelNameActivity.this.channelName.getText().toString());
                    if (ChannelNameActivity.this.imageChangeUri != null && ChannelNameActivity.this.profilePhotoFile != null) {
                        ChannelNameActivity.this.groupInfoUpdate.setNewlocalPath(ChannelNameActivity.this.profilePhotoFile.getAbsolutePath());
                        ChannelNameActivity.this.groupInfoUpdate.setContentUri(ChannelNameActivity.this.imageChangeUri.toString());
                    }
                    intent.putExtra("GROUP_UPDTAE_INFO", GsonUtils.getJsonFromObject((Object)ChannelNameActivity.this.groupInfoUpdate, GroupInfoUpdate.class));
                    ChannelNameActivity.this.setResult(-1, intent);
                    ChannelNameActivity.this.finish();
                }
            }
        });
        this.cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelNameActivity.this.finish();
            }
        });
        this.connectivityReceiver = new ConnectivityReceiver();
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                this.processImagePicker();
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 5) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_camera_permission_granted);
                this.processImagePicker();
            } else {
                this.showSnackBar(R.string.phone_camera_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (requestCode == 203) {
            CropImage.ActivityResult result = CropImage.getActivityResult((Intent)intent);
            if (resultCode == -1) {
                if (intent == null) {
                    return;
                }
                if (this.imageChangeUri != null) {
                    this.imageChangeUri = result.getUri();
                    this.applozicGroupProfileIcon.setImageDrawable(null);
                    this.applozicGroupProfileIcon.setImageURI(this.imageChangeUri);
                } else {
                    this.imageChangeUri = result.getUri();
                    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                    String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
                    this.applozicGroupProfileIcon.setImageDrawable(null);
                    this.applozicGroupProfileIcon.setImageURI(this.imageChangeUri);
                    this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this, (String)"image/jpeg");
                    this.fileClientService.writeFile(this.imageChangeUri, this.profilePhotoFile);
                }
            } else if (resultCode == 204) {
                Log.i((String)ChannelNameActivity.class.getName(), (String)("Cropping failed:" + result.getError()));
            }
        }
        if (resultCode == -1) {
            this.handleOnActivityResult(requestCode, intent);
        }
    }

    public void handleOnActivityResult(int requestCode, Intent intent) {
        switch (requestCode) {
            case 101: {
                Uri selectedFileUri = intent == null ? null : intent.getData();
                this.imageChangeUri = null;
                this.beginCrop(selectedFileUri);
                break;
            }
            case 102: {
                this.beginCrop(this.imageChangeUri);
            }
        }
    }

    void beginCrop(Uri imageUri) {
        try {
            CropImage.activity((Uri)imageUri).setGuidelines(CropImageView.Guidelines.OFF).setMultiTouchEnabled(true).start((Activity)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Uri getCurrentImageUri() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
        this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
        this.imageChangeUri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)this.profilePhotoFile);
        return this.imageChangeUri;
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    public void processImagePicker() {
        if (PermissionsUtils.isCameraPermissionGranted((Context)this) && !PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    FragmentManager supportFragmentManager = ChannelNameActivity.this.getSupportFragmentManager();
                    Channel channel = ChannelService.getInstance((Context)ChannelNameActivity.this).getChannel(ChannelNameActivity.this.groupInfoUpdate.getGroupId());
                    PictureUploadPopUpFragment fragment = PictureUploadPopUpFragment.newInstance(true, TextUtils.isEmpty((CharSequence)channel.getImageUrl()));
                    FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
                    Fragment prev = ChannelNameActivity.this.getSupportFragmentManager().findFragmentByTag("PhotosAttachmentFragment");
                    if (prev != null) {
                        fragmentTransaction.remove(prev);
                    }
                    fragmentTransaction.addToBackStack(null);
                    fragment.show(fragmentTransaction, "PhotosAttachmentFragment");
                }
            });
        } else if (Utils.hasMarshmallow()) {
            if (PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermissions.requestCameraPermission();
            } else {
                this.applozicPermissions.requestStoragePermissions();
            }
        } else {
            this.processImagePicker();
        }
    }

    @Override
    public void removeCallBack() {
        try {
            new ProfilePictureUpload((Context)this, this.applozicGroupProfileIcon, this.groupInfoUpdate).execute(new Void[]{null});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ProfilePictureUpload
    extends AsyncTask<Void, Void, Boolean> {
        Context context;
        WeakReference<ImageView> weakReferenceImageView;
        FileClientService fileClientService;
        ChannelService channelService;
        String responseForChannelUpdate;
        WeakReference<GroupInfoUpdate> groupInfoUpdateWeakReference;
        private ProgressDialog progressDialog;

        public ProfilePictureUpload(Context context, ImageView imageView, GroupInfoUpdate groupInfoUpdate) {
            this.context = context;
            this.weakReferenceImageView = new WeakReference<ImageView>(imageView);
            this.fileClientService = new FileClientService(context);
            this.channelService = ChannelService.getInstance((Context)context);
            this.groupInfoUpdateWeakReference = new WeakReference<GroupInfoUpdate>(groupInfoUpdate);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Boolean doInBackground(Void ... params) {
            try {
                GroupInfoUpdate giu = (GroupInfoUpdate)this.groupInfoUpdateWeakReference.get();
                if (giu != null) {
                    giu.setImageUrl("");
                    giu.setNewName(null);
                    this.responseForChannelUpdate = this.channelService.updateChannel(giu);
                    if (!TextUtils.isEmpty((CharSequence)this.responseForChannelUpdate) && "success".equals(this.responseForChannelUpdate)) {
                        this.channelService.updateChannelLocalImageURI(giu.getGroupId(), null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            ImageView imageView;
            this.progressDialog.dismiss();
            if (!TextUtils.isEmpty((CharSequence)this.responseForChannelUpdate) && "success".equals(this.responseForChannelUpdate) && (imageView = (ImageView)this.weakReferenceImageView.get()) != null) {
                ChannelNameActivity.this.imageChangeUri = null;
                imageView.setImageDrawable(null);
                imageView.setImageResource(R.drawable.applozic_group_icon);
            }
        }
    }
}

