/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.RemoveInterfaceListener;
import com.applozic.mobicomkit.uiwidgets.uilistener.MobicomkitUriListener;
import java.util.List;

public class PictureUploadPopUpFragment
extends DialogFragment {
    public static final String REMOVE_PHOTO = "REMOVE_PHOTO";
    public static final String REMOVE_OPTION = "REMOVE_OPTION";
    private static final String TAG = "PictureUploadPopUpFrag";
    LinearLayout removeLayout;
    LinearLayout galleryLayout;
    LinearLayout cameraLayout;
    boolean removePhoto;
    boolean disableRemoveOption;
    Bundle bundle;

    public static PictureUploadPopUpFragment newInstance(boolean removePhoto, boolean disableRemoveOption) {
        PictureUploadPopUpFragment f = new PictureUploadPopUpFragment();
        Bundle args = new Bundle();
        args.putBoolean(REMOVE_PHOTO, removePhoto);
        args.putBoolean(REMOVE_OPTION, disableRemoveOption);
        f.setArguments(args);
        return f;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        RelativeLayout root = new RelativeLayout((Context)this.getActivity());
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        Dialog dialog = new Dialog((Context)this.getActivity());
        dialog.requestWindowFeature(1);
        dialog.setContentView((View)root);
        dialog.getWindow().setLayout(-1, -2);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.attach_photo_popup_window_layout, container, false);
        this.bundle = this.getArguments();
        this.getDialog().setCancelable(Boolean.TRUE.booleanValue());
        this.cameraLayout = (LinearLayout)view.findViewById(R.id.upload_camera_layout);
        this.removeLayout = (LinearLayout)view.findViewById(R.id.upload_remove_image_layout);
        this.removeLayout.setVisibility(8);
        if (this.bundle != null) {
            this.removePhoto = this.bundle.getBoolean(REMOVE_PHOTO);
            this.disableRemoveOption = this.bundle.getBoolean(REMOVE_OPTION);
        }
        if (this.disableRemoveOption) {
            this.removeLayout.setVisibility(8);
        }
        this.removeLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PictureUploadPopUpFragment.this.removePhoto) {
                    ((RemoveInterfaceListener)PictureUploadPopUpFragment.this.getActivity()).removeCallBack();
                } else {
                    PictureUploadPopUpFragment.this.getTargetFragment().onActivityResult(102, -1, PictureUploadPopUpFragment.this.getActivity().getIntent());
                }
                PictureUploadPopUpFragment.this.getDialog().dismiss();
            }
        });
        this.galleryLayout = (LinearLayout)view.findViewById(R.id.upload_gallery_layout);
        this.galleryLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureUploadPopUpFragment.this.getDialog().dismiss();
                Intent getContentIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                PictureUploadPopUpFragment.this.getActivity().startActivityForResult(getContentIntent, 101);
            }
        });
        this.cameraLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureUploadPopUpFragment.this.getDialog().dismiss();
                PictureUploadPopUpFragment.this.imageCapture();
            }
        });
        return view;
    }

    public void imageCapture() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (!(this.getActivity() instanceof MobicomkitUriListener)) {
            Log.d((String)TAG, (String)"Activity must implement MobicomkitUriListener to get image file uri");
            return;
        }
        if (cameraIntent.resolveActivity(this.getContext().getPackageManager()) != null) {
            Uri capturedImageUri = ((MobicomkitUriListener)this.getActivity()).getCurrentImageUri();
            if (Build.VERSION.SDK_INT >= 21) {
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)this.getActivity().getContentResolver(), (CharSequence)"a Photo", (Uri)capturedImageUri);
                cameraIntent.setClipData(clip);
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else {
                List resInfoList = this.getActivity().getPackageManager().queryIntentActivities(cameraIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    this.getActivity().grantUriPermission(packageName, capturedImageUri, 2);
                    this.getActivity().grantUriPermission(packageName, capturedImageUri, 1);
                }
            }
            cameraIntent.putExtra("output", (Parcelable)capturedImageUri);
            this.getActivity().startActivityForResult(cameraIntent, 102);
        }
    }
}

