/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.PopupWindow;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import java.util.List;

public class MultimediaOptionsGridView {
    public PopupWindow showPopup;
    FragmentActivity context;
    GridView multimediaOptions;
    private Uri capturedImageUri;

    public MultimediaOptionsGridView(FragmentActivity context, GridView multimediaOptions) {
        this.context = context;
        this.multimediaOptions = multimediaOptions;
    }

    public void setMultimediaClickListener(final List<String> keys) {
        this.capturedImageUri = null;
        this.multimediaOptions.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultimediaOptionsGridView.this.executeMethod((String)keys.get(position));
            }
        });
    }

    public void executeMethod(String key) {
        switch (key) {
            case ":location": {
                ((ConversationActivity)this.context).processLocation();
                break;
            }
            case ":camera": {
                ((ConversationActivity)this.context).isTakePhoto(true);
                ((ConversationActivity)this.context).processCameraAction();
                break;
            }
            case ":file": {
                ((ConversationActivity)this.context).isAttachment(true);
                ((ConversationActivity)this.context).processAttachment();
                break;
            }
            case ":audio": {
                ((ConversationActivity)this.context).showAudioRecordingDialog();
                break;
            }
            case ":video": {
                ((ConversationActivity)this.context).isTakePhoto(false);
                ((ConversationActivity)this.context).processVideoRecording();
                break;
            }
            case ":contact": {
                ((ConversationActivity)this.context).processContact();
                break;
            }
            case ":pricing": {
                new ConversationUIService(this.context).sendPriceMessage();
                break;
            }
        }
        this.multimediaOptions.setVisibility(8);
    }
}

