/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.MultimediaOptionsGridView;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobicomMultimediaPopupAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComConversationFragment;
import com.applozic.mobicommons.commons.core.utils.LocationUtils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConversationFragment
extends MobiComConversationFragment
implements SearchListFragment {
    private static final String TAG = "ConversationFragment";
    private MultimediaOptionsGridView popupGrid;
    InputMethodManager inputMethodManager;
    public static final int ATTCHMENT_OPTIONS = 6;
    private List<String> attachmentKey = new ArrayList<String>();
    private List<String> attachmentText = new ArrayList<String>();
    private List<String> attachmentIcon = new ArrayList<String>();

    public ConversationFragment() {
        this.messageIntentClass = MessageIntentService.class;
    }

    public ConversationFragment(Contact contact, Channel channel, Integer conversationId) {
        this.messageIntentClass = MessageIntentService.class;
        this.contact = contact;
        this.channel = channel;
        this.currentConversationId = conversationId;
    }

    public ConversationFragment(Contact contact, Channel channel, Integer conversationId, String searchString) {
        this.messageIntentClass = MessageIntentService.class;
        this.contact = contact;
        this.channel = channel;
        this.currentConversationId = conversationId;
        this.searchString = searchString;
        if (searchString != null) {
            SyncCallService.refreshView = true;
        }
    }

    @Override
    public void attachLocation(Location mCurrentLocation) {
        String address = LocationUtils.getAddress((Context)this.getActivity(), (Location)mCurrentLocation);
        address = !TextUtils.isEmpty((CharSequence)address) ? "Address: " + address + "\n" : "";
        this.messageEditText.setText((CharSequence)(address + "http://maps.google.com/?q=" + mCurrentLocation.getLatitude() + "," + mCurrentLocation.getLongitude()));
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.title = "Chats";
        this.conversationService = new MobiComConversationService((Context)this.getActivity());
        this.hideExtendedSendingOptionLayout = true;
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.populateAttachmentOptions();
        if (this.alCustomizationSettings.isHideAttachmentButton()) {
            this.attachButton.setVisibility(8);
            this.messageEditText.setPadding(20, 0, 0, 0);
        }
        this.sendType.setSelection(1);
        this.messageEditText.setHint(R.string.enter_mt_message_hint);
        this.multimediaPopupGrid.setVisibility(8);
        ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this.getActivity(), (int)R.array.secret_message_timer_array, (int)R.layout.mobiframework_custom_spinner);
        adapter.setDropDownViewResource(R.layout.mobiframework_custom_spinner);
        this.inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.messageEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.multimediaPopupGrid.setVisibility(8);
            }
        });
        this.attachButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if ((ConversationFragment.this.contact != null && !ConversationFragment.this.contact.isBlocked() || ConversationFragment.this.channel != null) && ConversationFragment.this.attachmentLayout.getVisibility() == 0) {
                    Toast.makeText((Context)ConversationFragment.this.getActivity(), (int)R.string.select_file_count_limit, (int)1).show();
                    return;
                }
                if (ConversationFragment.this.channel != null) {
                    String userId = ChannelService.getInstance((Context)ConversationFragment.this.getActivity()).getGroupOfTwoReceiverUserId(ConversationFragment.this.channel.getKey());
                    if (!TextUtils.isEmpty((CharSequence)userId)) {
                        Contact withUserContact = ConversationFragment.this.appContactService.getContactById(userId);
                        if (withUserContact.isBlocked()) {
                            ConversationFragment.this.userBlockDialog(false, withUserContact, true);
                        } else {
                            ConversationFragment.this.processAttachButtonClick(view);
                        }
                    } else {
                        ConversationFragment.this.processAttachButtonClick(view);
                    }
                } else if (ConversationFragment.this.contact != null) {
                    if (ConversationFragment.this.contact.isBlocked()) {
                        ConversationFragment.this.userBlockDialog(false, ConversationFragment.this.contact, false);
                    } else {
                        ConversationFragment.this.processAttachButtonClick(view);
                    }
                }
            }
        });
        return view;
    }

    @Override
    protected void processMobiTexterUserCheck() {
    }

    @Override
    public void updateTitle() {
        super.updateTitle();
    }

    public void hideMultimediaOptionGrid() {
        if (this.multimediaPopupGrid.getVisibility() == 0) {
            this.multimediaPopupGrid.setVisibility(8);
        }
    }

    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty((CharSequence)newText)) {
            this.conversationAdapter.getFilter().filter(null);
        } else {
            this.conversationAdapter.getFilter().filter((CharSequence)newText);
        }
        return true;
    }

    void processAttachButtonClick(View view) {
        MobicomMultimediaPopupAdapter mobicomMultimediaPopupAdapter = new MobicomMultimediaPopupAdapter((Context)this.getActivity(), this.attachmentIcon, this.attachmentText);
        mobicomMultimediaPopupAdapter.setAlCustomizationSettings(this.alCustomizationSettings);
        this.multimediaPopupGrid.setAdapter((ListAdapter)mobicomMultimediaPopupAdapter);
        int noOfColumn = this.attachmentKey.size() == 6 ? 3 : this.attachmentKey.size();
        this.multimediaPopupGrid.setNumColumns(noOfColumn);
        this.multimediaPopupGrid.setVisibility(0);
        if (this.inputMethodManager.isActive()) {
            this.inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        MultimediaOptionsGridView itemClickHandler = new MultimediaOptionsGridView(this.getActivity(), this.multimediaPopupGrid);
        itemClickHandler.setMultimediaClickListener(this.attachmentKey);
    }

    private void populateAttachmentOptions() {
        String[] allKeys = this.getResources().getStringArray(R.array.multimediaOptions_without_price_key);
        String[] allValues = this.getResources().getStringArray(R.array.multimediaOptions_without_price_text);
        String[] allIcons = this.getResources().getStringArray(R.array.multimediaOptionIcons_without_price);
        Map<String, Boolean> maps = this.alCustomizationSettings.getAttachmentOptions();
        for (int index = 0; index < allKeys.length; ++index) {
            String key = allKeys[index];
            if (maps != null && maps.get(key) != null && !maps.get(key).booleanValue()) continue;
            this.attachmentKey.add(key);
            this.attachmentText.add(allValues[index]);
            this.attachmentIcon.add(allIcons[index]);
        }
    }
}

