/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.people.contact.ContactSelectionFragment;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import java.io.Serializable;

public class ContactSelectionActivity
extends AppCompatActivity
implements SearchView.OnQueryTextListener {
    public static final String CHANNEL = "CHANNEL_NAME";
    public static final String CHANNEL_OBJECT = "CHANNEL";
    public static final String CHECK_BOX = "CHECK_BOX";
    public static final String IMAGE_LINK = "IMAGE_LINK";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    Channel channel;
    private String name;
    private String imageUrl;
    private ActionBar mActionBar;
    boolean disableCheckBox;
    protected SearchView searchView;
    private SearchListFragment searchListFragment;
    private boolean isSearchResultView = false;
    int groupType;
    private String mSearchTerm;
    ContactDatabase contactDatabase;
    public static boolean isSearching = false;
    ContactSelectionFragment contactSelectionFragment;
    private AppContactService contactService;
    private ConnectivityReceiver connectivityReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.contact_select_layout);
        this.contactDatabase = new ContactDatabase((Context)this);
        this.contactSelectionFragment = new ContactSelectionFragment();
        this.setSearchListFragment(this.contactSelectionFragment);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.contactService = new AppContactService((Context)this);
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        if (this.getIntent().getExtras() != null) {
            this.channel = (Channel)this.getIntent().getSerializableExtra(CHANNEL_OBJECT);
            this.disableCheckBox = this.getIntent().getBooleanExtra(CHECK_BOX, false);
            this.mActionBar.setTitle(R.string.channel_member_title);
            this.name = this.getIntent().getStringExtra(CHANNEL);
            this.imageUrl = this.getIntent().getStringExtra(IMAGE_LINK);
            this.groupType = this.getIntent().getIntExtra(GROUP_TYPE, Channel.GroupType.PUBLIC.getValue().intValue());
        } else {
            this.mActionBar.setTitle(R.string.channel_members_title);
        }
        Bundle bundle = new Bundle();
        bundle.putSerializable(CHANNEL_OBJECT, (Serializable)this.channel);
        bundle.putBoolean(CHECK_BOX, this.disableCheckBox);
        bundle.putString(CHANNEL, this.name);
        bundle.putString(IMAGE_LINK, this.imageUrl);
        bundle.putInt(GROUP_TYPE, this.groupType);
        this.contactSelectionFragment.setArguments(bundle);
        ContactSelectionActivity.addFragment((FragmentActivity)this, (Fragment)this.contactSelectionFragment, "ContactSelectionFragment");
        this.connectivityReceiver = new ConnectivityReceiver();
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.group_create_menu, menu2);
        menu2.removeItem(R.id.Next);
        if (this.disableCheckBox) {
            menu2.removeItem(R.id.Done);
        }
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        if (Utils.hasICS()) {
            searchItem.collapseActionView();
        }
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconified(true);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_search) {
            this.onSearchRequested();
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onSearchRequested() {
        return !this.isSearchResultView && super.onSearchRequested();
    }

    public boolean onSupportNavigateUp() {
        this.finish();
        return super.onSupportNavigateUp();
    }

    public boolean onQueryTextSubmit(String query) {
        this.mSearchTerm = query;
        isSearching = false;
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.mSearchTerm = query;
        if (this.getSearchListFragment() != null) {
            this.getSearchListFragment().onQueryTextChange(query);
            isSearching = true;
            if (query.isEmpty()) {
                isSearching = false;
            }
        }
        return true;
    }

    public SearchListFragment getSearchListFragment() {
        return this.searchListFragment;
    }

    public void setSearchListFragment(SearchListFragment searchListFragment) {
        this.searchListFragment = searchListFragment;
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

