/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.RegisteredUsersAsyncTask;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.ContactService;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.TopicDetail;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicChannelDeleteTask;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicChannelLeaveMember;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.UIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelInfoActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MessageInfoFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.LocationInfo;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.util.ArrayList;

public class ConversationUIService {
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 1011;
    public static final String CONVERSATION_FRAGMENT = "ConversationFragment";
    public static final String MESSGAE_INFO_FRAGMENT = "messageInfoFagment";
    public static final String USER_PROFILE_FRAMENT = "userProfilefragment";
    public static final String QUICK_CONVERSATION_FRAGMENT = "QuickConversationFragment";
    public static final String FORWARD_MESSAGE = "forwardMessage";
    public static final String CLIENT_GROUP_ID = "clientGroupId";
    public static final String DISPLAY_NAME = "displayName";
    public static final String TAKE_ORDER = "takeOrder";
    public static final String USER_ID = "userId";
    public static final String GROUP_ID = "groupId";
    public static final String GROUP_NAME = "groupName";
    public static final String FIRST_TIME_MTEXTER_FRIEND = "firstTimeMTexterFriend";
    public static final String CONTACT_ID = "contactId";
    public static final String CONTEXT_BASED_CHAT = "contextBasedChat";
    public static final String CONTACT_NUMBER = "contactNumber";
    public static final String APPLICATION_ID = "applicationId";
    public static final String DEFAULT_TEXT = "defaultText";
    public static final String FINAL_PRICE_TEXT = "Final agreed price ";
    public static final String PRODUCT_TOPIC_ID = "topicId";
    public static final String PRODUCT_IMAGE_URL = "productImageUrl";
    private static final String TAG = "ConversationUIService";
    public static final String CONTACT = "CONTACT";
    private static final String APPLICATION_KEY_META_DATA = "com.applozic.application.key";
    public static final String GROUP = "group-";
    public static final String SUCCESS = "success";
    public static final String SEARCH_STRING = "searchString";
    private FragmentActivity fragmentActivity;
    private BaseContactService baseContactService;
    private MobiComUserPreference userPreference;
    private Conversation conversation;
    private TopicDetail topicDetailsParcelable;
    public static final String CONVERSATION_ID = "CONVERSATION_ID";
    public static final String TOPIC_ID = "TOPIC_ID";
    private Contact contact;
    private NotificationManager notificationManager;
    FileClientService fileClientService;

    public ConversationUIService(FragmentActivity fragmentActivity) {
        this.fragmentActivity = fragmentActivity;
        this.baseContactService = new AppContactService((Context)fragmentActivity);
        this.userPreference = MobiComUserPreference.getInstance((Context)fragmentActivity);
        this.notificationManager = (NotificationManager)fragmentActivity.getSystemService("notification");
        this.fileClientService = new FileClientService((Context)fragmentActivity);
    }

    public MobiComQuickConversationFragment getQuickConversationFragment() {
        MobiComQuickConversationFragment quickConversationFragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (quickConversationFragment == null) {
            quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment(this.fragmentActivity, quickConversationFragment, QUICK_CONVERSATION_FRAGMENT);
        }
        return quickConversationFragment;
    }

    public ConversationFragment getConversationFragment() {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            Contact contact = ((ConversationActivity)this.fragmentActivity).getContact();
            Channel channel = ((ConversationActivity)this.fragmentActivity).getChannel();
            Integer conversationId = ((ConversationActivity)this.fragmentActivity).getConversationId();
            conversationFragment = new ConversationFragment(contact, channel, conversationId);
            ConversationActivity.addFragment(this.fragmentActivity, conversationFragment, CONVERSATION_FRAGMENT);
        }
        return conversationFragment;
    }

    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        TextView textView = (TextView)view.findViewById(R.id.unreadSmsCount);
        textView.setVisibility(8);
        this.openConversationFragment(contact, null, null);
    }

    public void openConversationFragment(final Contact contact, final Integer conversationId, final String searchString) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(ConversationUIService.this.fragmentActivity, ConversationUIService.CONVERSATION_FRAGMENT);
                if (conversationFragment == null) {
                    conversationFragment = new ConversationFragment(contact, null, conversationId, searchString);
                    ((MobiComKitActivityInterface)ConversationUIService.this.fragmentActivity).addFragment(conversationFragment);
                } else {
                    conversationFragment.loadConversation(contact, conversationId, searchString);
                }
            }
        });
    }

    public void openConversationFragment(final Channel channel, final Integer conversationId, final String searchString) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(ConversationUIService.this.fragmentActivity, ConversationUIService.CONVERSATION_FRAGMENT);
                if (conversationFragment == null) {
                    conversationFragment = new ConversationFragment(null, channel, conversationId, searchString);
                    ((MobiComKitActivityInterface)ConversationUIService.this.fragmentActivity).addFragment(conversationFragment);
                } else {
                    conversationFragment.loadConversation(channel, conversationId, searchString);
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        try {
            File file;
            if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
                Uri selectedFileUri = intent == null ? null : intent.getData();
                file = null;
                if (selectedFileUri == null) {
                    file = ((ConversationActivity)this.fragmentActivity).getFileObject();
                    ConversationActivity cfr_ignored_0 = (ConversationActivity)this.fragmentActivity;
                    selectedFileUri = ConversationActivity.getCapturedImageUri();
                }
                if (selectedFileUri != null) {
                    ConversationActivity cfr_ignored_1 = (ConversationActivity)this.fragmentActivity;
                    selectedFileUri = ConversationActivity.getCapturedImageUri();
                    file = ((ConversationActivity)this.fragmentActivity).getFileObject();
                }
                MediaScannerConnection.scanFile((Context)this.fragmentActivity, (String[])new String[]{file.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                    }
                });
                this.getConversationFragment().loadFile(selectedFileUri, file);
                Log.i((String)TAG, (String)("File uri: " + selectedFileUri));
            }
            if (requestCode == 1011 && resultCode == -1) {
                this.checkForStartNewConversation(intent);
            }
            if (requestCode == 14 && resultCode == -1) {
                Uri selectedFilePath = ((ConversationActivity)this.fragmentActivity).getVideoFileUri();
                file = ((ConversationActivity)this.fragmentActivity).getFileObject();
                if (file == null || !file.exists()) {
                    FileUtils.getLastModifiedFile((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + "/DCIM/Camera/")).renameTo(file);
                }
                if (selectedFilePath != null) {
                    this.getConversationFragment().loadFile(selectedFilePath, file);
                    this.getConversationFragment().sendMessage("", Message.ContentType.VIDEO_MSG.getValue());
                }
            }
            if (requestCode == 15 && resultCode == -1) {
                try {
                    File vCradFile = new ContactService((Context)this.fragmentActivity).vCard(intent.getData());
                    if (vCradFile != null) {
                        this.getConversationFragment().sendMessage(Message.ContentType.CONTACT_MSG.getValue(), vCradFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.fragmentActivity, (CharSequence)"Failed to load Contact", (int)0).show();
                    Log.e((String)"Exception::", (String)"Exception", (Throwable)e);
                }
            }
            if (requestCode == 16 && resultCode == -1) {
                ArrayList attachmentList = intent.getParcelableArrayListExtra("multiselect.selectedFiles");
                String messageText = intent.getStringExtra("multiselect.message");
                for (Uri info : attachmentList) {
                    this.getConversationFragment().sendMessage(messageText, Message.ContentType.ATTACHMENT.getValue(), info.toString());
                }
            }
            if (requestCode == 10 && resultCode == -1) {
                Log.i((String)"test", (String)"posi");
                Double latitude = intent.getDoubleExtra("latitude", 0.0);
                Double longitude = intent.getDoubleExtra("longitude", 0.0);
                LocationInfo info = new LocationInfo(latitude.doubleValue(), longitude.doubleValue());
                String locationInfo = GsonUtils.getJsonFromObject((Object)info, LocationInfo.class);
                this.sendLocation(locationInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversationThread(final Contact contact, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)ConversationUIService.this.fragmentActivity), contact, channel, null, (Context)ConversationUIService.this.fragmentActivity).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        if (channel != null) {
            if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                String userId = ChannelService.getInstance((Context)this.fragmentActivity).getGroupOfTwoReceiverUserId(channel.getKey());
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    Contact withUserContact = this.baseContactService.getContactById(userId);
                    name = withUserContact.getDisplayName();
                }
            } else {
                name = ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.fragmentActivity).getUserId());
            }
        } else {
            name = contact.getDisplayName();
        }
        alertDialog.setTitle((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_title).replace("[name]", name));
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_confir).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void deleteGroupConversation(final Channel channel) {
        if (!Utils.isInternetAvailable((Context)this.fragmentActivity)) {
            this.showToastMessage(this.fragmentActivity.getString(R.string.you_dont_have_any_network_access_info));
            return;
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.channel_deleting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                final ProgressDialog progressDialog = ProgressDialog.show((Context)ConversationUIService.this.fragmentActivity, (CharSequence)"", (CharSequence)ConversationUIService.this.fragmentActivity.getString(R.string.deleting_channel_user), (boolean)true);
                ApplozicChannelDeleteTask.TaskListener channelDeleteTask = new ApplozicChannelDeleteTask.TaskListener(){

                    @Override
                    public void onSuccess(String response) {
                        Log.i((String)ConversationUIService.TAG, (String)("Channel deleted response:" + response));
                    }

                    @Override
                    public void onFailure(String response, Exception exception) {
                        ConversationUIService.this.showToastMessage(ConversationUIService.this.fragmentActivity.getString(Utils.isInternetAvailable((Context)ConversationUIService.this.fragmentActivity) ? R.string.applozic_server_error : R.string.you_dont_have_any_network_access_info));
                    }

                    @Override
                    public void onCompletion() {
                        if (progressDialog != null && progressDialog.isShowing()) {
                            progressDialog.dismiss();
                        }
                    }
                };
                ApplozicChannelDeleteTask applozicChannelDeleteTask = new ApplozicChannelDeleteTask((Context)ConversationUIService.this.fragmentActivity, channelDeleteTask, channel);
                applozicChannelDeleteTask.execute(new Void[]{null});
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.delete_channel_messages_and_channel_info).replace(this.fragmentActivity.getString(R.string.group_name_info), channel.getName()).replace(this.fragmentActivity.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.fragmentActivity.getString(R.string.broadcast_string) : this.fragmentActivity.getString(R.string.group_string)));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void channelLeaveProcess(final Channel channel) {
        if (!Utils.isInternetAvailable((Context)this.fragmentActivity)) {
            this.showToastMessage(this.fragmentActivity.getString(R.string.you_dont_have_any_network_access_info));
            return;
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.channel_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ApplozicChannelLeaveMember.ChannelLeaveMemberListener applozicLeaveMemberListener = new ApplozicChannelLeaveMember.ChannelLeaveMemberListener(){

                    @Override
                    public void onSuccess(String response, Context context) {
                    }

                    @Override
                    public void onFailure(String response, Exception e, Context context) {
                        ConversationUIService.this.showToastMessage(ConversationUIService.this.fragmentActivity.getString(Utils.isInternetAvailable((Context)ConversationUIService.this.fragmentActivity) ? R.string.applozic_server_error : R.string.you_dont_have_any_network_access_info));
                    }
                };
                ApplozicChannelLeaveMember applozicChannelLeaveMember = new ApplozicChannelLeaveMember((Context)ConversationUIService.this.fragmentActivity, channel.getKey(), MobiComUserPreference.getInstance((Context)ConversationUIService.this.fragmentActivity).getUserId(), applozicLeaveMemberListener);
                applozicChannelLeaveMember.setEnableProgressDialog(true);
                applozicChannelLeaveMember.execute(new Void[]{null});
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.exit_channel_message_info).replace(this.fragmentActivity.getString(R.string.group_name_info), channel.getName()).replace(this.fragmentActivity.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.fragmentActivity.getString(R.string.broadcast_string) : this.fragmentActivity.getString(R.string.group_string)));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void updateLatestMessage(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLatestMessage(message, formattedContactNumber);
    }

    public void removeConversation(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().removeConversation(message, formattedContactNumber);
    }

    public void addMessage(Message message) {
        if (message.isUpdateMessage()) {
            if (!BroadcastService.isQuick()) {
                return;
            }
            MobiComQuickConversationFragment fragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
            if (fragment != null) {
                fragment.addMessage(message);
            }
        }
    }

    public void updateLastMessage(String keyString, String userId) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLastMessage(keyString, userId);
    }

    public boolean isBroadcastedToGroup(Integer channelKey) {
        if (!BroadcastService.isIndividual()) {
            return false;
        }
        return this.getConversationFragment().isBroadcastedToChannel(channelKey);
    }

    public void syncMessages(Message message, String keyString) {
        if (!Message.ContentType.HIDDEN.getValue().equals(message.getContentType())) {
            ConversationFragment conversationFragment;
            String userId = null;
            if (message.getGroupId() == null) {
                userId = message.getContactIds();
            }
            if (BroadcastService.isIndividual() && (conversationFragment = this.getConversationFragment()).isMsgForConversation(message) && !Message.GroupMessageMetaData.TRUE.getValue().equals(message.getMetaDataValueForKey(Message.GroupMessageMetaData.HIDE_KEY.getValue()))) {
                conversationFragment.addMessage(message);
            }
            if (message.getGroupId() == null && !Message.MetaDataType.ARCHIVE.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) {
                this.updateLastMessage(keyString, userId);
            }
        }
    }

    public void downloadConversations(boolean showInstruction) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().downloadConversations(showInstruction, null);
    }

    public void setLoadMore(boolean loadMore) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().setLoadMore(loadMore);
    }

    public void updateMessageKeyString(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        String userId = message.getContactIds();
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)userId) && conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getUserId()) || conversationFragment.getCurrentChannelKey(message.getGroupId())) {
            conversationFragment.updateMessageKeyString(message);
        }
    }

    public void deleteMessage(String keyString, String userId) {
        this.updateLastMessage(keyString, userId);
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().deleteMessageFromDeviceList(keyString);
        }
    }

    public void updateLastSeenStatus(String contactId) {
        ConversationFragment conversationFragment;
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().updateLastSeenStatus(contactId);
            return;
        }
        if (BroadcastService.isIndividual() && ((conversationFragment = this.getConversationFragment()).getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds()) || conversationFragment.getChannel() != null)) {
            conversationFragment.updateLastSeenStatus();
        }
    }

    public void updateDeliveryStatusForContact(String contactId) {
        this.updateStatus(contactId, false);
    }

    public void updateReadStatusForContact(String contactId) {
        this.updateStatus(contactId, true);
    }

    private void updateStatus(String contactId, boolean markRead) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)contactId) && conversationFragment.getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateDeliveryStatusForAllMessages(markRead);
        }
    }

    public void updateDeliveryStatus(Message message, String formattedContactNumber) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (conversationFragment.isMessageForCurrentConversation(message)) {
            conversationFragment.updateDeliveryStatus(message);
        }
    }

    public void deleteConversation(Contact contact, Integer channelKey, String response) {
        if (BroadcastService.isIndividual()) {
            if (SUCCESS.equals(response)) {
                this.getConversationFragment().clearList();
            } else if (!Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                Toast.makeText((Context)this.fragmentActivity, (CharSequence)this.fragmentActivity.getString(R.string.you_need_network_access_for_delete), (int)0).show();
            } else {
                Toast.makeText((Context)this.fragmentActivity, (CharSequence)this.fragmentActivity.getString(R.string.delete_conversation_failed), (int)0).show();
            }
        }
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().removeConversation(contact, channelKey, response);
        }
    }

    public void updateUploadFailedStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateUploadFailedStatus(message);
    }

    public void updateDownloadFailed(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().downloadFailed(message);
    }

    public void updateDownloadStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateDownloadStatus(message);
    }

    public void updateChannelName() {
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().updateChannelName();
        }
    }

    public void updateTypingStatus(String userId, String isTypingStatus) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        Log.i((String)TAG, (String)("Received typing status for: " + userId));
        if (conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getContactIds()) || conversationFragment.getChannel() != null) {
            conversationFragment.updateUserTypingStatus(userId, isTypingStatus);
        }
    }

    public void updateChannelSync() {
        if (BroadcastService.isChannelInfo()) {
            ((ChannelInfoActivity)this.fragmentActivity).updateChannelList();
        }
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().updateChannelTitleAndSubTitle();
        }
    }

    public void updateTitleAndSubtitle() {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().updateTitleForOpenGroup();
        }
    }

    public void updateConversationRead(String currentId, boolean isGroup) {
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            return;
        }
        if (!BroadcastService.isIndividual()) {
            this.notificationManager.cancel(currentId.hashCode());
        }
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().updateConversationRead(currentId, isGroup);
        }
    }

    public void startContactActivityForResult(Intent intent, Message message, String messageContent, String[] userIdArray) {
        if (message != null) {
            intent.putExtra(FORWARD_MESSAGE, GsonUtils.getJsonFromObject((Object)message, message.getClass()));
        }
        if (messageContent != null) {
            intent.putExtra("SHARED_TEXT", messageContent);
        }
        if (userIdArray != null) {
            intent.putExtra("userIdArray", userIdArray);
        }
        this.fragmentActivity.startActivityForResult(intent, 1011);
    }

    public void startContactActivityForResult() {
        this.startContactActivityForResult(null, null);
    }

    public void startContactActivityForResult(Message message, String messageContent) {
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.fragmentActivity.getApplicationContext());
        AlCustomizationSettings alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        if (alCustomizationSettings.getTotalOnlineUsers() > 0 && Utils.isInternetAvailable((Context)this.fragmentActivity)) {
            this.processLoadUsers(false, message, messageContent, alCustomizationSettings.getTotalRegisteredUserToFetch(), alCustomizationSettings.getTotalOnlineUsers());
        } else if (alCustomizationSettings.getTotalRegisteredUserToFetch() > 0 && alCustomizationSettings.isRegisteredUserContactListCall() && !this.userPreference.getWasContactListServerCallAlreadyDone()) {
            if (Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                this.processLoadUsers(true, message, messageContent, alCustomizationSettings.getTotalRegisteredUserToFetch(), alCustomizationSettings.getTotalOnlineUsers());
            }
        } else {
            Intent intent = new Intent((Context)this.fragmentActivity, MobiComKitPeopleActivity.class);
            this.startContactActivityForResult(intent, message, messageContent, null);
        }
    }

    public void sendPriceMessage() {
        try {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity);
            alertDialog.setTitle((CharSequence)"Price");
            alertDialog.setMessage((CharSequence)"Enter your amount");
            final EditText inputText = new EditText((Context)this.fragmentActivity);
            inputText.setInputType(2);
            LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(-1, -1);
            inputText.setLayoutParams((ViewGroup.LayoutParams)linearParams);
            alertDialog.setView((View)inputText);
            alertDialog.setPositiveButton((CharSequence)this.fragmentActivity.getString(R.string.send_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (!TextUtils.isEmpty((CharSequence)inputText.getText().toString())) {
                        ConversationUIService.this.getConversationFragment().sendMessage(inputText.getText().toString(), Message.ContentType.PRICE.getValue());
                    }
                }
            });
            alertDialog.setNegativeButton((CharSequence)this.fragmentActivity.getString(R.string.cancel_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            if (!this.fragmentActivity.isFinishing()) {
                alertDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAudioMessage(String selectedFilePath) {
        Log.i((String)"ConversationUIService:", (String)"Send audio message ...");
        this.getConversationFragment().sendMessage(Message.ContentType.AUDIO_MSG.getValue(), selectedFilePath);
    }

    public void startMessageInfoFragment(String messageJson) {
        MessageInfoFragment messageInfoFragment = (MessageInfoFragment)UIService.getFragmentByTag(this.fragmentActivity, MESSGAE_INFO_FRAGMENT);
        if (messageInfoFragment == null) {
            messageInfoFragment = new MessageInfoFragment();
            Bundle bundle = new Bundle();
            bundle.putString("MESSAGE", messageJson);
            messageInfoFragment.setArguments(bundle);
            ConversationActivity.addFragment(this.fragmentActivity, messageInfoFragment, MESSGAE_INFO_FRAGMENT);
        }
    }

    public void checkForStartNewConversation(Intent intent) {
        String sharedText;
        String forwardMessage;
        String defaultText;
        String messageJson;
        String userId;
        Uri uri;
        Contact contact = null;
        Channel channel = null;
        Integer conversationId = null;
        if ("android.intent.action.SEND".equals(intent.getAction()) && intent.getType() != null) {
            if ("text/plain".equals(intent.getType())) {
                String sharedText2 = intent.getStringExtra("android.intent.extra.TEXT");
                if (sharedText2 != null) {
                    this.startContactActivityForResult(null, sharedText2);
                }
            } else if (intent.getType().startsWith("image/")) {
                // empty if block
            }
        }
        if ((uri = intent.getData()) != null) {
            Long contactId = intent.getLongExtra(CONTACT_ID, 0L);
            if (contactId == 0L) {
                return;
            }
            contact = this.baseContactService.getContactById(String.valueOf(contactId));
        }
        Integer channelKey = intent.getIntExtra(GROUP_ID, -1);
        String clientGroupId = intent.getStringExtra(CLIENT_GROUP_ID);
        String channelName = intent.getStringExtra(GROUP_NAME);
        if (!TextUtils.isEmpty((CharSequence)clientGroupId)) {
            channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannelByClientGroupId(clientGroupId);
            if (channel == null) {
                return;
            }
        } else if (channelKey != -1 && channelKey != null && channelKey != 0) {
            channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannel(channelKey);
        }
        if (channel != null && !TextUtils.isEmpty((CharSequence)channelName) && TextUtils.isEmpty((CharSequence)channel.getName())) {
            channel.setName(channelName);
            ChannelService.getInstance((Context)this.fragmentActivity).updateChannel(channel);
        }
        String contactNumber = intent.getStringExtra(CONTACT_NUMBER);
        boolean firstTimeMTexterFriend = intent.getBooleanExtra(FIRST_TIME_MTEXTER_FRIEND, false);
        if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
            contact = this.baseContactService.getContactById(contactNumber);
            if (BroadcastService.isIndividual()) {
                this.getConversationFragment().setFirstTimeMTexterFriend(firstTimeMTexterFriend);
            }
        }
        if (TextUtils.isEmpty((CharSequence)(userId = intent.getStringExtra(USER_ID)))) {
            userId = intent.getStringExtra(CONTACT_ID);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            contact = this.baseContactService.getContactById(userId);
        }
        String searchString = intent.getStringExtra(SEARCH_STRING);
        String applicationId = intent.getStringExtra(APPLICATION_ID);
        if (contact != null) {
            contact.setApplicationId(applicationId);
            this.baseContactService.upsert(contact);
        }
        String fullName = intent.getStringExtra(DISPLAY_NAME);
        if (contact != null && TextUtils.isEmpty((CharSequence)contact.getFullName()) && !TextUtils.isEmpty((CharSequence)fullName)) {
            contact.setFullName(fullName);
            this.baseContactService.upsert(contact);
            new UserClientService((Context)this.fragmentActivity).updateUserDisplayName(userId, fullName);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageJson = intent.getStringExtra("message_json")))) {
            Message message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
            if (message.getGroupId() != null) {
                channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannelByChannelKey(message.getGroupId());
            } else {
                contact = this.baseContactService.getContactById(message.getContactIds());
            }
            conversationId = message.getConversationId();
        }
        if (conversationId == null) {
            conversationId = intent.getIntExtra(CONVERSATION_ID, 0);
        }
        if (conversationId != 0 && conversationId != null) {
            this.getConversationFragment().setConversationId(conversationId);
        } else {
            conversationId = null;
        }
        boolean support = intent.getBooleanExtra("SUPPORT_INTENT_KEY", false);
        if (support) {
            contact = new Support((Context)this.fragmentActivity).getSupportContact();
        }
        if (!TextUtils.isEmpty((CharSequence)(defaultText = intent.getStringExtra(DEFAULT_TEXT)))) {
            this.getConversationFragment().setDefaultText(defaultText);
        }
        if (!TextUtils.isEmpty((CharSequence)(forwardMessage = intent.getStringExtra(FORWARD_MESSAGE)))) {
            Message messageToForward = (Message)GsonUtils.getObjectFromJson((String)forwardMessage, Message.class);
            this.getConversationFragment().forwardMessage(messageToForward, contact, channel);
        }
        if (contact != null) {
            this.openConversationFragment(contact, conversationId, searchString);
        }
        if (channel != null) {
            this.openConversationFragment(channel, conversationId, searchString);
        }
        String productTopicId = intent.getStringExtra(PRODUCT_TOPIC_ID);
        String productImageUrl = intent.getStringExtra(PRODUCT_IMAGE_URL);
        if (!TextUtils.isEmpty((CharSequence)productTopicId) && !TextUtils.isEmpty((CharSequence)productImageUrl)) {
            try {
                FileMeta fileMeta = new FileMeta();
                fileMeta.setContentType("image");
                fileMeta.setBlobKeyString(productImageUrl);
                this.getConversationFragment().sendProductMessage(productTopicId, fileMeta, contact, Message.ContentType.TEXT_URL.getValue());
            }
            catch (Exception fileMeta) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = intent.getStringExtra("SHARED_TEXT")))) {
            this.getConversationFragment().sendMessage(sharedText);
        }
    }

    void showToastMessage(String messageToShow) {
        Toast toast = Toast.makeText((Context)this.fragmentActivity, (CharSequence)messageToShow, (int)0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    public void reconnectMQTT() {
        try {
            if (((MobiComKitActivityInterface)this.fragmentActivity).getRetryCount() <= 3 && Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                Log.i((String)TAG, (String)"Reconnecting to mqtt.");
                ((MobiComKitActivityInterface)this.fragmentActivity).retry();
                Intent intent = new Intent((Context)this.fragmentActivity, ApplozicMqttIntentService.class);
                intent.putExtra("subscribe", true);
                this.fragmentActivity.startService(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendLocation(String position) {
        this.getConversationFragment().sendMessage(position, Message.ContentType.LOCATION.getValue());
    }

    public void processLoadUsers(boolean isRegisteredUserCall, final Message message, final String messageContent, int totalRegisteredUsers, int totalOnlineUser) {
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this.fragmentActivity, (CharSequence)"", (CharSequence)this.fragmentActivity.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        RegisteredUsersAsyncTask.TaskListener usersAsyncTaskTaskListener = new RegisteredUsersAsyncTask.TaskListener(){

            public void onSuccess(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                try {
                    Intent intent;
                    if (registeredUsersApiResponse != null) {
                        ConversationUIService.this.userPreference.setWasContactListServerCallAlreadyDone(Boolean.valueOf(true));
                        intent = new Intent((Context)ConversationUIService.this.fragmentActivity, MobiComKitPeopleActivity.class);
                        ConversationUIService.this.startContactActivityForResult(intent, message, messageContent, null);
                    }
                    if (userIdArray != null && userIdArray.length > 0) {
                        intent = new Intent((Context)ConversationUIService.this.fragmentActivity, MobiComKitPeopleActivity.class);
                        ConversationUIService.this.startContactActivityForResult(intent, message, messageContent, userIdArray);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray, Exception exception) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                String error = ConversationUIService.this.fragmentActivity.getString(Utils.isInternetAvailable((Context)ConversationUIService.this.fragmentActivity) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)ConversationUIService.this.fragmentActivity, (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
            }
        };
        RegisteredUsersAsyncTask usersAsyncTask = isRegisteredUserCall ? new RegisteredUsersAsyncTask((Context)this.fragmentActivity, usersAsyncTaskTaskListener, totalRegisteredUsers, 0L, message, messageContent, true) : new RegisteredUsersAsyncTask((Context)this.fragmentActivity, usersAsyncTaskTaskListener, totalOnlineUser, message, messageContent);
        usersAsyncTask.execute((Object[])new Void[]{null});
    }
}

