/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageInfo;
import com.applozic.mobicomkit.api.conversation.MessageInfoResponse;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import com.applozic.mobicomkit.contact.VCFContactData;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.LocationUtils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.List;

public class MessageInfoFragment
extends Fragment {
    public static final String MESSAGE_ARGUMENT_KEY = "MESSAGE";
    Message message = null;
    AttachmentView attachmentView;
    MessageInfoResponse messageInfoResponse;
    private ImageLoader contactImageLoader;
    private ImageLoader locationImageLoader;
    private RecyclerView readListView;
    private RecyclerView deliveredListView;
    MessageInfoAsyncTask messageInfoAsyncTask;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.init();
        View view = inflater.inflate(R.layout.applozic_message_info, container, false);
        Bundle bundle = this.getArguments();
        String messageJson = bundle.getString(MESSAGE_ARGUMENT_KEY);
        this.message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
        this.attachmentView = (AttachmentView)view.findViewById(R.id.applozic_message_info_attachmentview);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.applozic_message_info_progress_bar);
        this.attachmentView.setProressBar(progressBar);
        this.attachmentView.setVisibility(this.message.hasAttachment() ? 0 : 8);
        RelativeLayout defaultRelativeLayout = (RelativeLayout)view.findViewById(R.id.applozic_message_info_default_layout);
        TextView textView = (TextView)view.findViewById(R.id.applozic_message_info_message_text);
        this.readListView = (RecyclerView)view.findViewById(R.id.applozic_message_info_read_list);
        this.deliveredListView = (RecyclerView)view.findViewById(R.id.applozic_message_info_delivered_list_view);
        this.readListView.setHasFixedSize(true);
        this.deliveredListView.setHasFixedSize(true);
        LinearLayoutManager mLayoutManager = new LinearLayoutManager((Context)this.getActivity());
        LinearLayoutManager mLayoutManagerForDev = new LinearLayoutManager((Context)this.getActivity());
        this.readListView.setLayoutManager((RecyclerView.LayoutManager)mLayoutManager);
        this.readListView.setClickable(true);
        this.deliveredListView.setLayoutManager((RecyclerView.LayoutManager)mLayoutManagerForDev);
        this.deliveredListView.setClickable(true);
        ImageView locationImageView = (ImageView)view.findViewById(R.id.static_mapview);
        LinearLayout mainContactShareLayout = (LinearLayout)view.findViewById(R.id.contact_share_layout);
        RelativeLayout chatLocation = (RelativeLayout)view.findViewById(R.id.chat_location);
        if (this.message.hasAttachment() && !this.message.isContactMessage() && !this.message.isLocationMessage()) {
            textView.setVisibility(8);
            this.attachmentView.setMessage(this.message);
            chatLocation.setVisibility(8);
            defaultRelativeLayout.setVisibility(8);
            defaultRelativeLayout.setVisibility(0);
            this.setupAttachmentView(this.message, defaultRelativeLayout);
        } else {
            defaultRelativeLayout.setVisibility(8);
            textView.setVisibility(0);
            textView.setText((CharSequence)this.message.getMessage());
        }
        if (this.message.isLocationMessage()) {
            defaultRelativeLayout.setVisibility(8);
            chatLocation.setVisibility(0);
            this.locationImageLoader.setImageFadeIn(false);
            this.locationImageLoader.setLoadingImage(R.drawable.applozic_map_offline_thumbnail);
            this.locationImageLoader.loadImage((Object)LocationUtils.loadStaticMap((String)this.message.getMessage()), locationImageView);
            textView.setVisibility(8);
        } else {
            chatLocation.setVisibility(8);
        }
        if (this.message.isContactMessage()) {
            chatLocation.setVisibility(8);
            defaultRelativeLayout.setVisibility(8);
            this.setupContactShareView(this.message, mainContactShareLayout);
            textView.setVisibility(8);
        } else {
            mainContactShareLayout.setVisibility(8);
        }
        this.messageInfoAsyncTask = new MessageInfoAsyncTask(this.message.getKeyString(), (Context)this.getActivity());
        this.messageInfoAsyncTask.execute(new Void[0]);
        return view;
    }

    private void init() {
        if (this.contactImageLoader == null) {
            this.contactImageLoader = new ImageLoader(this.getContext(), this.getListPreferredItemHeight()){

                protected Bitmap processBitmap(Object data) {
                    AppContactService contactService = new AppContactService(MessageInfoFragment.this.getContext());
                    return contactService.downloadContactImage(MessageInfoFragment.this.getContext(), (Contact)data);
                }
            };
            this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
            this.contactImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        }
        if (this.locationImageLoader == null) {
            this.locationImageLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

                protected Bitmap processBitmap(Object data) {
                    FileClientService fileClientService = new FileClientService(MessageInfoFragment.this.getContext());
                    return fileClientService.loadMessageImage(MessageInfoFragment.this.getContext(), (String)data);
                }
            };
            this.locationImageLoader.setImageFadeIn(false);
            this.locationImageLoader.addImageCache(((FragmentActivity)this.getContext()).getSupportFragmentManager(), 0.1f);
        }
        Toolbar toolbar = (Toolbar)this.getActivity().findViewById(R.id.my_toolbar);
        toolbar.setClickable(false);
        toolbar.setTitle((CharSequence)this.getString(R.string.applozic_message_info));
        toolbar.setSubtitle((CharSequence)"");
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        menu2.findItem(R.id.dial).setVisible(false);
        menu2.removeItem(R.id.start_new);
        menu2.removeItem(R.id.conversations);
        menu2.removeItem(R.id.deleteConversation);
        menu2.removeItem(R.id.refresh);
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    private void setupAttachmentView(Message message, RelativeLayout defaultRelativeLayout) {
        FileMeta fileMeta = message.getFileMetas();
        ImageView attachmentInconView = (ImageView)defaultRelativeLayout.findViewById(R.id.applozic_message_info_attachment_icon);
        TextView attachmentFilename = (TextView)defaultRelativeLayout.findViewById(R.id.applozic_message_info_attachment_filename);
        TextView messageText = (TextView)defaultRelativeLayout.findViewById(R.id.messageText);
        if (TextUtils.isEmpty((CharSequence)message.getMessage())) {
            messageText.setVisibility(8);
        }
        if (message.getMessage() != null) {
            messageText.setText((CharSequence)message.getMessage());
        }
        if (fileMeta.getContentType().contains("image")) {
            this.attachmentView.setVisibility(0);
            attachmentInconView.setVisibility(8);
            attachmentFilename.setVisibility(8);
        } else {
            this.attachmentView.setVisibility(8);
            attachmentInconView.setVisibility(0);
            attachmentFilename.setVisibility(0);
            attachmentFilename.setText((CharSequence)fileMeta.getName());
        }
    }

    private void setupContactShareView(Message message, LinearLayout mainContactShareLayout) {
        mainContactShareLayout.setVisibility(0);
        MobiComVCFParser parser = new MobiComVCFParser();
        try {
            VCFContactData data = parser.parseCVFContactData((String)message.getFilePaths().get(0));
            ImageView shareContactImage = (ImageView)mainContactShareLayout.findViewById(R.id.contact_share_image);
            TextView shareContactName = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_tv_name);
            TextView shareContactNo = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_tv_no);
            TextView shareEmailContact = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_emailId);
            mainContactShareLayout.findViewById(R.id.divider).setVisibility(8);
            Button addContactButton = (Button)mainContactShareLayout.findViewById(R.id.contact_share_add_btn);
            addContactButton.setVisibility(8);
            shareContactName.setText((CharSequence)data.getName());
            if (data.getProfilePic() != null) {
                shareContactImage.setImageBitmap(data.getProfilePic());
            }
            if (!TextUtils.isEmpty((CharSequence)data.getTelephoneNumber())) {
                shareContactNo.setText((CharSequence)data.getTelephoneNumber());
            } else {
                shareContactNo.setVisibility(8);
            }
            if (data.getEmail() != null) {
                shareEmailContact.setText((CharSequence)data.getEmail());
            } else {
                shareEmailContact.setVisibility(8);
            }
        }
        catch (Exception e) {
            Log.e((String)"DetailedConvAdapter", (String)"Exception in parsing", (Throwable)e);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.messageInfoAsyncTask != null) {
            this.messageInfoAsyncTask.cancel(true);
        }
    }

    public class ContactsAdapter
    extends RecyclerView.Adapter<MyViewHolder> {
        List<MessageInfo> messageInfoList;
        BaseContactService contactService;

        public ContactsAdapter(List<MessageInfo> messageInfoList) {
            this.contactService = new AppContactService(MessageInfoFragment.this.getContext());
            this.messageInfoList = messageInfoList;
        }

        public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.contact_users_layout, parent, false);
            return new MyViewHolder(itemView);
        }

        public void onBindViewHolder(MyViewHolder holder, int position) {
            long timeStamp;
            MessageInfo messageInfo = this.messageInfoList.get(position);
            Contact contact = this.contactService.getContactById(messageInfo.getUserId());
            holder.displayName.setText((CharSequence)contact.getDisplayName());
            long l = messageInfo.isRead() ? messageInfo.getReadAtTime() : (timeStamp = messageInfo.getDeliveredAtTime() == null ? 0L : messageInfo.getDeliveredAtTime());
            if (timeStamp != 0L) {
                holder.lastSeenAtTextView.setVisibility(0);
                holder.lastSeenAtTextView.setText((CharSequence)String.valueOf(DateUtils.getDateAndTimeInDefaultFormat((long)timeStamp)));
            } else {
                holder.lastSeenAtTextView.setVisibility(8);
                holder.lastSeenAtTextView.setText((CharSequence)"");
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getDisplayName().toUpperCase();
                char firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.alphabeticImage.getBackground();
                bgShape.setColor(MessageInfoFragment.this.getContext().getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            if (contact.isDrawableResources()) {
                int drawableResourceId = MessageInfoFragment.this.getContext().getResources().getIdentifier(contact.getrDrawableName(), "drawable", MessageInfoFragment.this.getContext().getPackageName());
                holder.circleImageView.setImageResource(drawableResourceId);
            } else {
                MessageInfoFragment.this.contactImageLoader.loadImage((Object)contact, (ImageView)holder.circleImageView, holder.alphabeticImage);
            }
        }

        public int getItemCount() {
            return this.messageInfoList.size();
        }

        public class MyViewHolder
        extends RecyclerView.ViewHolder {
            public TextView displayName;
            public TextView alphabeticImage;
            public TextView adminTextView;
            public TextView lastSeenAtTextView;
            CircleImageView circleImageView;

            public MyViewHolder(View view) {
                super(view);
                this.displayName = (TextView)view.findViewById(R.id.displayName);
                this.alphabeticImage = (TextView)view.findViewById(R.id.alphabeticImage);
                this.circleImageView = (CircleImageView)view.findViewById(R.id.contactImage);
                this.adminTextView = (TextView)view.findViewById(R.id.adminTextView);
                this.lastSeenAtTextView = (TextView)view.findViewById(R.id.lastSeenAtTextView);
            }
        }
    }

    public class MessageInfoAsyncTask
    extends AsyncTask<Void, Integer, Long> {
        String messageKey;
        MobiComMessageService messageService;

        public MessageInfoAsyncTask(String messageKey, Context context) {
            this.messageKey = messageKey;
            this.messageService = new MobiComMessageService(context, MessageIntentService.class);
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Long doInBackground(Void ... params) {
            try {
                MessageInfoFragment.this.messageInfoResponse = this.messageService.getMessageInfoResponse(this.messageKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (!MessageInfoFragment.this.isVisible()) {
                return;
            }
            if (MessageInfoFragment.this.messageInfoResponse == null) {
                Toast.makeText((Context)MessageInfoFragment.this.getContext(), (CharSequence)MessageInfoFragment.this.getString(R.string.applozic_message_info_no_network), (int)0).show();
                return;
            }
            if (MessageInfoFragment.this.messageInfoResponse.getReadByUserList() != null) {
                ContactsAdapter readAdapter = new ContactsAdapter(MessageInfoFragment.this.messageInfoResponse.getReadByUserList());
                MessageInfoFragment.this.readListView.setAdapter((RecyclerView.Adapter)readAdapter);
            }
            if (MessageInfoFragment.this.messageInfoResponse.getDeliverdToUserList() != null) {
                ContactsAdapter deliveredAdapter = new ContactsAdapter(MessageInfoFragment.this.messageInfoResponse.getDeliverdToUserList());
                MessageInfoFragment.this.deliveredListView.setAdapter((RecyclerView.Adapter)deliveredAdapter);
            }
        }
    }
}

