/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.channel;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ChannelFragment
extends ListFragment
implements AdapterView.OnItemClickListener,
SearchListFragment,
LoaderManager.LoaderCallbacks<Cursor> {
    private static final String SHARE_TEXT = "share_text";
    private static String inviteMessage;
    private ChannelAdapter mAdapter;
    private OnContactsInteractionListener mOnChannelSelectedListener;
    private Button shareButton;
    private TextView resultTextView;
    private boolean syncStatus = true;
    String mSearchTerm;
    ImageLoader mChannelImageLoader;
    BaseContactService baseContactService;
    static int QUERY_ID;
    private int mPreviouslySelectedSearchItem = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        inviteMessage = Utils.getMetaDataValue((Context)this.getActivity().getApplicationContext(), (String)SHARE_TEXT);
        this.baseContactService = new AppContactService((Context)this.getActivity());
        this.mAdapter = new ChannelAdapter(this.getActivity().getApplicationContext());
        if (savedInstanceState != null) {
            this.mSearchTerm = savedInstanceState.getString("query");
        }
        final Context context = this.getActivity().getApplicationContext();
        this.mChannelImageLoader = new ImageLoader(context, this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ChannelFragment.this.baseContactService.downloadGroupImage(context, (Channel)data);
            }
        };
        this.mChannelImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mChannelImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        this.mChannelImageLoader.setImageFadeIn(false);
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Channel channel = ChannelDatabaseService.getInstance((Context)this.getContext()).getChannel(cursor);
        this.mOnChannelSelectedListener.onGroupSelected(channel);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        this.shareButton = (Button)view.findViewById(R.id.actionButton);
        this.shareButton.setVisibility(8);
        this.resultTextView = (TextView)view.findViewById(R.id.result);
        this.resultTextView.setText((CharSequence)"No Groups");
        return view;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mOnChannelSelectedListener = (OnContactsInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnContactsInteractionListener");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.shareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                ArrayList<Intent> targetedShareIntents = new ArrayList<Intent>();
                List resInfo = ChannelFragment.this.getActivity().getPackageManager().queryIntentActivities(intent, 0);
                if (!resInfo.isEmpty()) {
                    for (ResolveInfo resolveInfo : resInfo) {
                        String packageName = resolveInfo.activityInfo.packageName;
                        Intent targetedShareIntent = new Intent("android.intent.action.SEND");
                        targetedShareIntent.setType("text/plain").setAction("android.intent.action.SEND").putExtra("android.intent.extra.TEXT", inviteMessage).setPackage(packageName);
                        targetedShareIntents.add(targetedShareIntent);
                    }
                    Intent chooserIntent = Intent.createChooser((Intent)((Intent)targetedShareIntents.remove(0)), (CharSequence)"Share Via");
                    chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", targetedShareIntents.toArray(new Parcelable[0]));
                    ChannelFragment.this.startActivity(chooserIntent);
                }
            }
        });
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                ChannelFragment.this.mChannelImageLoader.setPauseWork(scrollState == 2);
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
        if (this.mPreviouslySelectedSearchItem == 0) {
            this.getLoaderManager().initLoader(QUERY_ID, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        Loader loader = ChannelDatabaseService.getInstance((Context)this.getActivity()).getSearchCursorForGroupsLoader(this.mSearchTerm);
        return loader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (loader.getId() == QUERY_ID) {
            this.mAdapter.swapCursor(data);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        if (loader.getId() == QUERY_ID) {
            this.mAdapter.swapCursor(null);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.mSearchTerm)) {
            outState.putString("query", this.mSearchTerm);
        }
    }

    public boolean onQueryTextChange(String newText) {
        String newFilter;
        this.mSearchTerm = newFilter = !TextUtils.isEmpty((CharSequence)newText) ? newText : null;
        this.mAdapter.indexOfSearchQuery(newFilter);
        this.getLoaderManager().restartLoader(QUERY_ID, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public void onPause() {
        super.onPause();
        if (this.mChannelImageLoader != null) {
            this.mChannelImageLoader.setPauseWork(false);
        }
    }

    static {
        QUERY_ID = 1;
    }

    private class ChannelAdapter
    extends CursorAdapter
    implements SectionIndexer {
        Context context;
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ChannelAdapter(Context context) {
            super(context, null, 0);
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)ChannelFragment.this.getActivity(), R.style.searchTextHiglight);
        }

        private int indexOfSearchQuery(String displayName) {
            if (!TextUtils.isEmpty((CharSequence)ChannelFragment.this.mSearchTerm)) {
                return displayName.toLowerCase(Locale.getDefault()).indexOf(ChannelFragment.this.mSearchTerm.toLowerCase(Locale.getDefault()));
            }
            return -1;
        }

        public View newView(Context context, Cursor cursor, ViewGroup parent) {
            View itemLayout = this.mInflater.inflate(R.layout.applozic_groups_list_layout, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.groupName = (TextView)itemLayout.findViewById(R.id.applozic_group_name);
            holder.totalmembers = (TextView)itemLayout.findViewById(R.id.applozic_group_members);
            holder.groupIcon = (CircleImageView)itemLayout.findViewById(R.id.contactImage);
            itemLayout.setTag((Object)holder);
            return itemLayout;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ViewHolder holder = (ViewHolder)view.getTag();
            Channel channel = ChannelDatabaseService.getInstance((Context)ChannelFragment.this.getContext()).getChannel(cursor);
            if (!TextUtils.isEmpty((CharSequence)channel.getImageUrl())) {
                ChannelFragment.this.mChannelImageLoader.loadImage((Object)channel, (ImageView)holder.groupIcon);
            } else if (channel.isBroadcastMessage()) {
                holder.groupIcon.setImageResource(R.drawable.applozic_ic_applozic_broadcast);
            } else {
                holder.groupIcon.setImageResource(R.drawable.applozic_group_icon);
            }
            int startIndex = this.indexOfSearchQuery(channel.getName());
            if (startIndex == -1) {
                holder.groupName.setText((CharSequence)channel.getName());
                if (TextUtils.isEmpty((CharSequence)ChannelFragment.this.mSearchTerm)) {
                    holder.totalmembers.setVisibility(8);
                } else {
                    holder.totalmembers.setVisibility(0);
                }
            } else {
                SpannableString highlightedName = new SpannableString((CharSequence)channel.getName());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + ChannelFragment.this.mSearchTerm.length(), 0);
                holder.groupName.setText((CharSequence)highlightedName);
            }
        }

        public Cursor swapCursor(Cursor newCursor) {
            this.mAlphabetIndexer.setCursor(newCursor);
            return super.swapCursor(newCursor);
        }

        public int getCount() {
            if (this.getCursor() == null) {
                return 0;
            }
            return super.getCount();
        }

        public Object[] getSections() {
            return this.mAlphabetIndexer.getSections();
        }

        public int getPositionForSection(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getPositionForSection(i);
        }

        public int getSectionForPosition(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getSectionForPosition(i);
        }

        private class ViewHolder {
            TextView groupName;
            TextView totalmembers;
            CircleImageView groupIcon;

            private ViewHolder() {
            }
        }
    }
}

