/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.FileProvider;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AlphabetIndexer;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.VideoCallNotificationHelper;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import com.applozic.mobicomkit.contact.VCFContactData;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.FullScreenImageActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.LocationUtils;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageCache;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DetailedConversationAdapter
extends ArrayAdapter<Message> {
    private static final String TAG = "DetailedConversation";
    private static final int FILE_THRESOLD_SIZE = 400;
    public ImageLoader contactImageLoader;
    public ImageLoader loadImage;
    private Context context;
    private Contact contact;
    private Channel channel;
    private boolean individual;
    private Drawable sentIcon;
    private Drawable deliveredIcon;
    private Drawable pendingIcon;
    private Drawable scheduledIcon;
    private ImageLoader imageThumbnailLoader;
    private TextView downloadSizeTextView;
    private EmojiconHandler emojiconHandler;
    private FileClientService fileClientService;
    private MessageDatabaseService messageDatabaseService;
    private BaseContactService contactService;
    private Contact senderContact;
    private long deviceTimeOffset = 0L;
    private Class<?> messageIntentClass;
    private List<Message> messageList;
    private List<Message> originalList;
    private MobiComConversationService conversationService;
    private ImageCache imageCache;
    public String searchString;
    private AlphabetIndexer mAlphabetIndexer;
    private TextAppearanceSpan highlightTextSpan;
    AlCustomizationSettings alCustomizationSettings;

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Channel channel, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, textViewResourceId, messageList, null, channel, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Contact contact, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, textViewResourceId, messageList, contact, null, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Contact contact, Channel channel, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        super(context, textViewResourceId, messageList);
        this.messageIntentClass = messageIntentClass;
        this.context = context;
        this.contact = contact;
        this.channel = channel;
        this.emojiconHandler = emojiconHandler;
        this.individual = contact != null || channel != null;
        this.fileClientService = new FileClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.conversationService = new MobiComConversationService(context);
        this.contactService = new AppContactService(context);
        this.imageCache = ImageCache.getInstance((FragmentManager)((FragmentActivity)context).getSupportFragmentManager(), (float)0.1f);
        this.senderContact = this.contactService.getContactById(MobiComUserPreference.getInstance((Context)context).getUserId());
        this.messageList = messageList;
        this.contactImageLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.contactService.downloadContactImage(DetailedConversationAdapter.this.getContext(), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.loadImage = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.fileClientService.loadMessageImage(DetailedConversationAdapter.this.getContext(), (String)data);
            }
        };
        this.loadImage.setImageFadeIn(false);
        this.loadImage.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.imageThumbnailLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.fileClientService.loadThumbnailImage(DetailedConversationAdapter.this.getContext(), (FileMeta)data, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).width, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).height);
            }
        };
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.imageThumbnailLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.sentIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_sent);
        this.deliveredIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
        this.pendingIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_pending);
        this.scheduledIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_schedule);
        String alphabet = context.getString(R.string.alphabet);
        this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
        this.highlightTextSpan = new TextAppearanceSpan(context, R.style.searchTextHiglight);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.deviceTimeOffset = MobiComUserPreference.getInstance((Context)this.context).getDeviceTimeOffset();
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        final Message message = (Message)this.getItem(position);
        int type = this.getItemViewType(position);
        if (type == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
            SimpleDateFormat simpleDateFormatDay = new SimpleDateFormat("EEEE");
            View customView = inflater.inflate(R.layout.mobicom_date_layout, parent, false);
            TextView dateView = (TextView)customView.findViewById(R.id.chat_screen_date);
            TextView dayTextView = (TextView)customView.findViewById(R.id.chat_screen_day);
            Date date = new Date(message.getCreatedAtTime());
            dateView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getConversationDateTextColor().trim()));
            dayTextView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getConversationDayTextColor().trim()));
            if (DateUtils.isSameDay((Long)message.getCreatedAtTime())) {
                dayTextView.setVisibility(0);
                dayTextView.setText((CharSequence)"Today");
            } else {
                dayTextView.setVisibility(0);
                dateView.setVisibility(0);
                dayTextView.setText((CharSequence)simpleDateFormatDay.format(date));
                dateView.setText((CharSequence)simpleDateFormat.format(date));
            }
            return customView;
        }
        if (type == 3) {
            View customView = inflater.inflate(R.layout.applozic_custom_message_layout, parent, false);
            TextView customContentTextView = (TextView)customView.findViewById(R.id.applozic_custom_message_layout_content);
            customContentTextView.setText((CharSequence)message.getMessage());
            customContentTextView.setVisibility(0);
            return customView;
        }
        if (type == 4) {
            View customView = inflater.inflate(R.layout.applozic_channel_custom_message_layout, parent, false);
            TextView channelMessageTextView = (TextView)customView.findViewById(R.id.channel_message);
            GradientDrawable bgGradientDrawable = (GradientDrawable)channelMessageTextView.getBackground();
            bgGradientDrawable.setColor(Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageBgColor()));
            bgGradientDrawable.setStroke(3, Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageBorderColor()));
            channelMessageTextView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageTextColor()));
            channelMessageTextView.setText((CharSequence)message.getMessage());
            return customView;
        }
        if (type == 5) {
            View customView = inflater.inflate(R.layout.applozic_call_layout, parent, false);
            this.populateVideoCall(customView, message);
            return customView;
        }
        View customView = type == 0 ? inflater.inflate(R.layout.mobicom_received_message_list_view, parent, false) : inflater.inflate(R.layout.mobicom_sent_message_list_view, parent, false);
        if (message != null) {
            Contact receiverContact = null;
            Contact contactDisplayName = null;
            if (message.getGroupId() == null) {
                List<String> items = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                List<String> userIds = null;
                if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                    userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                }
                if (this.individual) {
                    receiverContact = this.contact;
                    this.contact.setContactNumber(items.get(0));
                    if (userIds != null) {
                        this.contact.setUserId(userIds.get(0));
                    }
                } else {
                    receiverContact = this.contactService.getContactReceiver(items, userIds);
                }
            } else if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                contactDisplayName = this.contactService.getContactById(message.getContactIds());
            }
            View messageTextLayout = customView.findViewById(R.id.messageTextLayout);
            TextView createdAtTime = (TextView)customView.findViewById(R.id.createdAtTime);
            TextView messageTextView = (TextView)customView.findViewById(R.id.message);
            CircleImageView contactImage = (CircleImageView)customView.findViewById(R.id.contactImage);
            TextView alphabeticTextView = (TextView)customView.findViewById(R.id.alphabeticImage);
            ImageView sentOrReceived = (ImageView)customView.findViewById(R.id.sentOrReceivedIcon);
            ImageView mapImageView = (ImageView)customView.findViewById(R.id.static_mapview);
            RelativeLayout chatLocation = (RelativeLayout)customView.findViewById(R.id.chat_location);
            TextView deliveryStatus = (TextView)customView.findViewById(R.id.status);
            TextView selfDestruct = (TextView)customView.findViewById(R.id.selfDestruct);
            ImageView preview = (ImageView)customView.findViewById(R.id.preview);
            final AttachmentView attachmentView = (AttachmentView)customView.findViewById(R.id.main_attachment_view);
            TextView attachedFile = (TextView)customView.findViewById(R.id.attached_file);
            ImageView attachmentIcon = (ImageView)customView.findViewById(R.id.attachmentIcon);
            this.downloadSizeTextView = (TextView)customView.findViewById(R.id.attachment_size_text);
            final LinearLayout attachmentDownloadLayout = (LinearLayout)customView.findViewById(R.id.attachment_download_layout);
            final LinearLayout attachmentRetry = (LinearLayout)customView.findViewById(R.id.attachment_retry_layout);
            final RelativeLayout attachmentDownloadProgressLayout = (RelativeLayout)customView.findViewById(R.id.attachment_download_progress_layout);
            RelativeLayout mainAttachmentLayout = (RelativeLayout)customView.findViewById(R.id.attachment_preview_layout);
            LinearLayout mainContactShareLayout = (LinearLayout)customView.findViewById(R.id.contact_share_layout);
            ImageView videoIcon = (ImageView)customView.findViewById(R.id.video_icon);
            final ProgressBar mediaDownloadProgressBar = (ProgressBar)customView.findViewById(R.id.media_download_progress_bar);
            final ProgressBar mediaUploadProgressBar = (ProgressBar)customView.findViewById(R.id.media_upload_progress_bar);
            TextView nameTextView = (TextView)customView.findViewById(R.id.name_textView);
            createdAtTime.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getMessageTimeTextColor()));
            final String messageTapActivityClassName = ApplozicSetting.getInstance(this.context).getActivityCallback(ApplozicSetting.RequestCode.MESSAGE_TAP);
            if (!TextUtils.isEmpty((CharSequence)messageTapActivityClassName) && message.getMetadata() != null && !message.getMetadata().isEmpty()) {
                customView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            Intent intent = new Intent(DetailedConversationAdapter.this.context, Class.forName(messageTapActivityClassName));
                            intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)message, Message.class));
                            DetailedConversationAdapter.this.context.startActivity(intent);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            if (TextUtils.isEmpty((CharSequence)message.getMessage())) {
                messageTextView.setVisibility(8);
            }
            if (attachedFile != null) {
                attachedFile.setText((CharSequence)"");
                attachedFile.setVisibility(8);
            }
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
            if (this.channel != null && nameTextView != null && contactDisplayName != null) {
                nameTextView.setVisibility(0);
                String userId = contactDisplayName.getDisplayName();
                char firstLetter = contactDisplayName.getDisplayName().charAt(0);
                if (userId.length() > 0) {
                    nameTextView.setText((CharSequence)String.valueOf(userId));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                nameTextView.setTextColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            attachmentDownloadLayout.setVisibility(8);
            preview.setVisibility(message.hasAttachment() ? 0 : 8);
            attachmentView.setVisibility(8);
            if (message.isTypeOutbox() && !message.isCanceled()) {
                mediaUploadProgressBar.setVisibility(message.isAttachmentUploadInProgress() ? 0 : 8);
            } else {
                mediaUploadProgressBar.setVisibility(8);
            }
            if (attachedFile != null) {
                attachedFile.setVisibility(message.hasAttachment() ? 0 : 8);
            }
            if (this.individual && message.getTimeToLive() != null) {
                selfDestruct.setText((CharSequence)("Self destruct in " + message.getTimeToLive() + " mins"));
                selfDestruct.setVisibility(0);
            } else {
                selfDestruct.setText((CharSequence)"");
                selfDestruct.setVisibility(8);
            }
            if (sentOrReceived != null) {
                if (!message.isCall() || message.isDummyEmptyMessage()) {
                    sentOrReceived.setVisibility(8);
                } else if (message.isCall()) {
                    sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                } else if (this.getItemViewType(position) == 0) {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                } else {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                }
                if (message.isCall()) {
                    messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                }
            }
            if (message.isCall() || message.isDummyEmptyMessage()) {
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            } else if (!message.isSentToServer() && message.isTypeOutbox()) {
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, message.getScheduledAt() != null ? this.scheduledIcon : this.pendingIcon, null);
            } else if (message.getKeyString() != null && message.isTypeOutbox() && message.isSentToServer()) {
                Drawable statusIcon = message.isDeliveredAndRead() ? this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_read) : (message.getDelivered() != false || this.contact != null && new Support(this.context).isSupportNumber(this.contact.getFormattedContactNumber()) ? this.deliveredIcon : (message.getScheduledAt() != null ? this.scheduledIcon : this.sentIcon));
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, statusIcon, null);
            }
            if (message.isCall()) {
                deliveryStatus.setText((CharSequence)"");
            }
            if (message.isTypeOutbox()) {
                this.loadContactImage(this.senderContact, contactDisplayName, message, (ImageView)contactImage, alphabeticTextView);
            } else {
                this.loadContactImage(receiverContact, contactDisplayName, message, (ImageView)contactImage, alphabeticTextView);
            }
            if (message.hasAttachment() && attachedFile != null & message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                int i;
                mainAttachmentLayout.setLayoutParams(this.getImageLayoutParam(false));
                if (message.getFileMetas() != null && (message.getFileMetas().getContentType().contains("image") || message.getFileMetas().getContentType().contains("video"))) {
                    attachedFile.setVisibility(8);
                }
                if (message.isAttachmentDownloaded()) {
                    preview.setVisibility(8);
                    String[] filePaths = new String[message.getFilePaths().size()];
                    i = 0;
                    for (String filePath : message.getFilePaths()) {
                        filePaths[i++] = filePath;
                        String mimeType = FileUtils.getMimeType((String)filePath);
                        if (mimeType != null && mimeType.startsWith("image")) {
                            attachmentView.setMessage(message);
                            attachmentView.setProressBar(mediaDownloadProgressBar);
                            attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                            attachmentView.setVisibility(0);
                            attachedFile.setVisibility(8);
                            continue;
                        }
                        if (mimeType != null && mimeType.startsWith("video")) {
                            preview.setVisibility(0);
                            videoIcon.setVisibility(0);
                            attachmentDownloadLayout.setVisibility(8);
                            attachedFile.setVisibility(8);
                            if (this.imageCache.getBitmapFromMemCache(message.getKeyString()) != null) {
                                preview.setImageBitmap(this.imageCache.getBitmapFromMemCache(message.getKeyString()));
                                continue;
                            }
                            this.imageCache.addBitmapToCache(message.getKeyString(), this.fileClientService.createAndSaveVideoThumbnail(filePath));
                            preview.setImageBitmap(this.fileClientService.createAndSaveVideoThumbnail(filePath));
                            continue;
                        }
                        this.showAttachmentIconAndText(attachedFile, message, mimeType);
                    }
                } else if (message.isAttachmentUploadInProgress()) {
                    attachmentDownloadProgressLayout.setVisibility(0);
                    attachmentView.setProressBar(mediaDownloadProgressBar);
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    attachmentView.setMessage(message);
                    attachmentView.setVisibility(0);
                } else if (AttachmentManager.isAttachmentInProgress((String)message.getKeyString())) {
                    attachmentView.setMessage(message);
                    attachmentView.setVisibility(0);
                    attachmentView.setProressBar(mediaDownloadProgressBar);
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    this.showPreview(message, preview, attachmentDownloadLayout);
                    FileMeta fileMeta = message.getFileMetas();
                    String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                    if (!fileMeta.getContentType().contains("image") && !fileMeta.getContentType().contains("video")) {
                        this.showAttachmentIconAndText(attachedFile, message, mimeType);
                    }
                    this.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    attachmentDownloadProgressLayout.setVisibility(0);
                } else {
                    String fileKeys = message.getFileMetaKeyStrings();
                    i = 0;
                    this.showPreview(message, preview, attachmentDownloadLayout);
                    if (message.getFileMetas() != null) {
                        FileMeta fileMeta = message.getFileMetas();
                        attachmentDownloadLayout.setVisibility(0);
                        attachmentDownloadProgressLayout.setVisibility(8);
                        this.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                        String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                        if (!fileMeta.getContentType().contains("image") && !fileMeta.getContentType().contains("video")) {
                            this.showAttachmentIconAndText(attachedFile, message, mimeType);
                        }
                    }
                }
            }
            if (message.isCanceled()) {
                attachmentRetry.setVisibility(0);
            }
            attachmentRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Toast.makeText((Context)DetailedConversationAdapter.this.context, (CharSequence)"Resending attachment....", (int)1).show();
                    mediaUploadProgressBar.setVisibility(0);
                    attachmentRetry.setVisibility(8);
                    message.setCanceled(false);
                    DetailedConversationAdapter.this.messageDatabaseService.updateCanceledFlag(message.getMessageId().longValue(), 0);
                    DetailedConversationAdapter.this.conversationService.sendMessage(message, DetailedConversationAdapter.this.messageIntentClass);
                }
            });
            attachmentDownloadProgressLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    attachmentView.setVisibility(8);
                    attachmentView.cancelDownload();
                    attachmentDownloadProgressLayout.setVisibility(8);
                    message.setAttDownloadInProgress(false);
                }
            });
            preview.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (message.getContentType() == Message.ContentType.TEXT_URL.getValue().shortValue()) {
                        return;
                    }
                    if (message.isAttachmentDownloaded()) {
                        DetailedConversationAdapter.this.showFullView(message);
                    } else {
                        attachmentDownloadLayout.setVisibility(8);
                        attachmentView.setProressBar(mediaDownloadProgressBar);
                        attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                        attachmentView.setMessage(message);
                        attachmentView.setVisibility(0);
                        attachmentDownloadProgressLayout.setVisibility(0);
                    }
                }
            });
            preview.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
            attachmentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DetailedConversationAdapter.this.showFullView(message);
                }
            });
            attachmentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
            if (attachedFile != null) {
                attachedFile.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        return false;
                    }
                });
            }
            if (message.getScheduledAt() != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getScheduledAt()));
            } else if (createdAtTime != null && message.isDummyEmptyMessage()) {
                createdAtTime.setText((CharSequence)"");
            } else if (createdAtTime != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getCreatedAtTime()));
            }
            String mimeType = "";
            if (messageTextView != null) {
                messageTextView.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
                messageTextView.setLinkTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageLinkTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageLinkTextColor()));
                if (message.getContentType() == Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    try {
                        attachedFile.setVisibility(8);
                        preview.setVisibility(0);
                        messageTextView.setText((CharSequence)message.getMessage());
                        this.loadImage.setImageFadeIn(false);
                        this.loadImage.loadImage((Object)message.getFileMetas().getBlobKeyString(), preview);
                        attachmentDownloadLayout.setVisibility(8);
                    }
                    catch (Exception i) {}
                } else if (message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) {
                    chatLocation.setLayoutParams(this.getImageLayoutParam(false));
                    chatLocation.setVisibility(0);
                    this.loadImage.setImageFadeIn(false);
                    this.loadImage.setLoadingImage(R.drawable.applozic_map_offline_thumbnail);
                    this.loadImage.loadImage((Object)LocationUtils.loadStaticMap((String)message.getMessage()), mapImageView);
                    messageTextView.setVisibility(8);
                    mapImageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            String uri = String.format(Locale.ENGLISH, "http://maps.google.com/maps?q=" + LocationUtils.getLocationFromMessage((String)message.getMessage()), new Object[0]);
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
                            DetailedConversationAdapter.this.getContext().startActivity(intent);
                        }
                    });
                } else if (message.getContentType() == Message.ContentType.PRICE.getValue().shortValue()) {
                    messageTextView.setText((CharSequence)("Final agreed price " + message.getMessage()));
                } else if (message.getContentType() == Message.ContentType.VIDEO_MSG.getValue().shortValue() && !message.isAttachmentDownloaded()) {
                    preview.setVisibility(0);
                    preview.setImageResource(R.drawable.applozic_video_default_thumbnail);
                } else if (message.getContentType() == Message.ContentType.TEXT_HTML.getValue().shortValue()) {
                    messageTextView.setText((CharSequence)Html.fromHtml((String)message.getMessage()));
                } else {
                    messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)message.getMessage(), (EmojiconHandler)this.emojiconHandler));
                    if (mimeType != null && attachmentIcon != null) {
                        if (mimeType.startsWith("image")) {
                            attachmentIcon.setImageResource(R.drawable.applozic_ic_action_camera);
                        } else if (mimeType.startsWith("video")) {
                            attachmentIcon.setImageResource(R.drawable.applozic_ic_action_video);
                        }
                    }
                }
                if (messageTextLayout != null) {
                    GradientDrawable bgShape = (GradientDrawable)messageTextLayout.getBackground();
                    bgShape.setColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageBackgroundColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageBackgroundColor()));
                    bgShape.setStroke(3, message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageBorderColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageBackgroundColor()));
                }
            }
            if (message.isContactMessage()) {
                attachedFile.setVisibility(8);
                mainAttachmentLayout.setVisibility(8);
                this.setupContactShareView(message, mainContactShareLayout);
                return customView;
            }
            mainContactShareLayout.setVisibility(8);
            int startIndex = this.indexOfSearchQuery(message.getMessage());
            if (startIndex != -1) {
                SpannableString highlightedName = new SpannableString((CharSequence)message.getMessage());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + this.searchString.toString().length(), 0);
                messageTextView.setText((CharSequence)highlightedName);
            }
        }
        return customView;
    }

    private void setupContactShareView(final Message message, LinearLayout mainContactShareLayout) {
        mainContactShareLayout.setVisibility(0);
        mainContactShareLayout.setLayoutParams(this.getImageLayoutParam(false));
        MobiComVCFParser parser = new MobiComVCFParser();
        try {
            VCFContactData data = parser.parseCVFContactData((String)message.getFilePaths().get(0));
            ImageView shareContactImage = (ImageView)mainContactShareLayout.findViewById(R.id.contact_share_image);
            TextView shareContactName = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_tv_name);
            TextView shareContactNo = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_tv_no);
            TextView shareEmailContact = (TextView)mainContactShareLayout.findViewById(R.id.contact_share_emailId);
            Button addContactButton = (Button)mainContactShareLayout.findViewById(R.id.contact_share_add_btn);
            shareContactName.setText((CharSequence)data.getName());
            int resId = message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentContactMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedContactMessageTextColor());
            shareContactName.setTextColor(resId);
            shareContactNo.setTextColor(resId);
            shareEmailContact.setTextColor(resId);
            addContactButton.setTextColor(resId);
            if (data.getProfilePic() != null) {
                if (this.imageCache.getBitmapFromMemCache(message.getKeyString()) == null) {
                    this.imageCache.addBitmapToCache(message.getKeyString(), data.getProfilePic());
                }
                shareContactImage.setImageBitmap(this.imageCache.getBitmapFromMemCache(message.getKeyString()));
            }
            if (!TextUtils.isEmpty((CharSequence)data.getTelephoneNumber())) {
                shareContactNo.setText((CharSequence)data.getTelephoneNumber());
            } else {
                shareContactNo.setVisibility(8);
            }
            if (data.getEmail() != null) {
                shareEmailContact.setText((CharSequence)data.getEmail());
            } else {
                shareEmailContact.setVisibility(8);
            }
            addContactButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    Uri outputUri = null;
                    intent.addFlags(1);
                    outputUri = Utils.hasNougat() ? FileProvider.getUriForFile((Context)DetailedConversationAdapter.this.context, (String)(Utils.getMetaDataValue((Context)DetailedConversationAdapter.this.context, (String)"com.package.name") + ".provider"), (File)new File((String)message.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)message.getFilePaths().get(0)));
                    if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                        intent.setDataAndType(outputUri, "text/x-vcard");
                        DetailedConversationAdapter.this.context.startActivity(intent);
                    } else {
                        Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                    }
                }
            });
        }
        catch (Exception e) {
            Log.e((String)"DetailedConvAdapter", (String)"Exception in parsing", (Throwable)e);
        }
    }

    private void loadContactImage(Contact contact, Contact contactDisplayName, Message messageObj, ImageView contactImage, TextView alphabeticTextView) {
        if (alphabeticTextView != null) {
            String contactNumber = "";
            char firstLetter = '\u0000';
            if (contact != null) {
                contactNumber = contact.getDisplayName().toUpperCase();
                firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
            } else if (this.channel != null && contactDisplayName != null) {
                firstLetter = contactDisplayName.getDisplayName().toUpperCase().charAt(0);
                contactNumber = contactDisplayName.getDisplayName().toUpperCase();
            }
            if (firstLetter != '+') {
                alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
            } else if (!TextUtils.isEmpty((CharSequence)contactNumber) && contactNumber.length() >= 2) {
                alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
            }
            Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
            GradientDrawable bgShape = (GradientDrawable)alphabeticTextView.getBackground();
            bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
        }
        if (contact != null && contact.isDrawableResources() && contactImage != null) {
            int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
            contactImage.setImageResource(drawableResourceId);
            contactImage.setVisibility(0);
            alphabeticTextView.setVisibility(8);
        } else if (contact != null && contactImage != null) {
            if (TextUtils.isEmpty((CharSequence)contact.getImageURL())) {
                contactImage.setVisibility(8);
                alphabeticTextView.setVisibility(0);
            } else {
                this.contactImageLoader.loadImage((Object)contact, contactImage, alphabeticTextView);
            }
        }
        if (contactDisplayName != null && contactDisplayName.isDrawableResources() && contactImage != null) {
            int drawableResourceId = this.context.getResources().getIdentifier(contactDisplayName.getrDrawableName(), "drawable", this.context.getPackageName());
            contactImage.setImageResource(drawableResourceId);
            contactImage.setVisibility(0);
            alphabeticTextView.setVisibility(8);
        } else if (contactDisplayName != null && contactImage != null) {
            if (TextUtils.isEmpty((CharSequence)contactDisplayName.getImageURL())) {
                contactImage.setVisibility(8);
                alphabeticTextView.setVisibility(0);
            } else {
                this.contactImageLoader.loadImage((Object)contactDisplayName, contactImage, alphabeticTextView);
            }
        }
    }

    private void showAttachmentIconAndText(TextView attachedFile, final Message message, final String mimeType) {
        String fileName = "";
        if (message.getFileMetas() == null && message.getFilePaths() != null) {
            fileName = ((String)message.getFilePaths().get(0)).substring(((String)message.getFilePaths().get(0)).lastIndexOf("/") + 1);
        } else if (message.getFileMetas() != null) {
            fileName = message.getFileMetas().getName();
        }
        attachedFile.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
        attachedFile.setText((CharSequence)fileName);
        attachedFile.setVisibility(0);
        attachedFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.isAttachmentDownloaded()) {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    Uri outputUri = Utils.hasNougat() ? FileProvider.getUriForFile((Context)DetailedConversationAdapter.this.context, (String)(Utils.getMetaDataValue((Context)DetailedConversationAdapter.this.context, (String)"com.package.name") + ".provider"), (File)new File((String)message.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)message.getFilePaths().get(0)));
                    intent.addFlags(1);
                    if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                        intent.setDataAndType(outputUri, mimeType);
                        DetailedConversationAdapter.this.context.startActivity(intent);
                    } else {
                        Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                    }
                }
            }
        });
    }

    private void showPreview(Message smListItem, ImageView preview, LinearLayout attachmentDownloadLayout) {
        FileMeta fileMeta = smListItem.getFileMetas();
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.imageThumbnailLoader.setLoadingImage(R.id.media_upload_progress_bar);
        this.imageThumbnailLoader.loadImage((Object)fileMeta, preview);
        attachmentDownloadLayout.setVisibility(8);
    }

    private void showFullView(Message smListItem) {
        String mimeType = FileUtils.getMimeType((String)((String)smListItem.getFilePaths().get(0)));
        if (mimeType != null) {
            if (mimeType.startsWith("image")) {
                Intent intent = new Intent(this.context, FullScreenImageActivity.class);
                intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)smListItem, Message.class));
                ((MobiComKitActivityInterface)this.context).startActivityForResult(intent, 301);
            }
            if (mimeType.startsWith("video") && smListItem.isAttachmentDownloaded()) {
                Intent intentVideo = new Intent();
                intentVideo.setAction("android.intent.action.VIEW");
                Uri outputUri = Utils.hasNougat() ? FileProvider.getUriForFile((Context)this.context, (String)(Utils.getMetaDataValue((Context)this.context, (String)"com.package.name") + ".provider"), (File)new File((String)smListItem.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)smListItem.getFilePaths().get(0)));
                intentVideo.addFlags(1);
                if (intentVideo.resolveActivity(this.context.getPackageManager()) != null) {
                    intentVideo.setDataAndType(outputUri, "video/*");
                    this.context.startActivity(intentVideo);
                } else {
                    Toast.makeText((Context)this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                }
            }
        }
    }

    public int getViewTypeCount() {
        return 6;
    }

    public int getItemViewType(int position) {
        Message message = (Message)this.getItem(position);
        if (message == null) {
            return 0;
        }
        if (message.isTempDateType()) {
            return 2;
        }
        if (message.isCustom()) {
            return 3;
        }
        if (message.isChannelCustomMessage()) {
            return 4;
        }
        if (message.isVideoCallMessage()) {
            return 5;
        }
        return message.isTypeOutbox() ? 1 : 0;
    }

    public ViewGroup.LayoutParams getImageLayoutParam(boolean outBoxType) {
        RelativeLayout.LayoutParams params;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        float wt_px = TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        if (outBoxType) {
            params = new RelativeLayout.LayoutParams(metrics.widthPixels + (int)wt_px * 2, -2);
            params.setMargins((int)wt_px, 0, (int)wt_px, 0);
        } else {
            params = new LinearLayout.LayoutParams(metrics.widthPixels - (int)wt_px * 2, -2);
            params.setMargins(0, 0, 0, 0);
        }
        return params;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults oReturn = new Filter.FilterResults();
                ArrayList<Message> results = new ArrayList<Message>();
                if (DetailedConversationAdapter.this.originalList == null) {
                    DetailedConversationAdapter.this.originalList = DetailedConversationAdapter.this.messageList;
                }
                if (constraint != null) {
                    DetailedConversationAdapter.this.searchString = constraint.toString();
                    if (DetailedConversationAdapter.this.originalList != null && DetailedConversationAdapter.this.originalList.size() > 0) {
                        for (Message message : DetailedConversationAdapter.this.originalList) {
                            if (!message.getMessage().toLowerCase().contains(constraint.toString())) continue;
                            results.add(message);
                        }
                    }
                    oReturn.values = results;
                } else {
                    oReturn.values = DetailedConversationAdapter.this.originalList;
                }
                return oReturn;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                DetailedConversationAdapter.this.messageList = (ArrayList)results.values;
                DetailedConversationAdapter.this.notifyDataSetChanged();
            }
        };
    }

    private int indexOfSearchQuery(String message) {
        if (!TextUtils.isEmpty((CharSequence)this.searchString)) {
            return message.toLowerCase(Locale.getDefault()).indexOf(this.searchString.toString().toLowerCase(Locale.getDefault()));
        }
        return -1;
    }

    private void populateVideoCall(View customView, Message msg) {
        Map metaData = msg.getMetadata();
        TextView statusTextView = (TextView)customView.findViewById(R.id.applozic_call_status);
        TextView timeTextView = (TextView)customView.findViewById(R.id.applozic_call_timing);
        TextView durationTextView = (TextView)customView.findViewById(R.id.applozic_call_duration);
        ImageView imageView = (ImageView)customView.findViewById(R.id.applozic_call_image_type);
        timeTextView.setText((CharSequence)DateUtils.getFormattedDate((Long)msg.getCreatedAtTime()));
        statusTextView.setText((CharSequence)VideoCallNotificationHelper.getStatus((Map)metaData));
        if (VideoCallNotificationHelper.isMissedCall((Message)msg)) {
            imageView.setImageResource(R.drawable.ic_communication_call_missed);
        }
        if (!VideoCallNotificationHelper.isAudioCall((Message)msg)) {
            imageView.setImageResource(R.drawable.ic_videocam_white_24px);
        }
        if (((String)metaData.get("MSG_TYPE")).equals("CALL_END")) {
            String duration = (String)metaData.get("CALL_DURATION");
            if (!TextUtils.isEmpty((CharSequence)duration)) {
                durationTextView.setVisibility(0);
                duration = Utils.getTimeDurationInFormat((Long)Long.parseLong(duration));
                durationTextView.setText((CharSequence)duration);
            }
        } else {
            durationTextView.setVisibility(8);
        }
    }
}

