/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AudioMessageFragment
extends DialogFragment {
    Button cancel;
    Button send;
    TextView txtcount;
    TextView audioRecordingText;
    ImageButton record;
    private MediaRecorder audioRecorder;
    private String outputFile = null;
    CountDownTimer t;
    private int cnt;
    private boolean isRecordring;

    public static AudioMessageFragment newInstance() {
        AudioMessageFragment f = new AudioMessageFragment();
        return f;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.mobicom_audio_message_layout, container, false);
        this.getDialog().setTitle((CharSequence)"Voice Message");
        this.getDialog().setCancelable(Boolean.TRUE.booleanValue());
        this.record = (ImageButton)v.findViewById(R.id.audio_mic_imageview);
        this.send = (Button)v.findViewById(R.id.audio_send);
        this.cancel = (Button)v.findViewById(R.id.audio_cancel);
        this.txtcount = (TextView)v.findViewById(R.id.txtcount);
        this.audioRecordingText = (TextView)v.findViewById(R.id.audio_recording_text);
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String audioFileName = "AUD_" + timeStamp + "_" + ".m4a";
        this.outputFile = FileClientService.getFilePath((String)audioFileName, (Context)this.getActivity().getApplicationContext(), (String)"audio/m4a").getAbsolutePath();
        this.prepareMediaRecorder();
        this.record.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (AudioMessageFragment.this.isRecordring) {
                        AudioMessageFragment.this.stopRecording();
                        AudioMessageFragment.this.cancel.setVisibility(0);
                        AudioMessageFragment.this.send.setVisibility(0);
                    } else {
                        AudioMessageFragment.this.cancel.setVisibility(8);
                        AudioMessageFragment.this.send.setVisibility(8);
                        if (AudioMessageFragment.this.audioRecorder == null) {
                            AudioMessageFragment.this.prepareMediaRecorder();
                        }
                        AudioMessageFragment.this.audioRecordingText.setText((CharSequence)"STOP");
                        AudioMessageFragment.this.audioRecorder.prepare();
                        AudioMessageFragment.this.audioRecorder.start();
                        AudioMessageFragment.this.isRecordring = true;
                        AudioMessageFragment.this.record.setImageResource(R.drawable.applozic_audio_mic_inverted);
                        AudioMessageFragment.this.t.cancel();
                        AudioMessageFragment.this.t.start();
                        AudioMessageFragment.this.cnt = 0;
                    }
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                File file;
                if (AudioMessageFragment.this.isRecordring) {
                    AudioMessageFragment.this.stopRecording();
                }
                if ((file = new File(AudioMessageFragment.this.outputFile)) != null) {
                    Log.i((String)"AudioFRG:", (String)"File deleted...");
                    file.delete();
                }
                AudioMessageFragment.this.dismiss();
            }
        });
        this.send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) throws IllegalArgumentException, SecurityException, IllegalStateException {
                if (AudioMessageFragment.this.isRecordring) {
                    AudioMessageFragment.this.stopRecording();
                }
                if (!new File(AudioMessageFragment.this.outputFile).exists()) {
                    Toast.makeText((Context)AudioMessageFragment.this.getContext(), (int)R.string.audio_recording_send_text, (int)0).show();
                    return;
                }
                ConversationUIService conversationUIService = new ConversationUIService(AudioMessageFragment.this.getActivity());
                conversationUIService.sendAudioMessage(AudioMessageFragment.this.outputFile);
                AudioMessageFragment.this.dismiss();
            }
        });
        this.t = new CountDownTimer(Long.MAX_VALUE, 1000L){

            public void onTick(long millisUntilFinished) {
                AudioMessageFragment.this.cnt++;
                long millis = AudioMessageFragment.this.cnt;
                int seconds = (int)(millis / 60L);
                int minutes = seconds / 60;
                AudioMessageFragment.this.txtcount.setText((CharSequence)String.format("%d:%02d:%02d", minutes, seconds %= 60, millis));
            }

            public void onFinish() {
            }
        };
        return v;
    }

    public void stopRecording() {
        if (this.audioRecorder != null) {
            try {
                this.audioRecorder.stop();
            }
            catch (RuntimeException stopException) {
                Log.i((String)"AudioMsgFrag:", (String)"Runtime exception.This is thrown intentionally if stop is called just after start");
            }
            finally {
                this.audioRecorder.release();
                this.audioRecorder = null;
                this.isRecordring = false;
                this.record.setImageResource(R.drawable.applozic_audio_normal);
                this.audioRecordingText.setText(this.getResources().getText(R.string.start_text));
                this.t.cancel();
            }
        }
    }

    public MediaRecorder prepareMediaRecorder() {
        this.audioRecorder = new MediaRecorder();
        this.audioRecorder.setAudioSource(1);
        this.audioRecorder.setOutputFormat(2);
        this.audioRecorder.setAudioEncoder(3);
        this.audioRecorder.setAudioEncodingBitRate(256);
        this.audioRecorder.setAudioChannels(1);
        this.audioRecorder.setAudioSamplingRate(44100);
        this.audioRecorder.setOutputFile(this.outputFile);
        return this.audioRecorder;
    }
}

