/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.support.v4.app.FragmentActivity;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AlphabetIndexer;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.VideoCallNotificationHelper;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class QuickConversationAdapter
extends BaseAdapter
implements Filterable {
    private static Map<Short, Integer> messageTypeColorMap = new HashMap<Short, Integer>();
    public ImageLoader contactImageLoader;
    public ImageLoader channelImageLoader;
    private Context context;
    private MessageDatabaseService messageDatabaseService;
    private List<Message> messageList;
    private BaseContactService contactService;
    private EmojiconHandler emojiconHandler;
    private long deviceTimeOffset = 0L;
    private List<Message> originalList;
    public String searchString = null;
    private AlphabetIndexer mAlphabetIndexer;
    private TextAppearanceSpan highlightTextSpan;
    private AlCustomizationSettings alCustomizationSettings;
    TextView messageTextView;
    ImageView attachmentIcon;

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public QuickConversationAdapter(final Context context, List<Message> messageList, EmojiconHandler emojiconHandler) {
        this.context = context;
        this.emojiconHandler = emojiconHandler;
        this.contactService = new AppContactService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.messageList = messageList;
        this.contactImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return QuickConversationAdapter.this.contactService.downloadContactImage((Context)((Activity)context), (Contact)data);
            }
        };
        this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.channelImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return QuickConversationAdapter.this.contactService.downloadGroupImage((Context)((Activity)context), (Channel)data);
            }
        };
        this.channelImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.channelImageLoader.setImageFadeIn(false);
        String alphabet = context.getString(R.string.alphabet);
        this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
        this.highlightTextSpan = new TextAppearanceSpan(context, R.style.searchTextHiglight);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.deviceTimeOffset = MobiComUserPreference.getInstance((Context)this.context).getDeviceTimeOffset();
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        View customView = inflater.inflate(R.layout.mobicom_message_row_view, parent, false);
        TextView smTime = (TextView)customView.findViewById(R.id.smTime);
        smTime.setVisibility(8);
        final Message message = this.getItem(position);
        if (message != null) {
            Contact contactReceiver;
            TextView smReceivers = (TextView)customView.findViewById(R.id.smReceivers);
            TextView createdAtTime = (TextView)customView.findViewById(R.id.createdAtTime);
            this.messageTextView = (TextView)customView.findViewById(R.id.message);
            CircleImageView contactImage = (CircleImageView)customView.findViewById(R.id.contactImage);
            TextView alphabeticTextView = (TextView)customView.findViewById(R.id.alphabeticImage);
            TextView onlineTextView = (TextView)customView.findViewById(R.id.onlineTextView);
            ImageView sentOrReceived = (ImageView)customView.findViewById(R.id.sentOrReceivedIcon);
            TextView attachedFile = (TextView)customView.findViewById(R.id.attached_file);
            this.attachmentIcon = (ImageView)customView.findViewById(R.id.attachmentIcon);
            TextView unReadCountTextView = (TextView)customView.findViewById(R.id.unreadSmsCount);
            List<String> items = null;
            List<String> userIds = null;
            final Channel channel = ChannelDatabaseService.getInstance((Context)this.context).getChannelByChannelKey(message.getGroupId());
            if (channel == null && message.getGroupId() == null) {
                items = Arrays.asList(message.getTo().split("\\s*,\\s*"));
                if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                    userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                }
            }
            if ((contactReceiver = this.contactService.getContactReceiver(items, userIds)) != null) {
                String contactInfo = contactReceiver.getDisplayName();
                if (items.size() > 1) {
                    Contact contact2 = this.contactService.getContactById(items.get(1));
                    contactInfo = TextUtils.isEmpty((CharSequence)contactReceiver.getFirstName()) ? contactReceiver.getContactNumber() : contactReceiver.getFirstName() + ", " + (TextUtils.isEmpty((CharSequence)contact2.getFirstName()) ? contact2.getContactNumber() : contact2.getFirstName()) + (items.size() > 2 ? " & others" : "");
                }
                smReceivers.setText((CharSequence)contactInfo);
            }
            if (message.getGroupId() == null) {
                this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
            } else {
                this.channelImageLoader.setLoadingImage(R.drawable.applozic_group_icon);
            }
            String contactNumber = "";
            char firstLetter = '\u0000';
            if (channel != null && message.getGroupId() != null) {
                smReceivers.setText((CharSequence)ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.context).getUserId()));
                if (!TextUtils.isEmpty((CharSequence)channel.getImageUrl())) {
                    this.channelImageLoader.loadImage((Object)channel, (ImageView)contactImage);
                } else if (channel.isBroadcastMessage()) {
                    contactImage.setImageResource(R.drawable.applozic_ic_applozic_broadcast);
                } else {
                    this.channelImageLoader.setLoadingImage(R.drawable.applozic_group_icon);
                }
            } else if (contactReceiver != null) {
                contactNumber = contactReceiver.getDisplayName().toUpperCase();
                firstLetter = contactReceiver.getDisplayName().toUpperCase().charAt(0);
                if (contactReceiver != null) {
                    if (firstLetter != '+') {
                        alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
                    } else if (contactNumber.length() >= 2) {
                        alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                    }
                    Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                    GradientDrawable bgShape = (GradientDrawable)alphabeticTextView.getBackground();
                    bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
                }
                if (contactReceiver.isDrawableResources()) {
                    int drawableResourceId = this.context.getResources().getIdentifier(contactReceiver.getrDrawableName(), "drawable", this.context.getPackageName());
                    contactImage.setImageResource(drawableResourceId);
                } else if (TextUtils.isEmpty((CharSequence)contactReceiver.getImageURL())) {
                    alphabeticTextView.setVisibility(0);
                    contactImage.setVisibility(8);
                } else {
                    this.contactImageLoader.loadImage((Object)contactReceiver, (ImageView)contactImage, alphabeticTextView);
                }
            }
            if (this.alCustomizationSettings.isOnlineStatusMasterList()) {
                onlineTextView.setVisibility(contactReceiver != null && contactReceiver.isOnline() ? 0 : 8);
            }
            customView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    InstructionUtil.hideInstruction(QuickConversationAdapter.this.context, R.string.instruction_open_conversation_thread);
                    ((MobiComKitActivityInterface)QuickConversationAdapter.this.context).onQuickConversationFragmentItemClick(view, contactReceiver, channel, message.getConversationId(), QuickConversationAdapter.this.searchString);
                }
            });
            if (attachedFile != null) {
                attachedFile.setText((CharSequence)"");
                attachedFile.setVisibility(8);
            }
            if (this.attachmentIcon != null) {
                this.attachmentIcon.setVisibility(8);
            }
            if (message.hasAttachment() && this.attachmentIcon != null && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                String filePath = message.getFileMetas() == null && message.getFilePaths() != null ? ((String)message.getFilePaths().get(0)).substring(((String)message.getFilePaths().get(0)).lastIndexOf("/") + 1) : (message.getFileMetas() != null ? message.getFileMetas().getName() : "");
                this.attachmentIcon.setVisibility(0);
                this.messageTextView.setText((CharSequence)filePath);
            } else if (this.attachmentIcon != null && message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) {
                this.attachmentIcon.setVisibility(0);
                this.attachmentIcon.setImageResource(R.drawable.mobicom_notification_location_icon);
                this.messageTextView.setText((CharSequence)"Location");
            } else if (message.getContentType() == Message.ContentType.PRICE.getValue().shortValue()) {
                this.messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)("Final agreed price " + message.getMessage()), (EmojiconHandler)this.emojiconHandler));
            } else if (message.getContentType() == Message.ContentType.TEXT_HTML.getValue().shortValue()) {
                this.messageTextView.setText((CharSequence)Html.fromHtml((String)message.getMessage()));
            } else {
                this.messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)message.getMessage(), (EmojiconHandler)this.emojiconHandler));
            }
            if (sentOrReceived != null) {
                if (message.isCall()) {
                    sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                    this.messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                } else if (this.getItemViewType(position) == 0) {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                } else {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                }
            }
            if (createdAtTime != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDateAndTime((Long)message.getCreatedAtTime()));
            }
            int messageUnReadCount = 0;
            if (message.getGroupId() == null && contactReceiver != null && !TextUtils.isEmpty((CharSequence)contactReceiver.getContactIds())) {
                messageUnReadCount = this.messageDatabaseService.getUnreadMessageCountForContact(contactReceiver.getContactIds());
            } else if (channel != null && channel.getKey() != null && channel.getKey() != 0) {
                messageUnReadCount = this.messageDatabaseService.getUnreadMessageCountForChannel(channel.getKey());
            }
            if (messageUnReadCount > 0) {
                unReadCountTextView.setVisibility(0);
                unReadCountTextView.setText((CharSequence)String.valueOf(messageUnReadCount));
            } else {
                unReadCountTextView.setVisibility(8);
            }
            int startIndex = this.indexOfSearchQuery(message.getMessage());
            if (startIndex != -1) {
                SpannableString highlightedName = new SpannableString((CharSequence)message.getMessage());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + this.searchString.toString().length(), 0);
                this.messageTextView.setText((CharSequence)highlightedName);
            }
            if (message.isVideoCallMessage()) {
                this.createVideoCallView(message);
            }
        }
        return customView;
    }

    public int getCount() {
        return this.messageList.size();
    }

    public Message getItem(int position) {
        return this.messageList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getItemViewType(int position) {
        return this.getItem(position).isTypeOutbox() ? 1 : 0;
    }

    private int indexOfSearchQuery(String message) {
        if (!TextUtils.isEmpty((CharSequence)this.searchString)) {
            return message.toLowerCase(Locale.getDefault()).indexOf(this.searchString.toString().toLowerCase(Locale.getDefault()));
        }
        return -1;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults oReturn = new Filter.FilterResults();
                ArrayList<Message> results = new ArrayList<Message>();
                if (QuickConversationAdapter.this.originalList == null) {
                    QuickConversationAdapter.this.originalList = QuickConversationAdapter.this.messageList;
                }
                if (constraint != null) {
                    QuickConversationAdapter.this.searchString = constraint.toString();
                    if (QuickConversationAdapter.this.originalList != null && QuickConversationAdapter.this.originalList.size() > 0) {
                        for (Message message : QuickConversationAdapter.this.originalList) {
                            if (!message.getMessage().toLowerCase().contains(constraint.toString())) continue;
                            results.add(message);
                        }
                    }
                    oReturn.values = results;
                } else {
                    oReturn.values = QuickConversationAdapter.this.originalList;
                }
                return oReturn;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                QuickConversationAdapter.this.messageList = (ArrayList)results.values;
                QuickConversationAdapter.this.notifyDataSetChanged();
            }
        };
    }

    public void createVideoCallView(Message message) {
        if (message.getMetadata() == null || message.getMetadata().isEmpty()) {
            this.attachmentIcon.setImageResource(R.drawable.ic_videocam_white_24px);
            this.attachmentIcon.setColorFilter(R.color.applozic_green_color);
            return;
        }
        this.messageTextView.setText((CharSequence)VideoCallNotificationHelper.getStatus((Map)message.getMetadata()));
        this.attachmentIcon.setVisibility(0);
        if (VideoCallNotificationHelper.isMissedCall((Message)message)) {
            this.attachmentIcon.setImageResource(R.drawable.ic_communication_call_missed);
        } else if (VideoCallNotificationHelper.isAudioCall((Message)message)) {
            this.attachmentIcon.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
        } else {
            this.attachmentIcon.setImageResource(R.drawable.ic_videocam_white_24px);
            this.attachmentIcon.setColorFilter(R.color.applozic_green_color);
        }
    }

    static {
        messageTypeColorMap.put(Message.MessageType.INBOX.getValue(), R.color.message_type_inbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX.getValue(), R.color.message_type_outbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX_SENT_FROM_DEVICE.getValue(), R.color.message_type_outbox_sent_from_device);
        messageTypeColorMap.put(Message.MessageType.MT_INBOX.getValue(), R.color.message_type_mt_inbox);
        messageTypeColorMap.put(Message.MessageType.MT_OUTBOX.getValue(), R.color.message_type_mt_outbox);
        messageTypeColorMap.put(Message.MessageType.CALL_INCOMING.getValue(), R.color.message_type_incoming_call);
        messageTypeColorMap.put(Message.MessageType.CALL_OUTGOING.getValue(), R.color.message_type_outgoing_call);
    }
}

