/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.soundcloud.android.crop.Crop;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;

public class ChannelNameActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    private static final String TAG = "ChannelNameActivity";
    private EditText channelName;
    private Button ok;
    private Button cancel;
    public static final String CHANNEL_NAME = "CHANNEL_NAME";
    public static final String CHANNEL_IMAGE_URL = "IMAGE_URL";
    private static final int REQUEST_CODE_ATTACH_PHOTO = 701;
    String oldChannelName;
    ActionBar mActionBar;
    private CircleImageView selectImageProfileIcon;
    private ImageView applozicGroupProfileIcon;
    GroupInfoUpdate groupInfoUpdate;
    private LinearLayout layout;
    private Uri imageChangeUri;
    private Snackbar snackbar;
    private ApplozicPermissions applozicPermissions;
    private AlCustomizationSettings alCustomizationSettings;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.update_channel_name_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.mActionBar = this.getSupportActionBar();
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermissions = new ApplozicPermissions((Activity)this, this.layout);
        this.mActionBar.setTitle((CharSequence)this.getString(R.string.update_channel_title_name));
        this.selectImageProfileIcon = (CircleImageView)this.findViewById(R.id.applozic_group_profile_camera);
        this.applozicGroupProfileIcon = (ImageView)this.findViewById(R.id.applozic_group_profile);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        int drawableResourceId = this.getResources().getIdentifier(this.alCustomizationSettings.getAttachCameraIconName(), "drawable", this.getPackageName());
        this.selectImageProfileIcon.setImageResource(drawableResourceId);
        if (this.getIntent().getExtras() != null) {
            String groupInfoJson = this.getIntent().getExtras().getString("GROUP_UPDTAE_INFO");
            this.groupInfoUpdate = (GroupInfoUpdate)GsonUtils.getObjectFromJson((String)groupInfoJson, GroupInfoUpdate.class);
        }
        if (this.groupInfoUpdate != null && !TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getLocalImagePath())) {
            Uri uri = Uri.fromFile((File)new File(this.groupInfoUpdate.getLocalImagePath()));
            if (uri != null) {
                Log.i((String)"ChannelNameActivity::", (String)uri.toString());
                this.applozicGroupProfileIcon.setImageURI(uri);
            }
        } else {
            this.applozicGroupProfileIcon.setImageResource(R.drawable.applozic_group_icon);
        }
        this.channelName = (EditText)this.findViewById(R.id.newChannelName);
        this.channelName.setText((CharSequence)this.groupInfoUpdate.getNewName());
        this.ok = (Button)this.findViewById(R.id.channelNameOk);
        this.cancel = (Button)this.findViewById(R.id.channelNameCancel);
        this.selectImageProfileIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelNameActivity.this.processImagePicker();
            }
        });
        this.ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelNameActivity.this.groupInfoUpdate.getNewName().equals(ChannelNameActivity.this.channelName.getText().toString()) && ChannelNameActivity.this.imageChangeUri == null) {
                    ChannelNameActivity.this.finish();
                }
                if (TextUtils.isEmpty((CharSequence)ChannelNameActivity.this.channelName.getText().toString()) || ChannelNameActivity.this.channelName.getText().toString().trim().length() == 0) {
                    Toast.makeText((Context)ChannelNameActivity.this, (CharSequence)ChannelNameActivity.this.getString(R.string.channel_name_empty), (int)0).show();
                    ChannelNameActivity.this.finish();
                } else {
                    Intent intent = new Intent();
                    ChannelNameActivity.this.groupInfoUpdate.setNewName(ChannelNameActivity.this.channelName.getText().toString());
                    if (ChannelNameActivity.this.imageChangeUri != null) {
                        String filePath = FilePathFinder.getPath((Context)ChannelNameActivity.this, (Uri)ChannelNameActivity.this.imageChangeUri);
                        ChannelNameActivity.this.groupInfoUpdate.setNewlocalPath(filePath);
                    }
                    intent.putExtra("GROUP_UPDTAE_INFO", GsonUtils.getJsonFromObject((Object)ChannelNameActivity.this.groupInfoUpdate, GroupInfoUpdate.class));
                    ChannelNameActivity.this.setResult(-1, intent);
                    ChannelNameActivity.this.finish();
                }
            }
        });
        this.cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelNameActivity.this.finish();
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                this.processImagePicker();
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        Uri selectedFileUri = null;
        if (requestCode == 701 && resultCode == -1) {
            selectedFileUri = intent == null ? null : intent.getData();
            this.beginCrop(selectedFileUri);
        }
        if (requestCode == 6709 && resultCode == -1) {
            try {
                this.imageChangeUri = Crop.getOutput((Intent)intent);
                this.applozicGroupProfileIcon.setImageDrawable(null);
                this.applozicGroupProfileIcon.setImageURI(this.imageChangeUri);
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)"exception in profile image");
            }
        }
    }

    private void beginCrop(Uri source) {
        Uri destination = Uri.fromFile((File)new File(this.getCacheDir(), this.groupInfoUpdate.getGroupId() + "_profile_temp.jpeg"));
        Crop.of((Uri)source, (Uri)destination).asSquare().start((Activity)this);
    }

    public void processImagePicker() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermissions.requestStoragePermissions();
        } else {
            Intent getContentIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            this.startActivityForResult(getContentIntent, 701);
        }
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }
}

