/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NavUtils;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelCreateActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobicomLocationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.AudioMessageFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicomkit.uiwidgets.people.fragment.ProfileFragment;
import com.applozic.mobicomkit.uiwidgets.uilistener.MobicomkitUriListener;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.soundcloud.android.crop.Crop;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConversationActivity
extends AppCompatActivity
implements MessageCommunicator,
MobiComKitActivityInterface,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener,
ActivityCompat.OnRequestPermissionsResultCallback,
MobicomkitUriListener,
SearchView.OnQueryTextListener {
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final String TAKE_ORDER = "takeOrder";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String GOOGLE_API_KEY_META_DATA = "com.google.android.geo.API_KEY";
    public static final String ACTIVITY_TO_OPEN_ONCLICK_OF_CALL_BUTTON_META_DATA = "activity.open.on.call.button.click";
    protected static final long UPDATE_INTERVAL = 500L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final String API_KYE_STRING = "YOUR_GEO_API_KEY";
    private static final String CAPTURED_IMAGE_URI = "capturedImageUri";
    private static final String CAPTURED_VIDEO_URI = "capturedVideoUri";
    private static final String SHARE_TEXT = "share_text";
    private static Uri capturedImageUri;
    private static String inviteMessage;
    protected ConversationFragment conversation;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected ActionBar mActionBar;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private Contact contact;
    private Channel channel;
    private static int retry;
    public LinearLayout layout;
    String geoApiKey;
    String activityToOpenOnClickOfCallButton;
    int resourceId;
    RelativeLayout childFragmentLayout;
    private boolean isTakePhoto;
    private boolean isAttachment;
    private BaseContactService baseContactService;
    private ApplozicPermissions applozicPermission;
    private Integer currentConversationId;
    private Uri videoFileUri;
    private Uri imageUri;
    ProfileFragment profilefragment;
    MobiComMessageService mobiComMessageService;
    private ConversationUIService conversationUIService;
    private SearchView searchView;
    private String searchTerm;
    private SearchListFragment searchListFragment;
    AlCustomizationSettings alCustomizationSettings;
    public Snackbar snackbar;

    @Override
    public void showErrorMessageView(String message) {
        this.layout.setVisibility(0);
        this.snackbar = Snackbar.make((View)this.layout, (CharSequence)message, (int)0);
        this.snackbar.setAction((CharSequence)"OK", new View.OnClickListener(){

            public void onClick(View view) {
                ConversationActivity.this.snackbar.dismiss();
            }
        });
        this.snackbar.setDuration(0);
        ViewGroup group = (ViewGroup)this.snackbar.getView();
        TextView textView = (TextView)group.findViewById(R.id.snackbar_action);
        textView.setTextColor(-256);
        group.setBackgroundColor(this.getResources().getColor(R.color.error_background_color));
        TextView txtView = (TextView)group.findViewById(R.id.snackbar_text);
        txtView.setMaxLines(5);
        this.snackbar.show();
    }

    @Override
    public void retry() {
        ++retry;
    }

    @Override
    public int getRetryCount() {
        return retry;
    }

    public void dismissErrorMessage() {
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
    }

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1 && !"messageInfoFagment".equalsIgnoreCase(fragmentTag)) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    protected void onStop() {
        super.onStop();
        String deviceKeyString = MobiComUserPreference.getInstance((Context)this).getDeviceKeyString();
        String userKeyString = MobiComUserPreference.getInstance((Context)this).getSuUserKeyString();
        Intent intent = new Intent((Context)this, ApplozicMqttIntentService.class);
        intent.putExtra("userKeyString", userKeyString);
        intent.putExtra("deviceKeyString", deviceKeyString);
        this.startService(intent);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        Intent subscribeIntent = new Intent((Context)this, ApplozicMqttIntentService.class);
        subscribeIntent.putExtra("subscribe", true);
        this.startService(subscribeIntent);
        if (!Utils.isInternetAvailable((Context)this.getApplicationContext())) {
            String errorMessage = this.getResources().getString(R.string.internet_connection_not_available);
            this.showErrorMessageView(errorMessage);
        }
    }

    protected void onPause() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        super.onPause();
    }

    protected void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putSerializable(CONTACT, (Serializable)this.contact);
        savedInstanceState.putSerializable(CHANNEL, (Serializable)this.channel);
        savedInstanceState.putSerializable(CONVERSATION_ID, (Serializable)this.currentConversationId);
        if (capturedImageUri != null) {
            savedInstanceState.putString(CAPTURED_IMAGE_URI, capturedImageUri.toString());
        }
        if (this.videoFileUri != null) {
            savedInstanceState.putString(CAPTURED_VIDEO_URI, this.videoFileUri.toString());
        }
        super.onSaveInstanceState(savedInstanceState);
    }

    public boolean onSupportNavigateUp() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
                this.finish();
                return true;
            }
            Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
            if (takeOrder.booleanValue()) {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
                this.finish();
                return true;
            }
            this.getSupportFragmentManager().popBackStack();
            Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
            return true;
        }
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.baseContactService = new AppContactService((Context)this);
        this.conversationUIService = new ConversationUIService((FragmentActivity)this);
        this.mobiComMessageService = new MobiComMessageService((Context)this, MessageIntentService.class);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getChatBackgroundImageName())) {
            this.resourceId = this.getResources().getIdentifier(this.alCustomizationSettings.getChatBackgroundImageName(), "drawable", this.getPackageName());
        }
        if (this.resourceId != 0) {
            this.getWindow().setBackgroundDrawableResource(this.resourceId);
        }
        this.setContentView(R.layout.quickconversion_activity);
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        this.geoApiKey = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)GOOGLE_API_KEY_META_DATA);
        this.activityToOpenOnClickOfCallButton = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)ACTIVITY_TO_OPEN_ONCLICK_OF_CALL_BUTTON_META_DATA);
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermission = new ApplozicPermissions((Activity)this, this.layout);
        this.childFragmentLayout = (RelativeLayout)this.findViewById(R.id.layout_child_activity);
        this.profilefragment = new ProfileFragment();
        this.profilefragment.setAlCustomizationSettings(this.alCustomizationSettings);
        if (Utils.hasMarshmallow()) {
            this.applozicPermission.checkRuntimePermissionForStorage();
        }
        this.mActionBar = this.getSupportActionBar();
        inviteMessage = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)SHARE_TEXT);
        retry = 0;
        if (savedInstanceState != null) {
            capturedImageUri = savedInstanceState.getString(CAPTURED_IMAGE_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_IMAGE_URI)) : null;
            this.videoFileUri = savedInstanceState.getString(CAPTURED_VIDEO_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_VIDEO_URI)) : null;
            this.contact = (Contact)savedInstanceState.getSerializable(CONTACT);
            this.channel = (Channel)savedInstanceState.getSerializable(CHANNEL);
            this.currentConversationId = savedInstanceState.getInt(CONVERSATION_ID);
            this.conversation = this.channel != null ? new ConversationFragment(null, this.channel, this.currentConversationId) : new ConversationFragment(this.contact, null, this.currentConversationId);
            ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        } else {
            this.quickConversationFragment = new MobiComQuickConversationFragment();
            this.setSearchListFragment(this.quickConversationFragment);
            ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        InstructionUtil.showInfo((Context)this, R.string.info_message_sync, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
        this.mActionBar.setTitle(R.string.conversations);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.googleApiClient = new GoogleApiClient.Builder(this.getApplicationContext()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.onNewIntent(this.getIntent());
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        if (!takeOrder.booleanValue()) {
            new MobiComConversationService(this.getApplicationContext()).processLastSeenAtStatus();
        }
        if (ApplozicClient.getInstance((Context)this).isAccountClosed() || ApplozicClient.getInstance((Context)this).isNotAllowed()) {
            this.snackbar = Snackbar.make((View)this.layout, (int)(ApplozicClient.getInstance((Context)this).isAccountClosed() ? R.string.applozic_account_closed : R.string.applozic_free_version_not_allowed_on_release_build), (int)-2);
            this.snackbar.show();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
            Log.i((String)"AL", (String)"user is not logged in yet.");
            return;
        }
        try {
            if (intent.getExtras() != null) {
                BroadcastService.setContextBasedChat((boolean)intent.getExtras().getBoolean("contextBasedChat"));
            }
            this.conversationUIService.checkForStartNewConversation(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showActionBar() {
        this.mActionBar.setDisplayShowTitleEnabled(true);
    }

    @SuppressLint(value={"NewApi"})
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.showActionBar();
        this.getMenuInflater().inflate(R.menu.mobicom_basic_menu_for_normal_message, menu2);
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        if (Utils.hasICS()) {
            searchItem.collapseActionView();
        }
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconified(true);
        return super.onCreateOptionsMenu(menu2);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.conversationUIService.onActivityResult(requestCode, resultCode, data);
        this.handleOnActivityResult(requestCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void handleOnActivityResult(int requestCode, Intent intent) {
        switch (requestCode) {
            case 101: {
                Uri selectedFileUri = intent == null ? null : intent.getData();
                this.beginCrop(selectedFileUri);
                break;
            }
            case 11: {
                this.beginCrop(this.imageUri);
                break;
            }
            case 6709: {
                try {
                    Uri imageUri = Crop.getOutput((Intent)intent);
                    if (imageUri == null || this.profilefragment == null) break;
                    this.profilefragment.handleProfileimageUpload(imageUri);
                    break;
                }
                catch (Exception e) {
                    Log.i((String)"ConversationActivity", (String)"exception in profile image");
                }
            }
        }
    }

    private void beginCrop(Uri source) {
        Uri destination = Uri.fromFile((File)new File(this.getCacheDir(), "profile.jpeg"));
        Crop.of((Uri)source, (Uri)destination).asSquare().start((Activity)this);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                if (this.isAttachment) {
                    this.isAttachment = false;
                    this.processAttachment();
                }
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 1) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.location_permission_granted);
                this.processingLocation();
            } else {
                this.showSnackBar(R.string.location_permission_not_granted);
            }
        } else if (requestCode == 2) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_state_permission_granted);
            } else {
                this.showSnackBar(R.string.phone_state_permission_not_granted);
            }
        } else if (requestCode == 4) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_call_permission_granted);
                this.processCall(this.contact, this.currentConversationId);
            } else {
                this.showSnackBar(R.string.phone_call_permission_not_granted);
            }
        } else if (requestCode == 3) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.record_audio_permission_granted);
                this.showAudioRecordingDialog();
            } else {
                this.showSnackBar(R.string.record_audio_permission_not_granted);
            }
        } else if (requestCode == 5) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_camera_permission_granted);
                if (this.isTakePhoto) {
                    this.processCameraAction();
                } else {
                    this.processVideoRecording();
                }
            } else {
                this.showSnackBar(R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 6) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.contact_permission_granted);
                this.processContact();
            } else {
                this.showSnackBar(R.string.contact_permission_not_granted);
            }
        } else if (requestCode == 7) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_camera_permission_granted);
                this.processImageCaptureForProfilePhoto();
            } else {
                this.showSnackBar(R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 8) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                this.processGalleryPhotoSelection();
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void processingLocation() {
        if (this.alCustomizationSettings.isLocationShareViaMap() && !TextUtils.isEmpty((CharSequence)this.geoApiKey) && !API_KYE_STRING.equals(this.geoApiKey)) {
            Intent toMapActivity = new Intent((Context)this, MobicomLocationActivity.class);
            this.startActivityForResult(toMapActivity, 10);
            Log.i((String)"test", (String)"Activity for result strarted");
        } else if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    ConversationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)ConversationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    public void processLocation() {
        if (Utils.hasMarshmallow()) {
            new ApplozicPermissions((Activity)this, this.layout).checkRuntimePermissionForLocation();
        } else {
            this.processingLocation();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.start_new) {
            this.conversationUIService.startContactActivityForResult();
        } else if (id2 == R.id.conversations) {
            Intent intent = new Intent((Context)this, ChannelCreateActivity.class);
            intent.putExtra(ChannelCreateActivity.GROUP_TYPE, Channel.GroupType.PUBLIC.getValue().intValue());
            this.startActivity(intent);
        } else if (id2 == R.id.broadcast) {
            Intent intent = new Intent((Context)this, ContactSelectionActivity.class);
            intent.putExtra("GROUP_TYPE", Channel.GroupType.BROADCAST.getValue().intValue());
            this.startActivity(intent);
        } else if (id2 == R.id.refresh) {
            String message = this.getString(R.string.info_message_sync);
            this.mobiComMessageService.syncMessagesWithServer(message);
        } else {
            if (id2 == R.id.shareOptions) {
                Intent intent = new Intent("android.intent.action.SEND");
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share Via"));
                return super.onOptionsItemSelected(item);
            }
            if (id2 == R.id.applozicUserProfile) {
                ConversationActivity.addFragment((FragmentActivity)this, this.profilefragment, "ProfileFragment");
            }
        }
        return false;
    }

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact, Channel channel, Integer conversationId, String searchString) {
        this.conversation = new ConversationFragment(contact, channel, conversationId, searchString);
        ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        this.channel = channel;
        this.contact = contact;
        this.currentConversationId = conversationId;
    }

    @Override
    public void startContactActivityForResult() {
        this.conversationUIService.startContactActivityForResult();
    }

    @Override
    public void addFragment(ConversationFragment conversationFragment) {
        ConversationActivity.addFragment((FragmentActivity)this, conversationFragment, "ConversationFragment");
        this.conversation = conversationFragment;
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            try {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.finish();
            return;
        }
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        ConversationFragment conversationFragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag("ConversationFragment");
        if (conversationFragment != null && conversationFragment.isVisible() && conversationFragment.multimediaPopupGrid.getVisibility() == 0) {
            conversationFragment.hideMultimediaOptionGrid();
            return;
        }
        if (takeOrder.booleanValue()) {
            Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
            if (upIntent != null && this.isTaskRoot()) {
                TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
            }
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        this.conversationUIService.updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        this.conversationUIService.removeConversation(message, formattedContactNumber);
    }

    public void onConnected(Bundle bundle) {
        try {
            Location mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
            if (mCurrentLocation == null) {
                Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
                this.locationRequest = new LocationRequest();
                this.locationRequest.setPriority(100);
                this.locationRequest.setInterval(500L);
                this.locationRequest.setFastestInterval(1L);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
            }
            if (mCurrentLocation != null && this.conversation != null) {
                this.conversation.attachLocation(mCurrentLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)this.getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onLocationChanged(Location location) {
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            if (this.conversation != null && location != null) {
                this.conversation.attachLocation(location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult((Activity)this, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
        }
    }

    public void setChildFragmentLayoutBG() {
        this.childFragmentLayout.setBackgroundResource(R.color.conversation_list_all_background);
    }

    public void setChildFragmentLayoutBGToTransparent() {
        this.childFragmentLayout.setBackgroundResource(17170445);
    }

    void showErrorDialog(int code) {
        GooglePlayServicesUtil.getErrorDialog((int)code, (Activity)this, (int)9000).show();
    }

    public Contact getContact() {
        return this.contact;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Integer getConversationId() {
        return this.currentConversationId;
    }

    public static Uri getCapturedImageUri() {
        return capturedImageUri;
    }

    public static void setCapturedImageUri(Uri capturedImageUri) {
        ConversationActivity.capturedImageUri = capturedImageUri;
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    public Uri getVideoFileUri() {
        return this.videoFileUri;
    }

    public void setVideoFileUri(Uri videoFileUri) {
        this.videoFileUri = videoFileUri;
    }

    public void isTakePhoto(boolean takePhoto) {
        this.isTakePhoto = takePhoto;
    }

    public void isAttachment(boolean attachment) {
        this.isAttachment = attachment;
    }

    public void showAudioRecordingDialog() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfPermissionForAudioRecording((Activity)this)) {
            new ApplozicPermissions((Activity)this, this.layout).requestAudio();
        } else if (PermissionsUtils.isAudioRecordingPermissionGranted((Context)this)) {
            FragmentManager supportFragmentManager = this.getSupportFragmentManager();
            AudioMessageFragment fragment = AudioMessageFragment.newInstance();
            FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction().add((Fragment)fragment, "dialog");
            fragmentTransaction.addToBackStack(null);
            fragmentTransaction.commitAllowingStateLoss();
        } else if (this.alCustomizationSettings.getAudioPermissionNotFoundMsg() == null) {
            this.showSnackBar(R.string.applozic_audio_permission_missing);
        } else {
            this.snackbar = Snackbar.make((View)this.layout, (CharSequence)this.alCustomizationSettings.getAudioPermissionNotFoundMsg(), (int)-1);
            this.snackbar.show();
        }
    }

    public void processCall(Contact contactObj, Integer conversationId) {
        this.contact = this.baseContactService.getContactById(contactObj.getContactIds());
        this.currentConversationId = conversationId;
        try {
            if (this.activityToOpenOnClickOfCallButton != null) {
                Intent callIntent = new Intent((Context)this, Class.forName(this.activityToOpenOnClickOfCallButton));
                if (this.currentConversationId != null) {
                    Conversation conversation = ConversationService.getInstance((Context)this).getConversationByConversationId(this.currentConversationId);
                    callIntent.putExtra("TOPIC_ID", conversation.getTopicId());
                }
                callIntent.putExtra("CONTACT", (Serializable)this.contact);
                this.startActivity(callIntent);
            } else if (this.alCustomizationSettings.isShowActionDialWithOutCalling()) {
                if (!TextUtils.isEmpty((CharSequence)this.contact.getContactNumber())) {
                    String uri = "tel:" + this.contact.getContactNumber().trim();
                    Intent callIntent = new Intent("android.intent.action.DIAL");
                    callIntent.setData(Uri.parse((String)uri));
                    this.startActivity(callIntent);
                }
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCallPermission((Activity)this)) {
                this.applozicPermission.requestCallPermission();
            } else if (PermissionsUtils.isCallPermissionGranted((Context)this)) {
                if (!TextUtils.isEmpty((CharSequence)this.contact.getContactNumber())) {
                    String uri = "tel:" + this.contact.getContactNumber().trim();
                    Intent callIntent = new Intent("android.intent.action.CALL");
                    callIntent.setData(Uri.parse((String)uri));
                    this.startActivity(callIntent);
                }
            } else {
                this.snackbar = Snackbar.make((View)this.layout, (int)R.string.phone_call_permission_not_granted, (int)-1);
                this.snackbar.show();
            }
        }
        catch (Exception e) {
            Log.i((String)"ConversationActivity", (String)"Call permission is not added in androidManifest");
        }
    }

    public void processCameraAction() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this)) {
                this.imageCapture();
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermission.requestCameraPermission();
            } else {
                this.imageCapture();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processVideoRecording() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this)) {
                this.showVideoCapture();
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermission.requestCameraPermission();
            } else {
                this.showVideoCapture();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processContact() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForContactPermission((Activity)this)) {
            this.applozicPermission.requestContactPermission();
        } else {
            Intent contactIntent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
            contactIntent.setType("vnd.android.cursor.dir/contact");
            this.startActivityForResult(contactIntent, 15);
        }
    }

    public void imageCapture() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getApplicationContext().getPackageManager()) != null) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_" + ".jpeg";
            File photoFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
            if (photoFile != null) {
                capturedImageUri = Uri.fromFile((File)photoFile);
                cameraIntent.putExtra("output", (Parcelable)capturedImageUri);
                this.startActivityForResult(cameraIntent, 11);
            }
        }
    }

    public void processAttachment() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermission.requestStoragePermissions();
        } else {
            Intent intentPick = new Intent((Context)this, MobiComAttachmentSelectorActivity.class);
            this.startActivityForResult(intentPick, 16);
        }
    }

    public void showVideoCapture() {
        Intent videoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "VID_" + timeStamp + "_" + ".mp4";
        File fileUri = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"video/mp4");
        videoIntent.putExtra("output", (Parcelable)Uri.fromFile((File)fileUri));
        videoIntent.putExtra("android.intent.extra.videoQuality", 0);
        this.videoFileUri = Uri.fromFile((File)fileUri);
        this.startActivityForResult(videoIntent, 14);
    }

    @Override
    public Uri getCurrentImageUri() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_" + ".jpeg";
        File photoFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
        this.imageUri = Uri.fromFile((File)photoFile);
        return this.imageUri;
    }

    public void imageCaptureForProfilePhoto() {
        if (!(this instanceof MobicomkitUriListener)) {
            Log.d((String)"ConversationActvity", (String)"Activity must implement MobicomkitUriListener to get image file uri");
            return;
        }
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri capturedImageUri = this.getCurrentImageUri();
            cameraIntent.putExtra("output", (Parcelable)capturedImageUri);
            this.startActivityForResult(cameraIntent, 11);
        }
    }

    public void processImageCaptureForProfilePhoto() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this)) {
                this.imageCaptureForProfilePhoto();
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermission.requestCameraPermissionForProfilePhoto();
            } else {
                this.imageCaptureForProfilePhoto();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processGalleryPhotoSelection() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermission.requestStoragePermissionsForProfilePhoto();
        } else {
            Intent getContentIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            this.startActivityForResult(getContentIntent, 101);
        }
    }

    public boolean onQueryTextSubmit(String query) {
        this.searchTerm = query;
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.searchTerm = query;
        if (this.getSearchListFragment() != null) {
            this.getSearchListFragment().onQueryTextChange(query);
        }
        return true;
    }

    public SearchListFragment getSearchListFragment() {
        return this.searchListFragment;
    }

    public void setSearchListFragment(SearchListFragment searchListFragment) {
        this.searchListFragment = searchListFragment;
    }
}

