/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.fragment;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;

public class UserProfileFragment
extends Fragment {
    Contact contact;
    CardView name_cardView;
    CardView email_cardView;
    CardView status_cardView;
    CardView phone_cardView;
    TextView name;
    TextView email;
    TextView phone;
    TextView status;
    ImageLoader contactImageLoader;
    TextView alphabeticTextView;
    CircleImageView contactImage;
    AppContactService baseContactService;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.baseContactService = new AppContactService((Context)this.getActivity());
        final Context context = this.getActivity().getApplicationContext();
        this.contactImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return UserProfileFragment.this.baseContactService.downloadContactImage(context, (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.contactImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.user_profile_fragment_layout, container, false);
        this.name_cardView = (CardView)view.findViewById(R.id.applzoic_name_cardView);
        this.email_cardView = (CardView)view.findViewById(R.id.applzoic_email_cardview);
        this.status_cardView = (CardView)view.findViewById(R.id.applzoic_last_sean_status_cardView);
        this.phone_cardView = (CardView)view.findViewById(R.id.applozic_user_phone_cardview);
        this.name = (TextView)view.findViewById(R.id.userName);
        this.status = (TextView)view.findViewById(R.id.applozic_user_status);
        this.email = (TextView)view.findViewById(R.id.email);
        this.phone = (TextView)view.findViewById(R.id.phone);
        this.contactImage = (CircleImageView)view.findViewById(R.id.contactImage);
        this.alphabeticTextView = (TextView)view.findViewById(R.id.alphabeticImage);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.contact = (Contact)bundle.getSerializable("CONTACT");
            this.contact = this.baseContactService.getContactById(this.contact.getContactIds());
            ((AppCompatActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)this.contact.getDisplayName());
            ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)"");
            this.name.setText((CharSequence)this.contact.getDisplayName());
            char firstLetter = this.contact.getDisplayName().toUpperCase().charAt(0);
            String contactNumber = this.contact.getDisplayName().toUpperCase();
            if (firstLetter != '+') {
                this.alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
            } else if (contactNumber.length() >= 2) {
                this.alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
            }
            Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
            GradientDrawable bgShape = (GradientDrawable)this.alphabeticTextView.getBackground();
            bgShape.setColor(this.getActivity().getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            if (this.contact.isDrawableResources()) {
                int drawableResourceId = this.getResources().getIdentifier(this.contact.getrDrawableName(), "drawable", this.getActivity().getPackageName());
                this.contactImage.setImageResource(drawableResourceId);
            } else {
                this.contactImageLoader.loadImage((Object)this.contact, (ImageView)this.contactImage, this.alphabeticTextView);
            }
            this.name.setText((CharSequence)this.contact.getDisplayName());
            if (!TextUtils.isEmpty((CharSequence)this.contact.getEmailId())) {
                this.email_cardView.setVisibility(0);
                this.email.setText((CharSequence)this.contact.getEmailId());
            }
            if (!TextUtils.isEmpty((CharSequence)this.contact.getStatus())) {
                this.status_cardView.setVisibility(0);
                this.status.setText((CharSequence)this.contact.getStatus());
            }
            if (!TextUtils.isEmpty((CharSequence)this.contact.getContactNumber())) {
                this.phone_cardView.setVisibility(0);
                this.phone.setText((CharSequence)this.contact.getContactNumber());
            } else {
                this.phone_cardView.setVisibility(8);
            }
        }
        return view;
    }
}

