/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.soundcloud.android.crop.Crop;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;

public class ChannelCreateActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    private static final int REQUEST_CODE_ATTACH_PHOTO = 901;
    private static final String TAG = "ChannelCreateActivity";
    public static String GROUP_TYPE = "GroupType";
    private EditText channelName;
    private CircleImageView circleImageView;
    private View focus;
    private ActionBar mActionBar;
    public static Activity channelActivity;
    private ImageView uploadImageButton;
    private Uri imageChangeUri;
    private String groupIconImageLink;
    private Integer groupType;
    private LinearLayout layout;
    private Snackbar snackbar;
    private ApplozicPermissions applozicPermissions;
    private FinishActivityReceiver finishActivityReceiver;
    public static final String ACTION_FINISH_CHANNEL_CREATE = "channelCreateActivity.ACTION_FINISH";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.channel_create_activty_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setTitle(R.string.channel_create_title);
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.finishActivityReceiver = new FinishActivityReceiver();
        this.registerReceiver(this.finishActivityReceiver, new IntentFilter(ACTION_FINISH_CHANNEL_CREATE));
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermissions = new ApplozicPermissions((Activity)this, this.layout);
        this.channelName = (EditText)this.findViewById(R.id.channelName);
        this.circleImageView = (CircleImageView)this.findViewById(R.id.channelIcon);
        this.uploadImageButton = (ImageView)this.findViewById(R.id.applozic_channel_profile_camera);
        this.uploadImageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelCreateActivity.this.processImagePicker();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.group_create_menu, menu2);
        menu2.removeItem(R.id.Done);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.Next) {
            boolean check = true;
            if (this.channelName.getText().toString().trim().length() == 0 || TextUtils.isEmpty((CharSequence)this.channelName.getText().toString())) {
                this.focus = this.channelName;
                this.focus.requestFocus();
                check = false;
            }
            if (check) {
                Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
                Intent intent = new Intent((Context)this, ContactSelectionActivity.class);
                intent.putExtra("CHANNEL_NAME", this.channelName.getText().toString());
                if (!TextUtils.isEmpty((CharSequence)this.groupIconImageLink)) {
                    intent.putExtra("IMAGE_LINK", this.groupIconImageLink);
                }
                this.startActivity(intent);
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void beginCrop(Uri source) {
        Uri destination = Uri.fromFile((File)new File(this.getCacheDir(), "new_group_profile.jpeg"));
        Crop.of((Uri)source, (Uri)destination).asSquare().start((Activity)this);
    }

    public void processImagePicker() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermissions.requestStoragePermissions();
        } else {
            Intent getContentIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            this.startActivityForResult(getContentIntent, 901);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        Uri selectedFileUri = null;
        if (requestCode == 901 && resultCode == -1) {
            selectedFileUri = intent == null ? null : intent.getData();
            Log.i((String)TAG, (String)("selectedFileUri :: " + selectedFileUri));
            this.beginCrop(selectedFileUri);
        }
        if (requestCode == 6709 && resultCode == -1) {
            try {
                this.imageChangeUri = Crop.getOutput((Intent)intent);
                this.circleImageView.setImageDrawable(null);
                this.circleImageView.setImageURI(this.imageChangeUri);
                new ProfilePictureUpload(this.imageChangeUri, (Context)this).execute(null);
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)"exception in profile image");
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                this.processImagePicker();
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.finishActivityReceiver);
    }

    private final class FinishActivityReceiver
    extends BroadcastReceiver {
        private FinishActivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && intent.getAction().equals(ChannelCreateActivity.ACTION_FINISH_CHANNEL_CREATE)) {
                ChannelCreateActivity.this.finish();
            }
        }
    }

    class ProfilePictureUpload
    extends AsyncTask<Void, Void, Boolean> {
        Context context;
        Uri fileUri;
        String displayName;
        private ProgressDialog progressDialog;

        public ProfilePictureUpload(Uri fileUri, Context context) {
            this.context = context;
            this.fileUri = fileUri;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Boolean doInBackground(Void ... params) {
            FileClientService fileClientService = new FileClientService(this.context);
            try {
                if (this.fileUri != null) {
                    String filePath = FilePathFinder.getPath((Context)this.context, (Uri)this.fileUri);
                    ChannelCreateActivity.this.groupIconImageLink = fileClientService.uploadProfileImage(filePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.i((String)ChannelCreateActivity.class.getName(), (String)"Exception");
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            this.progressDialog.dismiss();
        }
    }
}

