/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NavUtils;
import android.support.v4.view.MenuItemCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.people.channel.ChannelFragment;
import com.applozic.mobicomkit.uiwidgets.people.contact.AppContactFragment;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.contact.ContactUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MobiComKitPeopleActivity
extends AppCompatActivity
implements OnContactsInteractionListener,
SearchView.OnQueryTextListener {
    public static final String SHARED_TEXT = "SHARED_TEXT";
    public static final String FORWARD_MESSAGE = "forwardMessage";
    private static final String CONTACT_ID = "contactId";
    private static final String GROUP_ID = "groupId";
    private static final String GROUP_NAME = "groupName";
    private static final String USER_ID = "userId";
    public static final String USER_ID_ARRAY = "userIdArray";
    protected SearchView searchView;
    protected String searchTerm;
    private SearchListFragment searchListFragment;
    private boolean isSearchResultView = false;
    ApplozicSetting applozicSetting;
    ViewPager viewPager;
    TabLayout tabLayout;
    ActionBar actionBar;
    String[] userIdArray;
    public static boolean isSearching = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.people_activity);
        this.applozicSetting = ApplozicSetting.getInstance(this.getBaseContext());
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        this.actionBar = this.getSupportActionBar();
        this.actionBar.setHomeButtonEnabled(true);
        this.actionBar.setDisplayHomeAsUpEnabled(true);
        this.actionBar.setDisplayShowTitleEnabled(true);
        if (this.getIntent().getExtras() != null) {
            this.userIdArray = this.getIntent().getStringArrayExtra(USER_ID_ARRAY);
        }
        if (this.applozicSetting.isStartNewGroupButtonVisible()) {
            this.actionBar.setTitle((CharSequence)this.getString(R.string.search_title));
            this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
            this.viewPager.setVisibility(0);
            this.setupViewPager(this.viewPager);
            this.tabLayout = (TabLayout)this.findViewById(R.id.tab_layout);
            this.tabLayout.setVisibility(0);
            this.tabLayout.setupWithViewPager(this.viewPager);
        } else {
            this.actionBar.setTitle((CharSequence)this.getString(R.string.search_title));
            MobiComKitPeopleActivity.addFragment((FragmentActivity)this, (Fragment)new AppContactFragment(this.userIdArray), "AppContactFragment");
        }
        this.isSearchResultView = true;
        Intent intent = this.getIntent();
        String searchQuery = intent.getStringExtra("query");
        String title = this.getString(R.string.contacts_list_search_results_title, new Object[]{searchQuery});
        this.setTitle(title);
    }

    @TargetApi(value=11)
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_contact, menu2);
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        if (Utils.hasICS()) {
            searchItem.collapseActionView();
        }
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconified(true);
        return super.onCreateOptionsMenu(menu2);
    }

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    public void onContactSelected(Uri contactUri) {
        Long contactId = ContactUtils.getContactId((ContentResolver)this.getContentResolver(), (Uri)contactUri);
        Map phoneNumbers = ContactUtils.getPhoneNumbers((Context)this.getApplicationContext(), (long)contactId);
        if (phoneNumbers.isEmpty()) {
            Toast toast = Toast.makeText((Context)this.getApplicationContext(), (int)R.string.phone_number_not_present, (int)0);
            toast.setGravity(17, 0, 0);
            toast.show();
            return;
        }
        Intent intent = new Intent();
        intent.putExtra(CONTACT_ID, (Serializable)contactId);
        intent.setData(contactUri);
        this.finishActivity(intent);
    }

    public void startNewConversation(String contactNumber) {
        Intent intent = new Intent();
        intent.putExtra(USER_ID, contactNumber);
        this.finishActivity(intent);
    }

    public void onGroupSelected(Channel channel) {
        Intent intent = new Intent();
        intent.putExtra(GROUP_ID, (Serializable)channel.getKey());
        intent.putExtra(GROUP_NAME, channel.getName());
        this.finishActivity(intent);
    }

    public void onCustomContactSelected(Contact contact) {
        Intent intent = new Intent();
        intent.putExtra(USER_ID, contact.getUserId());
        this.finishActivity(intent);
    }

    public void finishActivity(Intent intent) {
        String sharedText;
        String forwardMessage = this.getIntent().getStringExtra(FORWARD_MESSAGE);
        if (!TextUtils.isEmpty((CharSequence)forwardMessage)) {
            intent.putExtra(FORWARD_MESSAGE, forwardMessage);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = this.getIntent().getStringExtra(SHARED_TEXT)))) {
            intent.putExtra(SHARED_TEXT, sharedText);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    public void onSelectionCleared() {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == 16908332) {
            NavUtils.navigateUpFromSameTask((Activity)this);
            return true;
        }
        if (i == R.id.menu_search) {
            this.onSearchRequested();
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onSearchRequested() {
        return !this.isSearchResultView && super.onSearchRequested();
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public boolean onQueryTextSubmit(String query) {
        if (this.applozicSetting.isCreateAnyContact()) {
            this.searchTerm = query;
            this.startNewConversation(query);
            isSearching = false;
        }
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.searchTerm = query;
        if (this.getSearchListFragment() != null) {
            this.getSearchListFragment().onQueryTextChange(query);
            isSearching = true;
            if (query.isEmpty()) {
                isSearching = false;
            }
        }
        return true;
    }

    public SearchListFragment getSearchListFragment() {
        return this.searchListFragment;
    }

    public void setSearchListFragment(SearchListFragment searchListFragment) {
        this.searchListFragment = searchListFragment;
    }

    private void setupViewPager(ViewPager viewPager) {
        ViewPagerAdapter adapter = new ViewPagerAdapter(this.getSupportFragmentManager());
        adapter.addFrag((Fragment)new AppContactFragment(this.userIdArray), "Contact");
        adapter.addFrag((Fragment)new ChannelFragment(), "Group");
        viewPager.setAdapter((PagerAdapter)adapter);
    }

    class ViewPagerAdapter
    extends FragmentPagerAdapter {
        private final List<Fragment> fragmentList;
        private final List<String> titleList;

        public ViewPagerAdapter(FragmentManager manager) {
            super(manager);
            this.fragmentList = new ArrayList<Fragment>();
            this.titleList = new ArrayList<String>();
        }

        public Fragment getItem(int position) {
            return this.fragmentList.get(position);
        }

        public int getCount() {
            return this.fragmentList.size();
        }

        public void addFrag(Fragment fragment, String title) {
            this.fragmentList.add(fragment);
            this.titleList.add(title);
        }

        public CharSequence getPageTitle(int position) {
            return this.titleList.get(position);
        }
    }
}

