/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.async;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.people.ChannelCreate;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.people.channel.Channel;
import java.util.List;

public class ApplozicChannelCreateTask
extends AsyncTask<Void, Void, Boolean> {
    Context context;
    String groupName;
    List<String> groupMemberList;
    ChannelService channelService;
    Channel channel;
    ChannelCreate channelCreate;
    Exception exception;
    ChannelCreateListener channelCreateListener;

    public ApplozicChannelCreateTask(Context context, ChannelCreateListener channelCreateListener, String groupName, List<String> groupMemberList) {
        this.context = context;
        this.groupName = groupName;
        this.groupMemberList = groupMemberList;
        this.channelCreateListener = channelCreateListener;
        this.channelService = ChannelService.getInstance((Context)context);
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.groupName) && this.groupName.trim().length() != 0 && this.groupMemberList != null && this.groupMemberList.size() > 0) {
                this.channelCreate = new ChannelCreate(this.groupName.trim(), this.groupMemberList);
                this.channel = this.channelService.createChannel(this.channelCreate);
                return true;
            }
            throw new Exception(this.context.getString(R.string.applozic_channel_error_info_in_logs));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
            return false;
        }
    }

    protected void onPostExecute(Boolean resultBoolean) {
        super.onPostExecute((Object)resultBoolean);
        if (resultBoolean.booleanValue() && this.channel != null && this.channelCreateListener != null) {
            this.channelCreateListener.onSuccess(this.channel, this.context);
        } else if (this.exception != null && !resultBoolean.booleanValue() && this.channelCreateListener != null) {
            this.channelCreateListener.onFailure(this.exception, this.context);
        }
    }

    public static interface ChannelCreateListener {
        public void onSuccess(Channel var1, Context var2);

        public void onFailure(Exception var1, Context var2);
    }
}

