/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ChannelName;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelNameActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.Serializable;
import java.util.List;

public class ChannelInfoActivity
extends AppCompatActivity {
    private static final String TAG = "ChannelInfoActivity";
    private ActionBar mActionBar;
    private ImageLoader contactImageLoader;
    public static final String CHANNEL_KEY = "CHANNEL_KEY";
    private BaseContactService contactService;
    private List<ChannelUserMapper> channelUserMapperList;
    private Channel channel;
    private static final String SUCCESS = "success";
    private ImageView channelImage;
    public static final String USERID = "USERID";
    private TextView createdBy;
    protected ListView mainListView;
    CollapsingToolbarLayout collapsingToolbarLayout;
    public static final String CHANNEL_NAME = "CHANNEL_NAME";
    protected ContactsAdapter contactsAdapter;
    private Button exitChannelButton;
    private Button deleteChannelButton;
    private RelativeLayout channelDeleteRelativeLayout;
    private RelativeLayout channelExitRelativeLayout;
    private Integer channelKey;
    public static final int REQUEST_CODE_FOR_CONTACT = 1;
    public static final int REQUEST_CODE_FOR_CHANNEL_NEW_NAME = 2;
    boolean isUserPresent;
    Contact contact;
    BaseContactService baseContactService;
    MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.channel_info_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.baseContactService = new AppContactService((Context)this);
        this.channelImage = (ImageView)this.findViewById(R.id.channelImage);
        this.createdBy = (TextView)this.findViewById(R.id.created_by);
        this.exitChannelButton = (Button)this.findViewById(R.id.exit_channel);
        this.deleteChannelButton = (Button)this.findViewById(R.id.delete_channel_button);
        this.channelDeleteRelativeLayout = (RelativeLayout)this.findViewById(R.id.channel_delete_relativeLayout);
        this.channelExitRelativeLayout = (RelativeLayout)this.findViewById(R.id.channel_exit_relativeLayout);
        this.collapsingToolbarLayout = (CollapsingToolbarLayout)this.findViewById(R.id.toolbar_layout);
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mainListView = (ListView)this.findViewById(R.id.mainList);
        this.mainListView.setLongClickable(true);
        this.mainListView.setSmoothScrollbarEnabled(true);
        if (Utils.hasLollipop()) {
            this.mainListView.setNestedScrollingEnabled(true);
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        this.registerForContextMenu((View)this.mainListView);
        if (ApplozicSetting.getInstance((Context)this).isHideGroupExitMemberButton()) {
            this.channelExitRelativeLayout.setVisibility(8);
        }
        if (this.getIntent().getExtras() != null) {
            this.channelKey = this.getIntent().getIntExtra(CHANNEL_KEY, 0);
            this.channel = ChannelService.getInstance((Context)this).getChannelByChannelKey(this.channelKey);
            this.isUserPresent = ChannelService.getInstance((Context)this).processIsUserPresentInChannel(this.channelKey);
            if (this.channel != null) {
                String title = ChannelUtils.getChannelTitleName((Channel)this.channel, (String)MobiComUserPreference.getInstance((Context)this.getApplicationContext()).getUserId());
                this.contact = new AppContactService((Context)this).getContactById(this.channel.getAdminKey());
                this.mActionBar.setTitle((CharSequence)title);
                if (MobiComUserPreference.getInstance((Context)this).getUserId().equals(this.contact.getUserId())) {
                    this.createdBy.setText((CharSequence)(this.getString(R.string.channel_created_by) + " " + this.getString(R.string.you_string)));
                } else {
                    this.createdBy.setText((CharSequence)(this.getString(R.string.channel_created_by) + " " + this.contact.getDisplayName()));
                }
                if (!this.isUserPresent) {
                    this.channelExitRelativeLayout.setVisibility(8);
                    this.channelDeleteRelativeLayout.setVisibility(0);
                }
            }
        }
        this.contactService = new AppContactService((Context)this);
        this.contactImageLoader = new ImageLoader((Context)this, this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ChannelInfoActivity.this.contactService.downloadContactImage(ChannelInfoActivity.this.getApplicationContext(), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.contactImageLoader.addImageCache(this.getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.channelUserMapperList = ChannelService.getInstance((Context)this).getListOfUsersFromChannelUserMapper(this.channel.getKey());
        this.contactsAdapter = new ContactsAdapter((Context)this);
        this.mainListView.setAdapter((ListAdapter)this.contactsAdapter);
        this.mainListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    ChannelInfoActivity.this.contactImageLoader.setPauseWork(true);
                } else {
                    ChannelInfoActivity.this.contactImageLoader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
        this.exitChannelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelInfoActivity.this.leaveChannel(ChannelInfoActivity.this.channel);
            }
        });
        this.deleteChannelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelService.getInstance((Context)ChannelInfoActivity.this).processChannelDeleteConversation(ChannelInfoActivity.this.channel.getKey(), (Context)ChannelInfoActivity.this);
                if (ConversationActivity.conversationActivity != null) {
                    ConversationActivity.conversationActivity.finish();
                }
                Intent intent = new Intent((Context)ChannelInfoActivity.this, ConversationActivity.class);
                if (ApplozicClient.getInstance((Context)ChannelInfoActivity.this).isContextBasedChat()) {
                    intent.putExtra("contextBasedChat", true);
                }
                ChannelInfoActivity.this.startActivity(intent);
                ChannelInfoActivity.this.finish();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        BroadcastService.currentInfoId = null;
        this.contactImageLoader.setPauseWork(false);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        if (this.channel != null) {
            BroadcastService.currentInfoId = String.valueOf(this.channel.getKey());
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null) {
            if (requestCode == 1 && resultCode == -1) {
                boolean isUserAlreadyPresent = ChannelService.getInstance((Context)this).isUserAlreadyPresentInChannel(this.channel.getKey(), data.getExtras().getString(USERID));
                if (!isUserAlreadyPresent) {
                    this.addChannelUser(data.getExtras().getString(USERID), this.channel);
                } else {
                    Toast toast = Toast.makeText((Context)this, (CharSequence)this.getString(R.string.user_is_already_exists), (int)0);
                    toast.setGravity(17, 0, 0);
                    toast.show();
                }
            }
            if (requestCode == 2 && resultCode == -1) {
                ChannelName channelName = new ChannelName(data.getExtras().getString(CHANNEL_NAME), this.channel.getKey());
                new ChannelAsync(channelName, (Context)this).execute(new Void[0]);
            }
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position;
        if (this.channelUserMapperList.size() <= position) {
            return true;
        }
        if (this.channel == null) {
            return true;
        }
        ChannelUserMapper channelUserMapper = this.channelUserMapperList.get(position);
        if (MobiComUserPreference.getInstance((Context)this).getUserId().equals(channelUserMapper.getUserKey())) {
            return true;
        }
        switch (item.getItemId()) {
            case 0: {
                this.removeChannelUser(this.channel, channelUserMapper);
                break;
            }
            default: {
                return super.onContextItemSelected(item);
            }
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.channel_menu_option, menu2);
        ApplozicSetting setting = ApplozicSetting.getInstance((Context)this);
        if (setting.isHideGroupAddMemberButton() || !ChannelUtils.isAdminUserId((String)MobiComUserPreference.getInstance((Context)this).getUserId(), (Channel)this.channel)) {
            menu2.removeItem(R.id.add_member_to_channel);
        }
        if (setting.isHideGroupNameEditButton()) {
            menu2.removeItem(R.id.edit_channel_name);
        }
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
        int positionInList = info.position;
        if (positionInList < 0 || this.channelUserMapperList.isEmpty()) {
            return;
        }
        ChannelUserMapper channelUserMapper = this.channelUserMapperList.get(positionInList);
        if (ChannelUtils.isAdminUserId((String)MobiComUserPreference.getInstance((Context)this).getUserId(), (Channel)this.channel)) {
            this.isUserPresent = ChannelService.getInstance((Context)this).processIsUserPresentInChannel(this.channelKey);
            boolean isHideRemove = ApplozicSetting.getInstance((Context)this).isHideGroupRemoveMemberOption();
            if (!ChannelUtils.isAdminUserId((String)channelUserMapper.getUserKey(), (Channel)this.channel) && this.isUserPresent && !isHideRemove) {
                menu2.add(0, 0, 0, (CharSequence)"Remove");
            }
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        boolean isUserPresent = false;
        if (this.channel != null) {
            isUserPresent = ChannelService.getInstance((Context)this).processIsUserPresentInChannel(this.channel.getKey());
        }
        if (id2 == R.id.add_member_to_channel) {
            if (isUserPresent) {
                Intent addMemberIntent = new Intent((Context)this, ContactSelectionActivity.class);
                addMemberIntent.putExtra("CHECK_BOX", true);
                addMemberIntent.putExtra("CHANNEL", (Serializable)this.channel);
                this.startActivityForResult(addMemberIntent, 1);
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.channel_add_alert), (int)0).show();
            }
        } else if (id2 == R.id.edit_channel_name) {
            if (isUserPresent) {
                Intent editChannelNameIntent = new Intent((Context)this, ChannelNameActivity.class);
                editChannelNameIntent.putExtra(CHANNEL_NAME, this.channel.getName());
                this.startActivityForResult(editChannelNameIntent, 2);
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.channel_edit_alert), (int)0).show();
            }
        }
        return false;
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public void updateChannelList() {
        if (this.contactsAdapter != null && this.channel != null) {
            this.channelUserMapperList.clear();
            this.channelUserMapperList = ChannelService.getInstance((Context)this).getListOfUsersFromChannelUserMapper(this.channel.getKey());
            this.contactsAdapter.notifyDataSetChanged();
            String oldChannelName = this.channel.getName();
            this.channel = ChannelService.getInstance((Context)this).getChannelByChannelKey(this.channel.getKey());
            if (!oldChannelName.equals(this.channel.getName())) {
                this.mActionBar.setTitle((CharSequence)this.channel.getName());
                this.collapsingToolbarLayout.setTitle((CharSequence)this.channel.getName());
            }
        }
    }

    public void removeChannelUser(final Channel channel, final ChannelUserMapper channelUserMapper) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.remove_member, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelMember(channelUserMapper, channel, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        String channelName = "";
        if (!TextUtils.isEmpty((CharSequence)channelUserMapper.getUserKey())) {
            Contact contact = this.baseContactService.getContactById(channelUserMapper.getUserKey());
            name = contact.getDisplayName();
            channelName = channel.getName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.dialog_remove_group_user).replace(this.getString(R.string.user_name_info), name).replace(this.getString(R.string.group_name_info), channelName));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void addChannelUser(final String userId, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.add_member, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelMemberAdd(channel, userId, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        String channelName = "";
        if (channel != null) {
            Contact contact = this.baseContactService.getContactById(userId);
            name = contact.getDisplayName();
            channelName = channel.getName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.dialog_add_group_user).replace(this.getString(R.string.user_name_info), name).replace(this.getString(R.string.group_name_info), channelName));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void leaveChannel(final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.channel_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelAsync(channel, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setMessage((CharSequence)this.getString(R.string.leave_channel));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public class ChannelAsync
    extends AsyncTask<Void, Integer, Long> {
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;
        ChannelName channelName;
        String responseForExit;
        String responseForUpdateChannelName;

        public ChannelAsync(Channel channel, Context context) {
            this.channel = channel;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        public ChannelAsync(ChannelName channelName, Context context) {
            this.channelName = channelName;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.channelName != null) {
                this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.channel_update), (boolean)true);
            }
            if (this.channel != null) {
                this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.channel_member_exit), (boolean)true);
            }
        }

        protected Long doInBackground(Void ... params) {
            if (this.channelName != null) {
                this.responseForUpdateChannelName = this.channelService.updateNewChannelNameProcess(this.channelName);
            }
            if (this.channel != null) {
                this.responseForExit = this.channelService.leaveMemberFromChannelProcess(this.channel.getKey(), MobiComUserPreference.getInstance((Context)this.context).getUserId());
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            Toast toast;
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (this.channel != null && !Utils.isInternetAvailable((Context)this.context)) {
                toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.failed_to_leave_group), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.channelName != null && !Utils.isInternetAvailable((Context)this.context)) {
                toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.internet_connection_for_group_name_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForExit) && ChannelInfoActivity.SUCCESS.equals(this.responseForExit)) {
                ChannelInfoActivity.this.finish();
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForUpdateChannelName) && ChannelInfoActivity.SUCCESS.equals(this.responseForUpdateChannelName)) {
                ChannelInfoActivity.this.mActionBar.setTitle((CharSequence)this.channelName.getNewName());
                ChannelInfoActivity.this.collapsingToolbarLayout.setTitle((CharSequence)this.channelName.getNewName());
            }
        }
    }

    public class ChannelMemberAdd
    extends AsyncTask<Void, Integer, Long> {
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;
        String responseForAdd;
        String userId;

        public ChannelMemberAdd(Channel channel, String userId, Context context) {
            this.channel = channel;
            this.context = context;
            this.userId = userId;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.adding_channel_user), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.channel != null && !TextUtils.isEmpty((CharSequence)this.userId)) {
                this.responseForAdd = this.channelService.addMemberToChannelProcess(this.channel.getKey(), this.userId);
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.you_dont_have_any_network_access_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForAdd) && ChannelInfoActivity.SUCCESS.equals(this.responseForAdd)) {
                ChannelUserMapper channelUserMapper = new ChannelUserMapper(this.channel.getKey(), this.userId);
                ChannelInfoActivity.this.channelUserMapperList.add(channelUserMapper);
                ChannelInfoActivity.this.contactsAdapter.notifyDataSetChanged();
            }
        }
    }

    private class ContactViewHolder {
        public TextView displayName;
        public TextView alphabeticImage;
        public TextView adminTextView;
        public TextView lastSeenAtTextView;
        public CircleImageView circleImageView;

        public ContactViewHolder() {
        }

        public ContactViewHolder(TextView displayName, TextView alphabeticImage, TextView adminTextView, TextView lastSeenAtTextView, CircleImageView circleImageView) {
            this.displayName = displayName;
            this.alphabeticImage = alphabeticImage;
            this.adminTextView = adminTextView;
            this.lastSeenAtTextView = lastSeenAtTextView;
            this.circleImageView = circleImageView;
        }

        public TextView getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(TextView displayName) {
            this.displayName = displayName;
        }

        public TextView getAlphabeticImage() {
            return this.alphabeticImage;
        }

        public void setAlphabeticImage(TextView alphabeticImage) {
            this.alphabeticImage = alphabeticImage;
        }

        public TextView getAdminTextView() {
            return this.adminTextView;
        }

        public void setAdminTextView(TextView adminTextView) {
            this.adminTextView = adminTextView;
        }

        public CircleImageView getCircleImageView() {
            return this.circleImageView;
        }

        public void setCircleImageView(CircleImageView circleImageView) {
            this.circleImageView = circleImageView;
        }

        public TextView getLastSeenAtTextView() {
            return this.lastSeenAtTextView;
        }

        public void setLastSeenAtTextView(TextView lastSeenAtTextView) {
            this.lastSeenAtTextView = lastSeenAtTextView;
        }
    }

    public class ChannelMember
    extends AsyncTask<Void, Integer, Long> {
        private ChannelUserMapper channelUserMapper;
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;
        String responseForRemove;

        public ChannelMember(ChannelUserMapper channelUserMapper, Channel channel, Context context) {
            this.channelUserMapper = channelUserMapper;
            this.channel = channel;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.removing_channel_user), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.channel != null && this.channelUserMapper != null) {
                this.responseForRemove = this.channelService.removeMemberFromChannelProcess(this.channel.getKey(), this.channelUserMapper.getUserKey());
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.you_dont_have_any_network_access_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (ChannelInfoActivity.SUCCESS.equals(this.responseForRemove) && ChannelInfoActivity.this.contactsAdapter != null && ChannelInfoActivity.this.channelUserMapperList != null && ChannelInfoActivity.this.channelUserMapperList.size() > 0) {
                ChannelInfoActivity.this.channelUserMapperList.remove(this.channelUserMapper);
                ChannelInfoActivity.this.contactsAdapter.notifyDataSetChanged();
            }
        }
    }

    private class ContactsAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;
        Context context;

        public ContactsAdapter(Context context) {
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ContactViewHolder holder;
            ChannelUserMapper channelUserMapper = (ChannelUserMapper)ChannelInfoActivity.this.channelUserMapperList.get(position);
            Contact contact = ChannelInfoActivity.this.contactService.getContactById(channelUserMapper.getUserKey());
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.contact_users_layout, parent, false);
                holder = new ContactViewHolder();
                holder.displayName = (TextView)convertView.findViewById(R.id.displayName);
                holder.alphabeticImage = (TextView)convertView.findViewById(R.id.alphabeticImage);
                holder.circleImageView = (CircleImageView)convertView.findViewById(R.id.contactImage);
                holder.adminTextView = (TextView)convertView.findViewById(R.id.adminTextView);
                holder.lastSeenAtTextView = (TextView)convertView.findViewById(R.id.lastSeenAtTextView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ContactViewHolder)convertView.getTag();
            }
            if (MobiComUserPreference.getInstance((Context)this.context).getUserId().equals(contact.getUserId())) {
                holder.displayName.setText((CharSequence)ChannelInfoActivity.this.getString(R.string.you_string));
            } else {
                holder.displayName.setText((CharSequence)contact.getDisplayName());
            }
            if (ChannelUtils.isAdminUserId((String)contact.getUserId(), (Channel)ChannelInfoActivity.this.channel)) {
                holder.adminTextView.setVisibility(0);
            } else {
                holder.adminTextView.setVisibility(8);
            }
            if (contact.getLastSeenAt() != 0L) {
                if (!MobiComUserPreference.getInstance((Context)this.context).getUserId().equals(contact.getUserId())) {
                    holder.lastSeenAtTextView.setVisibility(0);
                    holder.lastSeenAtTextView.setText((CharSequence)(ChannelInfoActivity.this.getString(R.string.subtitle_last_seen_at_time) + " " + String.valueOf(DateUtils.getDateAndTimeForLastSeen((Long)contact.getLastSeenAt()))));
                } else {
                    holder.lastSeenAtTextView.setVisibility(8);
                    holder.lastSeenAtTextView.setText((CharSequence)"");
                }
            } else {
                holder.lastSeenAtTextView.setVisibility(8);
                holder.lastSeenAtTextView.setText((CharSequence)"");
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getDisplayName().toUpperCase();
                char firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.alphabeticImage.getBackground();
                bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            holder.alphabeticImage.setVisibility(8);
            holder.circleImageView.setVisibility(0);
            if (contact != null) {
                if (contact.isDrawableResources()) {
                    int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
                    holder.circleImageView.setImageResource(drawableResourceId);
                } else {
                    ChannelInfoActivity.this.contactImageLoader.loadImage((Object)contact, (ImageView)holder.circleImageView, holder.alphabeticImage);
                }
            }
            return convertView;
        }

        public int getCount() {
            return ChannelInfoActivity.this.channelUserMapperList.size();
        }

        public Object getItem(int position) {
            return ChannelInfoActivity.this.channelUserMapperList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }
    }
}

