/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.ContactService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.TopicDetail;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.UIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelInfoActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MessageInfoFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.LocationInfo;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ConversationUIService {
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 101;
    public static final String CONVERSATION_FRAGMENT = "ConversationFragment";
    public static final String MESSGAE_INFO_FRAGMENT = "messageInfoFagment";
    public static final String QUICK_CONVERSATION_FRAGMENT = "QuickConversationFragment";
    public static final String DISPLAY_NAME = "displayName";
    public static final String USER_ID = "userId";
    public static final String GROUP_ID = "groupId";
    public static final String GROUP_NAME = "groupName";
    public static final String FIRST_TIME_MTEXTER_FRIEND = "firstTimeMTexterFriend";
    public static final String CONTACT_ID = "contactId";
    public static final String CONTEXT_BASED_CHAT = "contextBasedChat";
    public static final String CONTACT_NUMBER = "contactNumber";
    public static final String APPLICATION_ID = "applicationId";
    public static final String DEFAULT_TEXT = "defaultText";
    public static final String FINAL_PRICE_TEXT = "Final agreed price ";
    public static final String PRODUCT_TOPIC_ID = "topicId";
    public static final String PRODUCT_IMAGE_URL = "productImageUrl";
    private static final String TAG = "ConversationUIService";
    private static final String APPLICATION_KEY_META_DATA = "com.applozic.application.key";
    public static final String GROUP = "group-";
    public static final String SUCCESS = "success";
    private FragmentActivity fragmentActivity;
    private BaseContactService baseContactService;
    private MobiComUserPreference userPreference;
    private ApplozicSetting applozicSetting;
    private Conversation conversation;
    private TopicDetail topicDetailsParcelable;
    public static final String TOPICDETAIL = "TOPICDETAIL";
    private Contact contact;

    public ConversationUIService(FragmentActivity fragmentActivity) {
        this.fragmentActivity = fragmentActivity;
        this.baseContactService = new AppContactService((Context)fragmentActivity);
        this.userPreference = MobiComUserPreference.getInstance((Context)fragmentActivity);
        this.applozicSetting = ApplozicSetting.getInstance((Context)fragmentActivity);
    }

    public MobiComQuickConversationFragment getQuickConversationFragment() {
        MobiComQuickConversationFragment quickConversationFragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (quickConversationFragment == null) {
            quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment(this.fragmentActivity, quickConversationFragment, QUICK_CONVERSATION_FRAGMENT);
        }
        return quickConversationFragment;
    }

    public ConversationFragment getConversationFragment() {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            Contact contact = ((ConversationActivity)this.fragmentActivity).getContact();
            Channel channel = ((ConversationActivity)this.fragmentActivity).getChannel();
            Integer conversationId = ((ConversationActivity)this.fragmentActivity).getConversationId();
            conversationFragment = new ConversationFragment(contact, channel, conversationId);
            ConversationActivity.addFragment(this.fragmentActivity, conversationFragment, CONVERSATION_FRAGMENT);
        }
        return conversationFragment;
    }

    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        TextView textView = (TextView)view.findViewById(R.id.unreadSmsCount);
        textView.setVisibility(8);
        this.openConversationFragment(contact, null);
    }

    public void openConversationFragment(final Contact contact, final Integer conversationId) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(ConversationUIService.this.fragmentActivity, ConversationUIService.CONVERSATION_FRAGMENT);
                if (conversationFragment == null) {
                    conversationFragment = new ConversationFragment(contact, null, conversationId);
                    ((MobiComKitActivityInterface)ConversationUIService.this.fragmentActivity).addFragment(conversationFragment);
                } else {
                    conversationFragment.loadConversation(contact, conversationId);
                }
            }
        });
    }

    public void openConversationFragment(Channel channel, Integer conversationId) {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            conversationFragment = new ConversationFragment(null, channel, conversationId);
            ((MobiComKitActivityInterface)this.fragmentActivity).addFragment(conversationFragment);
        } else {
            conversationFragment.loadConversation(channel, conversationId);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        try {
            if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
                Uri selectedFileUri;
                Uri uri = selectedFileUri = intent == null ? null : intent.getData();
                if (selectedFileUri == null) {
                    ConversationActivity cfr_ignored_0 = (ConversationActivity)this.fragmentActivity;
                    selectedFileUri = ConversationActivity.getCapturedImageUri();
                    ImageUtils.addImageToGallery((String)FilePathFinder.getPath((Context)this.fragmentActivity, (Uri)selectedFileUri), (Context)this.fragmentActivity);
                }
                if (selectedFileUri == null) {
                    Bitmap photo = (Bitmap)(intent != null ? intent.getExtras().get("data") : null);
                    selectedFileUri = ImageUtils.getImageUri((Context)this.fragmentActivity, (Bitmap)photo);
                }
                this.getConversationFragment().loadFile(selectedFileUri);
                Log.i((String)TAG, (String)("File uri: " + selectedFileUri));
            }
            if (requestCode == 101 && resultCode == -1) {
                this.checkForStartNewConversation(intent);
            }
            if (requestCode == 14 && resultCode == -1) {
                Uri selectedFilePath = ((ConversationActivity)this.fragmentActivity).getVideoFileUri();
                String file = Pattern.compile("//").split(selectedFilePath.toString())[1];
                if (!new File(file).exists()) {
                    this.getLastModifiedFile(Environment.getExternalStorageDirectory().getAbsolutePath() + "/DCIM/Camera/").renameTo(new File(file));
                }
                if (selectedFilePath != null) {
                    this.getConversationFragment().loadFile(selectedFilePath);
                }
                this.getConversationFragment().sendMessage("", Message.ContentType.VIDEO_MSG.getValue());
            }
            if (requestCode == 15 && resultCode == -1) {
                try {
                    File vCradFile = new ContactService((Context)this.fragmentActivity).vCard(intent.getData());
                    if (vCradFile != null) {
                        this.getConversationFragment().loadFile(Uri.fromFile((File)vCradFile));
                        this.getConversationFragment().sendMessage("", Message.ContentType.CONTACT_MSG.getValue());
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.fragmentActivity, (CharSequence)"Failed to load Contact", (int)0).show();
                    Log.e((String)"Exception::", (String)"Exception", (Throwable)e);
                }
            }
            if (requestCode == 16 && resultCode == -1) {
                ArrayList attachmentList = intent.getParcelableArrayListExtra("multiselect.selectedFiles");
                String messageText = intent.getStringExtra("multiselect.message");
                for (Uri info : attachmentList) {
                    this.getConversationFragment().loadFile(info);
                    this.getConversationFragment().sendMessage(messageText, Message.ContentType.ATTACHMENT.getValue());
                }
            }
            if (requestCode == 10 && resultCode == -1) {
                Log.i((String)"test", (String)"posi");
                Double latitude = intent.getDoubleExtra("latitude", 0.0);
                Double longitude = intent.getDoubleExtra("longitude", 0.0);
                LocationInfo info = new LocationInfo(latitude.doubleValue(), longitude.doubleValue());
                String locationInfo = GsonUtils.getJsonFromObject((Object)info, LocationInfo.class);
                this.sendLocation(locationInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversationThread(final Contact contact, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)ConversationUIService.this.fragmentActivity), contact, channel, null, (Context)ConversationUIService.this.fragmentActivity).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        name = channel != null ? ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.fragmentActivity).getUserId()) : contact.getDisplayName();
        alertDialog.setTitle((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_title).replace("[name]", name));
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_confir).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void updateLatestMessage(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLatestMessage(message, formattedContactNumber);
    }

    public void removeConversation(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().removeConversation(message, formattedContactNumber);
    }

    public void addMessage(Message message) {
        if (!Message.ContentType.HIDDEN.getValue().equals(message.getContentType())) {
            if (!BroadcastService.isQuick()) {
                return;
            }
            MobiComQuickConversationFragment fragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
            if (fragment != null) {
                fragment.addMessage(message);
            }
        }
    }

    public void updateLastMessage(String keyString, String userId) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLastMessage(keyString, userId);
    }

    public boolean isBroadcastedToGroup(Integer channelKey) {
        if (!BroadcastService.isIndividual()) {
            return false;
        }
        return this.getConversationFragment().isBroadcastedToChannel(channelKey);
    }

    public void syncMessages(Message message, String keyString) {
        if (!Message.ContentType.HIDDEN.getValue().equals(message.getContentType())) {
            ConversationFragment conversationFragment;
            String userId = null;
            if (message.getGroupId() == null) {
                userId = message.getContactIds();
            }
            if (BroadcastService.isIndividual() && (conversationFragment = this.getConversationFragment()).isMsgForConversation(message)) {
                conversationFragment.addMessage(message);
            }
            if (message.getGroupId() == null) {
                this.updateLastMessage(keyString, userId);
            }
        }
    }

    public void downloadConversations(boolean showInstruction) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().downloadConversations(showInstruction);
    }

    public void setLoadMore(boolean loadMore) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().setLoadMore(loadMore);
    }

    public void updateMessageKeyString(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        String userId = message.getContactIds();
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)userId) && conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getUserId()) || conversationFragment.getCurrentChannelKey(message.getGroupId())) {
            conversationFragment.updateMessageKeyString(message);
        }
    }

    public void deleteMessage(String keyString, String userId) {
        this.updateLastMessage(keyString, userId);
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().deleteMessageFromDeviceList(keyString);
        }
    }

    public void updateLastSeenStatus(String contactId) {
        ConversationFragment conversationFragment;
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().updateLastSeenStatus(contactId);
            return;
        }
        if (BroadcastService.isIndividual() && (conversationFragment = this.getConversationFragment()).getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateLastSeenStatus();
        }
    }

    public void updateDeliveryStatusForContact(String contactId) {
        this.updateStatus(contactId, false);
    }

    public void updateReadStatusForContact(String contactId) {
        this.updateStatus(contactId, true);
    }

    private void updateStatus(String contactId, boolean markRead) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)contactId) && conversationFragment.getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateDeliveryStatusForAllMessages(markRead);
        }
    }

    public void updateDeliveryStatus(Message message, String formattedContactNumber) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (conversationFragment.isMessageForCurrentConversation(message)) {
            conversationFragment.updateDeliveryStatus(message);
        }
    }

    public void deleteConversation(Contact contact, Integer channelKey, String response) {
        if (BroadcastService.isIndividual()) {
            if (SUCCESS.equals(response)) {
                this.getConversationFragment().clearList();
            } else if (!Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                Toast.makeText((Context)this.fragmentActivity, (CharSequence)this.fragmentActivity.getString(R.string.you_need_network_access_for_delete), (int)0).show();
            } else {
                Toast.makeText((Context)this.fragmentActivity, (CharSequence)this.fragmentActivity.getString(R.string.delete_conversation_failed), (int)0).show();
            }
        }
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().removeConversation(contact, channelKey, response);
        }
    }

    public void updateUploadFailedStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateUploadFailedStatus(message);
    }

    public void updateDownloadFailed(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().downloadFailed(message);
    }

    public void updateDownloadStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateDownloadStatus(message);
    }

    public void updateName(Integer channelKey) {
        if (BroadcastService.isIndividual()) {
            return;
        }
        this.getQuickConversationFragment().updateUserName(channelKey);
    }

    public void updateTypingStatus(String userId, String isTypingStatus) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        Log.i((String)TAG, (String)("Received typing status for: " + userId));
        if (conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateUserTypingStatus(userId, isTypingStatus);
        }
    }

    public void updateChannelSync() {
        if (BroadcastService.isChannelInfo()) {
            ((ChannelInfoActivity)this.fragmentActivity).updateChannelList();
        }
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().updateChannelTitleAndSubTitle();
        }
    }

    public void startContactActivityForResult(Intent intent, Message message, String messageContent, String[] userIdArray) {
        if (message != null) {
            intent.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)message, message.getClass()));
        }
        if (messageContent != null) {
            intent.putExtra("SHARED_TEXT", messageContent);
        }
        if (userIdArray != null) {
            intent.putExtra("userIdArray", userIdArray);
        }
        this.fragmentActivity.startActivityForResult(intent, 101);
    }

    public void startContactActivityForResult() {
        this.startContactActivityForResult(null, null);
    }

    public void startContactActivityForResult(Message message, String messageContent) {
        if (this.applozicSetting.getTotalOnlineUser() > 0) {
            new DownloadNNumberOfUserAsync(this.applozicSetting.getTotalOnlineUser(), message, messageContent).execute(null);
        } else if (this.applozicSetting.getTotalRegisteredUsers() > 0 && this.applozicSetting.isRegisteredUsersContactCall()) {
            new DownloadNNumberOfUserAsync(this.applozicSetting.getTotalRegisteredUsers(), message, messageContent, true).execute(null);
        } else {
            Intent intent = new Intent((Context)this.fragmentActivity, MobiComKitPeopleActivity.class);
            this.startContactActivityForResult(intent, message, messageContent, null);
        }
    }

    public void sendPriceMessage() {
        try {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity);
            alertDialog.setTitle((CharSequence)"Price");
            alertDialog.setMessage((CharSequence)"Enter your amount");
            final EditText inputText = new EditText((Context)this.fragmentActivity);
            inputText.setInputType(2);
            LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(-1, -1);
            inputText.setLayoutParams((ViewGroup.LayoutParams)linearParams);
            alertDialog.setView((View)inputText);
            alertDialog.setPositiveButton((CharSequence)this.fragmentActivity.getString(R.string.send_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (!TextUtils.isEmpty((CharSequence)inputText.getText().toString())) {
                        ConversationUIService.this.getConversationFragment().sendMessage(inputText.getText().toString(), Message.ContentType.PRICE.getValue());
                    }
                }
            });
            alertDialog.setNegativeButton((CharSequence)this.fragmentActivity.getString(R.string.cancel_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            if (!this.fragmentActivity.isFinishing()) {
                alertDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAudioMessage(String selectedFilePath) {
        Log.i((String)"ConversationUIService:", (String)"Send audio message ...");
        if (selectedFilePath != null) {
            Uri uri = Uri.fromFile((File)new File(selectedFilePath));
            this.getConversationFragment().loadFile(uri);
        }
        this.getConversationFragment().sendMessage("", Message.ContentType.AUDIO_MSG.getValue());
    }

    public void startMessageInfoFragment(String messageJson) {
        MessageInfoFragment messageInfoFragment = (MessageInfoFragment)UIService.getFragmentByTag(this.fragmentActivity, MESSGAE_INFO_FRAGMENT);
        if (messageInfoFragment == null) {
            messageInfoFragment = new MessageInfoFragment();
            Bundle bundle = new Bundle();
            bundle.putString("MESSAGE", messageJson);
            messageInfoFragment.setArguments(bundle);
            ConversationActivity.addFragment(this.fragmentActivity, messageInfoFragment, MESSGAE_INFO_FRAGMENT);
        }
    }

    public void checkForStartNewConversation(Intent intent) {
        String defaultText;
        String sharedText;
        String forwardMessage;
        boolean support;
        String messageJson;
        String userId;
        Uri uri;
        Channel channel = null;
        Integer conversationId = null;
        if ("android.intent.action.SEND".equals(intent.getAction()) && intent.getType() != null) {
            if ("text/plain".equals(intent.getType())) {
                String sharedText2 = intent.getStringExtra("android.intent.extra.TEXT");
                if (sharedText2 != null) {
                    this.startContactActivityForResult(null, sharedText2);
                }
            } else if (intent.getType().startsWith("image/")) {
                // empty if block
            }
        }
        if ((uri = intent.getData()) != null) {
            Long contactId = intent.getLongExtra(CONTACT_ID, 0L);
            if (contactId == 0L) {
                return;
            }
            this.contact = this.baseContactService.getContactById(String.valueOf(contactId));
        }
        Integer channelKey = intent.getIntExtra(GROUP_ID, -1);
        String channelName = intent.getStringExtra(GROUP_NAME);
        if (channelKey != -1 && channelKey != null && channelKey != 0) {
            channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannel(channelKey);
        }
        if (channel != null && !TextUtils.isEmpty((CharSequence)channelName) && TextUtils.isEmpty((CharSequence)channel.getName())) {
            channel.setName(channelName);
            ChannelService.getInstance((Context)this.fragmentActivity).updateChannel(channel);
        }
        String contactNumber = intent.getStringExtra(CONTACT_NUMBER);
        boolean firstTimeMTexterFriend = intent.getBooleanExtra(FIRST_TIME_MTEXTER_FRIEND, false);
        if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
            this.contact = this.baseContactService.getContactById(contactNumber);
            if (BroadcastService.isIndividual()) {
                this.getConversationFragment().setFirstTimeMTexterFriend(firstTimeMTexterFriend);
            }
        }
        if (TextUtils.isEmpty((CharSequence)(userId = intent.getStringExtra(USER_ID)))) {
            userId = intent.getStringExtra(CONTACT_ID);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            this.contact = this.baseContactService.getContactById(userId);
        }
        String applicationId = intent.getStringExtra(APPLICATION_ID);
        if (this.contact != null) {
            this.contact.setApplicationId(applicationId);
            this.baseContactService.upsert(this.contact);
        }
        String fullName = intent.getStringExtra(DISPLAY_NAME);
        if (this.contact != null && TextUtils.isEmpty((CharSequence)this.contact.getFullName()) && !TextUtils.isEmpty((CharSequence)fullName)) {
            this.contact.setFullName(fullName);
            this.baseContactService.upsert(this.contact);
            new UserClientService((Context)this.fragmentActivity).updateUserDisplayName(userId, fullName);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageJson = intent.getStringExtra("message_json")))) {
            Message message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
            if (message.getGroupId() != null) {
                channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannelByChannelKey(message.getGroupId());
            } else {
                this.contact = this.baseContactService.getContactById(message.getContactIds());
            }
            conversationId = message.getConversationId();
        }
        String conversationJson = null;
        if (intent.getExtras() != null) {
            conversationJson = intent.getExtras().getString(TOPICDETAIL);
        }
        if (conversationJson != null) {
            try {
                this.conversation = (Conversation)GsonUtils.getObjectFromJson((String)conversationJson, Conversation.class);
                if (this.conversation != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ChannelFeed channelFeed = ConversationService.getInstance((Context)ConversationUIService.this.fragmentActivity).createConversation(ConversationUIService.this.conversation);
                            if (channelFeed != null) {
                                if (ConversationUIService.this.conversation.getSupportIds() != null) {
                                    ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                                    ChannelService.getInstance((Context)ConversationUIService.this.fragmentActivity).processChannelFeedList(channelFeeds, false);
                                }
                                if (channelFeed.getConversationPxy() != null) {
                                    ConversationService.getInstance((Context)ConversationUIService.this.fragmentActivity).addConversation(channelFeed.getConversationPxy());
                                    ConversationUIService.this.getConversationFragment().setConversationId(channelFeed.getConversationPxy().getId());
                                }
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (support = intent.getBooleanExtra("SUPPORT_INTENT_KEY", false)) {
            this.contact = new Support((Context)this.fragmentActivity).getSupportContact();
        }
        if (this.contact != null) {
            this.openConversationFragment(this.contact, conversationId);
        }
        if (channel != null) {
            this.openConversationFragment(channel, conversationId);
        }
        if (conversationId != null) {
            this.getConversationFragment().setConversationId(conversationId);
        }
        if (!TextUtils.isEmpty((CharSequence)(forwardMessage = intent.getStringExtra("forwardMessage")))) {
            Message messageToForward = (Message)GsonUtils.getObjectFromJson((String)forwardMessage, Message.class);
            this.getConversationFragment().forwardMessage(messageToForward, this.contact);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = intent.getStringExtra("SHARED_TEXT")))) {
            this.getConversationFragment().sendMessage(sharedText);
        }
        if (!TextUtils.isEmpty((CharSequence)(defaultText = intent.getStringExtra(DEFAULT_TEXT)))) {
            this.getConversationFragment().setDefaultText(defaultText);
        }
        String productTopicId = intent.getStringExtra(PRODUCT_TOPIC_ID);
        String productImageUrl = intent.getStringExtra(PRODUCT_IMAGE_URL);
        if (!TextUtils.isEmpty((CharSequence)productTopicId) && !TextUtils.isEmpty((CharSequence)productImageUrl)) {
            try {
                FileMeta fileMeta = new FileMeta();
                fileMeta.setContentType("image");
                fileMeta.setBlobKeyString(productImageUrl);
                this.getConversationFragment().sendProductMessage(productTopicId, fileMeta, this.contact, Message.ContentType.TEXT_URL.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reconnectMQTT() {
        try {
            if (((MobiComKitActivityInterface)this.fragmentActivity).getRetryCount() <= 3 && Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                Log.i((String)TAG, (String)"Reconnecting to mqtt.");
                ((MobiComKitActivityInterface)this.fragmentActivity).retry();
                Intent intent = new Intent((Context)this.fragmentActivity, ApplozicMqttIntentService.class);
                intent.putExtra("subscribe", true);
                this.fragmentActivity.startService(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendLocation(String position) {
        this.getConversationFragment().sendMessage(position, Message.ContentType.LOCATION.getValue());
    }

    public File getLastModifiedFile(String directory) {
        File dir = new File(directory);
        File[] allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            return null;
        }
        File lastModifiedFile = allFiles[0];
        for (int i = 1; i < allFiles.length; ++i) {
            if (lastModifiedFile.lastModified() >= allFiles[i].lastModified()) continue;
            lastModifiedFile = allFiles[i];
        }
        return lastModifiedFile;
    }

    public class DownloadNNumberOfUserAsync
    extends AsyncTask<Void, Integer, Long> {
        private Message message;
        private UserService userService;
        private ProgressDialog progressDialog;
        private String messageContent;
        private int nNumberOfUsers;
        private String[] userIdArray;
        boolean callForRegistered;
        private RegisteredUsersApiResponse registeredUsersApiResponse;

        public DownloadNNumberOfUserAsync(int nNumberOfUsers, Message message, String messageContent) {
            this.message = message;
            this.messageContent = messageContent;
            this.nNumberOfUsers = nNumberOfUsers;
            this.userService = UserService.getInstance((Context)ConversationUIService.this.fragmentActivity);
        }

        public DownloadNNumberOfUserAsync(int numberOfUsersToFetch, Message message, String messageContent, boolean callForRegistered) {
            this.callForRegistered = callForRegistered;
            this.message = message;
            this.messageContent = messageContent;
            this.nNumberOfUsers = numberOfUsersToFetch;
            this.userService = UserService.getInstance((Context)ConversationUIService.this.fragmentActivity);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)ConversationUIService.this.fragmentActivity, (CharSequence)"", (CharSequence)ConversationUIService.this.fragmentActivity.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.callForRegistered) {
                this.registeredUsersApiResponse = this.userService.getRegisteredUsersList(Long.valueOf(0L), this.nNumberOfUsers);
            } else {
                this.userIdArray = this.userService.getOnlineUsers(this.nNumberOfUsers);
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            Intent intent;
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)ConversationUIService.this.fragmentActivity)) {
                Toast toast = Toast.makeText((Context)ConversationUIService.this.fragmentActivity, (CharSequence)ConversationUIService.this.fragmentActivity.getString(R.string.applozic_contacts_loading_error), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.userIdArray != null && this.userIdArray.length > 0) {
                intent = new Intent((Context)ConversationUIService.this.fragmentActivity, MobiComKitPeopleActivity.class);
                ConversationUIService.this.startContactActivityForResult(intent, this.message, this.messageContent, this.userIdArray);
            }
            if (this.registeredUsersApiResponse != null) {
                intent = new Intent((Context)ConversationUIService.this.fragmentActivity, MobiComKitPeopleActivity.class);
                ConversationUIService.this.startContactActivityForResult(intent, this.message, this.messageContent, null);
            }
        }
    }
}

