/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelCreateActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobicomLocationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.AudioMessageFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.io.Serializable;

public class ConversationActivity
extends AppCompatActivity
implements MessageCommunicator,
MobiComKitActivityInterface,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener,
ActivityCompat.OnRequestPermissionsResultCallback {
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final String TAKE_ORDER = "takeOrder";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String GOOGLE_API_KEY_META_DATA = "com.google.android.geo.API_KEY";
    protected static final long UPDATE_INTERVAL = 500L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final String API_KYE_STRING = "YOUR_GEO_API_KEY";
    private static final String CAPTURED_IMAGE_URI = "capturedImageUri";
    private static final String CAPTURED_VIDEO_URI = "capturedVideoUri";
    private static final String SHARE_TEXT = "share_text";
    private static Uri capturedImageUri;
    private static String inviteMessage;
    protected ConversationFragment conversation;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected ActionBar mActionBar;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private Contact contact;
    private Channel channel;
    private static int retry;
    public LinearLayout layout;
    String geoApiKey;
    int resourceId;
    RelativeLayout childFragmentLayout;
    public static Activity conversationActivity;
    private Uri videoFileUri;
    public Snackbar snackbar;

    @Override
    public void showErrorMessageView(String message) {
        this.layout.setVisibility(0);
        this.snackbar = Snackbar.make((View)this.layout, (CharSequence)message, (int)0);
        this.snackbar.setAction((CharSequence)"OK", new View.OnClickListener(){

            public void onClick(View view) {
                ConversationActivity.this.snackbar.dismiss();
            }
        });
        this.snackbar.setDuration(0);
        ViewGroup group = (ViewGroup)this.snackbar.getView();
        TextView textView = (TextView)group.findViewById(R.id.snackbar_action);
        textView.setTextColor(-256);
        group.setBackgroundColor(this.getResources().getColor(R.color.error_background_color));
        TextView txtView = (TextView)group.findViewById(R.id.snackbar_text);
        txtView.setMaxLines(5);
        this.snackbar.show();
    }

    @Override
    public void retry() {
        ++retry;
    }

    @Override
    public int getRetryCount() {
        return retry;
    }

    public void dismissErrorMessage() {
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
    }

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    protected void onStop() {
        super.onStop();
        String userKeyString = MobiComUserPreference.getInstance((Context)this).getSuUserKeyString();
        Intent intent = new Intent((Context)this, ApplozicMqttIntentService.class);
        intent.putExtra("userKeyString", userKeyString);
        this.startService(intent);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        Intent subscribeIntent = new Intent((Context)this, ApplozicMqttIntentService.class);
        subscribeIntent.putExtra("subscribe", true);
        this.startService(subscribeIntent);
        if (!Utils.isInternetAvailable((Context)this)) {
            String errorMessage = this.getResources().getString(R.string.internet_connection_not_available);
            this.showErrorMessageView(errorMessage);
        }
    }

    protected void onPause() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        super.onPause();
    }

    protected void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putSerializable(CONTACT, (Serializable)this.contact);
        savedInstanceState.putSerializable(CHANNEL, (Serializable)this.channel);
        if (capturedImageUri != null) {
            savedInstanceState.putString(CAPTURED_IMAGE_URI, capturedImageUri.toString());
        }
        if (this.videoFileUri != null) {
            savedInstanceState.putString(CAPTURED_VIDEO_URI, this.videoFileUri.toString());
        }
        super.onSaveInstanceState(savedInstanceState);
    }

    public boolean onSupportNavigateUp() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
            if (takeOrder.booleanValue()) {
                this.finish();
            } else {
                this.getSupportFragmentManager().popBackStack();
            }
            Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
            return true;
        }
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.resourceId = ApplozicSetting.getInstance((Context)this).getChatBackgroundColorOrDrawableResource();
        if (this.resourceId != 0) {
            this.getWindow().setBackgroundDrawableResource(this.resourceId);
        }
        this.setContentView(R.layout.quickconversion_activity);
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        conversationActivity = this;
        this.geoApiKey = Utils.getMetaDataValue((Context)this, (String)GOOGLE_API_KEY_META_DATA);
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.childFragmentLayout = (RelativeLayout)this.findViewById(R.id.layout_child_activity);
        if (Utils.hasMarshmallow()) {
            new ApplozicPermissions((Activity)this, this.layout).checkRuntimePermissionForStorage();
        }
        this.mActionBar = this.getSupportActionBar();
        inviteMessage = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)SHARE_TEXT);
        retry = 0;
        if (savedInstanceState != null) {
            capturedImageUri = savedInstanceState.getString(CAPTURED_IMAGE_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_IMAGE_URI)) : null;
            this.videoFileUri = savedInstanceState.getString(CAPTURED_VIDEO_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_VIDEO_URI)) : null;
            this.contact = (Contact)savedInstanceState.getSerializable(CONTACT);
            this.channel = (Channel)savedInstanceState.getSerializable(CHANNEL);
            this.conversation = this.channel != null ? new ConversationFragment(null, this.channel) : new ConversationFragment(this.contact, null);
            ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        } else {
            this.quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        InstructionUtil.showInfo((Context)this, R.string.info_message_sync, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                if (ConversationActivity.this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
                    ConversationActivity.this.finish();
                }
            }
        });
        this.mActionBar.setTitle(R.string.conversations);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.googleApiClient = new GoogleApiClient.Builder((Context)this).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.onNewIntent(this.getIntent());
        new MobiComConversationService((Context)this).processLastSeenAtStatus();
        UserService.getInstance((Context)this).processSyncUserBlock();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
            Log.i((String)"AL", (String)"user is not logged in yet.");
            return;
        }
        try {
            new ConversationUIService((FragmentActivity)this).checkForStartNewConversation(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showActionBar() {
        this.mActionBar.setDisplayShowTitleEnabled(true);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.showActionBar();
        this.getMenuInflater().inflate(R.menu.mobicom_basic_menu_for_normal_message, menu2);
        if (!ApplozicSetting.getInstance((Context)this).isStartNewButtonVisible()) {
            menu2.removeItem(R.id.start_new);
        }
        if (!ApplozicClient.getInstance((Context)this).isHandleDial()) {
            menu2.findItem(R.id.dial).setVisible(false);
        }
        if (!ApplozicSetting.getInstance((Context)this).isStartNewGroupButtonVisible()) {
            menu2.removeItem(R.id.conversations);
        }
        return true;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        new ConversationUIService((FragmentActivity)this).onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 1) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.location_permission_granted);
                this.processingLocation();
            } else {
                this.showSnackBar(R.string.location_permission_not_granted);
            }
        } else if (requestCode == 2) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_state_permission_granted);
            } else {
                this.showSnackBar(R.string.phone_state_permission_not_granted);
            }
        } else if (requestCode == 3) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.record_audio_permission_granted);
                this.showAudioRecordingDialog();
            } else {
                this.showSnackBar(R.string.record_audio_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void processingLocation() {
        if (ApplozicSetting.getInstance((Context)this).isLocationSharingViaMap() && !TextUtils.isEmpty((CharSequence)this.geoApiKey) && !API_KYE_STRING.equals(this.geoApiKey)) {
            Intent toMapActivity = new Intent((Context)this, MobicomLocationActivity.class);
            this.startActivityForResult(toMapActivity, 10);
            Log.i((String)"test", (String)"Activity for result strarted");
        } else if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    ConversationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)ConversationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    public void processLocation() {
        if (Utils.hasMarshmallow()) {
            new ApplozicPermissions((Activity)this, this.layout).checkRuntimePermissionForLocation();
        } else {
            this.processingLocation();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.start_new) {
            new ConversationUIService((FragmentActivity)this).startContactActivityForResult();
        } else if (id2 == R.id.conversations) {
            Intent intent = new Intent((Context)this, ChannelCreateActivity.class);
            this.startActivity(intent);
        } else if (id2 == R.id.refresh) {
            String message = this.getString(R.string.info_message_sync);
            new MobiComMessageService((Context)this, MessageIntentService.class).syncMessagesWithServer(message);
        } else {
            if (id2 == R.id.shareOptions) {
                Intent intent = new Intent("android.intent.action.SEND");
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share Via"));
                return super.onOptionsItemSelected(item);
            }
            if (id2 == R.id.deleteConversation && this.conversation != null) {
                this.conversation.deleteConversationThread();
            }
        }
        return false;
    }

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact, Channel channel) {
        this.conversation = new ConversationFragment(contact, channel);
        ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        this.channel = channel;
        this.contact = contact;
    }

    @Override
    public void startContactActivityForResult() {
        new ConversationUIService((FragmentActivity)this).startContactActivityForResult();
    }

    @Override
    public void addFragment(ConversationFragment conversationFragment) {
        ConversationActivity.addFragment((FragmentActivity)this, conversationFragment, "ConversationFragment");
        this.conversation = conversationFragment;
    }

    public void onBackPressed() {
        ConversationFragment conversationFragment;
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        if (takeOrder.booleanValue()) {
            this.finish();
        }
        if ((conversationFragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag("ConversationFragment")) != null && conversationFragment.isVisible() && conversationFragment.multimediaPopupGrid.getVisibility() == 0) {
            conversationFragment.hideMultimediaOptionGrid();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).removeConversation(message, formattedContactNumber);
    }

    public void onConnected(Bundle bundle) {
        try {
            Location mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
            if (mCurrentLocation == null) {
                Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
                this.locationRequest = new LocationRequest();
                this.locationRequest.setPriority(100);
                this.locationRequest.setInterval(500L);
                this.locationRequest.setFastestInterval(1L);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
            }
            if (mCurrentLocation != null && this.conversation != null) {
                this.conversation.attachLocation(mCurrentLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)this.getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onLocationChanged(Location location) {
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            if (this.conversation != null && location != null) {
                this.conversation.attachLocation(location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult((Activity)this, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
        }
    }

    public void setChildFragmentLayoutBG() {
        this.childFragmentLayout.setBackground(this.getDrawable(R.color.conversation_list_all_background));
    }

    public void setChildFragmentLayoutBGToTransparent() {
        this.childFragmentLayout.setBackground(this.getDrawable(17170445));
    }

    void showErrorDialog(int code) {
        GooglePlayServicesUtil.getErrorDialog((int)code, (Activity)this, (int)9000).show();
    }

    public Contact getContact() {
        return this.contact;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public static Uri getCapturedImageUri() {
        return capturedImageUri;
    }

    public static void setCapturedImageUri(Uri capturedImageUri) {
        ConversationActivity.capturedImageUri = capturedImageUri;
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    public Uri getVideoFileUri() {
        return this.videoFileUri;
    }

    public void setVideoFileUri(Uri videoFileUri) {
        this.videoFileUri = videoFileUri;
    }

    public void showAudioRecordingDialog() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfPermissionForAudioRecording((Activity)this)) {
            new ApplozicPermissions((Activity)this, this.layout).requestAudio();
        } else if (PermissionsUtils.isAudioRecordingPermissionGranted((Context)this)) {
            FragmentManager supportFragmentManager = this.getSupportFragmentManager();
            AudioMessageFragment fragment = AudioMessageFragment.newInstance();
            FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction().add((Fragment)fragment, "dialog");
            fragmentTransaction.addToBackStack(null);
            fragmentTransaction.commitAllowingStateLoss();
        } else if (ApplozicSetting.getInstance((Context)this).getTextForAudioPermissionNotFound() == null) {
            this.showSnackBar(R.string.applozic_audio_permission_missing);
        } else {
            this.snackbar = Snackbar.make((View)this.layout, (CharSequence)ApplozicSetting.getInstance((Context)this).getTextForAudioPermissionNotFound(), (int)-1);
            this.snackbar.show();
        }
    }
}

