/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.location.Location;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.MobiComKitConstants;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.ApplozicIntentService;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.selfdestruct.DisappearingMessageTask;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationListView;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelInfoActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComActivityForFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.SpinnerNavItem;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.DetailedConversationAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.TitleNavigationAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MultimediaOptionFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicomkit.uiwidgets.schedule.ConversationScheduler;
import com.applozic.mobicomkit.uiwidgets.schedule.ScheduledTimeHolder;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class MobiComConversationFragment
extends Fragment
implements View.OnClickListener {
    public static final int MAX_ALLOWED_FILE_SIZE = 0xA00000;
    private static final String TAG = "MobiComConversation";
    public FrameLayout emoticonsFrameLayout;
    protected String title = "Conversations";
    protected DownloadConversation downloadConversation;
    protected MobiComConversationService conversationService;
    protected TextView infoBroadcast;
    protected Class messageIntentClass;
    protected TextView emptyTextView;
    protected boolean loadMore = true;
    protected Contact contact;
    protected Channel channel;
    protected Integer currentConversationId;
    protected EditText messageEditText;
    protected ImageButton sendButton;
    protected ImageButton attachButton;
    protected Spinner sendType;
    protected LinearLayout individualMessageSendLayout;
    protected LinearLayout extendedSendingOptionLayout;
    protected RelativeLayout attachmentLayout;
    protected ProgressBar mediaUploadProgressBar;
    protected View spinnerLayout;
    protected SwipeRefreshLayout swipeLayout;
    protected Button scheduleOption;
    protected ScheduledTimeHolder scheduledTimeHolder = new ScheduledTimeHolder();
    protected Spinner selfDestructMessageSpinner;
    protected ImageView mediaContainer;
    protected TextView attachedFile;
    protected String filePath;
    protected boolean firstTimeMTexterFriend;
    protected MessageCommunicator messageCommunicator;
    protected ConversationListView listView = null;
    protected List<Message> messageList = new ArrayList<Message>();
    protected DetailedConversationAdapter conversationAdapter = null;
    protected Drawable sentIcon;
    protected Drawable deliveredIcon;
    protected ImageButton emoticonsBtn;
    protected Support support;
    protected MultimediaOptionFragment multimediaOptionFragment = new MultimediaOptionFragment();
    protected boolean hideExtendedSendingOptionLayout;
    private EmojiconHandler emojiIconHandler;
    private Bitmap previewThumbnail;
    private TextView isTyping;
    private LinearLayout statusMessageLayout;
    private String defaultText;
    private boolean typingStarted;
    private Integer channelKey;
    private Toolbar toolbar;
    LinearLayout userNotAbleToChatLayout;
    protected ApplozicSetting applozicSetting;
    public GridView multimediaPopupGrid;
    int resourceId;
    private Menu menu;
    protected SyncCallService syncCallService;

    public void setEmojiIconHandler(EmojiconHandler emojiIconHandler) {
        this.emojiIconHandler = emojiIconHandler;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.syncCallService = SyncCallService.getInstance((Context)this.getActivity());
        this.applozicSetting = ApplozicSetting.getInstance((Context)this.getActivity());
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View list = inflater.inflate(R.layout.mobicom_message_list, container, false);
        this.listView = (ConversationListView)list.findViewById(R.id.messageList);
        this.listView.setScrollToBottomOnSizeChange(Boolean.TRUE);
        this.resourceId = this.applozicSetting.getChatBackgroundColorOrDrawableResource();
        if (this.resourceId != 0) {
            this.listView.setBackgroundResource(this.resourceId);
            list.setBackgroundResource(this.resourceId);
        }
        this.listView.setDivider(null);
        this.messageList = new ArrayList<Message>();
        this.multimediaPopupGrid = (GridView)list.findViewById(R.id.mobicom_multimedia_options1);
        this.getActivity().getWindow().setSoftInputMode(3);
        this.toolbar = (Toolbar)this.getActivity().findViewById(R.id.my_toolbar);
        this.toolbar.setClickable(true);
        this.individualMessageSendLayout = (LinearLayout)list.findViewById(R.id.individual_message_send_layout);
        this.extendedSendingOptionLayout = (LinearLayout)list.findViewById(R.id.extended_sending_option_layout);
        this.statusMessageLayout = (LinearLayout)list.findViewById(R.id.status_message_layout);
        this.attachmentLayout = (RelativeLayout)list.findViewById(R.id.attachment_layout);
        this.isTyping = (TextView)list.findViewById(R.id.isTyping);
        this.mediaUploadProgressBar = (ProgressBar)this.attachmentLayout.findViewById(R.id.media_upload_progress_bar);
        this.emoticonsFrameLayout = (FrameLayout)list.findViewById(R.id.emojicons_frame_layout);
        this.emoticonsBtn = (ImageButton)list.findViewById(R.id.emoticons_btn);
        if (this.emojiIconHandler == null && this.emoticonsBtn != null) {
            this.emoticonsBtn.setVisibility(8);
        }
        this.spinnerLayout = inflater.inflate(R.layout.mobicom_message_list_header_footer, null);
        this.infoBroadcast = (TextView)this.spinnerLayout.findViewById(R.id.info_broadcast);
        this.emptyTextView = (TextView)list.findViewById(R.id.noConversations);
        this.emoticonsBtn.setOnClickListener((View.OnClickListener)this);
        this.listView.addHeaderView(this.spinnerLayout);
        this.sentIcon = this.getResources().getDrawable(R.drawable.applozic_ic_action_message_sent);
        this.deliveredIcon = this.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
        this.listView.setLongClickable(true);
        this.sendButton = (ImageButton)this.individualMessageSendLayout.findViewById(R.id.conversation_send);
        GradientDrawable bgShape = (GradientDrawable)this.sendButton.getBackground();
        bgShape.setColor(this.getActivity().getResources().getColor(this.applozicSetting.getSendButtonBackgroundColor()));
        this.attachButton = (ImageButton)this.individualMessageSendLayout.findViewById(R.id.attach_button);
        this.sendType = (Spinner)this.extendedSendingOptionLayout.findViewById(R.id.sendTypeSpinner);
        this.messageEditText = (EditText)this.individualMessageSendLayout.findViewById(R.id.conversation_message);
        this.messageEditText.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)this.applozicSetting.getMessageEditTextTextColor()));
        this.userNotAbleToChatLayout = (LinearLayout)list.findViewById(R.id.user_not_able_to_chat_layout);
        if (!TextUtils.isEmpty((CharSequence)this.defaultText)) {
            this.messageEditText.setText((CharSequence)this.defaultText);
            this.defaultText = "";
        }
        this.scheduleOption = (Button)this.extendedSendingOptionLayout.findViewById(R.id.scheduleOption);
        this.mediaContainer = (ImageView)this.attachmentLayout.findViewById(R.id.media_container);
        this.attachedFile = (TextView)this.attachmentLayout.findViewById(R.id.attached_file);
        ImageView closeAttachmentLayout = (ImageView)this.attachmentLayout.findViewById(R.id.close_attachment_layout);
        this.swipeLayout = (SwipeRefreshLayout)list.findViewById(R.id.swipe_container);
        this.swipeLayout.setColorScheme(new int[]{17170459, 17170452, 17170456, 0x1060016});
        this.listView.setMessageEditText(this.messageEditText);
        ArrayAdapter sendTypeAdapter = ArrayAdapter.createFromResource((Context)this.getActivity(), (int)R.array.send_type_options, (int)R.layout.mobiframework_custom_spinner);
        sendTypeAdapter.setDropDownViewResource(R.layout.mobiframework_custom_spinner);
        this.sendType.setAdapter((SpinnerAdapter)sendTypeAdapter);
        this.scheduleOption.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationScheduler conversationScheduler = new ConversationScheduler();
                conversationScheduler.setScheduleOption(MobiComConversationFragment.this.scheduleOption);
                conversationScheduler.setScheduledTimeHolder(MobiComConversationFragment.this.scheduledTimeHolder);
                conversationScheduler.setCancelable(false);
                conversationScheduler.show(MobiComConversationFragment.this.getActivity().getSupportFragmentManager(), "conversationScheduler");
            }
        });
        this.messageEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (!TextUtils.isEmpty((CharSequence)s.toString()) && s.toString().trim().length() == 1) {
                    MobiComConversationFragment.this.typingStarted = true;
                    Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), ApplozicMqttIntentService.class);
                    intent.putExtra("contact", (Serializable)MobiComConversationFragment.this.contact);
                    intent.putExtra("typing", MobiComConversationFragment.this.typingStarted);
                    MobiComConversationFragment.this.getActivity().startService(intent);
                } else if (s.toString().trim().length() == 0 && MobiComConversationFragment.this.typingStarted) {
                    MobiComConversationFragment.this.typingStarted = false;
                    Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), ApplozicMqttIntentService.class);
                    intent.putExtra("contact", (Serializable)MobiComConversationFragment.this.contact);
                    intent.putExtra("typing", MobiComConversationFragment.this.typingStarted);
                    MobiComConversationFragment.this.getActivity().startService(intent);
                }
            }
        });
        this.messageEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
            }
        });
        this.messageEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    if (MobiComConversationFragment.this.typingStarted) {
                        Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), ApplozicMqttIntentService.class);
                        intent.putExtra("contact", (Serializable)MobiComConversationFragment.this.contact);
                        intent.putExtra("typing", MobiComConversationFragment.this.typingStarted);
                        MobiComConversationFragment.this.getActivity().startService(intent);
                    }
                    MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
                    MobiComConversationFragment.this.multimediaPopupGrid.setVisibility(8);
                }
            }
        });
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
                if (!((MobiComConversationFragment.this.contact == null || MobiComConversationFragment.this.contact.isBlocked()) && MobiComConversationFragment.this.channel == null || TextUtils.isEmpty((CharSequence)MobiComConversationFragment.this.messageEditText.getText().toString().trim()) && TextUtils.isEmpty((CharSequence)MobiComConversationFragment.this.filePath))) {
                    MobiComConversationFragment.this.sendMessage(MobiComConversationFragment.this.messageEditText.getText().toString().trim());
                    MobiComConversationFragment.this.messageEditText.setText((CharSequence)"");
                    MobiComConversationFragment.this.scheduleOption.setText(R.string.ScheduleText);
                    if (MobiComConversationFragment.this.scheduledTimeHolder.getTimestamp() != null) {
                        MobiComConversationFragment.this.showScheduleMessageToast();
                    }
                    MobiComConversationFragment.this.scheduledTimeHolder.resetScheduledTimeHolder();
                }
                if (MobiComConversationFragment.this.contact != null && MobiComConversationFragment.this.contact.isBlocked()) {
                    MobiComConversationFragment.this.userUnBlockDialog(MobiComConversationFragment.this.contact.getUserId());
                }
            }
        });
        closeAttachmentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobiComConversationFragment.this.filePath = null;
                if (MobiComConversationFragment.this.previewThumbnail != null) {
                    MobiComConversationFragment.this.previewThumbnail.recycle();
                }
                MobiComConversationFragment.this.attachmentLayout.setVisibility(8);
            }
        });
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (MobiComConversationFragment.this.conversationAdapter != null) {
                    if (scrollState == 2) {
                        MobiComConversationFragment.this.conversationAdapter.contactImageLoader.setPauseWork(true);
                    } else {
                        MobiComConversationFragment.this.conversationAdapter.contactImageLoader.setPauseWork(false);
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int amountVisible, int totalItems) {
                if (MobiComConversationFragment.this.loadMore) {
                    int topRowVerticalPosition = MobiComConversationFragment.this.listView == null || MobiComConversationFragment.this.listView.getChildCount() == 0 ? 0 : MobiComConversationFragment.this.listView.getChildAt(0).getTop();
                    MobiComConversationFragment.this.swipeLayout.setEnabled(topRowVerticalPosition >= 0);
                }
            }
        });
        this.toolbar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MobiComConversationFragment.this.channel != null) {
                    Intent channelInfo = new Intent((Context)MobiComConversationFragment.this.getActivity(), ChannelInfoActivity.class);
                    channelInfo.putExtra("CHANNEL_KEY", (Serializable)MobiComConversationFragment.this.channel.getKey());
                    MobiComConversationFragment.this.startActivity(channelInfo);
                } else {
                    String activityClass = Utils.getMetaDataValue((Context)MobiComConversationFragment.this.getActivity(), (String)MobiComKitConstants.APPLICATION_ACTIVITY_TO_OPEN_ON_CHAT_TOOLBAR_TAP);
                    if (!TextUtils.isEmpty((CharSequence)activityClass)) {
                        try {
                            Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), Class.forName(activityClass));
                            intent.putExtra("userId", MobiComConversationFragment.this.contact.getContactIds());
                            MobiComConversationFragment.this.startActivity(intent);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        return list;
    }

    public void showScheduleMessageToast() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)MobiComConversationFragment.this.getActivity(), (int)R.string.info_message_scheduled, (int)0).show();
            }
        });
    }

    public void deleteMessageFromDeviceList(String messageKeyString) {
        try {
            int messageListSize;
            boolean updateQuickConversation = false;
            for (Message message : this.messageList) {
                int index;
                boolean value;
                boolean bl = value = message.getKeyString() != null ? message.getKeyString().equals(messageKeyString) : false;
                if (value && (index = this.messageList.indexOf(message)) != -1) {
                    int aboveIndex = index - 1;
                    int belowIndex = index + 1;
                    Message aboveMessage = this.messageList.get(aboveIndex);
                    if (belowIndex != this.messageList.size()) {
                        Message belowMessage = this.messageList.get(belowIndex);
                        if (aboveMessage.isTempDateType() && belowMessage.isTempDateType()) {
                            this.messageList.remove(aboveMessage);
                        }
                    } else if (belowIndex == this.messageList.size() && aboveMessage.isTempDateType()) {
                        this.messageList.remove(aboveMessage);
                    }
                }
                if (message.getKeyString() == null || !message.getKeyString().equals(messageKeyString)) continue;
                int position = this.messageList.indexOf(message);
                if (position == this.messageList.size() - 1) {
                    updateQuickConversation = true;
                }
                if (message.getScheduledAt() != null && message.getScheduledAt() != 0L) {
                    new MessageDatabaseService((Context)this.getActivity()).deleteScheduledMessage(messageKeyString);
                }
                this.messageList.remove(position);
                this.conversationAdapter.notifyDataSetChanged();
                if (!this.messageList.isEmpty()) break;
                this.emptyTextView.setVisibility(0);
                ((MobiComKitActivityInterface)this.getActivity()).removeConversation(message, this.channel != null ? String.valueOf(this.channel.getKey()) : this.contact.getFormattedContactNumber());
                break;
            }
            if ((messageListSize = this.messageList.size()) > 0 && updateQuickConversation) {
                ((MobiComKitActivityInterface)this.getActivity()).updateLatestMessage(this.messageList.get(messageListSize - 1), this.channel != null ? String.valueOf(this.channel.getKey()) : this.contact.getFormattedContactNumber());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrentUserId() {
        if (this.contact == null) {
            return "";
        }
        return this.contact.getUserId() != null ? this.contact.getUserId() : this.contact.getFormattedContactNumber();
    }

    public Contact getContact() {
        return this.contact;
    }

    protected void setContact(Contact contact) {
        this.contact = contact;
    }

    public String getFormattedContactNumber() {
        return this.contact != null ? this.contact.getFormattedContactNumber() : null;
    }

    public boolean hasMultiplePhoneNumbers() {
        return this.contact != null && this.contact.hasMultiplePhoneNumbers();
    }

    public MultimediaOptionFragment getMultimediaOptionFragment() {
        return this.multimediaOptionFragment;
    }

    public Spinner getSendType() {
        return this.sendType;
    }

    public Spinner getSelfDestructMessageSpinner() {
        return this.selfDestructMessageSpinner;
    }

    public Button getScheduleOption() {
        return this.scheduleOption;
    }

    public void setFirstTimeMTexterFriend(boolean firstTimeMTexterFriend) {
        this.firstTimeMTexterFriend = firstTimeMTexterFriend;
    }

    public void clearList() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MobiComConversationFragment.this.conversationAdapter != null) {
                    MobiComConversationFragment.this.messageList.clear();
                    MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                }
            }
        });
    }

    public void updateMessage(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MobiComConversationFragment.this.messageList.remove(message);
                MobiComConversationFragment.this.messageList.add(message);
                MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            }
        });
    }

    public void addMessage(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean added = MobiComConversationFragment.this.updateMessageList(message, false);
                if (added) {
                    MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    MobiComConversationFragment.this.listView.smoothScrollToPosition(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.emptyTextView.setVisibility(8);
                    MobiComConversationFragment.this.currentConversationId = message.getConversationId();
                    MobiComConversationFragment.this.channelKey = message.getGroupId();
                    if (!TextUtils.isEmpty((CharSequence)message.getTo())) {
                        new MessageDatabaseService((Context)MobiComConversationFragment.this.getActivity()).updateReadStatus(message.getTo());
                    }
                    if (Message.MessageType.MT_INBOX.getValue().equals(message.getType())) {
                        Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), ApplozicIntentService.class);
                        intent.putExtra("pairedMessageKey", message.getPairedMessageKeyString());
                        MobiComConversationFragment.this.getActivity().startService(intent);
                    }
                }
                MobiComConversationFragment.this.selfDestructMessage(message);
            }
        });
    }

    protected abstract void processMobiTexterUserCheck();

    public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (view.getId() == R.id.messageList) {
            menu2.setHeaderTitle(R.string.messageOptions);
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            int positionInSmsList = info.position - 1;
            if (positionInSmsList < 0 || this.messageList.isEmpty()) {
                return;
            }
            Message message = this.messageList.get(positionInSmsList);
            if (message.isTempDateType() || message.isCustom() || message.isChannelCustomMessage()) {
                return;
            }
            String[] menuItems = this.getResources().getStringArray(R.array.menu);
            for (int i = 0; i < menuItems.length; ++i) {
                if (!message.isGroupMessage() && !message.isTypeOutbox() && menuItems[i].equals("info") || (message.hasAttachment() || message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) && menuItems[i].equals("Copy") || message.isCall() && (menuItems[i].equals("Forward") || menuItems[i].equals("Resend")) || menuItems[i].equals("Resend") && (!message.isSentViaApp() || message.isSentToServer()) || menuItems[i].equals("Delete") && (message.isAttachmentUploadInProgress() || TextUtils.isEmpty((CharSequence)message.getKeyString()))) continue;
                menu2.add(0, i, i, (CharSequence)menuItems[i]);
            }
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        String contactNumber;
        super.onCreateOptionsMenu(menu2, inflater);
        this.menu = menu2;
        String string2 = contactNumber = this.contact != null ? this.contact.getContactNumber() : null;
        if (ApplozicClient.getInstance((Context)this.getActivity()).isHandleDial() && !TextUtils.isEmpty((CharSequence)contactNumber) && contactNumber.matches("[0-9]+") && contactNumber.length() > 2) {
            menu2.findItem(R.id.dial).setVisible(true);
        } else {
            menu2.findItem(R.id.dial).setVisible(false);
        }
        if (this.channel != null) {
            menu2.findItem(R.id.userBlock).setVisible(false);
            menu2.findItem(R.id.userUnBlock).setVisible(false);
        } else if (this.contact != null) {
            if (this.contact.isBlocked()) {
                menu2.findItem(R.id.userUnBlock).setVisible(true);
            } else {
                menu2.findItem(R.id.userBlock).setVisible(true);
            }
        }
        menu2.removeItem(R.id.start_new);
        menu2.removeItem(R.id.conversations);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.userBlock) {
            this.userBlockDialog(this.contact.getUserId());
        }
        if (id2 == R.id.userUnBlock) {
            new UserBlockAsync(this.contact.getUserId(), (Context)this.getActivity(), false).execute(new Void[0]);
        }
        return false;
    }

    public void loadConversation(final Contact contact, Channel channel) {
        NotificationManager notificationManager;
        if (this.downloadConversation != null) {
            this.downloadConversation.cancel(true);
        }
        final MessageClientService messageClientService = new MessageClientService((Context)this.getActivity());
        BroadcastService.currentUserId = contact != null ? contact.getContactIds() : String.valueOf(channel.getKey());
        this.typingStarted = false;
        if (TextUtils.isEmpty((CharSequence)this.filePath)) {
            this.attachmentLayout.setVisibility(8);
        }
        this.setContact(contact);
        this.setChannel(channel);
        this.individualMessageSendLayout.setVisibility(0);
        this.extendedSendingOptionLayout.setVisibility(0);
        this.unregisterForContextMenu((View)this.listView);
        this.clearList();
        this.updateTitle();
        this.swipeLayout.setEnabled(true);
        this.loadMore = true;
        if (this.selfDestructMessageSpinner != null) {
            this.selfDestructMessageSpinner.setSelection(0);
        }
        if (contact != null) {
            this.conversationAdapter = new DetailedConversationAdapter((Context)this.getActivity(), R.layout.mobicom_message_row_view, this.messageList, contact, this.messageIntentClass, this.emojiIconHandler);
        } else if (channel != null) {
            this.conversationAdapter = new DetailedConversationAdapter((Context)this.getActivity(), R.layout.mobicom_message_row_view, this.messageList, channel, this.messageIntentClass, this.emojiIconHandler);
        }
        this.listView.setTranscriptMode(2);
        this.listView.setAdapter((ListAdapter)this.conversationAdapter);
        this.registerForContextMenu((View)this.listView);
        this.processMobiTexterUserCheck();
        if (contact != null) {
            this.processPhoneNumbers();
            if (!TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
                notificationManager = (NotificationManager)this.getActivity().getSystemService("notification");
                notificationManager.cancel(contact.getContactIds().hashCode());
            }
        }
        if (channel != null) {
            notificationManager = (NotificationManager)this.getActivity().getSystemService("notification");
            notificationManager.cancel(String.valueOf(channel.getKey()).hashCode());
        }
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, contact, channel);
        this.downloadConversation.execute(new Void[0]);
        if (contact != null && this.support.isSupportNumber(contact.getFormattedContactNumber())) {
            this.sendType.setSelection(1);
            this.extendedSendingOptionLayout.setVisibility(8);
            this.messageEditText.setHint(R.string.enter_support_query_hint);
        } else {
            this.messageEditText.setHint(R.string.enter_mt_message_hint);
        }
        if (this.hideExtendedSendingOptionLayout) {
            this.extendedSendingOptionLayout.setVisibility(8);
        }
        this.emoticonsFrameLayout.setVisibility(8);
        if (contact != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        messageClientService.processUserStatus(contact);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        if (channel != null) {
            this.updateChannelSubTitle();
        }
        InstructionUtil.showInstruction((Context)this.getActivity(), R.string.instruction_go_back_to_recent_conversation_list, 5000, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
    }

    public void updateLastSeenStatus() {
        if (this.getActivity() == null) {
            return;
        }
        if (this.contact != null) {
            this.contact = new AppContactService((Context)this.getActivity()).getContactById(this.contact.getContactIds());
        }
        if (this.contact == null) {
            return;
        }
        if (this.contact.isBlocked() || this.contact.isBlockedBy()) {
            ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)"");
            this.isTyping.setVisibility(8);
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MobiComConversationFragment.this.contact != null && MobiComConversationFragment.this.channel == null) {
                    if (MobiComConversationFragment.this.contact.isConnected()) {
                        ((AppCompatActivity)MobiComConversationFragment.this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)MobiComConversationFragment.this.getActivity().getString(R.string.user_online));
                    } else if (MobiComConversationFragment.this.contact.getLastSeenAt() != 0L) {
                        ((AppCompatActivity)MobiComConversationFragment.this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)(MobiComConversationFragment.this.getActivity().getString(R.string.subtitle_last_seen_at_time) + " " + DateUtils.getDateAndTimeForLastSeen((Long)MobiComConversationFragment.this.contact.getLastSeenAt())));
                    }
                }
            }
        });
    }

    public void updateChannelSubTitle() {
        List channelUserMapperList = ChannelService.getInstance((Context)this.getActivity()).getListOfUsersFromChannelUserMapper(this.channel.getKey());
        if (channelUserMapperList != null && channelUserMapperList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            for (ChannelUserMapper channelUserMapper : channelUserMapperList) {
                if (++i > 2) break;
                Contact contactDisplayName = new AppContactService((Context)this.getActivity()).getContactById(channelUserMapper.getUserKey());
                if (TextUtils.isEmpty((CharSequence)channelUserMapper.getUserKey())) continue;
                stringBuffer.append(contactDisplayName.getDisplayName()).append(",");
            }
            if (!TextUtils.isEmpty((CharSequence)stringBuffer)) {
                if (channelUserMapperList.size() <= 2) {
                    int lastIndex = stringBuffer.lastIndexOf(",");
                    String userIds = stringBuffer.replace(lastIndex, lastIndex + 1, "").toString();
                    ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)userIds);
                } else {
                    ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)(stringBuffer.toString() + "+" + (channelUserMapperList.size() - 2) + " more"));
                }
            }
        }
    }

    public boolean isBroadcastedToChannel(Integer channelKey) {
        return this.getChannel() != null && this.getChannel().getKey().equals(channelKey);
    }

    public boolean getCurrentChannelKey(Integer channelKey) {
        return this.channel != null && this.channel.getKey().equals(channelKey);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isMsgForConversation(Message message) {
        return message.getGroupId() != null && this.channel != null && message.getGroupId().equals(this.channel.getKey()) || !TextUtils.isEmpty((CharSequence)message.getContactIds()) && this.contact != null && message.getContactIds().equals(this.contact.getContactIds());
    }

    protected void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void updateUploadFailedStatus(Message message) {
        int i = this.messageList.indexOf(message);
        if (i != -1) {
            this.messageList.get(i).setCanceled(true);
            this.conversationAdapter.notifyDataSetChanged();
        }
    }

    public void downloadFailed(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                View view;
                int index = MobiComConversationFragment.this.messageList.indexOf(message);
                if (index != -1 && (view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1)) != null) {
                    LinearLayout attachmentDownloadLayout = (LinearLayout)view.findViewById(R.id.attachment_download_layout);
                    attachmentDownloadLayout.setVisibility(0);
                }
            }
        });
    }

    public abstract void attachLocation(Location var1);

    public void updateDeliveryStatusForAllMessages(final boolean markRead) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Drawable statusIcon = MobiComConversationFragment.this.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
                    if (markRead) {
                        statusIcon = MobiComConversationFragment.this.getResources().getDrawable(R.drawable.applozic_ic_action_message_read);
                    }
                    for (int index = 0; index < MobiComConversationFragment.this.messageList.size(); ++index) {
                        View view;
                        Message message = MobiComConversationFragment.this.messageList.get(index);
                        if (message.getStatus() == Message.Status.DELIVERED_AND_READ.getValue().shortValue() || message.isTempDateType() || message.isCustom() || !message.isTypeOutbox() || message.isChannelCustomMessage()) continue;
                        message.setDelivered(Boolean.valueOf(true));
                        if (markRead) {
                            message.setStatus(Message.Status.DELIVERED_AND_READ.getValue().shortValue());
                        }
                        if ((view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1)) == null || message.isCustom() || message.isChannelCustomMessage()) continue;
                        TextView createdAtTime = (TextView)view.findViewById(R.id.createdAtTime);
                        TextView status = (TextView)view.findViewById(R.id.status);
                        createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, statusIcon, null);
                    }
                }
                catch (Exception ex) {
                    Log.i((String)MobiComConversationFragment.TAG, (String)"Exception while updating delivery status in UI.");
                }
            }
        });
    }

    public void updateDeliveryStatus(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    int index = MobiComConversationFragment.this.messageList.indexOf(message);
                    if (index != -1) {
                        if (MobiComConversationFragment.this.messageList.get(index).getStatus() == Message.Status.DELIVERED_AND_READ.getValue().shortValue() || MobiComConversationFragment.this.messageList.get(index).isTempDateType() || MobiComConversationFragment.this.messageList.get(index).isCustom() || MobiComConversationFragment.this.messageList.get(index).isChannelCustomMessage()) {
                            return;
                        }
                        MobiComConversationFragment.this.messageList.get(index).setDelivered(Boolean.valueOf(true));
                        MobiComConversationFragment.this.messageList.get(index).setStatus(message.getStatus());
                        View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                        if (view != null && !MobiComConversationFragment.this.messageList.get(index).isCustom()) {
                            TextView createdAtTime = (TextView)view.findViewById(R.id.createdAtTime);
                            Drawable statusIcon = MobiComConversationFragment.this.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
                            if (message.getStatus() == Message.Status.DELIVERED_AND_READ.getValue().shortValue()) {
                                statusIcon = MobiComConversationFragment.this.getResources().getDrawable(R.drawable.applozic_ic_action_message_read);
                                MobiComConversationFragment.this.messageList.get(index).setStatus(Message.Status.DELIVERED_AND_READ.getValue().shortValue());
                            }
                            createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, statusIcon, null);
                        }
                    } else {
                        MobiComConversationFragment.this.messageList.add(message);
                        MobiComConversationFragment.this.listView.smoothScrollToPosition(MobiComConversationFragment.this.messageList.size());
                        MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size());
                        MobiComConversationFragment.this.emptyTextView.setVisibility(8);
                        MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    }
                }
                catch (Exception ex) {
                    Log.i((String)MobiComConversationFragment.TAG, (String)"Exception while updating delivery status in UI.");
                }
            }
        });
    }

    public void loadFile(Uri uri) {
        if (uri == null) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.file_not_selected, (int)1).show();
            return;
        }
        this.filePath = FilePathFinder.getPath((Context)this.getActivity(), (Uri)uri);
        if (TextUtils.isEmpty((CharSequence)this.filePath)) {
            Log.i((String)TAG, (String)"Error while fetching filePath");
            this.attachmentLayout.setVisibility(8);
            Toast.makeText((Context)this.getActivity(), (int)R.string.info_file_attachment_error, (int)1).show();
            return;
        }
        Cursor returnCursor = this.getActivity().getContentResolver().query(uri, null, null, null, null);
        if (returnCursor != null) {
            int sizeIndex = returnCursor.getColumnIndex("_size");
            returnCursor.moveToFirst();
            Long fileSize = returnCursor.getLong(sizeIndex);
            int maxFileSize = ApplozicSetting.getInstance((Context)this.getActivity()).getMaxAttachmentSizeAllowed() * 1024 * 1024;
            if (fileSize > (long)maxFileSize) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.info_attachment_max_allowed_file_size, (int)1).show();
                return;
            }
            this.attachedFile.setText((CharSequence)returnCursor.getString(returnCursor.getColumnIndex("_display_name")));
            returnCursor.close();
        }
        this.attachmentLayout.setVisibility(0);
        String mimeType = FileUtils.getMimeType((Context)this.getActivity(), (Uri)uri);
        if (mimeType != null && (mimeType.startsWith("image") || mimeType.startsWith("video"))) {
            this.attachedFile.setVisibility(8);
            int reqWidth = this.mediaContainer.getWidth();
            int reqHeight = this.mediaContainer.getHeight();
            if (reqWidth == 0 || reqHeight == 0) {
                DisplayMetrics displaymetrics = new DisplayMetrics();
                this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
                reqHeight = displaymetrics.heightPixels;
                reqWidth = displaymetrics.widthPixels;
            }
            this.previewThumbnail = FileUtils.getPreview((String)this.filePath, (int)reqWidth, (int)reqHeight, (boolean)ApplozicSetting.getInstance((Context)this.getActivity()).isImageCompressionEnabled(), (String)mimeType);
            this.mediaContainer.setImageBitmap(this.previewThumbnail);
        } else {
            this.attachedFile.setVisibility(0);
            this.mediaContainer.setImageBitmap(null);
        }
    }

    public synchronized boolean updateMessageList(Message message, boolean update) {
        boolean toAdd;
        boolean bl = toAdd = !this.messageList.contains(message);
        if (update) {
            this.messageList.remove(message);
            this.messageList.add(message);
        } else if (toAdd) {
            Message firstDateMessage = new Message();
            firstDateMessage.setTempDateType(Short.valueOf("100").shortValue());
            firstDateMessage.setCreatedAtTime(message.getCreatedAtTime());
            if (!this.messageList.contains(firstDateMessage)) {
                this.messageList.add(firstDateMessage);
            }
            this.messageList.add(message);
        }
        return toAdd;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.support = new Support((Context)activity);
        try {
            this.messageCommunicator = (MessageCommunicator)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement interfaceDataCommunicator");
        }
    }

    protected AlertDialog showInviteDialog(int titleId, int messageId) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setMessage((CharSequence)this.getString(messageId).replace("[name]", this.getNameForInviteDialog())).setTitle(titleId);
        builder.setPositiveButton(R.string.invite, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                Intent share = new Intent("android.intent.action.SEND");
                MobiComConversationFragment.this.startActivity(Intent.createChooser((Intent)share, (CharSequence)"Share Via"));
                MobiComConversationFragment.this.sendType.setSelection(0);
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                MobiComConversationFragment.this.sendType.setSelection(0);
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
        return dialog;
    }

    public String getNameForInviteDialog() {
        if (this.contact != null) {
            return this.contact.getDisplayName();
        }
        if (this.channel != null) {
            return ChannelUtils.getChannelTitleName((Channel)this.channel, (String)MobiComUserPreference.getInstance((Context)this.getActivity()).getUserId());
        }
        return "";
    }

    public void forwardMessage(Message messageToForward, Contact contact) {
        this.contact = contact;
        this.loadConversation(contact);
        if (messageToForward.isAttachmentDownloaded()) {
            this.filePath = (String)messageToForward.getFilePaths().get(0);
        }
        this.sendMessage(messageToForward.getMessage(), messageToForward.getFileMetas(), messageToForward.getFileMetaKeyStrings(), Message.ContentType.DEFAULT.getValue());
    }

    public void sendMessage(String message, FileMeta fileMetas, String fileMetaKeyStrings, short messageContentType) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance((Context)this.getActivity());
        Message messageToSend = new Message();
        if (this.channel != null) {
            messageToSend.setGroupId(this.channel.getKey());
        } else {
            messageToSend.setTo(this.contact.getContactIds());
            messageToSend.setContactIds(this.contact.getContactIds());
        }
        messageToSend.setContentType(messageContentType);
        messageToSend.setRead(Boolean.TRUE);
        messageToSend.setStoreOnDevice(Boolean.TRUE.booleanValue());
        if (messageToSend.getCreatedAtTime() == null) {
            messageToSend.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + userPreferences.getDeviceTimeOffset()));
        }
        messageToSend.setConversationId(this.currentConversationId);
        messageToSend.setSendToDevice(Boolean.FALSE.booleanValue());
        messageToSend.setType(this.sendType.getSelectedItemId() == 1L ? Message.MessageType.MT_OUTBOX.getValue() : Message.MessageType.OUTBOX.getValue());
        messageToSend.setTimeToLive(this.getTimeToLive());
        messageToSend.setMessage(message);
        messageToSend.setDeviceKeyString(userPreferences.getDeviceKeyString());
        messageToSend.setScheduledAt(this.scheduledTimeHolder.getTimestamp());
        messageToSend.setSource(Message.Source.MT_MOBILE_APP.getValue());
        if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
            ArrayList<String> filePaths = new ArrayList<String>();
            filePaths.add(this.filePath);
            messageToSend.setFilePaths(filePaths);
        }
        messageToSend.setFileMetaKeyStrings(fileMetaKeyStrings);
        messageToSend.setFileMetas(fileMetas);
        this.conversationService.sendMessage(messageToSend, this.messageIntentClass);
        if (this.selfDestructMessageSpinner != null) {
            this.selfDestructMessageSpinner.setSelection(0);
        }
        this.attachmentLayout.setVisibility(8);
        this.filePath = null;
    }

    public void sendProductMessage(final String messageToSend, final FileMeta fileMeta, final Contact contact, final short messageContentType) {
        final Message message = new Message();
        new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComConversationService conversationService = new MobiComConversationService((Context)MobiComConversationFragment.this.getActivity());
                MobiComUserPreference userPreferences = MobiComUserPreference.getInstance((Context)MobiComConversationFragment.this.getActivity());
                String topicId = new MessageClientService((Context)MobiComConversationFragment.this.getActivity()).getTopicId(MobiComConversationFragment.this.currentConversationId);
                if (MobiComConversationFragment.this.getChannel() != null) {
                    message.setGroupId(MobiComConversationFragment.this.channelKey);
                } else {
                    message.setContactIds(contact.getUserId());
                    message.setTo(contact.getUserId());
                }
                message.setMessage(messageToSend);
                message.setRead(Boolean.TRUE);
                message.setStoreOnDevice(Boolean.TRUE.booleanValue());
                message.setSendToDevice(Boolean.FALSE.booleanValue());
                message.setContentType(messageContentType);
                message.setType(Message.MessageType.MT_OUTBOX.getValue());
                message.setDeviceKeyString(userPreferences.getDeviceKeyString());
                message.setSource(Message.Source.MT_MOBILE_APP.getValue());
                message.setTopicId(messageToSend);
                message.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + userPreferences.getDeviceTimeOffset()));
                message.setTopicId(topicId);
                message.setConversationId(MobiComConversationFragment.this.currentConversationId);
                message.setFileMetas(fileMeta);
                conversationService.sendMessage(message, MessageIntentService.class);
            }
        }).start();
    }

    private Integer getTimeToLive() {
        if (this.selfDestructMessageSpinner == null || this.selfDestructMessageSpinner.getSelectedItemPosition() <= 1) {
            return null;
        }
        return Integer.parseInt(this.selfDestructMessageSpinner.getSelectedItem().toString().replace("mins", "").replace("min", "").trim());
    }

    public void sendMessage(String message) {
        this.sendMessage(message, null, null, Message.ContentType.DEFAULT.getValue());
    }

    public void sendMessage(String message, short messageContentType) {
        this.sendMessage(message, null, null, messageContentType);
    }

    public void updateMessageKeyString(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int index = MobiComConversationFragment.this.messageList.indexOf(message);
                if (index != -1) {
                    Message messageListItem = MobiComConversationFragment.this.messageList.get(index);
                    messageListItem.setKeyString(message.getKeyString());
                    messageListItem.setSentToServer(true);
                    messageListItem.setCreatedAtTime(Long.valueOf(message.getSentMessageTimeAtServer()));
                    messageListItem.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
                    View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                    if (view != null) {
                        TextView createdAtTime;
                        ProgressBar mediaUploadProgressBarIndividualMessage = (ProgressBar)view.findViewById(R.id.media_upload_progress_bar);
                        if (mediaUploadProgressBarIndividualMessage != null) {
                            mediaUploadProgressBarIndividualMessage.setVisibility(8);
                        }
                        if (!((createdAtTime = (TextView)view.findViewById(R.id.createdAtTime)) == null || !messageListItem.isTypeOutbox() || messageListItem.isCall() || messageListItem.getDelivered().booleanValue() || messageListItem.isCustom() || messageListItem.isChannelCustomMessage() || messageListItem.getScheduledAt() != null)) {
                            createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, MobiComConversationFragment.this.support.isSupportNumber(MobiComConversationFragment.this.getCurrentUserId()) ? MobiComConversationFragment.this.deliveredIcon : MobiComConversationFragment.this.sentIcon, null);
                        }
                    }
                }
            }
        });
    }

    public void updateDownloadStatus(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    int index = MobiComConversationFragment.this.messageList.indexOf(message);
                    if (index != -1) {
                        Message smListItem = MobiComConversationFragment.this.messageList.get(index);
                        smListItem.setKeyString(message.getKeyString());
                        smListItem.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
                        View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                        if (view != null) {
                            RelativeLayout attachmentDownloadProgressLayout = (RelativeLayout)view.findViewById(R.id.attachment_download_progress_layout);
                            AttachmentView attachmentView = (AttachmentView)view.findViewById(R.id.main_attachment_view);
                            ImageView preview = (ImageView)view.findViewById(R.id.preview);
                            if (message.getFileMetas() != null && message.getFileMetas().getContentType().contains("image")) {
                                attachmentView.setVisibility(0);
                                preview.setVisibility(8);
                                attachmentView.setMessage(smListItem);
                                attachmentDownloadProgressLayout.setVisibility(8);
                            } else if (message.getFileMetas() != null && !message.getFileMetas().getContentType().contains("image")) {
                                attachmentView.setMessage(smListItem);
                                attachmentDownloadProgressLayout.setVisibility(8);
                                attachmentView.setVisibility(8);
                                preview.setVisibility(8);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Log.i((String)MobiComConversationFragment.TAG, (String)("Exception while updating download status: " + ex.getMessage()));
                }
            }
        });
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public void updateUserTypingStatus(String typingUserId, final String isTypingStatus) {
        if (this.contact.isBlocked() || this.contact.isBlockedBy()) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (isTypingStatus.equals("1")) {
                    MobiComConversationFragment.this.statusMessageLayout.setVisibility(0);
                    MobiComConversationFragment.this.isTyping.setVisibility(0);
                    MobiComConversationFragment.this.isTyping.setText((CharSequence)(MobiComConversationFragment.this.contact.getDisplayName() + " " + MobiComConversationFragment.this.getString(R.string.is_typing)));
                } else {
                    MobiComConversationFragment.this.statusMessageLayout.setVisibility(8);
                    MobiComConversationFragment.this.isTyping.setVisibility(8);
                    MobiComConversationFragment.this.isTyping.setText((CharSequence)"");
                }
            }
        });
    }

    public LayoutInflater getLayoutInflater(Bundle savedInstanceState) {
        return super.getLayoutInflater(savedInstanceState);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.emoticons_btn) {
            if (this.emoticonsFrameLayout.getVisibility() == 0) {
                this.emoticonsFrameLayout.setVisibility(8);
                Utils.toggleSoftKeyBoard((Activity)this.getActivity(), (boolean)false);
            } else {
                Utils.toggleSoftKeyBoard((Activity)this.getActivity(), (boolean)true);
                this.emoticonsFrameLayout.setVisibility(0);
            }
        }
    }

    public void onPause() {
        super.onPause();
        BroadcastService.currentUserId = null;
        if (this.typingStarted) {
            Intent intent = new Intent((Context)this.getActivity(), ApplozicMqttIntentService.class);
            intent.putExtra("contact", (Serializable)this.contact);
            intent.putExtra("typing", false);
            this.getActivity().startService(intent);
        }
        if (this.conversationAdapter != null) {
            this.conversationAdapter.contactImageLoader.setPauseWork(false);
        }
    }

    public void updateTitle() {
        String title = null;
        if (this.contact != null) {
            title = this.contact.getDisplayName();
        } else if (this.channel != null) {
            title = ChannelUtils.getChannelTitleName((Channel)this.channel, (String)MobiComUserPreference.getInstance((Context)this.getActivity()).getUserId());
        }
        if (title != null) {
            ((AppCompatActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)title);
        }
    }

    public void loadConversation(Channel channel) {
        this.loadConversation(null, channel);
    }

    public void loadConversation(Contact contact) {
        this.loadConversation(contact, null);
    }

    public void deleteConversationThread() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)MobiComConversationFragment.this.getActivity()), MobiComConversationFragment.this.contact, MobiComConversationFragment.this.channel, (Context)MobiComConversationFragment.this.getActivity()).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setTitle((CharSequence)this.getActivity().getString(R.string.dialog_delete_conversation_title).replace("[name]", this.getNameForInviteDialog()));
        alertDialog.setMessage((CharSequence)this.getActivity().getString(R.string.dialog_delete_conversation_confir).replace("[name]", this.getNameForInviteDialog()));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    protected void processPhoneNumbers() {
        if (this.contact.hasMultiplePhoneNumbers()) {
            ArrayList<SpinnerNavItem> navSpinner = new ArrayList<SpinnerNavItem>();
            navSpinner.add(new SpinnerNavItem(this.contact, this.contact.getContactNumber(), (String)this.contact.getPhoneNumbers().get(this.contact.getContactNumber()), R.drawable.applozic_ic_action_email));
            for (String phoneNumber : this.contact.getPhoneNumbers().keySet()) {
                if (PhoneNumberUtils.compare((String)this.contact.getContactNumber(), (String)phoneNumber)) continue;
                navSpinner.add(new SpinnerNavItem(this.contact, phoneNumber, (String)this.contact.getPhoneNumbers().get(phoneNumber), R.drawable.applozic_ic_action_email));
            }
            MobiComActivityForFragment activity = (MobiComActivityForFragment)this.getActivity();
            TitleNavigationAdapter adapter = new TitleNavigationAdapter(this.getActivity().getApplicationContext(), navSpinner);
            activity.setNavSpinner(navSpinner);
            activity.setAdapter(adapter);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position - 1;
        if (this.messageList.size() <= position) {
            return true;
        }
        Message message = this.messageList.get(position);
        if (message.isTempDateType() || message.isCustom()) {
            return true;
        }
        switch (item.getItemId()) {
            case 0: {
                if (Build.VERSION.SDK_INT < 11) {
                    android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getActivity().getSystemService("clipboard");
                    clipboard.setText((CharSequence)message.getMessage());
                    break;
                }
                ClipboardManager clipboard = (ClipboardManager)this.getActivity().getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"Copied message", (CharSequence)message.getMessage());
                clipboard.setPrimaryClip(clip);
                break;
            }
            case 1: {
                Message messageToResend = new Message(message);
                messageToResend.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + MobiComUserPreference.getInstance((Context)this.getActivity()).getDeviceTimeOffset()));
                this.conversationService.sendMessage(messageToResend, this.messageIntentClass);
                break;
            }
            case 2: {
                String messageKeyString = message.getKeyString();
                new DeleteConversationAsyncTask(this.conversationService, message, this.contact).execute(new Void[0]);
                this.deleteMessageFromDeviceList(messageKeyString);
                break;
            }
            case 3: {
                ConversationUIService conversationUIService = new ConversationUIService(this.getActivity());
                String messageJson = GsonUtils.getJsonFromObject((Object)message, Message.class);
                conversationUIService.startMessageInfoFragment(messageJson);
            }
        }
        return true;
    }

    public void onResume() {
        super.onResume();
        if (this.contact != null || this.channel != null) {
            String string2 = BroadcastService.currentUserId = this.contact != null ? this.contact.getContactIds() : String.valueOf(this.channel.getKey());
            if (BroadcastService.currentUserId != null) {
                String ns = "notification";
                NotificationManager nMgr = (NotificationManager)this.getActivity().getSystemService(ns);
                nMgr.cancel(BroadcastService.currentUserId.hashCode());
            }
            if (this.downloadConversation != null) {
                this.downloadConversation.cancel(true);
            }
            if (this.contact != null) {
                this.contact = new AppContactService((Context)this.getActivity()).getContactById(this.contact.getContactIds());
                if (this.contact.isBlocked() || this.contact.isBlockedBy()) {
                    this.isTyping.setVisibility(8);
                    ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)"");
                } else {
                    this.updateLastSeenStatus();
                }
            }
            if (SyncCallService.refreshView) {
                this.messageList.clear();
                SyncCallService.refreshView = false;
            }
            if (this.messageList.isEmpty()) {
                this.loadConversation(this.contact, this.channel);
            } else if (MobiComUserPreference.getInstance((Context)this.getActivity()).getNewMessageFlag()) {
                this.loadnewMessageOnResume(this.contact, this.channel);
            }
            MobiComUserPreference.getInstance((Context)this.getActivity()).setNewMessageFlag(false);
        }
        this.swipeLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                MobiComConversationFragment.this.downloadConversation = new DownloadConversation((AbsListView)MobiComConversationFragment.this.listView, false, 1, 1, 1, MobiComConversationFragment.this.contact, MobiComConversationFragment.this.channel);
                MobiComConversationFragment.this.downloadConversation.execute(new Void[0]);
            }
        });
        if (this.channel != null) {
            boolean present;
            Channel newChannel = ChannelService.getInstance((Context)this.getActivity()).getChannelByChannelKey(this.channel.getKey());
            if (newChannel != null && !this.channel.getName().equals(newChannel.getName())) {
                this.title = ChannelUtils.getChannelTitleName((Channel)newChannel, (String)MobiComUserPreference.getInstance((Context)this.getActivity()).getUserId());
                ((AppCompatActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)this.title);
            }
            if (!(present = ChannelService.getInstance((Context)this.getActivity()).processIsUserPresentInChannel(this.channel.getKey()))) {
                this.individualMessageSendLayout.setVisibility(8);
                this.userNotAbleToChatLayout.setVisibility(0);
            }
            if (ChannelService.isUpdateTitle) {
                this.updateChannelSubTitle();
                ChannelService.isUpdateTitle = false;
            }
        }
    }

    public void updateChannelTitleAndSubTitle() {
        if (this.channel != null) {
            Channel newChannel = ChannelService.getInstance((Context)this.getActivity()).getChannelByChannelKey(this.channel.getKey());
            if (newChannel != null && !this.channel.getName().equals(newChannel.getName())) {
                this.title = ChannelUtils.getChannelTitleName((Channel)newChannel, (String)MobiComUserPreference.getInstance((Context)this.getActivity()).getUserId());
                ((AppCompatActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)this.title);
            }
            this.updateChannelSubTitle();
        }
    }

    public void selfDestructMessage(Message message) {
        if (Message.MessageType.MT_INBOX.getValue().equals(message.getType()) && message.getTimeToLive() != null && message.getTimeToLive() != 0) {
            new Timer().schedule((TimerTask)new DisappearingMessageTask((Context)this.getActivity(), this.conversationService, message), message.getTimeToLive() * 60 * 1000);
        }
    }

    public void loadnewMessageOnResume(Contact contact, Channel channel) {
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, contact, channel);
        this.downloadConversation.execute(new Void[0]);
    }

    public void userBlockDialog(final String userId) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new UserBlockAsync(userId, (Context)MobiComConversationFragment.this.getActivity(), true).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        if (this.contact != null) {
            name = this.contact.getDisplayName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.user_block_info).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void userUnBlockDialog(final String userId) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new UserBlockAsync(userId, (Context)MobiComConversationFragment.this.getActivity(), false).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        if (this.contact != null) {
            name = this.contact.getDisplayName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.user_un_block_info).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public class UserBlockAsync
    extends AsyncTask<Void, Integer, Long> {
        private UserService userService;
        private ProgressDialog progressDialog;
        private Context context;
        String userId;
        boolean userBlock;
        String userBlockResponse;
        String userUnBlockResponse;

        public UserBlockAsync(String userId, Context context, boolean userBlock) {
            this.context = context;
            this.userId = userId;
            this.userBlock = userBlock;
            this.userService = UserService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.please_wait_info), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.userBlock && !TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userBlockResponse = this.userService.processUserBlock(this.userId);
            }
            if (!this.userBlock && !TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userUnBlockResponse = this.userService.processUserUnBlockUser(this.userId);
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)MobiComConversationFragment.this.getString(R.string.you_need_network_access_for_block_or_unblock), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (!TextUtils.isEmpty((CharSequence)this.userBlockResponse) && "success".equals(this.userBlockResponse)) {
                ((AppCompatActivity)MobiComConversationFragment.this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)"");
                MobiComConversationFragment.this.isTyping.setVisibility(8);
                if (MobiComConversationFragment.this.typingStarted) {
                    Intent intent = new Intent((Context)MobiComConversationFragment.this.getActivity(), ApplozicMqttIntentService.class);
                    intent.putExtra("contact", (Serializable)MobiComConversationFragment.this.contact);
                    intent.putExtra("STOP_TYPING", true);
                    MobiComConversationFragment.this.getActivity().startService(intent);
                }
                MobiComConversationFragment.this.menu.findItem(R.id.userBlock).setVisible(false);
                MobiComConversationFragment.this.menu.findItem(R.id.userUnBlock).setVisible(true);
            }
            if (!TextUtils.isEmpty((CharSequence)this.userUnBlockResponse) && "success".equals(this.userUnBlockResponse)) {
                MobiComConversationFragment.this.menu.findItem(R.id.userUnBlock).setVisible(false);
                MobiComConversationFragment.this.menu.findItem(R.id.userBlock).setVisible(true);
            }
            MobiComConversationFragment.this.contact = new AppContactService((Context)MobiComConversationFragment.this.getActivity()).getContactById(this.userId);
        }
    }

    public class DownloadConversation
    extends AsyncTask<Void, Integer, Long> {
        private AbsListView view;
        private int firstVisibleItem;
        private int amountVisible;
        private int totalItems;
        private boolean initial;
        private Contact contact;
        private Channel channel;
        private List<Message> nextMessageList = new ArrayList<Message>();

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems, Contact contact, Channel channel) {
            this.view = view;
            this.initial = initial;
            this.firstVisibleItem = firstVisibleItem;
            this.amountVisible = amountVisible;
            this.totalItems = totalItems;
            this.contact = contact;
            this.channel = channel;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MobiComConversationFragment.this.emptyTextView.setVisibility(8);
            MobiComConversationFragment.this.swipeLayout.post(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationFragment.this.swipeLayout.setRefreshing(true);
                }
            });
            if (this.initial) {
                MobiComConversationFragment.this.sendButton.setEnabled(false);
                MobiComConversationFragment.this.messageEditText.setEnabled(false);
            }
            if (!this.initial && MobiComConversationFragment.this.messageList.isEmpty()) {
                AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)MobiComConversationFragment.this.getActivity()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                });
                alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        MobiComConversationFragment.this.loadMore = false;
                    }
                });
                alertDialog.setTitle(R.string.sync_older_messages);
                alertDialog.setCancelable(true);
                alertDialog.create().show();
            }
        }

        protected Long doInBackground(Void ... voids) {
            try {
                if (this.initial) {
                    Long lastConversationloadTime = 1L;
                    if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                        for (int i = MobiComConversationFragment.this.messageList.size() - 1; i >= 0; --i) {
                            if (MobiComConversationFragment.this.messageList.get(i).isTempDateType()) continue;
                            lastConversationloadTime = MobiComConversationFragment.this.messageList.get(i).getCreatedAtTime();
                            break;
                        }
                    }
                    Log.i((String)MobiComConversationFragment.TAG, (String)(" loading conversation with  lastConversationloadTime " + lastConversationloadTime));
                    this.nextMessageList = MobiComConversationFragment.this.conversationService.getMessages(Long.valueOf(lastConversationloadTime + 1L), null, this.contact, this.channel);
                } else if (this.firstVisibleItem == 1 && MobiComConversationFragment.this.loadMore && !MobiComConversationFragment.this.messageList.isEmpty()) {
                    MobiComConversationFragment.this.loadMore = false;
                    Long endTime = null;
                    for (Message message : MobiComConversationFragment.this.messageList) {
                        if (message.isTempDateType()) continue;
                        endTime = MobiComConversationFragment.this.messageList.get(0).getCreatedAtTime();
                        break;
                    }
                    this.nextMessageList = MobiComConversationFragment.this.conversationService.getMessages(null, endTime, this.contact, this.channel);
                }
                ArrayList<Message> createAtMessage = new ArrayList<Message>();
                if (this.nextMessageList != null && !this.nextMessageList.isEmpty()) {
                    Message firstDateMessage = new Message();
                    firstDateMessage.setTempDateType(Short.valueOf("100").shortValue());
                    firstDateMessage.setCreatedAtTime(this.nextMessageList.get(0).getCreatedAtTime());
                    if (this.initial && !MobiComConversationFragment.this.messageList.contains(firstDateMessage)) {
                        createAtMessage.add(firstDateMessage);
                    } else if (!this.initial) {
                        createAtMessage.add(firstDateMessage);
                        MobiComConversationFragment.this.messageList.remove(firstDateMessage);
                    }
                    if (!createAtMessage.contains(this.nextMessageList.get(0))) {
                        createAtMessage.add(this.nextMessageList.get(0));
                    }
                    for (int i = 1; i <= this.nextMessageList.size() - 1; ++i) {
                        long dayDifference = DateUtils.daysBetween((Date)new Date(this.nextMessageList.get(i - 1).getCreatedAtTime()), (Date)new Date(this.nextMessageList.get(i).getCreatedAtTime()));
                        if (dayDifference >= 1L) {
                            Message message = new Message();
                            message.setTempDateType(Short.valueOf("100").shortValue());
                            message.setCreatedAtTime(this.nextMessageList.get(i).getCreatedAtTime());
                            if (this.initial && !MobiComConversationFragment.this.messageList.contains(message)) {
                                createAtMessage.add(message);
                            } else if (!this.initial) {
                                createAtMessage.add(message);
                                MobiComConversationFragment.this.messageList.remove(message);
                            }
                        }
                        if (createAtMessage.contains(this.nextMessageList.get(i))) continue;
                        createAtMessage.add(this.nextMessageList.get(i));
                    }
                }
                this.nextMessageList = createAtMessage;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return 0L;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Long result) {
            super.onPostExecute((Object)result);
            MobiComConversationFragment.this.swipeLayout.post(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationFragment.this.swipeLayout.setRefreshing(true);
                }
            });
            if (this.nextMessageList.isEmpty()) {
                MobiComConversationFragment.this.swipeLayout.setEnabled(false);
                MobiComConversationFragment.this.swipeLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        MobiComConversationFragment.this.swipeLayout.setRefreshing(false);
                    }
                });
                if (this.initial) {
                    MobiComConversationFragment.this.sendButton.setEnabled(true);
                    MobiComConversationFragment.this.messageEditText.setEnabled(true);
                }
                return;
            }
            if (!MobiComConversationFragment.this.messageList.isEmpty() && !this.nextMessageList.isEmpty() && MobiComConversationFragment.this.messageList.get(0).equals((Object)this.nextMessageList.get(this.nextMessageList.size() - 1))) {
                this.nextMessageList.remove(this.nextMessageList.size() - 1);
            }
            if (!MobiComConversationFragment.this.messageList.isEmpty() && !this.nextMessageList.isEmpty() && MobiComConversationFragment.this.messageList.get(0).getCreatedAtTime().equals(this.nextMessageList.get(this.nextMessageList.size() - 1).getCreatedAtTime())) {
                this.nextMessageList.remove(this.nextMessageList.size() - 1);
            }
            for (Message message : this.nextMessageList) {
                MobiComConversationFragment.this.selfDestructMessage(message);
            }
            if (this.initial) {
                MobiComConversationFragment.this.messageList.addAll(this.nextMessageList);
                MobiComConversationFragment.this.emptyTextView.setVisibility(MobiComConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                    MobiComConversationFragment.this.listView.post(new Runnable(){

                        @Override
                        public void run() {
                            MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size() - 1);
                        }
                    });
                }
            } else if (!this.nextMessageList.isEmpty()) {
                MobiComConversationFragment.this.listView.setTranscriptMode(0);
                MobiComConversationFragment.this.messageList.addAll(0, this.nextMessageList);
                MobiComConversationFragment.this.listView.setSelection(this.nextMessageList.size());
            }
            if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                Message message;
                for (int i = MobiComConversationFragment.this.messageList.size() - 1; !(i < 0 || (message = MobiComConversationFragment.this.messageList.get(i)).isRead().booleanValue() || message.isTempDateType() || message.isCustom()); --i) {
                    message.setRead(Boolean.TRUE);
                    new MessageDatabaseService((Context)MobiComConversationFragment.this.getActivity()).updateMessageReadFlag(message.getMessageId().longValue(), true);
                }
            }
            MobiComConversationFragment.this.syncCallService.updateUnreadCount(this.contact, this.channel);
            if (MobiComConversationFragment.this.conversationAdapter != null) {
                MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            }
            MobiComConversationFragment.this.swipeLayout.post(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationFragment.this.swipeLayout.setRefreshing(false);
                }
            });
            if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                MobiComConversationFragment.this.currentConversationId = MobiComConversationFragment.this.messageList.get(MobiComConversationFragment.this.messageList.size() - 1).getConversationId();
                MobiComConversationFragment.this.channelKey = MobiComConversationFragment.this.messageList.get(MobiComConversationFragment.this.messageList.size() - 1).getGroupId();
            }
            if (this.initial) {
                MobiComConversationFragment.this.sendButton.setEnabled(true);
                MobiComConversationFragment.this.messageEditText.setEnabled(true);
            }
            MobiComConversationFragment.this.loadMore = !this.nextMessageList.isEmpty();
        }
    }
}

