/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.PopupWindow;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MultimediaOptionsGridView {
    private Uri capturedImageUri;
    public PopupWindow showPopup;
    FragmentActivity context;
    GridView multimediaOptions;

    public MultimediaOptionsGridView(FragmentActivity context, GridView multimediaOptions) {
        this.context = context;
        this.multimediaOptions = multimediaOptions;
    }

    public void setMultimediaClickListener() {
        this.capturedImageUri = null;
        this.multimediaOptions.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        ((ConversationActivity)MultimediaOptionsGridView.this.context).processLocation();
                        break;
                    }
                    case 1: {
                        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                        if (intent.resolveActivity(MultimediaOptionsGridView.this.context.getApplicationContext().getPackageManager()) == null) break;
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "JPEG_" + timeStamp + "_" + ".jpeg";
                        File photoFile = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionsGridView.this.context, (String)"image/jpeg");
                        if (photoFile == null) break;
                        MultimediaOptionsGridView.this.capturedImageUri = Uri.fromFile((File)photoFile);
                        ConversationActivity.setCapturedImageUri(MultimediaOptionsGridView.this.capturedImageUri);
                        intent.putExtra("output", (Parcelable)MultimediaOptionsGridView.this.capturedImageUri);
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 11);
                        break;
                    }
                    case 2: {
                        Intent intentPick = new Intent((Context)MultimediaOptionsGridView.this.context, MobiComAttachmentSelectorActivity.class);
                        MultimediaOptionsGridView.this.context.startActivityForResult(intentPick, 16);
                        break;
                    }
                    case 3: {
                        ((ConversationActivity)MultimediaOptionsGridView.this.context).showAudioRecordingDialog();
                        break;
                    }
                    case 4: {
                        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "VID_" + timeStamp + "_" + ".mp4";
                        File fileUri = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionsGridView.this.context, (String)"video/mp4");
                        intent.putExtra("output", (Parcelable)Uri.fromFile((File)fileUri));
                        intent.putExtra("android.intent.extra.videoQuality", 0);
                        ((ConversationActivity)MultimediaOptionsGridView.this.context).setVideoFileUri(Uri.fromFile((File)fileUri));
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 14);
                        break;
                    }
                    case 5: {
                        Intent intent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
                        intent.setType("vnd.android.cursor.dir/contact");
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 15);
                        break;
                    }
                    case 6: {
                        new ConversationUIService(MultimediaOptionsGridView.this.context).sendPriceMessage();
                        break;
                    }
                }
                MultimediaOptionsGridView.this.multimediaOptions.setVisibility(8);
            }
        });
    }
}

