/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageInfo;
import com.applozic.mobicomkit.api.conversation.MessageInfoResponse;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.List;

public class MessageInfoFragment
extends Fragment {
    public static final String MESSAGE_ARGUMENT_KEY = "MESSAGE";
    Message message = null;
    AttachmentView attachmentView;
    MessageInfoResponse messageInfoResponse;
    private ImageLoader contactImageLoader;
    private ListView readListView;
    private ListView deliveredListView;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.contactImageLoader = new ImageLoader(this.getContext(), this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                AppContactService contactService = new AppContactService(MessageInfoFragment.this.getContext());
                return contactService.downloadContactImage(MessageInfoFragment.this.getContext(), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.contactImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        View view = inflater.inflate(R.layout.applozic_message_info, container, false);
        Bundle bundle = this.getArguments();
        String messageJson = bundle.getString(MESSAGE_ARGUMENT_KEY);
        this.message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
        AttachmentView attachmentView = (AttachmentView)view.findViewById(R.id.applozic_message_info_attachmentview);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.applozic_message_info_progress_bar);
        attachmentView.setProressBar(progressBar);
        attachmentView.setVisibility(this.message.hasAttachment() ? 0 : 8);
        TextView textView = (TextView)view.findViewById(R.id.applozic_message_info_message_text);
        this.readListView = (ListView)view.findViewById(R.id.applozic_message_info_read_list);
        this.deliveredListView = (ListView)view.findViewById(R.id.applozic_message_info_delivered_list_view);
        attachmentView.setMessage(this.message);
        textView.setText((CharSequence)this.message.getMessage());
        new MessageInfoAsyncTask(this.message.getKeyString()).execute(new Void[0]);
        return view;
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    private class ContactViewHolder {
        public TextView displayName;
        public TextView alphabeticImage;
        public TextView adminTextView;
        public TextView lastSeenAtTextView;
        public CircleImageView circleImageView;

        public ContactViewHolder() {
        }

        public ContactViewHolder(TextView displayName, TextView alphabeticImage, TextView adminTextView, TextView lastSeenAtTextView, CircleImageView circleImageView) {
            this.displayName = displayName;
            this.alphabeticImage = alphabeticImage;
            this.adminTextView = adminTextView;
            this.lastSeenAtTextView = lastSeenAtTextView;
            this.circleImageView = circleImageView;
        }

        public TextView getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(TextView displayName) {
            this.displayName = displayName;
        }

        public TextView getAlphabeticImage() {
            return this.alphabeticImage;
        }

        public void setAlphabeticImage(TextView alphabeticImage) {
            this.alphabeticImage = alphabeticImage;
        }

        public TextView getAdminTextView() {
            return this.adminTextView;
        }

        public void setAdminTextView(TextView adminTextView) {
            this.adminTextView = adminTextView;
        }

        public CircleImageView getCircleImageView() {
            return this.circleImageView;
        }

        public void setCircleImageView(CircleImageView circleImageView) {
            this.circleImageView = circleImageView;
        }

        public TextView getLastSeenAtTextView() {
            return this.lastSeenAtTextView;
        }

        public void setLastSeenAtTextView(TextView lastSeenAtTextView) {
            this.lastSeenAtTextView = lastSeenAtTextView;
        }
    }

    private class ContactsAdapter
    extends BaseAdapter {
        List<MessageInfo> messageInfoList;
        private LayoutInflater mInflater;
        BaseContactService contactService;

        public ContactsAdapter() {
        }

        public ContactsAdapter(List<MessageInfo> messageInfoList) {
            this.messageInfoList = messageInfoList;
            this.contactService = new AppContactService(MessageInfoFragment.this.getContext());
            this.mInflater = LayoutInflater.from((Context)MessageInfoFragment.this.getContext());
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            long timeStamp;
            ContactViewHolder holder;
            MessageInfo messageInfo = this.messageInfoList.get(position);
            Contact contact = this.contactService.getContactById(messageInfo.getUserId());
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.contact_users_layout, parent, false);
                holder = new ContactViewHolder();
                holder.displayName = (TextView)convertView.findViewById(R.id.displayName);
                holder.alphabeticImage = (TextView)convertView.findViewById(R.id.alphabeticImage);
                holder.circleImageView = (CircleImageView)convertView.findViewById(R.id.contactImage);
                holder.adminTextView = (TextView)convertView.findViewById(R.id.adminTextView);
                holder.lastSeenAtTextView = (TextView)convertView.findViewById(R.id.lastSeenAtTextView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ContactViewHolder)convertView.getTag();
            }
            holder.displayName.setText((CharSequence)contact.getDisplayName());
            long l = messageInfo.isRead() ? messageInfo.getReadAtTime() : (timeStamp = messageInfo.getDeliveredAtTime() == null ? 0L : messageInfo.getDeliveredAtTime());
            if (timeStamp != 0L) {
                holder.lastSeenAtTextView.setVisibility(0);
                holder.lastSeenAtTextView.setText((CharSequence)String.valueOf(DateUtils.getDateAndTimeForLastSeen((Long)timeStamp)));
            } else {
                holder.lastSeenAtTextView.setVisibility(8);
                holder.lastSeenAtTextView.setText((CharSequence)"");
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getContactNumber().toUpperCase();
                char firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.alphabeticImage.getBackground();
                bgShape.setColor(MessageInfoFragment.this.getContext().getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            if (contact.isDrawableResources()) {
                int drawableResourceId = MessageInfoFragment.this.getContext().getResources().getIdentifier(contact.getrDrawableName(), "drawable", MessageInfoFragment.this.getContext().getPackageName());
                holder.circleImageView.setImageResource(drawableResourceId);
            } else {
                MessageInfoFragment.this.contactImageLoader.loadImage((Object)contact, (ImageView)holder.circleImageView, holder.alphabeticImage);
            }
            return convertView;
        }

        public int getCount() {
            return this.messageInfoList.size();
        }

        public Object getItem(int position) {
            return this.messageInfoList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }
    }

    public class MessageInfoAsyncTask
    extends AsyncTask<Void, Integer, Long> {
        String messageKey;

        public MessageInfoAsyncTask(String messageKey) {
            this.messageKey = messageKey;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Long doInBackground(Void ... params) {
            FragmentActivity context = MessageInfoFragment.this.getActivity();
            MobiComMessageService messageService = new MobiComMessageService((Context)context, MessageIntentService.class);
            MessageInfoFragment.this.messageInfoResponse = messageService.getMessageInfoResponse(this.messageKey);
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (MessageInfoFragment.this.messageInfoResponse.getReadByUserList() != null) {
                ContactsAdapter readAdapter = new ContactsAdapter(MessageInfoFragment.this.messageInfoResponse.getReadByUserList());
                MessageInfoFragment.this.readListView.setAdapter((ListAdapter)readAdapter);
            }
            if (MessageInfoFragment.this.messageInfoResponse.getDeliverdToUserList() != null) {
                ContactsAdapter deliveredAdapter = new ContactsAdapter(MessageInfoFragment.this.messageInfoResponse.getDeliverdToUserList());
                MessageInfoFragment.this.deliveredListView.setAdapter((ListAdapter)deliveredAdapter);
            }
        }
    }
}

