/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets;

import android.content.Context;
import android.content.SharedPreferences;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.uiwidgets.R;

public class ApplozicSetting {
    private Context context;
    public SharedPreferences sharedPreferences;
    private static final String START_NEW_FLOATING_ACTION_BUTTON_DISPLAY = "SETTING_START_NEW_FLOATING_ACTION_BUTTON_DISPLAY";
    private static final String START_NEW_BUTTON_DISPLAY = "SETTING_START_NEW_BUTTON_DISPLAY";
    private static final String NO_CONVERSATION_LABEL = "SETTING_NO_CONVERSATION_LABEL";
    private static final String CONVERSATION_CONTACT_IMAGE_VISIBILITY = "CONVERSATION_CONTACT_IMAGE_VISIBILITY";
    public static final String CUSTOM_MESSAGE_BACKGROUND_COLOR = "CUSTOM_MESSAGE_BACKGROUND_COLOR";
    private static final String SENT_MESSAGE_BACKGROUND_COLOR = "SENT_MESSAGE_BACKGROUND_COLOR";
    private static final String RECEIVED_MESSAGE_BACKGROUND_COLOR = "RECEIVED_MESSAGE_BACKGROUND_COLOR";
    private static final String ONLINE_STATUS_MASTER_LIST = "ONLINE_STATUS_MASTER_LIST";
    private static final String PRICE_WIDGET = "PRICE_WIDGET";
    private static final String SEND_BUTTON_BACKGROUND_COLOR = "SEND_BUTTON_BACKGROUND_COLOR";
    private static final String START_NEW_GROUP = "START_NEW_GROUP";
    private static final String IMAGE_COMPRESSION = "IMAGE_COMPRESSION";
    private static final String MAX_ATTACHMENT_ALLOWED = "MAX_ATTACHMENT_ALLOWED";
    private static final String LOCATION_SHARE_VIA_MAP = "LOCATION_SHARE_VIA_MAP";
    private static final String MAX_ATTACHMENT_SIZE_ALLOWED = "MAX_ATTACHMENT_SIZE_ALLOWED";
    private static final String INVITE_FRIENDS_IN_PEOPLE_ACTIVITY = "INVITE_FRIENDS_IN_PEOPLE_ACTIVITY";
    public static ApplozicSetting applozicSetting;

    private ApplozicSetting(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey((Context)context), 0);
    }

    public static ApplozicSetting getInstance(Context context) {
        if (applozicSetting == null) {
            applozicSetting = new ApplozicSetting(context);
        }
        return applozicSetting;
    }

    public ApplozicSetting setColor(String key, int color2) {
        this.sharedPreferences.edit().putInt(key, color2).commit();
        return this;
    }

    public int getColor(String key) {
        return this.sharedPreferences.getInt(key, R.color.applozic_theme_color_primary);
    }

    public ApplozicSetting setSentMessageBackgroundColor(int color2) {
        this.sharedPreferences.edit().putInt(SENT_MESSAGE_BACKGROUND_COLOR, color2).commit();
        return this;
    }

    public ApplozicSetting setReceivedMessageBackgroundColor(int color2) {
        this.sharedPreferences.edit().putInt(RECEIVED_MESSAGE_BACKGROUND_COLOR, color2).commit();
        return this;
    }

    public int getSentMessageBackgroundColor() {
        return this.sharedPreferences.getInt(SENT_MESSAGE_BACKGROUND_COLOR, R.color.applozic_theme_color_primary);
    }

    public int getReceivedMessageBackgroundColor() {
        return this.sharedPreferences.getInt(RECEIVED_MESSAGE_BACKGROUND_COLOR, R.color.white);
    }

    public ApplozicSetting showOnlineStatusInMasterList() {
        this.sharedPreferences.edit().putBoolean(ONLINE_STATUS_MASTER_LIST, true).commit();
        return this;
    }

    public ApplozicSetting hideOnlineStatusInMasterList() {
        this.sharedPreferences.edit().putBoolean(ONLINE_STATUS_MASTER_LIST, false).commit();
        return this;
    }

    public boolean isOnlineStatusInMasterListVisible() {
        return this.sharedPreferences.getBoolean(ONLINE_STATUS_MASTER_LIST, false);
    }

    public ApplozicSetting showConversationContactImage() {
        this.sharedPreferences.edit().putBoolean(CONVERSATION_CONTACT_IMAGE_VISIBILITY, true).commit();
        return this;
    }

    public ApplozicSetting hideConversationContactImage() {
        this.sharedPreferences.edit().putBoolean(CONVERSATION_CONTACT_IMAGE_VISIBILITY, false).commit();
        return this;
    }

    public boolean isConversationContactImageVisible() {
        return this.sharedPreferences.getBoolean(CONVERSATION_CONTACT_IMAGE_VISIBILITY, true);
    }

    public ApplozicSetting showStartNewButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_BUTTON_DISPLAY, true).commit();
        return this;
    }

    public ApplozicSetting hideStartNewButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_BUTTON_DISPLAY, false).commit();
        return this;
    }

    public boolean isStartNewButtonVisible() {
        return this.sharedPreferences.getBoolean(START_NEW_BUTTON_DISPLAY, false);
    }

    public ApplozicSetting showStartNewFloatingActionButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_FLOATING_ACTION_BUTTON_DISPLAY, true).commit();
        return this;
    }

    public ApplozicSetting hideStartNewFloatingActionButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_FLOATING_ACTION_BUTTON_DISPLAY, false).commit();
        return this;
    }

    public boolean isStartNewFloatingActionButtonVisible() {
        return this.sharedPreferences.getBoolean(START_NEW_BUTTON_DISPLAY, false);
    }

    public String getNoConversationLabel() {
        return this.sharedPreferences.getString(NO_CONVERSATION_LABEL, this.context.getResources().getString(R.string.no_conversation));
    }

    public ApplozicSetting setNoConversationLabel(String label) {
        this.sharedPreferences.edit().putString(NO_CONVERSATION_LABEL, label).commit();
        return this;
    }

    public ApplozicSetting showPriceOption() {
        this.sharedPreferences.edit().putBoolean(PRICE_WIDGET, true).commit();
        return this;
    }

    public ApplozicSetting hidePriceOption() {
        this.sharedPreferences.edit().putBoolean(PRICE_WIDGET, false).commit();
        return this;
    }

    public boolean isPriceOptionVisible() {
        return this.sharedPreferences.getBoolean(PRICE_WIDGET, false);
    }

    public ApplozicSetting setSendButtonBackgroundColor(int color2) {
        this.sharedPreferences.edit().putInt(SEND_BUTTON_BACKGROUND_COLOR, color2).commit();
        return this;
    }

    public int getSendButtonBackgroundColor() {
        return this.sharedPreferences.getInt(SEND_BUTTON_BACKGROUND_COLOR, R.color.applozic_theme_color_primary);
    }

    public ApplozicSetting showStartNewGroupButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_GROUP, true).commit();
        return this;
    }

    public ApplozicSetting hideStartNewGroupButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_GROUP, false).commit();
        return this;
    }

    public boolean isStartNewGroupButtonVisible() {
        return this.sharedPreferences.getBoolean(START_NEW_GROUP, false);
    }

    public ApplozicSetting showInviteFriendsButton() {
        this.sharedPreferences.edit().putBoolean(INVITE_FRIENDS_IN_PEOPLE_ACTIVITY, true).commit();
        return this;
    }

    public ApplozicSetting hideInviteFriendsButton() {
        this.sharedPreferences.edit().putBoolean(INVITE_FRIENDS_IN_PEOPLE_ACTIVITY, false).commit();
        return this;
    }

    public boolean isInviteFriendsButtonVisible() {
        return this.sharedPreferences.getBoolean(INVITE_FRIENDS_IN_PEOPLE_ACTIVITY, false);
    }

    public ApplozicSetting enableImageCompression() {
        MobiComUserPreference.getInstance((Context)this.context).setImageCompressionEnabled(true);
        return this;
    }

    public ApplozicSetting disableImageCompression() {
        MobiComUserPreference.getInstance((Context)this.context).setImageCompressionEnabled(false);
        return this;
    }

    public boolean isImageCompressionEnabled() {
        return MobiComUserPreference.getInstance((Context)this.context).isImageCompressionEnabled();
    }

    public ApplozicSetting setCompressedImageSizeInMB(int size) {
        MobiComUserPreference.getInstance((Context)this.context).setCompressedImageSizeInMB(size);
        return this;
    }

    public ApplozicSetting enableLocationSharingViaMap() {
        this.setLocationSharingViaMap(true);
        return this;
    }

    public ApplozicSetting disableLocationSharingViaMap() {
        this.setLocationSharingViaMap(false);
        return this;
    }

    public boolean isLocationSharingViaMap() {
        return this.sharedPreferences.getBoolean(LOCATION_SHARE_VIA_MAP, true);
    }

    public ApplozicSetting setLocationSharingViaMap(boolean value) {
        this.sharedPreferences.edit().putBoolean(LOCATION_SHARE_VIA_MAP, value).commit();
        return this;
    }

    public int getCompressedImageSizeInMB() {
        return MobiComUserPreference.getInstance((Context)this.context).getCompressedImageSizeInMB();
    }

    public ApplozicSetting setMaxAttachmentAllowed(int maxAttachment) {
        this.sharedPreferences.edit().putInt(MAX_ATTACHMENT_ALLOWED, maxAttachment).commit();
        return this;
    }

    public int getMaxAttachmentAllowed() {
        return this.sharedPreferences.getInt(MAX_ATTACHMENT_ALLOWED, 5);
    }

    public ApplozicSetting setMaxAttachmentSize(int maxAttachmentSize) {
        this.sharedPreferences.edit().putInt(MAX_ATTACHMENT_SIZE_ALLOWED, maxAttachmentSize).commit();
        return this;
    }

    public int getMaxAttachmentSizeAllowed() {
        return this.sharedPreferences.getInt(MAX_ATTACHMENT_SIZE_ALLOWED, 10);
    }

    public boolean clearAll() {
        return this.sharedPreferences.edit().clear().commit();
    }
}

