/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;

public class MobicomLocationActivity
extends AppCompatActivity
implements OnMapReadyCallback,
LocationListener,
GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks,
ActivityCompat.OnRequestPermissionsResultCallback {
    SupportMapFragment mapFragment;
    LatLng position;
    LinearLayout sendLocation;
    private LinearLayout layout;
    public Snackbar snackbar;
    Location mCurrentLocation;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    protected static final long UPDATE_INTERVAL = 5L;
    protected static final long FASTEST_INTERVAL = 1L;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_applozic_location);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_map_screen);
        toolbar.setTitle((CharSequence)"Send Location");
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.sendLocation = (LinearLayout)this.findViewById(R.id.sendLocation);
        this.mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        this.googleApiClient = new GoogleApiClient.Builder((Context)this).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.onNewIntent(this.getIntent());
        this.processLocation();
    }

    public void onMapReady(GoogleMap googleMap) {
        this.position = new LatLng(this.mCurrentLocation.getLatitude(), this.mCurrentLocation.getLongitude());
        googleMap.addMarker(new MarkerOptions().position(this.position).title(""));
        googleMap.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)this.position, (float)20.0f));
        googleMap.animateCamera(CameraUpdateFactory.zoomTo((float)17.0f), 2000, null);
        this.sendLocation.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.i((String)"test", (String)"in map");
                Intent intent = new Intent();
                intent.putExtra("latitude", MobicomLocationActivity.this.mCurrentLocation.getLatitude());
                intent.putExtra("longitude", MobicomLocationActivity.this.mCurrentLocation.getLongitude());
                MobicomLocationActivity.this.setResult(-1, intent);
                MobicomLocationActivity.this.finish();
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        new ConversationUIService((FragmentActivity)this).onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void processingLocation() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    MobicomLocationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)MobicomLocationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    public void processLocation() {
        this.processingLocation();
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onConnected(Bundle bundle) {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return;
            }
            this.mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
            if (this.mCurrentLocation == null) {
                Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
                this.locationRequest = new LocationRequest();
                this.locationRequest.setPriority(100);
                this.locationRequest.setInterval(5L);
                this.locationRequest.setFastestInterval(1L);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
            }
            if (this.mCurrentLocation != null) {
                this.mapFragment.getMapAsync((OnMapReadyCallback)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onLocationChanged(Location location) {
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            if (location != null) {
                this.mCurrentLocation = location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
    }
}

