/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.people.ChannelCreate;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelCreateActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ContactSelectionActivity
extends ActionBarActivity {
    public static final String CHANNEL = "CHANNEL_NAME";
    public static final String CHANNEL_OBJECT = "CHANNEL";
    public static final String CHECK_BOX = "CHECK_BOX";
    ListView mainListView;
    Channel channel;
    private String name;
    private ContactsAdapter mAdapter;
    private ImageLoader mImageLoader;
    private BaseContactService contactService;
    private List<Contact> contactList;
    private ActionBar mActionBar;
    boolean disableCheckBox;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.contact_select_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        if (this.getIntent().getExtras() != null) {
            this.channel = (Channel)this.getIntent().getSerializableExtra(CHANNEL_OBJECT);
            this.disableCheckBox = this.getIntent().getBooleanExtra(CHECK_BOX, false);
            this.mActionBar.setTitle(R.string.channel_member_title);
        } else {
            this.mActionBar.setTitle(R.string.channel_members_title);
        }
        this.mainListView = (ListView)this.findViewById(R.id.mainList);
        this.mainListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View item, int position, long id2) {
                Contact contact = (Contact)ContactSelectionActivity.this.contactList.get(position);
                if (ContactSelectionActivity.this.disableCheckBox) {
                    Intent intent = new Intent();
                    if (!TextUtils.isEmpty((CharSequence)contact.getUserId())) {
                        intent.putExtra("USERID", contact.getUserId());
                    }
                    ContactSelectionActivity.this.setResult(-1, intent);
                    ContactSelectionActivity.this.finish();
                }
                contact.toggleChecked();
                ContactViewHolder viewHolder = (ContactViewHolder)item.getTag();
                viewHolder.getCheckBox().setChecked(contact.isChecked());
            }
        });
        this.mImageLoader = new ImageLoader((Context)this, this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ContactSelectionActivity.this.contactService.downloadContactImage(ContactSelectionActivity.this.getApplicationContext(), (Contact)data);
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mImageLoader.addImageCache(this.getSupportFragmentManager(), 0.1f);
        this.contactService = new AppContactService((Context)this);
        this.contactList = this.contactService.getAll();
        this.mAdapter = new ContactsAdapter((Context)this);
        this.mainListView.setAdapter((ListAdapter)this.mAdapter);
        this.mainListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    Utils.toggleSoftKeyBoard((Activity)ContactSelectionActivity.this, (boolean)true);
                    ContactSelectionActivity.this.mImageLoader.setPauseWork(true);
                } else {
                    ContactSelectionActivity.this.mImageLoader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.group_create_menu, menu2);
        menu2.removeItem(R.id.Next);
        if (this.disableCheckBox) {
            menu2.removeItem(R.id.Done);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.Done) {
            if (this.mAdapter.getResult().size() == 0) {
                Toast.makeText((Context)this, (int)R.string.select_at_least, (int)0).show();
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ContactSelectionActivity.this.name = ContactSelectionActivity.this.getIntent().getStringExtra(ContactSelectionActivity.CHANNEL);
                        List<String> channelMemberNames = null;
                        if (!TextUtils.isEmpty((CharSequence)ContactSelectionActivity.this.name) && ContactSelectionActivity.this.mAdapter.getResult().size() > 0) {
                            channelMemberNames = ContactSelectionActivity.this.mAdapter.getResult();
                            ChannelCreate channelCreate = new ChannelCreate(ContactSelectionActivity.this.name, channelMemberNames);
                            Channel channel = ChannelService.getInstance((Context)ContactSelectionActivity.this).createChannel(channelCreate);
                            if (channel != null) {
                                Intent intent = new Intent(ContactSelectionActivity.this.getApplicationContext(), ConversationActivity.class);
                                intent.putExtra("groupId", (Serializable)channel.getKey());
                                intent.putExtra("groupName", channel.getName());
                                ContactSelectionActivity.this.startActivity(intent);
                            }
                        }
                    }
                }).start();
                ChannelCreateActivity.channelActivity.finish();
                this.finish();
            }
            return true;
        }
        return false;
    }

    public boolean onSupportNavigateUp() {
        this.finish();
        return super.onSupportNavigateUp();
    }

    public void onPause() {
        super.onPause();
        this.mImageLoader.setPauseWork(false);
    }

    private class ContactViewHolder {
        private CheckBox checkBox;
        private TextView textView1;
        private CircleImageView circleImageView;
        private TextView textView2;

        public ContactViewHolder() {
        }

        public ContactViewHolder(TextView textView1, TextView textView2, CheckBox checkBox, CircleImageView circleImageView) {
            this.checkBox = checkBox;
            this.textView1 = textView1;
            this.textView2 = textView2;
            this.circleImageView = circleImageView;
        }

        public CheckBox getCheckBox() {
            return this.checkBox;
        }

        public void setCheckBox(CheckBox checkBox) {
            this.checkBox = checkBox;
        }

        public CircleImageView getCircleImageView() {
            return this.circleImageView;
        }

        public void setCircleImageView(CircleImageView circleImageView) {
            this.circleImageView = circleImageView;
        }

        public TextView getTextView1() {
            return this.textView1;
        }

        public void setTextView1(TextView textView2) {
            this.textView1 = textView2;
        }

        public TextView getTextView2() {
            return this.textView2;
        }

        public void setTextView2(TextView textView2) {
            this.textView2 = textView2;
        }
    }

    private class ContactsAdapter
    extends BaseAdapter {
        Context context;
        CompoundButton.OnCheckedChangeListener myCheckChangList = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ((Contact)buttonView.getTag()).setChecked(isChecked);
            }
        };
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ContactsAdapter(Context context) {
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)ContactSelectionActivity.this, R.style.searchTextHiglight);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            CircleImageView circleImageView;
            CheckBox checkBox;
            TextView text2;
            TextView text1;
            Contact contact = this.getContact(position);
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.contact_select_list_item, parent, false);
                text1 = (TextView)convertView.findViewById(R.id.userId);
                text2 = (TextView)convertView.findViewById(R.id.displayName);
                checkBox = (CheckBox)convertView.findViewById(R.id.checkBox);
                checkBox.setVisibility(0);
                circleImageView = (CircleImageView)convertView.findViewById(R.id.contactImage);
                convertView.setTag((Object)new ContactViewHolder(text1, text2, checkBox, circleImageView));
            } else {
                ContactViewHolder viewHolder = (ContactViewHolder)convertView.getTag();
                checkBox = viewHolder.getCheckBox();
                text1 = viewHolder.getTextView1();
                text2 = viewHolder.getTextView2();
                circleImageView = viewHolder.getCircleImageView();
            }
            if (ContactSelectionActivity.this.disableCheckBox) {
                checkBox.setVisibility(8);
            }
            if (contact.isDrawableResources()) {
                int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
                circleImageView.setImageResource(drawableResourceId);
            } else {
                ContactSelectionActivity.this.mImageLoader.loadImage((Object)contact, (ImageView)circleImageView);
            }
            checkBox.setTag((Object)contact);
            checkBox.setChecked(contact.isChecked());
            checkBox.setOnCheckedChangeListener(this.myCheckChangList);
            text1.setText((CharSequence)contact.getUserId());
            text2.setText((CharSequence)contact.getDisplayName());
            return convertView;
        }

        List<Contact> getContacts() {
            ArrayList<Contact> selectedContactList = new ArrayList<Contact>();
            for (Contact contact : ContactSelectionActivity.this.contactList) {
                if (!contact.isChecked()) continue;
                selectedContactList.add(contact);
            }
            return selectedContactList;
        }

        List<String> getResult() {
            ArrayList<String> membersList = new ArrayList<String>();
            for (Contact contact : this.getContacts()) {
                if (!contact.isChecked()) continue;
                membersList.add(contact.getContactIds());
            }
            return membersList;
        }

        public int getCount() {
            return ContactSelectionActivity.this.contactList.size();
        }

        public Object getItem(int position) {
            return ContactSelectionActivity.this.contactList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        Contact getContact(int position) {
            return (Contact)this.getItem(position);
        }
    }
}

