/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobicomLocationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobicomMultimediaPopupAdapter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MultimediaOptionsGridView {
    private Uri capturedImageUri;
    public PopupWindow showPopup;
    FragmentActivity context;

    public MultimediaOptionsGridView(FragmentActivity context) {
        this.context = context;
    }

    public void showPopup(View view, String[] multimediaIcons, String[] multimediaText) {
        this.showPopup = MultimediaOptionsGridView.newBasicPopupWindow((Context)this.context);
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        View popupView = inflater.inflate(R.layout.mobicom_multimedia_fragment_layout, null);
        GridView multimediaOptions = (GridView)popupView.findViewById(R.id.mobicom_multimedia_options);
        MobicomMultimediaPopupAdapter adap = new MobicomMultimediaPopupAdapter((Context)this.context, multimediaIcons, multimediaText);
        multimediaOptions.setAdapter((ListAdapter)adap);
        this.showPopup.setContentView(popupView);
        this.showPopup.setWidth(-1);
        this.showPopup.setHeight(-2);
        this.showPopup.setAnimationStyle(R.style.Animations_GrowFromTop);
        this.showPopup.showAtLocation(view, 80, 0, 0);
        this.capturedImageUri = null;
        multimediaOptions.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        Intent toMapActivity = new Intent((Context)MultimediaOptionsGridView.this.context, MobicomLocationActivity.class);
                        MultimediaOptionsGridView.this.context.startActivityForResult(toMapActivity, 10);
                        break;
                    }
                    case 1: {
                        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                        if (intent.resolveActivity(MultimediaOptionsGridView.this.context.getApplicationContext().getPackageManager()) == null) break;
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "JPEG_" + timeStamp + "_" + ".jpeg";
                        File photoFile = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionsGridView.this.context, (String)"image/jpeg");
                        if (photoFile == null) break;
                        MultimediaOptionsGridView.this.capturedImageUri = Uri.fromFile((File)photoFile);
                        ConversationActivity.setCapturedImageUri(MultimediaOptionsGridView.this.capturedImageUri);
                        intent.putExtra("output", (Parcelable)MultimediaOptionsGridView.this.capturedImageUri);
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 11);
                        break;
                    }
                    case 2: {
                        Intent intentPick = new Intent((Context)MultimediaOptionsGridView.this.context, MobiComAttachmentSelectorActivity.class);
                        MultimediaOptionsGridView.this.context.startActivityForResult(intentPick, 16);
                        break;
                    }
                    case 3: {
                        ((ConversationActivity)MultimediaOptionsGridView.this.context).showAudioRecordingDialog();
                        break;
                    }
                    case 4: {
                        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "VID_" + timeStamp + "_" + ".mp4";
                        File fileUri = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionsGridView.this.context, (String)"video/mp4");
                        intent.putExtra("output", (Parcelable)Uri.fromFile((File)fileUri));
                        intent.putExtra("android.intent.extra.videoQuality", 0);
                        ((ConversationActivity)MultimediaOptionsGridView.this.context).setVideoFileUri(Uri.fromFile((File)fileUri));
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 14);
                        break;
                    }
                    case 5: {
                        Intent intent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
                        intent.setType("vnd.android.cursor.dir/contact");
                        MultimediaOptionsGridView.this.context.startActivityForResult(intent, 15);
                        break;
                    }
                    case 6: {
                        new ConversationUIService(MultimediaOptionsGridView.this.context).sendPriceMessage();
                        break;
                    }
                }
                MultimediaOptionsGridView.this.showPopup.dismiss();
            }
        });
    }

    public static PopupWindow newBasicPopupWindow(Context context) {
        final PopupWindow window = new PopupWindow(context);
        window.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    window.dismiss();
                    return true;
                }
                return false;
            }
        });
        window.setWidth(-2);
        window.setHeight(-2);
        window.setTouchable(true);
        window.setFocusable(true);
        window.setOutsideTouchable(true);
        window.setBackgroundDrawable((Drawable)new BitmapDrawable());
        return window;
    }
}

