/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.provider.ContactsContract;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.UIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelInfoActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.LocationInfo;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ConversationUIService {
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 101;
    public static final String CONVERSATION_FRAGMENT = "ConversationFragment";
    public static final String QUICK_CONVERSATION_FRAGMENT = "QuickConversationFragment";
    public static final String DISPLAY_NAME = "displayName";
    public static final String USER_ID = "userId";
    public static final String GROUP_ID = "groupId";
    public static final String GROUP_NAME = "groupName";
    public static final String FIRST_TIME_MTEXTER_FRIEND = "firstTimeMTexterFriend";
    public static final String CONTACT_ID = "contactId";
    public static final String CONTACT_NUMBER = "contactNumber";
    public static final String APPLICATION_ID = "applicationId";
    public static final String DEFAULT_TEXT = "defaultText";
    public static final String FINAL_PRICE_TEXT = "Final agreed price ";
    public static final String PRODUCT_TOPIC_ID = "topicId";
    public static final String PRODUCT_IMAGE_URL = "productImageUrl";
    private static final String TAG = "ConversationUIService";
    private static final String APPLICATION_KEY_META_DATA = "com.applozic.application.key";
    public static final String GROUP = "group-";
    public static final String SUCCESS = "success";
    private FragmentActivity fragmentActivity;
    private BaseContactService baseContactService;

    public ConversationUIService(FragmentActivity fragmentActivity) {
        this.fragmentActivity = fragmentActivity;
        this.baseContactService = new AppContactService((Context)fragmentActivity);
    }

    public MobiComQuickConversationFragment getQuickConversationFragment() {
        MobiComQuickConversationFragment quickConversationFragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (quickConversationFragment == null) {
            quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment(this.fragmentActivity, quickConversationFragment, QUICK_CONVERSATION_FRAGMENT);
        }
        return quickConversationFragment;
    }

    public ConversationFragment getConversationFragment() {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            Contact contact = ((ConversationActivity)this.fragmentActivity).getContact();
            Channel channel = ((ConversationActivity)this.fragmentActivity).getChannel();
            conversationFragment = new ConversationFragment(contact, channel);
            ConversationActivity.addFragment(this.fragmentActivity, conversationFragment, CONVERSATION_FRAGMENT);
        }
        return conversationFragment;
    }

    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        TextView textView = (TextView)view.findViewById(R.id.unreadSmsCount);
        textView.setVisibility(8);
        this.openConversationFragment(contact);
    }

    public void openConversationFragment(final Contact contact) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(ConversationUIService.this.fragmentActivity, ConversationUIService.CONVERSATION_FRAGMENT);
                if (conversationFragment == null) {
                    conversationFragment = new ConversationFragment(contact, null);
                    ((MobiComKitActivityInterface)ConversationUIService.this.fragmentActivity).addFragment(conversationFragment);
                } else {
                    conversationFragment.loadConversation(contact);
                }
            }
        });
    }

    public void openConversationFragment(Channel channel) {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            conversationFragment = new ConversationFragment(null, channel);
            ((MobiComKitActivityInterface)this.fragmentActivity).addFragment(conversationFragment);
        } else {
            conversationFragment.loadConversation(channel);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        try {
            if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
                Uri selectedFileUri;
                Uri uri = selectedFileUri = intent == null ? null : intent.getData();
                if (selectedFileUri == null) {
                    ConversationActivity cfr_ignored_0 = (ConversationActivity)this.fragmentActivity;
                    selectedFileUri = ConversationActivity.getCapturedImageUri();
                    ImageUtils.addImageToGallery((String)FilePathFinder.getPath((Context)this.fragmentActivity, (Uri)selectedFileUri), (Context)this.fragmentActivity);
                }
                if (selectedFileUri == null) {
                    Bitmap photo = (Bitmap)(intent != null ? intent.getExtras().get("data") : null);
                    selectedFileUri = ImageUtils.getImageUri((Context)this.fragmentActivity, (Bitmap)photo);
                }
                this.getConversationFragment().loadFile(selectedFileUri);
                Log.i((String)TAG, (String)("File uri: " + selectedFileUri));
            }
            if (requestCode == 101 && resultCode == -1) {
                this.checkForStartNewConversation(intent);
            }
            if (requestCode == 14 && resultCode == -1) {
                Uri selectedFilePath = ((ConversationActivity)this.fragmentActivity).getVideoFileUri();
                if (selectedFilePath != null) {
                    this.getConversationFragment().loadFile(selectedFilePath);
                }
                this.getConversationFragment().sendMessage("", Message.ContentType.VIDEO_MSG.getValue());
            }
            if (requestCode == 15 && resultCode == -1) {
                try {
                    File vCradFile = this.vCard(intent);
                    if (vCradFile != null) {
                        this.getConversationFragment().loadFile(Uri.fromFile((File)vCradFile));
                        this.getConversationFragment().sendMessage("", Message.ContentType.CONTACT_MSG.getValue());
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.fragmentActivity, (CharSequence)"Failed to load Contact: ", (int)0).show();
                    Log.e((String)"Exception::", (String)"Exception", (Throwable)e);
                }
            }
            if (requestCode == 16 && resultCode == -1) {
                ArrayList attachmentList = intent.getParcelableArrayListExtra("multiselect.selectedFiles");
                String messageText = intent.getStringExtra("multiselect.message");
                for (Uri info : attachmentList) {
                    this.getConversationFragment().loadFile(info);
                    this.getConversationFragment().sendMessage(messageText, Message.ContentType.ATTACHMENT.getValue());
                }
            }
            if (requestCode == 10 && resultCode == -1) {
                Log.i((String)"test", (String)"posi");
                Double latitude = intent.getDoubleExtra("latitude", 0.0);
                Double longitude = intent.getDoubleExtra("longitude", 0.0);
                LocationInfo info = new LocationInfo(latitude.doubleValue(), longitude.doubleValue());
                String locationInfo = GsonUtils.getJsonFromObject((Object)info, LocationInfo.class);
                this.sendLocation(locationInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversationThread(final Contact contact, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)ConversationUIService.this.fragmentActivity), contact, channel, (Context)ConversationUIService.this.fragmentActivity).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        name = channel != null ? ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.fragmentActivity).getUserId()) : contact.getDisplayName();
        alertDialog.setTitle((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_title).replace("[name]", name));
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_confir).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void updateLatestMessage(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLatestMessage(message, formattedContactNumber);
    }

    public void removeConversation(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().removeConversation(message, formattedContactNumber);
    }

    public void addMessage(Message message) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        MobiComQuickConversationFragment fragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (fragment != null) {
            fragment.addMessage(message);
        }
    }

    public void updateLastMessage(String keyString, String userId) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLastMessage(keyString, userId);
    }

    public boolean isBroadcastedToGroup(Integer channelKey) {
        if (!BroadcastService.isIndividual()) {
            return false;
        }
        return this.getConversationFragment().isBroadcastedToChannel(channelKey);
    }

    public void syncMessages(Message message, String keyString) {
        String userId = message.getContactIds();
        if (BroadcastService.isIndividual()) {
            ConversationFragment conversationFragment = this.getConversationFragment();
            if (!TextUtils.isEmpty((CharSequence)userId) && userId.equals(conversationFragment.getCurrentUserId()) || conversationFragment.isBroadcastedToChannel(message.getGroupId())) {
                conversationFragment.addMessage(message);
            }
        }
        if (message.getGroupId() == null) {
            this.updateLastMessage(keyString, userId);
        }
    }

    public void downloadConversations(boolean showInstruction) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().downloadConversations(showInstruction);
    }

    public void setLoadMore(boolean loadMore) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().setLoadMore(loadMore);
    }

    public void updateMessageKeyString(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        String userId = message.getContactIds();
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)userId) && conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getUserId()) || conversationFragment.isBroadcastedToChannel(message.getGroupId())) {
            conversationFragment.updateMessageKeyString(message);
        }
    }

    public void deleteMessage(String keyString, String userId) {
        this.updateLastMessage(keyString, userId);
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().deleteMessageFromDeviceList(keyString);
        }
    }

    public void updateLastSeenStatus(String contactId) {
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().updateLastSeenStatus(contactId);
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (conversationFragment.getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateLastSeenStatus();
        }
    }

    public void updateDeliveryStatusForContact(String contactId) {
        this.updateStatus(contactId, false);
    }

    public void updateReadStatusForContact(String contactId) {
        this.updateStatus(contactId, true);
    }

    private void updateStatus(String contactId, boolean markRead) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (!TextUtils.isEmpty((CharSequence)contactId) && conversationFragment.getContact() != null && contactId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateDeliveryStatusForAllMessages(markRead);
        }
    }

    public void updateDeliveryStatus(Message message, String formattedContactNumber) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (conversationFragment.getContact() != null && formattedContactNumber.equals(conversationFragment.getContact().getContactIds()) || conversationFragment.getChannel() != null && message.getGroupId() != null && message.getGroupId().equals(conversationFragment.getChannel().getKey())) {
            conversationFragment.updateDeliveryStatus(message);
        }
    }

    public void deleteConversation(Contact contact, Integer channelKey, String response) {
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().clearList();
        }
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().removeConversation(contact, channelKey, response);
        }
    }

    public void updateUploadFailedStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateUploadFailedStatus(message);
    }

    public void updateDownloadFailed(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().downloadFailed(message);
    }

    public void updateDownloadStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateDownloadStatus(message);
    }

    public void updateName(Integer channelKey) {
        if (BroadcastService.isIndividual()) {
            return;
        }
        this.getQuickConversationFragment().updateUserName(channelKey);
    }

    public void updateTypingStatus(String userId, String isTypingStatus) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        Log.i((String)TAG, (String)("Received typing status for: " + userId));
        if (conversationFragment.getContact() != null && userId.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateUserTypingStatus(userId, isTypingStatus);
        }
    }

    public void updateChannelSync() {
        ((ChannelInfoActivity)this.fragmentActivity).updateChannelList();
    }

    public void startContactActivityForResult(Intent intent, Message message, String messageContent) {
        if (message != null) {
            intent.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)message, message.getClass()));
        }
        if (messageContent != null) {
            intent.putExtra("SHARED_TEXT", messageContent);
        }
        this.fragmentActivity.startActivityForResult(intent, 101);
    }

    public void startContactActivityForResult() {
        this.startContactActivityForResult(null, null);
    }

    public void startContactActivityForResult(Message message, String messageContent) {
        Intent intent = new Intent((Context)this.fragmentActivity, MobiComKitPeopleActivity.class);
        this.startContactActivityForResult(intent, message, messageContent);
    }

    public void sendPriceMessage() {
        try {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity);
            alertDialog.setTitle((CharSequence)"Price");
            alertDialog.setMessage((CharSequence)"Enter your amount");
            final EditText inputText = new EditText((Context)this.fragmentActivity);
            inputText.setInputType(2);
            LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(-1, -1);
            inputText.setLayoutParams((ViewGroup.LayoutParams)linearParams);
            alertDialog.setView((View)inputText);
            alertDialog.setPositiveButton((CharSequence)this.fragmentActivity.getString(R.string.send_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (!TextUtils.isEmpty((CharSequence)inputText.getText().toString())) {
                        ConversationUIService.this.getConversationFragment().sendMessage(inputText.getText().toString(), Message.ContentType.PRICE.getValue());
                    }
                }
            });
            alertDialog.setNegativeButton((CharSequence)this.fragmentActivity.getString(R.string.cancel_text), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            if (!this.fragmentActivity.isFinishing()) {
                alertDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAudioMessage(String selectedFilePath) {
        Log.i((String)"ConversationUIService:", (String)"Send audio message ...");
        if (selectedFilePath != null) {
            Uri uri = Uri.fromFile((File)new File(selectedFilePath));
            this.getConversationFragment().loadFile(uri);
        }
        this.getConversationFragment().sendMessage("", Message.ContentType.AUDIO_MSG.getValue());
    }

    public void checkForStartNewConversation(Intent intent) {
        String defaultText;
        String sharedText;
        String forwardMessage;
        boolean support;
        String messageJson;
        String userId;
        Uri uri;
        Contact contact = null;
        Channel channel = null;
        if ("android.intent.action.SEND".equals(intent.getAction()) && intent.getType() != null) {
            if ("text/plain".equals(intent.getType())) {
                String sharedText2 = intent.getStringExtra("android.intent.extra.TEXT");
                if (sharedText2 != null) {
                    this.startContactActivityForResult(null, sharedText2);
                }
            } else if (intent.getType().startsWith("image/")) {
                // empty if block
            }
        }
        if ((uri = intent.getData()) != null) {
            Long contactId = intent.getLongExtra(CONTACT_ID, 0L);
            if (contactId == 0L) {
                return;
            }
            contact = this.baseContactService.getContactById(String.valueOf(contactId));
        }
        Integer channelKey = intent.getIntExtra(GROUP_ID, -1);
        String channelName = intent.getStringExtra(GROUP_NAME);
        if (channelKey != -1 && channelKey != null && channelKey != 0) {
            channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannel(channelKey);
        }
        if (channel != null && !TextUtils.isEmpty((CharSequence)channelName) && TextUtils.isEmpty((CharSequence)channel.getName())) {
            channel.setName(channelName);
            ChannelService.getInstance((Context)this.fragmentActivity).updateChannel(channel);
        }
        String contactNumber = intent.getStringExtra(CONTACT_NUMBER);
        boolean firstTimeMTexterFriend = intent.getBooleanExtra(FIRST_TIME_MTEXTER_FRIEND, false);
        if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
            contact = this.baseContactService.getContactById(contactNumber);
            if (BroadcastService.isIndividual()) {
                this.getConversationFragment().setFirstTimeMTexterFriend(firstTimeMTexterFriend);
            }
        }
        if (TextUtils.isEmpty((CharSequence)(userId = intent.getStringExtra(USER_ID)))) {
            userId = intent.getStringExtra(CONTACT_ID);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            contact = this.baseContactService.getContactById(userId);
        }
        String applicationId = intent.getStringExtra(APPLICATION_ID);
        if (contact != null) {
            contact.setApplicationId(applicationId);
            this.baseContactService.upsert(contact);
        }
        String fullName = intent.getStringExtra(DISPLAY_NAME);
        if (contact != null && TextUtils.isEmpty((CharSequence)contact.getFullName()) && !TextUtils.isEmpty((CharSequence)fullName)) {
            contact.setFullName(fullName);
            this.baseContactService.upsert(contact);
            new UserClientService((Context)this.fragmentActivity).updateUserDisplayName(userId, fullName);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageJson = intent.getStringExtra("message_json")))) {
            Message message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
            if (message.getGroupId() != null) {
                channel = ChannelService.getInstance((Context)this.fragmentActivity).getChannelByChannelKey(message.getGroupId());
            } else {
                contact = this.baseContactService.getContactById(message.getContactIds());
            }
        }
        if (support = intent.getBooleanExtra("SUPPORT_INTENT_KEY", false)) {
            contact = new Support((Context)this.fragmentActivity).getSupportContact();
        }
        if (contact != null) {
            this.openConversationFragment(contact);
        }
        if (channel != null) {
            this.openConversationFragment(channel);
        }
        if (!TextUtils.isEmpty((CharSequence)(forwardMessage = intent.getStringExtra("forwardMessage")))) {
            Message messageToForward = (Message)GsonUtils.getObjectFromJson((String)forwardMessage, Message.class);
            this.getConversationFragment().forwardMessage(messageToForward, contact);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = intent.getStringExtra("SHARED_TEXT")))) {
            this.getConversationFragment().sendMessage(sharedText);
        }
        if (!TextUtils.isEmpty((CharSequence)(defaultText = intent.getStringExtra(DEFAULT_TEXT)))) {
            this.getConversationFragment().setDefaultText(defaultText);
        }
        String productTopicId = intent.getStringExtra(PRODUCT_TOPIC_ID);
        String productImageUrl = intent.getStringExtra(PRODUCT_IMAGE_URL);
        if (!TextUtils.isEmpty((CharSequence)productTopicId) && !TextUtils.isEmpty((CharSequence)productImageUrl)) {
            try {
                FileMeta fileMeta = new FileMeta();
                fileMeta.setContentType("image");
                fileMeta.setBlobKeyString(productImageUrl);
                this.getConversationFragment().sendProductMessage(productTopicId, fileMeta, contact, Message.ContentType.TEXT_URL.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public File vCard(Intent data) throws Exception {
        Uri contactData = data.getData();
        Cursor cursor = this.fragmentActivity.getContentResolver().query(contactData, null, null, null, null);
        cursor.moveToFirst();
        String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_VCARD_URI, (String)lookupKey);
        String name = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "CONTACT_" + timeStamp + "_" + ".vcf";
        File outputFile = FileClientService.getFilePath((String)imageFileName, (Context)this.fragmentActivity, (String)"text/x-vcard");
        AssetFileDescriptor fd = this.fragmentActivity.getContentResolver().openAssetFileDescriptor(uri, "r");
        FileInputStream fis = fd.createInputStream();
        byte[] buf = new byte[(int)fd.getDeclaredLength()];
        fis.read(buf);
        String cvFdata = new String(buf);
        if (!MobiComVCFParser.validateData((String)cvFdata)) {
            Log.i((String)"vCard ::", (String)cvFdata.toString());
            throw new Exception("contact exported is not proper in proper format");
        }
        Log.i((String)" data:", (String)new String(buf));
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile.getAbsoluteFile());
        fileOutputStream.write(buf);
        fileOutputStream.close();
        return outputFile;
    }

    public void reconnectMQTT() {
        try {
            if (((MobiComKitActivityInterface)this.fragmentActivity).getRetryCount() <= 3 && Utils.isInternetAvailable((Context)this.fragmentActivity)) {
                Log.i((String)TAG, (String)"Reconnecting to mqtt.");
                ((MobiComKitActivityInterface)this.fragmentActivity).retry();
                Intent intent = new Intent((Context)this.fragmentActivity, ApplozicMqttIntentService.class);
                intent.putExtra("subscribe", true);
                this.fragmentActivity.startService(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendLocation(String position) {
        this.getConversationFragment().sendMessage(position, Message.ContentType.LOCATION.getValue());
    }
}

