/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobiComAttachmentGridViewAdapter;
import com.applozic.mobicommons.file.FileUtils;
import java.util.ArrayList;

public class MobiComAttachmentSelectorActivity
extends AppCompatActivity {
    public static final String MULTISELECT_SELECTED_FILES = "multiselect.selectedFiles";
    public static final String MULTISELECT_MESSAGE = "multiselect.message";
    private String TAG = "MultiAttActivity";
    private static int REQUEST_CODE_ATTACH_PHOTO = 10;
    private Button sendAttachment;
    private Button cancelAttachment;
    private EditText messageEditText;
    private GridView galleryImagesGridView;
    private ArrayList<Uri> attachmentFileList = new ArrayList();
    private MobiComAttachmentGridViewAdapter imagesAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mobicom_multi_attachment_activity);
        this.initViews();
        this.setUpGridView();
        Intent getContentIntent = FileUtils.createGetContentIntent();
        getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)this.getString(R.string.select_file));
        this.startActivityForResult(intentPick, REQUEST_CODE_ATTACH_PHOTO);
    }

    private void initViews() {
        this.sendAttachment = (Button)this.findViewById(R.id.mobicom_attachment_send_btn);
        this.cancelAttachment = (Button)this.findViewById(R.id.mobicom_attachment_cancel_btn);
        this.galleryImagesGridView = (GridView)this.findViewById(R.id.mobicom_attachment_grid_View);
        this.messageEditText = (EditText)this.findViewById(R.id.mobicom_attachment_edit_text);
        this.cancelAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                MobiComAttachmentSelectorActivity.this.setResult(0, intent);
                MobiComAttachmentSelectorActivity.this.finish();
            }
        });
        this.sendAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MobiComAttachmentSelectorActivity.this.attachmentFileList.isEmpty()) {
                    Toast.makeText((Context)MobiComAttachmentSelectorActivity.this.getApplicationContext(), (int)R.string.mobicom_select_attachment_text, (int)0).show();
                    return;
                }
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra(MobiComAttachmentSelectorActivity.MULTISELECT_SELECTED_FILES, MobiComAttachmentSelectorActivity.this.attachmentFileList);
                intent.putExtra(MobiComAttachmentSelectorActivity.MULTISELECT_MESSAGE, MobiComAttachmentSelectorActivity.this.messageEditText.getText().toString());
                MobiComAttachmentSelectorActivity.this.setResult(-1, intent);
                MobiComAttachmentSelectorActivity.this.finish();
            }
        });
    }

    private void addUri(Uri uri) {
        this.attachmentFileList.add(uri);
        Log.i((String)this.TAG, (String)("attachmentFileList  :: " + this.attachmentFileList));
    }

    private void setUpGridView() {
        this.imagesAdapter = new MobiComAttachmentGridViewAdapter((Context)this, this.attachmentFileList);
        this.galleryImagesGridView.setAdapter((ListAdapter)this.imagesAdapter);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (resultCode == -1) {
            Uri selectedFileUri = intent == null ? null : intent.getData();
            Log.i((String)this.TAG, (String)("selectedFileUri :: " + selectedFileUri));
            this.addUri(selectedFileUri);
            this.imagesAdapter.notifyDataSetChanged();
        }
    }
}

