/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.file.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MultimediaOptionFragment
extends DialogFragment {
    public static final int RESULT_OK = -1;
    public static final int REQUEST_CODE_TAKE_PHOTO = 11;
    public static final int REQUEST_CODE_ATTACH_PHOTO = 12;
    public static final int REQUEST_CODE_ATTACHE_AUDIO = 13;
    public static final int MEDIA_TYPE_VIDEO = 2;
    public static final int REQUEST_CODE_CAPTURE_VIDEO_ACTIVITY = 14;
    private Uri capturedImageUri;
    private int menuOptionsResourceId = R.array.multimediaOptions_sms;

    public Uri getCapturedImageUri() {
        return this.capturedImageUri;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.capturedImageUri = null;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setItems(this.menuOptionsResourceId, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case 0: {
                        ((ConversationActivity)MultimediaOptionFragment.this.getActivity()).processLocation();
                        break;
                    }
                    case 1: {
                        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                        if (intent.resolveActivity(MultimediaOptionFragment.this.getActivity().getPackageManager()) == null) break;
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "JPEG_" + timeStamp + "_" + ".jpeg";
                        File photoFile = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionFragment.this.getActivity(), (String)"image/jpeg");
                        if (photoFile == null) break;
                        MultimediaOptionFragment.this.capturedImageUri = Uri.fromFile((File)photoFile);
                        ConversationActivity.setCapturedImageUri(MultimediaOptionFragment.this.capturedImageUri);
                        intent.putExtra("output", (Parcelable)MultimediaOptionFragment.this.capturedImageUri);
                        MultimediaOptionFragment.this.getActivity().startActivityForResult(intent, 11);
                        break;
                    }
                    case 2: {
                        Intent getContentIntent = FileUtils.createGetContentIntent();
                        getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                        Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)MultimediaOptionFragment.this.getString(R.string.select_file));
                        MultimediaOptionFragment.this.getActivity().startActivityForResult(intentPick, 12);
                        break;
                    }
                    case 3: {
                        ((ConversationActivity)MultimediaOptionFragment.this.getActivity()).showAudioRecordingDialog();
                        break;
                    }
                    case 4: {
                        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "VID_" + timeStamp + "_" + ".mp4";
                        File fileUri = FileClientService.getFilePath((String)imageFileName, (Context)MultimediaOptionFragment.this.getActivity(), (String)"video/mp4");
                        intent.putExtra("output", (Parcelable)Uri.fromFile((File)fileUri));
                        intent.putExtra("android.intent.extra.videoQuality", 1);
                        ((ConversationActivity)MultimediaOptionFragment.this.getActivity()).setVideoFileUri(Uri.fromFile((File)fileUri));
                        MultimediaOptionFragment.this.getActivity().startActivityForResult(intent, 14);
                        break;
                    }
                    case 5: {
                        new ConversationUIService(MultimediaOptionFragment.this.getActivity()).sendPriceMessage();
                        break;
                    }
                }
            }
        });
        return builder.create();
    }

    public void show(FragmentManager supportFragmentManager, int resourceId) {
        this.menuOptionsResourceId = resourceId;
        this.show(supportFragmentManager, "Attachment options");
    }
}

