/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.channel;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.ListFragment;
import android.text.style.TextAppearanceSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.channel.Channel;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;

public class ChannelFragment
extends ListFragment
implements AdapterView.OnItemClickListener {
    public static final String PACKAGE_TO_EXCLUDE_FOR_INVITE = "net.mobitexter";
    private static final String SHARE_TEXT = "share_text";
    private static String inviteMessage;
    private ChannelAdapter mAdapter;
    private OnContactsInteractionListener mOnChannelSelectedListener;
    private Button shareButton;
    private TextView resultTextView;
    private List<Channel> channelList;
    private boolean syncStatus = true;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.channelList = ChannelService.getInstance((Context)this.getActivity()).getChannelList();
        inviteMessage = Utils.getMetaDataValue((Context)this.getActivity().getApplicationContext(), (String)SHARE_TEXT);
        this.mAdapter = new ChannelAdapter(this.getActivity().getApplicationContext());
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mOnChannelSelectedListener.onGroupSelected(this.channelList.get(position));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        this.shareButton = (Button)view.findViewById(R.id.actionButton);
        this.resultTextView = (TextView)view.findViewById(R.id.result);
        this.resultTextView.setText((CharSequence)"No Groups");
        return view;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mOnChannelSelectedListener = (OnContactsInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnContactsInteractionListener");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.shareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                ArrayList<Intent> targetedShareIntents = new ArrayList<Intent>();
                List resInfo = ChannelFragment.this.getActivity().getPackageManager().queryIntentActivities(intent, 0);
                if (!resInfo.isEmpty()) {
                    for (ResolveInfo resolveInfo : resInfo) {
                        String packageName = resolveInfo.activityInfo.packageName;
                        if (packageName.equals(ChannelFragment.PACKAGE_TO_EXCLUDE_FOR_INVITE)) continue;
                        Intent targetedShareIntent = new Intent("android.intent.action.SEND");
                        targetedShareIntent.setType("text/plain").setAction("android.intent.action.SEND").putExtra("android.intent.extra.TEXT", inviteMessage).setPackage(packageName);
                        targetedShareIntents.add(targetedShareIntent);
                    }
                    Intent chooserIntent = Intent.createChooser((Intent)((Intent)targetedShareIntents.remove(0)), (CharSequence)"Share Via");
                    chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", targetedShareIntents.toArray(new Parcelable[0]));
                    ChannelFragment.this.startActivity(chooserIntent);
                }
            }
        });
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
    }

    private class ChannelAdapter
    extends BaseAdapter {
        Context context;
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ChannelAdapter(Context context) {
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)ChannelFragment.this.getActivity(), R.style.searchTextHiglight);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View itemLayout = this.mInflater.inflate(R.layout.contact_list_item, parent, false);
            Channel channel = (Channel)ChannelFragment.this.channelList.get(position);
            TextView text1 = (TextView)itemLayout.findViewById(R.id.text1);
            TextView text2 = (TextView)itemLayout.findViewById(R.id.text2);
            CircleImageView icon = (CircleImageView)itemLayout.findViewById(R.id.contactImage);
            text1.setText((CharSequence)channel.getName());
            icon.setImageResource(R.drawable.applozic_group_icon);
            return itemLayout;
        }

        public int getCount() {
            return ChannelFragment.this.channelList.size();
        }

        public Object getItem(int position) {
            return ChannelFragment.this.channelList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }
    }
}

