/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.instruction;

import android.app.Activity;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.LinearLayout;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;

public class ApplozicPermissions {
    private LinearLayout snackBarLayout;
    private Activity activity;

    public ApplozicPermissions(Activity activity, LinearLayout linearLayout) {
        this.activity = activity;
        this.snackBarLayout = linearLayout;
    }

    public void checkRuntimePermissionForStorage() {
        if (PermissionsUtils.checkSelfForStoragePermission((Activity)this.activity)) {
            this.requestStoragePermissions();
        }
    }

    public void checkRuntimePermissionForLocation() {
        if (PermissionsUtils.checkSelfPermissionForLocation((Activity)this.activity)) {
            this.requestLocationPermissions();
        } else {
            ((ConversationActivity)this.activity).processingLocation();
        }
    }

    private void requestStoragePermissions() {
        if (PermissionsUtils.shouldShowRequestForStoragePermission((Activity)this.activity)) {
            this.showSnackBar(R.string.storage_permission, PermissionsUtils.PERMISSIONS_STORAGE, 0);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSIONS_STORAGE, (int)0);
        }
    }

    public void requestLocationPermissions() {
        if (PermissionsUtils.shouldShowRequestForLocationPermission((Activity)this.activity)) {
            this.showSnackBar(R.string.location_permission, PermissionsUtils.PERMISSIONS_LOCATION, 1);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSIONS_LOCATION, (int)1);
        }
    }

    public void showSnackBar(int resId, final String[] permissions, final int requestCode) {
        Snackbar.make((View)this.snackBarLayout, (int)resId, (int)-2).setAction(17039370, new View.OnClickListener(){

            public void onClick(View view) {
                PermissionsUtils.requestPermissions((Activity)ApplozicPermissions.this.activity, (String[])permissions, (int)requestCode);
            }
        }).show();
    }
}

