/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.ApplozicMqttService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.uiwidgets.ActivityLifecycleHandler;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.io.Serializable;

public class ConversationActivity
extends ActionBarActivity
implements MessageCommunicator,
MobiComKitActivityInterface,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final String TAKE_ORDER = "takeOrder";
    public static final String CONTACT = "contact";
    protected static final long UPDATE_INTERVAL = 5L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final String CAPTURED_IMAGE_URI = "capturedImageUri";
    private static final String SHARE_TEXT = "share_text";
    private static Uri capturedImageUri;
    private static String inviteMessage;
    protected ConversationFragment conversation;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected ActionBar mActionBar;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private Contact contact;
    public Snackbar snackbar;

    @Override
    public void showErrorMessageView(String message) {
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.footerAd);
        layout2.setVisibility(0);
        this.snackbar = Snackbar.make((View)layout2, (CharSequence)message, (int)0);
        this.snackbar.setAction((CharSequence)"OK", new View.OnClickListener(){

            public void onClick(View view) {
                ConversationActivity.this.snackbar.dismiss();
            }
        });
        this.snackbar.setDuration(0);
        ViewGroup group = (ViewGroup)this.snackbar.getView();
        TextView textView = (TextView)group.findViewById(R.id.snackbar_action);
        textView.setTextColor(-256);
        group.setBackgroundColor(this.getResources().getColor(R.color.error_background_color));
        TextView txtView = (TextView)group.findViewById(R.id.snackbar_text);
        txtView.setMaxLines(5);
        this.snackbar.show();
    }

    public void dismissErrorMessage() {
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
    }

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commit();
        supportFragmentManager.executePendingTransactions();
    }

    protected void onStop() {
        super.onStop();
        boolean background = ActivityLifecycleHandler.isApplicationVisible();
        if (!background) {
            String userKeyString = MobiComUserPreference.getInstance((Context)this).getSuUserKeyString();
            ApplozicMqttService.getInstance((Context)this.getApplicationContext()).disconnectPublish(userKeyString, "0");
        }
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        ApplozicMqttService.getInstance((Context)this).subscribe();
        if (!Utils.isInternetAvailable((Context)this)) {
            String errorMessage = this.getResources().getString(R.string.internet_connection_not_available);
            this.showErrorMessageView(errorMessage);
        }
    }

    protected void onPause() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        super.onPause();
    }

    protected void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        if (capturedImageUri != null) {
            savedInstanceState.putString(CAPTURED_IMAGE_URI, capturedImageUri.toString());
            savedInstanceState.putSerializable(CONTACT, (Serializable)this.contact);
        }
    }

    public boolean onSupportNavigateUp() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            this.getSupportFragmentManager().popBackStack();
            Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
            return true;
        }
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.quickconversion_activity);
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        this.mActionBar = this.getSupportActionBar();
        inviteMessage = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)SHARE_TEXT);
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String[] connectedUsers = new MessageClientService((Context)ConversationActivity.this).getConnectedUsers();
                    ContactDatabase contactDatabase = new ContactDatabase((Context)ConversationActivity.this);
                    if (connectedUsers != null && connectedUsers.length > 0) {
                        for (int i = 0; i <= connectedUsers.length - 1; ++i) {
                            contactDatabase.updateConnectedOrDisconnectedStatus(connectedUsers[i], true);
                        }
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (savedInstanceState != null && !TextUtils.isEmpty((CharSequence)savedInstanceState.getString(CAPTURED_IMAGE_URI))) {
            capturedImageUri = Uri.parse((String)savedInstanceState.getString(CAPTURED_IMAGE_URI));
            this.contact = (Contact)savedInstanceState.getSerializable(CONTACT);
            this.conversation = new ConversationFragment(this.contact);
            ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        } else {
            this.quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        InstructionUtil.showInfo((Context)this, R.string.info_message_sync, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                if (ConversationActivity.this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
                    ConversationActivity.this.finish();
                }
            }
        });
        this.mActionBar.setTitle(R.string.conversations);
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.googleApiClient = new GoogleApiClient.Builder((Context)this).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.onNewIntent(this.getIntent());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
            Log.i((String)"AL", (String)"user is not logged in yet.");
            return;
        }
        try {
            new ConversationUIService((FragmentActivity)this).checkForStartNewConversation(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showActionBar() {
        this.mActionBar.setDisplayShowTitleEnabled(true);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        new ConversationUIService((FragmentActivity)this).onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void processLocation() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    ConversationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)ConversationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        this.conversation = new ConversationFragment(contact);
        ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        this.contact = contact;
    }

    @Override
    public void startContactActivityForResult() {
        new ConversationUIService((FragmentActivity)this).startContactActivityForResult();
    }

    @Override
    public void addFragment(ConversationFragment conversationFragment) {
        ConversationActivity.addFragment((FragmentActivity)this, conversationFragment, "ConversationFragment");
        this.conversation = conversationFragment;
    }

    public void onBackPressed() {
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        if (takeOrder.booleanValue()) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).removeConversation(message, formattedContactNumber);
    }

    public void onConnected(Bundle bundle) {
        Location mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
        if (mCurrentLocation == null) {
            Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
            this.locationRequest = new LocationRequest();
            this.locationRequest.setPriority(100);
            this.locationRequest.setInterval(5L);
            this.locationRequest.setFastestInterval(1L);
            LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
        }
        if (mCurrentLocation != null) {
            this.conversation.attachLocation(mCurrentLocation);
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)this.getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onLocationChanged(Location location) {
        LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
        this.conversation.attachLocation(location);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult((Activity)this, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
        }
    }

    void showErrorDialog(int code) {
        GooglePlayServicesUtil.getErrorDialog((int)code, (Activity)this, (int)9000).show();
    }

    public Contact getContact() {
        return this.contact;
    }

    public static Uri getCapturedImageUri() {
        return capturedImageUri;
    }

    public static void setCapturedImageUri(Uri capturedImageUri) {
        ConversationActivity.capturedImageUri = capturedImageUri;
    }
}

