/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.ActionBarActivity;
import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.selfdestruct.DisappearingMessageTask;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationListView;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComActivityForFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.SpinnerNavItem;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.DetailedConversationAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.TitleNavigationAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MultimediaOptionFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicomkit.uiwidgets.schedule.ConversationScheduler;
import com.applozic.mobicomkit.uiwidgets.schedule.ScheduledTimeHolder;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class MobiComConversationFragment
extends Fragment
implements View.OnClickListener {
    public static final int MAX_ALLOWED_FILE_SIZE = 0x500000;
    private static final String TAG = "MobiComConversation";
    public FrameLayout emoticonsFrameLayout;
    protected String title = "Conversations";
    protected DownloadConversation downloadConversation;
    protected MobiComConversationService conversationService;
    protected TextView infoBroadcast;
    protected Class messageIntentClass;
    protected TextView emptyTextView;
    protected boolean loadMore = true;
    protected Contact contact;
    protected Group group;
    protected EditText messageEditText;
    protected ImageButton sendButton;
    protected ImageButton attachButton;
    protected Spinner sendType;
    protected LinearLayout individualMessageSendLayout;
    protected LinearLayout extendedSendingOptionLayout;
    protected RelativeLayout attachmentLayout;
    protected ProgressBar mediaUploadProgressBar;
    protected View spinnerLayout;
    protected SwipeRefreshLayout swipeLayout;
    protected Button scheduleOption;
    protected ScheduledTimeHolder scheduledTimeHolder = new ScheduledTimeHolder();
    protected Spinner selfDestructMessageSpinner;
    protected ImageView mediaContainer;
    protected TextView attachedFile;
    protected String filePath;
    protected boolean firstTimeMTexterFriend;
    protected MessageCommunicator messageCommunicator;
    protected ConversationListView listView = null;
    protected List<Message> messageList = new ArrayList<Message>();
    protected DetailedConversationAdapter conversationAdapter = null;
    protected Drawable sentIcon;
    protected Drawable deliveredIcon;
    protected ImageButton emoticonsBtn;
    protected Support support;
    protected MultimediaOptionFragment multimediaOptionFragment = new MultimediaOptionFragment();
    protected boolean hideExtendedSendingOptionLayout;
    private EmojiconHandler emojiIconHandler;
    private Bitmap previewThumbnail;

    public void setEmojiIconHandler(EmojiconHandler emojiIconHandler) {
        this.emojiIconHandler = emojiIconHandler;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View list = inflater.inflate(R.layout.mobicom_message_list, container, false);
        this.listView = (ConversationListView)list.findViewById(R.id.messageList);
        this.listView.setScrollToBottomOnSizeChange(Boolean.TRUE);
        this.listView.setDivider(null);
        this.messageList = new ArrayList<Message>();
        this.getActivity().getWindow().setSoftInputMode(3);
        this.individualMessageSendLayout = (LinearLayout)list.findViewById(R.id.individual_message_send_layout);
        this.extendedSendingOptionLayout = (LinearLayout)list.findViewById(R.id.extended_sending_option_layout);
        this.attachmentLayout = (RelativeLayout)list.findViewById(R.id.attachment_layout);
        this.mediaUploadProgressBar = (ProgressBar)this.attachmentLayout.findViewById(R.id.media_upload_progress_bar);
        this.emoticonsFrameLayout = (FrameLayout)list.findViewById(R.id.emojicons_frame_layout);
        this.emoticonsBtn = (ImageButton)list.findViewById(R.id.emoticons_btn);
        if (this.emojiIconHandler == null && this.emoticonsBtn != null) {
            this.emoticonsBtn.setVisibility(8);
        }
        this.spinnerLayout = inflater.inflate(R.layout.mobicom_message_list_header_footer, null);
        this.infoBroadcast = (TextView)this.spinnerLayout.findViewById(R.id.info_broadcast);
        this.emptyTextView = (TextView)this.spinnerLayout.findViewById(R.id.noConversations);
        this.emoticonsBtn.setOnClickListener((View.OnClickListener)this);
        this.listView.addHeaderView(this.spinnerLayout);
        this.sentIcon = this.getResources().getDrawable(R.drawable.applozic_ic_action_message_sent);
        this.deliveredIcon = this.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
        this.listView.setLongClickable(true);
        this.sendButton = (ImageButton)this.individualMessageSendLayout.findViewById(R.id.conversation_send);
        this.attachButton = (ImageButton)this.individualMessageSendLayout.findViewById(R.id.attach_button);
        this.sendType = (Spinner)this.extendedSendingOptionLayout.findViewById(R.id.sendTypeSpinner);
        this.messageEditText = (EditText)this.individualMessageSendLayout.findViewById(R.id.conversation_message);
        this.scheduleOption = (Button)this.extendedSendingOptionLayout.findViewById(R.id.scheduleOption);
        this.mediaContainer = (ImageView)this.attachmentLayout.findViewById(R.id.media_container);
        this.attachedFile = (TextView)this.attachmentLayout.findViewById(R.id.attached_file);
        ImageView closeAttachmentLayout = (ImageView)this.attachmentLayout.findViewById(R.id.close_attachment_layout);
        this.swipeLayout = (SwipeRefreshLayout)list.findViewById(R.id.swipe_container);
        this.swipeLayout.setColorScheme(new int[]{17170459, 17170452, 17170456, 0x1060016});
        this.listView.setMessageEditText(this.messageEditText);
        ArrayAdapter sendTypeAdapter = ArrayAdapter.createFromResource((Context)this.getActivity(), (int)R.array.send_type_options, (int)R.layout.mobiframework_custom_spinner);
        sendTypeAdapter.setDropDownViewResource(R.layout.mobiframework_custom_spinner);
        this.sendType.setAdapter((SpinnerAdapter)sendTypeAdapter);
        this.scheduleOption.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationScheduler conversationScheduler = new ConversationScheduler();
                conversationScheduler.setScheduleOption(MobiComConversationFragment.this.scheduleOption);
                conversationScheduler.setScheduledTimeHolder(MobiComConversationFragment.this.scheduledTimeHolder);
                conversationScheduler.setCancelable(false);
                conversationScheduler.show(MobiComConversationFragment.this.getActivity().getSupportFragmentManager(), "conversationScheduler");
            }
        });
        this.messageEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MobiComConversationFragment.this.sendButton.setVisibility((s == null || s.toString().trim().length() == 0) && TextUtils.isEmpty((CharSequence)MobiComConversationFragment.this.filePath) ? 8 : 0);
                MobiComConversationFragment.this.attachButton.setVisibility(s == null || s.toString().trim().length() == 0 ? 0 : 8);
            }
        });
        this.messageEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
            }
        });
        this.messageEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
                }
            }
        });
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MobiComConversationFragment.this.emoticonsFrameLayout.setVisibility(8);
                MobiComConversationFragment.this.sendMessage(MobiComConversationFragment.this.messageEditText.getText().toString());
                MobiComConversationFragment.this.messageEditText.setText((CharSequence)"");
                MobiComConversationFragment.this.scheduleOption.setText(R.string.ScheduleText);
                if (MobiComConversationFragment.this.scheduledTimeHolder.getTimestamp() != null) {
                    MobiComConversationFragment.this.showScheduleMessageToast();
                }
                MobiComConversationFragment.this.scheduledTimeHolder.resetScheduledTimeHolder();
            }
        });
        closeAttachmentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobiComConversationFragment.this.filePath = null;
                if (MobiComConversationFragment.this.previewThumbnail != null) {
                    MobiComConversationFragment.this.previewThumbnail.recycle();
                }
                MobiComConversationFragment.this.attachmentLayout.setVisibility(8);
            }
        });
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int i) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int amountVisible, int totalItems) {
                if (MobiComConversationFragment.this.loadMore) {
                    int topRowVerticalPosition = MobiComConversationFragment.this.listView == null || MobiComConversationFragment.this.listView.getChildCount() == 0 ? 0 : MobiComConversationFragment.this.listView.getChildAt(0).getTop();
                    MobiComConversationFragment.this.swipeLayout.setEnabled(topRowVerticalPosition >= 0);
                }
            }
        });
        return list;
    }

    public void showScheduleMessageToast() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)MobiComConversationFragment.this.getActivity(), (int)R.string.info_message_scheduled, (int)0).show();
            }
        });
    }

    public void deleteMessageFromDeviceList(String messageKeyString) {
        int messageListSize;
        boolean updateQuickConversation = false;
        for (Message message : this.messageList) {
            if (message.getKeyString() == null || !message.getKeyString().equals(messageKeyString)) continue;
            int position = this.messageList.indexOf(message);
            if (position == this.messageList.size() - 1) {
                updateQuickConversation = true;
            }
            if (message.getScheduledAt() != null && message.getScheduledAt() != 0L) {
                new MessageDatabaseService((Context)this.getActivity()).deleteScheduledMessage(messageKeyString);
            }
            this.messageList.remove(position);
            this.conversationAdapter.notifyDataSetChanged();
            if (!this.messageList.isEmpty()) break;
            this.emptyTextView.setVisibility(0);
            ((MobiComKitActivityInterface)this.getActivity()).removeConversation(message, this.contact.getFormattedContactNumber());
            break;
        }
        if ((messageListSize = this.messageList.size()) > 0 && updateQuickConversation) {
            ((MobiComKitActivityInterface)this.getActivity()).updateLatestMessage(this.messageList.get(messageListSize - 1), this.contact.getFormattedContactNumber());
        }
    }

    public String getCurrentUserId() {
        if (this.contact == null) {
            return "";
        }
        return this.contact.getUserId() != null ? this.contact.getUserId() : this.contact.getFormattedContactNumber();
    }

    public Contact getContact() {
        return this.contact;
    }

    protected void setContact(Contact contact) {
        this.contact = contact;
    }

    public String getFormattedContactNumber() {
        return this.contact != null ? this.contact.getFormattedContactNumber() : null;
    }

    public boolean hasMultiplePhoneNumbers() {
        return this.contact != null && this.contact.hasMultiplePhoneNumbers();
    }

    public MultimediaOptionFragment getMultimediaOptionFragment() {
        return this.multimediaOptionFragment;
    }

    public Spinner getSendType() {
        return this.sendType;
    }

    public Spinner getSelfDestructMessageSpinner() {
        return this.selfDestructMessageSpinner;
    }

    public Button getScheduleOption() {
        return this.scheduleOption;
    }

    public void setFirstTimeMTexterFriend(boolean firstTimeMTexterFriend) {
        this.firstTimeMTexterFriend = firstTimeMTexterFriend;
    }

    public void clearList() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MobiComConversationFragment.this.conversationAdapter != null) {
                    MobiComConversationFragment.this.messageList.clear();
                    MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                }
            }
        });
    }

    public void updateMessage(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MobiComConversationFragment.this.messageList.remove(message);
                MobiComConversationFragment.this.messageList.add(message);
                MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            }
        });
    }

    public void addMessage(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean added = MobiComConversationFragment.this.updateMessageList(message, false);
                if (added) {
                    MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    MobiComConversationFragment.this.listView.smoothScrollToPosition(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.emptyTextView.setVisibility(8);
                }
                MobiComConversationFragment.this.selfDestructMessage(message);
            }
        });
    }

    protected abstract void processMobiTexterUserCheck();

    public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (view.getId() == R.id.messageList) {
            menu2.setHeaderTitle(R.string.messageOptions);
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            int positionInSmsList = info.position - 1;
            if (positionInSmsList < 0 || this.messageList.isEmpty()) {
                return;
            }
            Message message = this.messageList.get(positionInSmsList);
            String[] menuItems = this.getResources().getStringArray(R.array.menu);
            for (int i = 0; i < menuItems.length; ++i) {
                if (message.hasAttachment() && menuItems[i].equals("Copy") || message.isCall() && (menuItems[i].equals("Forward") || menuItems[i].equals("Resend")) || menuItems[i].equals("Resend") && (!message.isSentViaApp() || message.getDelivered().booleanValue()) || menuItems[i].equals("Delete") && (message.isAttachmentUploadInProgress() || TextUtils.isEmpty((CharSequence)message.getKeyString()))) continue;
                menu2.add(0, i, i, (CharSequence)menuItems[i]);
            }
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        String contactNumber;
        super.onCreateOptionsMenu(menu2, inflater);
        String string2 = contactNumber = this.contact != null ? this.contact.getContactNumber() : null;
        if (!TextUtils.isEmpty((CharSequence)contactNumber) && contactNumber.matches("[0-9]+") && contactNumber.length() > 2) {
            menu2.findItem(R.id.dial).setVisible(true);
        } else {
            menu2.findItem(R.id.dial).setVisible(false);
        }
        menu2.removeItem(R.id.start_new);
    }

    public void loadConversation(Contact contact, Group group) {
        if (this.downloadConversation != null) {
            this.downloadConversation.cancel(true);
        }
        BroadcastService.currentUserId = contact.getContactIds();
        if (TextUtils.isEmpty((CharSequence)this.filePath)) {
            this.attachmentLayout.setVisibility(8);
        }
        this.infoBroadcast.setVisibility(group != null ? 0 : 8);
        this.setContact(contact);
        this.setGroup(group);
        this.individualMessageSendLayout.setVisibility(0);
        this.extendedSendingOptionLayout.setVisibility(0);
        this.unregisterForContextMenu((View)this.listView);
        this.clearList();
        this.updateTitle();
        this.swipeLayout.setEnabled(true);
        this.loadMore = true;
        if (this.selfDestructMessageSpinner != null) {
            this.selfDestructMessageSpinner.setSelection(0);
        }
        if (contact != null) {
            this.conversationAdapter = new DetailedConversationAdapter((Context)this.getActivity(), R.layout.mobicom_message_row_view, this.messageList, contact, this.messageIntentClass, this.emojiIconHandler);
        } else if (group != null) {
            this.conversationAdapter = new DetailedConversationAdapter((Context)this.getActivity(), R.layout.mobicom_message_row_view, this.messageList, group, this.messageIntentClass, this.emojiIconHandler);
        }
        this.listView.setAdapter((ListAdapter)this.conversationAdapter);
        this.registerForContextMenu((View)this.listView);
        this.processMobiTexterUserCheck();
        if (contact != null) {
            this.processPhoneNumbers();
            if (!TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
                NotificationManager notificationManager = (NotificationManager)this.getActivity().getSystemService("notification");
                notificationManager.cancel(contact.getContactIds().hashCode());
            }
        }
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, contact, group);
        this.downloadConversation.execute(new Void[0]);
        if (contact != null && this.support.isSupportNumber(contact.getFormattedContactNumber())) {
            this.sendType.setSelection(1);
            this.extendedSendingOptionLayout.setVisibility(8);
            this.messageEditText.setHint(R.string.enter_support_query_hint);
        } else {
            this.messageEditText.setHint(R.string.enter_mt_message_hint);
        }
        if (this.hideExtendedSendingOptionLayout) {
            this.extendedSendingOptionLayout.setVisibility(8);
        }
        this.emoticonsFrameLayout.setVisibility(8);
        InstructionUtil.showInstruction((Context)this.getActivity(), R.string.instruction_go_back_to_recent_conversation_list, 5000, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
    }

    public boolean isBroadcastedToGroup(Long groupId) {
        return this.getGroup() != null && this.getGroup().getGroupId().equals(groupId);
    }

    public Group getGroup() {
        return this.group;
    }

    protected void setGroup(Group group) {
        this.group = group;
    }

    public void updateUploadFailedStatus(Message message) {
        int i = this.messageList.indexOf(message);
        if (i != -1) {
            this.messageList.get(i).setCanceled(true);
            this.conversationAdapter.notifyDataSetChanged();
        }
    }

    public abstract void attachLocation(Location var1);

    public void updateDeliveryStatus(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int index = MobiComConversationFragment.this.messageList.indexOf(message);
                if (index != -1) {
                    MobiComConversationFragment.this.messageList.get(index).setDelivered(Boolean.valueOf(true));
                    View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                    if (view != null) {
                        TextView createdAtTime = (TextView)view.findViewById(R.id.createdAtTime);
                        createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, MobiComConversationFragment.this.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered), null);
                    }
                } else {
                    MobiComConversationFragment.this.messageList.add(message);
                    MobiComConversationFragment.this.listView.smoothScrollToPosition(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size());
                    MobiComConversationFragment.this.emptyTextView.setVisibility(8);
                    MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                }
            }
        });
    }

    public void loadFile(Uri uri) {
        if (uri == null) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.file_not_selected, (int)1).show();
            return;
        }
        this.filePath = FilePathFinder.getPath((Context)this.getActivity(), (Uri)uri);
        if (TextUtils.isEmpty((CharSequence)this.filePath)) {
            Log.i((String)TAG, (String)"Error while fetching filePath");
            this.attachmentLayout.setVisibility(8);
            Toast.makeText((Context)this.getActivity(), (int)R.string.info_file_attachment_error, (int)1).show();
            return;
        }
        Cursor returnCursor = this.getActivity().getContentResolver().query(uri, null, null, null, null);
        if (returnCursor != null) {
            int sizeIndex = returnCursor.getColumnIndex("_size");
            returnCursor.moveToFirst();
            Long fileSize = returnCursor.getLong(sizeIndex);
            if (fileSize > 0x500000L) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.info_attachment_max_allowed_file_size, (int)1).show();
                return;
            }
            this.attachedFile.setText((CharSequence)returnCursor.getString(returnCursor.getColumnIndex("_display_name")));
            returnCursor.close();
        }
        this.attachmentLayout.setVisibility(0);
        String mimeType = FileUtils.getMimeType((Context)this.getActivity(), (Uri)uri);
        if (mimeType != null && mimeType.startsWith("image")) {
            this.attachedFile.setVisibility(8);
            int reqWidth = this.mediaContainer.getWidth();
            int reqHeight = this.mediaContainer.getHeight();
            if (reqWidth == 0 || reqHeight == 0) {
                DisplayMetrics displaymetrics = new DisplayMetrics();
                this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
                reqHeight = displaymetrics.heightPixels;
                reqWidth = displaymetrics.widthPixels;
            }
            this.previewThumbnail = FileUtils.getPreview((String)this.filePath, (int)reqWidth, (int)reqHeight);
            this.mediaContainer.setImageBitmap(this.previewThumbnail);
        } else {
            this.attachedFile.setVisibility(0);
            this.mediaContainer.setImageBitmap(null);
        }
    }

    public synchronized boolean updateMessageList(Message message, boolean update) {
        boolean toAdd;
        boolean bl = toAdd = !this.messageList.contains(message);
        if (update) {
            this.messageList.remove(message);
            this.messageList.add(message);
        } else if (toAdd) {
            this.messageList.add(message);
        }
        return toAdd;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.support = new Support((Context)activity);
        try {
            this.messageCommunicator = (MessageCommunicator)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement interfaceDataCommunicator");
        }
    }

    protected AlertDialog showInviteDialog(int titleId, int messageId) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setMessage((CharSequence)this.getString(messageId).replace("[name]", this.getNameForInviteDialog())).setTitle(titleId);
        builder.setPositiveButton(R.string.invite, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                Intent share = new Intent("android.intent.action.SEND");
                String textToShare = MobiComConversationFragment.this.getActivity().getResources().getString(R.string.invite_message);
                share.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", textToShare);
                MobiComConversationFragment.this.startActivity(Intent.createChooser((Intent)share, (CharSequence)"Share Via"));
                MobiComConversationFragment.this.sendType.setSelection(0);
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                MobiComConversationFragment.this.sendType.setSelection(0);
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
        return dialog;
    }

    public String getNameForInviteDialog() {
        if (this.contact != null) {
            return this.contact.getDisplayName();
        }
        if (this.group != null) {
            return this.group.getName();
        }
        return "";
    }

    public void forwardMessage(Message messageToForward, Contact contact) {
        this.contact = contact;
        this.loadConversation(contact);
        if (messageToForward.isAttachmentDownloaded()) {
            this.filePath = (String)messageToForward.getFilePaths().get(0);
        }
        this.sendMessage(messageToForward.getMessage(), messageToForward.getFileMetas(), messageToForward.getFileMetaKeyStrings());
    }

    public void sendMessage(String message, List<FileMeta> fileMetas, List<String> fileMetaKeyStrings) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance((Context)this.getActivity());
        Message messageToSend = new Message();
        if (this.group != null && this.group.getGroupId() != null) {
            messageToSend.setBroadcastGroupId(this.group.getGroupId());
            ArrayList<String> contactIds = new ArrayList<String>();
            ArrayList<String> toList = new ArrayList<String>();
            for (Contact contact : this.group.getContacts()) {
                if (TextUtils.isEmpty((CharSequence)contact.getContactNumber())) continue;
                toList.add(contact.getContactNumber());
                contactIds.add(contact.getFormattedContactNumber());
            }
            messageToSend.setTo(TextUtils.join((CharSequence)",", toList));
            messageToSend.setContactIds(TextUtils.join((CharSequence)",", contactIds));
        } else {
            messageToSend.setTo(this.contact.getContactIds());
            messageToSend.setContactIds(this.contact.getContactIds());
        }
        messageToSend.setRead(Boolean.TRUE.booleanValue());
        messageToSend.setStoreOnDevice(Boolean.TRUE.booleanValue());
        if (messageToSend.getCreatedAtTime() == null) {
            messageToSend.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + userPreferences.getDeviceTimeOffset()));
        }
        messageToSend.setSendToDevice(Boolean.FALSE.booleanValue());
        messageToSend.setType(this.sendType.getSelectedItemId() == 1L ? Message.MessageType.MT_OUTBOX.getValue() : Message.MessageType.OUTBOX.getValue());
        messageToSend.setTimeToLive(this.getTimeToLive());
        messageToSend.setMessage(message);
        messageToSend.setDeviceKeyString(userPreferences.getDeviceKeyString());
        messageToSend.setScheduledAt(this.scheduledTimeHolder.getTimestamp());
        messageToSend.setSource(Message.Source.MT_MOBILE_APP.getValue());
        if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
            ArrayList<String> filePaths = new ArrayList<String>();
            filePaths.add(this.filePath);
            messageToSend.setFilePaths(filePaths);
        }
        messageToSend.setFileMetaKeyStrings(fileMetaKeyStrings);
        messageToSend.setFileMetas(fileMetas);
        this.conversationService.sendMessage(messageToSend, this.messageIntentClass);
        if (this.selfDestructMessageSpinner != null) {
            this.selfDestructMessageSpinner.setSelection(0);
        }
        this.attachmentLayout.setVisibility(8);
        this.filePath = null;
    }

    private Integer getTimeToLive() {
        if (this.selfDestructMessageSpinner == null || this.selfDestructMessageSpinner.getSelectedItemPosition() <= 1) {
            return null;
        }
        return Integer.parseInt(this.selfDestructMessageSpinner.getSelectedItem().toString().replace("mins", "").replace("min", "").trim());
    }

    public void sendMessage(String message) {
        this.sendMessage(message, null, null);
    }

    public void updateMessageKeyString(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int index = MobiComConversationFragment.this.messageList.indexOf(message);
                if (index != -1) {
                    Message messageListItem = MobiComConversationFragment.this.messageList.get(index);
                    messageListItem.setKeyString(message.getKeyString());
                    messageListItem.setSentToServer(true);
                    messageListItem.setCreatedAtTime(Long.valueOf(message.getSentMessageTimeAtServer()));
                    messageListItem.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
                    View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                    if (view != null) {
                        ProgressBar mediaUploadProgressBarIndividualMessage = (ProgressBar)view.findViewById(R.id.media_upload_progress_bar);
                        mediaUploadProgressBarIndividualMessage.setVisibility(8);
                        TextView createdAtTime = (TextView)view.findViewById(R.id.createdAtTime);
                        if (messageListItem.isTypeOutbox() && !messageListItem.isCall() && !messageListItem.getDelivered().booleanValue() && messageListItem.getScheduledAt() == null) {
                            createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, MobiComConversationFragment.this.support.isSupportNumber(MobiComConversationFragment.this.getCurrentUserId()) ? MobiComConversationFragment.this.deliveredIcon : MobiComConversationFragment.this.sentIcon, null);
                        }
                    }
                }
            }
        });
    }

    public void updateDownloadStatus(final Message message) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int index = MobiComConversationFragment.this.messageList.indexOf(message);
                if (index != -1) {
                    Message smListItem = MobiComConversationFragment.this.messageList.get(index);
                    smListItem.setKeyString(message.getKeyString());
                    smListItem.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
                    View view = MobiComConversationFragment.this.listView.getChildAt(index - MobiComConversationFragment.this.listView.getFirstVisiblePosition() + 1);
                    if (view != null) {
                        RelativeLayout attachmentDownloadProgressLayout = (RelativeLayout)view.findViewById(R.id.attachment_download_progress_layout);
                        attachmentDownloadProgressLayout.setVisibility(8);
                        ImageView preview = (ImageView)view.findViewById(R.id.preview);
                        view.findViewById(R.id.main_attachment_view).setVisibility(8);
                        preview.setVisibility(8);
                    }
                }
            }
        });
    }

    public LayoutInflater getLayoutInflater(Bundle savedInstanceState) {
        return super.getLayoutInflater(savedInstanceState);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.emoticons_btn) {
            if (this.emoticonsFrameLayout.getVisibility() == 0) {
                this.emoticonsFrameLayout.setVisibility(8);
                Utils.toggleSoftKeyBoard((Activity)this.getActivity(), (boolean)false);
            } else {
                Utils.toggleSoftKeyBoard((Activity)this.getActivity(), (boolean)true);
                this.emoticonsFrameLayout.setVisibility(0);
            }
        }
    }

    public void onPause() {
        super.onPause();
        BroadcastService.currentUserId = null;
    }

    public void updateTitle() {
        String title = null;
        if (this.contact != null) {
            title = this.contact.getDisplayName();
        } else if (this.group != null) {
            title = this.group.getName();
        }
        if (title != null) {
            ((ActionBarActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)title);
        }
    }

    public void loadConversation(Group group) {
        this.loadConversation(null, group);
    }

    public void loadConversation(Contact contact) {
        this.loadConversation(contact, null);
    }

    public void deleteConversationThread() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)MobiComConversationFragment.this.getActivity()), MobiComConversationFragment.this.contact, (Context)MobiComConversationFragment.this.getActivity()).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setTitle((CharSequence)this.getActivity().getString(R.string.dialog_delete_conversation_title).replace("[name]", this.getNameForInviteDialog()));
        alertDialog.setMessage((CharSequence)this.getActivity().getString(R.string.dialog_delete_conversation_confir).replace("[name]", this.getNameForInviteDialog()));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    protected void processPhoneNumbers() {
        if (this.contact.hasMultiplePhoneNumbers()) {
            ArrayList<SpinnerNavItem> navSpinner = new ArrayList<SpinnerNavItem>();
            navSpinner.add(new SpinnerNavItem(this.contact, this.contact.getContactNumber(), (String)this.contact.getPhoneNumbers().get(this.contact.getContactNumber()), R.drawable.applozic_ic_action_email));
            for (String phoneNumber : this.contact.getPhoneNumbers().keySet()) {
                if (PhoneNumberUtils.compare((String)this.contact.getContactNumber(), (String)phoneNumber)) continue;
                navSpinner.add(new SpinnerNavItem(this.contact, phoneNumber, (String)this.contact.getPhoneNumbers().get(phoneNumber), R.drawable.applozic_ic_action_email));
            }
            MobiComActivityForFragment activity = (MobiComActivityForFragment)this.getActivity();
            TitleNavigationAdapter adapter = new TitleNavigationAdapter(this.getActivity().getApplicationContext(), navSpinner);
            activity.setNavSpinner(navSpinner);
            activity.setAdapter(adapter);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position - 1;
        if (this.messageList.size() <= position) {
            return true;
        }
        Message message = this.messageList.get(position);
        switch (item.getItemId()) {
            case 0: {
                if (Build.VERSION.SDK_INT < 11) {
                    android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getActivity().getSystemService("clipboard");
                    clipboard.setText((CharSequence)message.getMessage());
                    break;
                }
                ClipboardManager clipboard = (ClipboardManager)this.getActivity().getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"Copied message", (CharSequence)message.getMessage());
                clipboard.setPrimaryClip(clip);
                break;
            }
            case 1: {
                new ConversationUIService(this.getActivity()).startContactActivityForResult(message, null);
                break;
            }
            case 2: {
                Message messageToResend = new Message(message);
                messageToResend.setCreatedAtTime(Long.valueOf(System.currentTimeMillis() + MobiComUserPreference.getInstance((Context)this.getActivity()).getDeviceTimeOffset()));
                this.conversationService.sendMessage(messageToResend, this.messageIntentClass);
                break;
            }
            case 3: {
                String messageKeyString = message.getKeyString();
                new DeleteConversationAsyncTask(this.conversationService, message, this.contact).execute(new Void[0]);
                this.deleteMessageFromDeviceList(messageKeyString);
            }
        }
        return true;
    }

    public void onResume() {
        super.onResume();
        if (this.contact != null || this.group != null) {
            BroadcastService.currentUserId = this.contact.getContactIds();
            String ns = "notification";
            NotificationManager nMgr = (NotificationManager)this.getActivity().getSystemService(ns);
            nMgr.cancel(BroadcastService.currentUserId.hashCode());
            if (this.downloadConversation != null) {
                this.downloadConversation.cancel(true);
            }
            if (this.messageList.isEmpty()) {
                this.loadConversation(this.contact, this.group);
            } else if (MobiComUserPreference.getInstance((Context)this.getActivity()).getNewMessageFlag()) {
                this.loadnewMessageOnResume(this.contact, this.group);
            }
            MobiComUserPreference.getInstance((Context)this.getActivity()).setNewMessageFlag(false);
        }
        this.swipeLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                MobiComConversationFragment.this.downloadConversation = new DownloadConversation((AbsListView)MobiComConversationFragment.this.listView, false, 1, 1, 1, MobiComConversationFragment.this.contact, MobiComConversationFragment.this.group);
                MobiComConversationFragment.this.downloadConversation.execute(new Void[0]);
            }
        });
    }

    public void selfDestructMessage(Message sms) {
        if (Message.MessageType.MT_INBOX.getValue().equals(sms.getType()) && sms.getTimeToLive() != null && sms.getTimeToLive() != 0) {
            new Timer().schedule((TimerTask)new DisappearingMessageTask((Context)this.getActivity(), this.conversationService, sms), sms.getTimeToLive() * 60 * 1000);
        }
    }

    public void loadnewMessageOnResume(Contact contact, Group group) {
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, contact, group);
        this.downloadConversation.execute(new Void[0]);
    }

    public class DownloadConversation
    extends AsyncTask<Void, Integer, Long> {
        private AbsListView view;
        private int firstVisibleItem;
        private int amountVisible;
        private int totalItems;
        private boolean initial;
        private Contact contact;
        private Group group;
        private List<Message> nextSmsList = new ArrayList<Message>();

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems, Contact contact, Group group) {
            this.view = view;
            this.initial = initial;
            this.firstVisibleItem = firstVisibleItem;
            this.amountVisible = amountVisible;
            this.totalItems = totalItems;
            this.contact = contact;
            this.group = group;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MobiComConversationFragment.this.emptyTextView.setVisibility(8);
            MobiComConversationFragment.this.swipeLayout.setRefreshing(true);
            if (!this.initial && MobiComConversationFragment.this.messageList.isEmpty()) {
                AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)MobiComConversationFragment.this.getActivity()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                });
                alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        MobiComConversationFragment.this.loadMore = false;
                    }
                });
                alertDialog.setTitle(R.string.sync_older_messages);
                alertDialog.setCancelable(true);
                alertDialog.create().show();
            }
        }

        protected Long doInBackground(Void ... voids) {
            if (this.initial) {
                Long lastConversationloadTime = MobiComConversationFragment.this.messageList.isEmpty() ? 1L : MobiComConversationFragment.this.messageList.get(MobiComConversationFragment.this.messageList.size() - 1).getCreatedAtTime();
                Log.i((String)MobiComConversationFragment.TAG, (String)(" loading conversation with  lastConversationloadTime " + lastConversationloadTime));
                this.nextSmsList = MobiComConversationFragment.this.conversationService.getMessages(Long.valueOf(lastConversationloadTime + 1L), null, this.contact, this.group);
            } else if (this.firstVisibleItem == 1 && MobiComConversationFragment.this.loadMore && !MobiComConversationFragment.this.messageList.isEmpty()) {
                MobiComConversationFragment.this.loadMore = false;
                Long endTime = MobiComConversationFragment.this.messageList.get(0).getCreatedAtTime();
                this.nextSmsList = MobiComConversationFragment.this.conversationService.getMessages(null, endTime, this.contact, this.group);
            }
            return 0L;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Long result) {
            super.onPostExecute((Object)result);
            if (this.contact != null && !PhoneNumberUtils.compare((String)this.contact.getFormattedContactNumber(), (String)this.contact.getFormattedContactNumber()) || this.nextSmsList.isEmpty()) {
                MobiComConversationFragment.this.swipeLayout.setRefreshing(false);
                MobiComConversationFragment.this.swipeLayout.setEnabled(false);
                return;
            }
            if (this.group != null && !this.group.getGroupId().equals(this.group.getGroupId())) {
                return;
            }
            if (!MobiComConversationFragment.this.messageList.isEmpty() && !this.nextSmsList.isEmpty() && MobiComConversationFragment.this.messageList.get(0).equals((Object)this.nextSmsList.get(this.nextSmsList.size() - 1))) {
                this.nextSmsList.remove(this.nextSmsList.size() - 1);
            }
            for (Message message : this.nextSmsList) {
                MobiComConversationFragment.this.selfDestructMessage(message);
            }
            if (this.initial) {
                MobiComConversationFragment.this.messageList.addAll(this.nextSmsList);
                MobiComConversationFragment.this.emptyTextView.setVisibility(MobiComConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                    MobiComConversationFragment.this.listView.setSelection(MobiComConversationFragment.this.messageList.size() - 1);
                }
            } else if (!this.nextSmsList.isEmpty()) {
                MobiComConversationFragment.this.messageList.addAll(0, this.nextSmsList);
                MobiComConversationFragment.this.listView.setSelection(this.nextSmsList.size());
            }
            if (!MobiComConversationFragment.this.messageList.isEmpty()) {
                for (int i = MobiComConversationFragment.this.messageList.size() - 1; i >= 0 && !MobiComConversationFragment.this.messageList.get(i).isRead(); --i) {
                    MobiComConversationFragment.this.messageList.get(i).setRead(Boolean.TRUE.booleanValue());
                    new MessageDatabaseService((Context)MobiComConversationFragment.this.getActivity()).updateSmsReadFlag(MobiComConversationFragment.this.messageList.get(i).getMessageId().longValue(), true);
                }
            }
            if (MobiComConversationFragment.this.conversationAdapter != null) {
                MobiComConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            }
            MobiComConversationFragment.this.swipeLayout.setRefreshing(false);
            MobiComConversationFragment.this.loadMore = !this.nextSmsList.isEmpty();
        }
    }
}

