/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets;

import android.content.Context;
import android.content.SharedPreferences;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.uiwidgets.R;

public class ApplozicSetting {
    private Context context;
    public SharedPreferences sharedPreferences;
    private static final String START_NEW_FLOATING_ACTION_BUTTON_DISPLAY = "SETTING_START_NEW_FLOATING_ACTION_BUTTON_DISPLAY";
    private static final String START_NEW_BUTTON_DISPLAY = "SETTING_START_NEW_BUTTON_DISPLAY";
    private static final String NO_CONVERSATION_LABEL = "SETTING_NO_CONVERSATION_LABEL";
    public static ApplozicSetting applozicSetting;

    private ApplozicSetting(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey((Context)context), 0);
    }

    public static ApplozicSetting getInstance(Context context) {
        if (applozicSetting == null) {
            applozicSetting = new ApplozicSetting(context);
        }
        return applozicSetting;
    }

    public ApplozicSetting showStartNewButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_BUTTON_DISPLAY, true).commit();
        return this;
    }

    public ApplozicSetting hideStartNewButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_BUTTON_DISPLAY, false).commit();
        return this;
    }

    public boolean isStartNewButtonVisible() {
        return this.sharedPreferences.getBoolean(START_NEW_BUTTON_DISPLAY, true);
    }

    public ApplozicSetting showStartNewFloatingActionButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_FLOATING_ACTION_BUTTON_DISPLAY, true).commit();
        return this;
    }

    public ApplozicSetting hideStartNewFloatingActionButton() {
        this.sharedPreferences.edit().putBoolean(START_NEW_FLOATING_ACTION_BUTTON_DISPLAY, false).commit();
        return this;
    }

    public boolean isStartNewFloatingActionButtonVisible() {
        return this.sharedPreferences.getBoolean(START_NEW_BUTTON_DISPLAY, true);
    }

    public String getNoConversationLabel() {
        return this.sharedPreferences.getString(NO_CONVERSATION_LABEL, this.context.getResources().getString(R.string.no_conversation));
    }

    public ApplozicSetting setNoConversationLabel(String label) {
        this.sharedPreferences.edit().putString(NO_CONVERSATION_LABEL, label).commit();
        return this;
    }
}

