/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.people.contact.AppContactFragment;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.contact.ContactUtils;
import com.applozic.mobicommons.people.group.Group;
import java.io.Serializable;
import java.util.Map;

public class MobiComKitPeopleActivity
extends ActionBarActivity
implements OnContactsInteractionListener,
SearchView.OnQueryTextListener {
    public static final String SHARED_TEXT = "SHARED_TEXT";
    public static final String FORWARD_MESSAGE = "forwardMessage";
    protected SearchView searchView;
    protected String searchTerm;
    AppContactFragment mContactsListFragment;
    private boolean isSearchResultView = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.people_activity);
        ActionBar actionBar = this.getSupportActionBar();
        actionBar.setHomeButtonEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setDisplayShowTitleEnabled(true);
        actionBar.setTitle(R.string.activity_contacts_title);
        this.mContactsListFragment = (AppContactFragment)this.getSupportFragmentManager().findFragmentById(R.id.contact_list);
        this.isSearchResultView = true;
        Intent intent = this.getIntent();
        String searchQuery = intent.getStringExtra("query");
        String title = this.getString(R.string.contacts_list_search_results_title, new Object[]{searchQuery});
        this.setTitle(title);
        if ("android.intent.action.SEARCH".equals(intent.getAction())) {
            this.mContactsListFragment.onQueryTextChange(searchQuery);
        }
    }

    @TargetApi(value=11)
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_contact, menu2);
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconified(false);
        return super.onCreateOptionsMenu(menu2);
    }

    public void onContactSelected(Uri contactUri) {
        Long contactId = ContactUtils.getContactId((ContentResolver)this.getContentResolver(), (Uri)contactUri);
        Map phoneNumbers = ContactUtils.getPhoneNumbers((Context)this.getApplicationContext(), (long)contactId);
        if (phoneNumbers.isEmpty()) {
            Toast toast = Toast.makeText((Context)this.getApplicationContext(), (int)R.string.phone_number_not_present, (int)0);
            toast.setGravity(17, 0, 0);
            toast.show();
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("contactId", (Serializable)contactId);
        intent.setData(contactUri);
        this.finishActivity(intent);
    }

    public void startNewConversation(String contactNumber) {
        Intent intent = new Intent();
        intent.putExtra("userId", contactNumber);
        this.finishActivity(intent);
    }

    public void onGroupSelected(Group group) {
        Intent intent = new Intent();
        intent.putExtra("groupId", (Serializable)group.getGroupId());
        intent.putExtra("groupName", group.getName());
        this.finishActivity(intent);
    }

    public void onCustomContactSelected(Contact contact) {
        Intent intent = new Intent();
        intent.putExtra("userId", contact.getUserId());
        this.finishActivity(intent);
    }

    public void finishActivity(Intent intent) {
        String sharedText;
        String forwardMessage = this.getIntent().getStringExtra(FORWARD_MESSAGE);
        if (!TextUtils.isEmpty((CharSequence)forwardMessage)) {
            intent.putExtra(FORWARD_MESSAGE, forwardMessage);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = this.getIntent().getStringExtra(SHARED_TEXT)))) {
            intent.putExtra(SHARED_TEXT, sharedText);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    public void onSelectionCleared() {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == 16908332) {
            NavUtils.navigateUpFromSameTask((Activity)this);
            return true;
        }
        if (i == R.id.menu_search) {
            this.onSearchRequested();
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onSearchRequested() {
        return !this.isSearchResultView && super.onSearchRequested();
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public boolean onQueryTextSubmit(String query) {
        this.searchTerm = query;
        this.startNewConversation(query);
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.searchTerm = query;
        this.mContactsListFragment.onQueryTextChange(query);
        return false;
    }
}

