/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import com.applozic.mobicommons.people.group.GroupUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuickConversationAdapter
extends BaseAdapter {
    private static Map<Short, Integer> messageTypeColorMap = new HashMap<Short, Integer>();
    private ImageLoader contactImageLoader;
    private Context context;
    private List<Message> messageList;
    private BaseContactService contactService;
    private EmojiconHandler emojiconHandler;
    private long deviceTimeOffset = 0L;

    public QuickConversationAdapter(final Context context, List<Message> messageList, EmojiconHandler emojiconHandler) {
        this.context = context;
        this.emojiconHandler = emojiconHandler;
        this.contactService = new AppContactService(context);
        this.messageList = messageList;
        this.contactImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return QuickConversationAdapter.this.contactService.downloadContactImage((Context)((Activity)context), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.deviceTimeOffset = MobiComUserPreference.getInstance((Context)this.context).getDeviceTimeOffset();
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        View customView = inflater.inflate(R.layout.mobicom_message_row_view, parent, false);
        TextView smTime = (TextView)customView.findViewById(R.id.smTime);
        smTime.setVisibility(8);
        Message message = this.getItem(position);
        if (message != null) {
            Contact contactReceiver;
            TextView smReceivers = (TextView)customView.findViewById(R.id.smReceivers);
            TextView createdAtTime = (TextView)customView.findViewById(R.id.createdAtTime);
            TextView messageTextView = (TextView)customView.findViewById(R.id.message);
            ImageView contactImage = (ImageView)customView.findViewById(R.id.contactImage);
            TextView alphabeticTextView = (TextView)customView.findViewById(R.id.alphabeticImage);
            ImageView sentOrReceived = (ImageView)customView.findViewById(R.id.sentOrReceivedIcon);
            TextView attachedFile = (TextView)customView.findViewById(R.id.attached_file);
            ImageView attachmentIcon = (ImageView)customView.findViewById(R.id.attachmentIcon);
            List<String> items = Arrays.asList(message.getTo().split("\\s*,\\s*"));
            List<String> userIds = null;
            if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
            }
            if ((contactReceiver = this.contactService.getContactReceiver(items, userIds)) != null) {
                String contactInfo = contactReceiver.getDisplayName();
                if (items.size() > 1) {
                    Contact contact2 = this.contactService.getContactById(items.get(1));
                    contactInfo = TextUtils.isEmpty((CharSequence)contactReceiver.getFirstName()) ? contactReceiver.getContactNumber() : contactReceiver.getFirstName() + ", " + (TextUtils.isEmpty((CharSequence)contact2.getFirstName()) ? contact2.getContactNumber() : contact2.getFirstName()) + (items.size() > 2 ? " & others" : "");
                }
                smReceivers.setText((CharSequence)contactInfo);
            }
            if (alphabeticTextView != null && contactReceiver != null) {
                String contactNumber = contactReceiver.getContactNumber().toUpperCase();
                char firstLetter = contactReceiver.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                alphabeticTextView.setTextColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetTextColorMap.get(colorKey).intValue()));
                alphabeticTextView.setBackgroundResource(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue());
            }
            if (contactReceiver.isDrawableResources()) {
                int drawableResourceId = this.context.getResources().getIdentifier(contactReceiver.getrDrawableName(), "drawable", this.context.getPackageName());
                contactImage.setImageResource(drawableResourceId);
            } else {
                this.contactImageLoader.loadImage((Object)contactReceiver, contactImage, alphabeticTextView);
            }
            if (attachedFile != null) {
                attachedFile.setText((CharSequence)"");
                attachedFile.setVisibility(8);
            }
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
            if (message.isSentToMany()) {
                Group drawableResourceId;
                Group group = drawableResourceId = message.getBroadcastGroupId() != null ? GroupUtils.fetchGroup((Context)this.context, (Long)message.getBroadcastGroupId()) : null;
            }
            if (message.hasAttachment() && attachmentIcon != null) {
                String filePath = message.isAttachmentDownloaded() ? (String)message.getFilePaths().get(0) : (message.getFileMetas() != null ? ((FileMeta)message.getFileMetas().get(0)).getName() : "");
                attachmentIcon.setVisibility(0);
                messageTextView.setText((CharSequence)(filePath.substring(filePath.lastIndexOf("/") + 1) + " " + messageTextView.getText()));
            } else {
                messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)message.getMessage(), (EmojiconHandler)this.emojiconHandler));
            }
            customView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    InstructionUtil.hideInstruction(QuickConversationAdapter.this.context, R.string.instruction_open_conversation_thread);
                    ((MobiComKitActivityInterface)QuickConversationAdapter.this.context).onQuickConversationFragmentItemClick(view, contactReceiver);
                }
            });
            if (contactReceiver != null && new Support(this.context).isSupportNumber(contactReceiver.getContactNumber()) && !message.isTypeOutbox()) {
                contactImage.setImageResource(R.drawable.mobicom_ic_launcher);
            }
            if (sentOrReceived != null) {
                if (message.isCall()) {
                    sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                    messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                } else if (this.getItemViewType(position) == 0) {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                } else {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                }
            }
            if (createdAtTime != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)(message.getCreatedAtTime() - this.deviceTimeOffset)));
            }
        }
        return customView;
    }

    public int getCount() {
        return this.messageList.size();
    }

    public Message getItem(int position) {
        return this.messageList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getItemViewType(int position) {
        return this.getItem(position).isTypeOutbox() ? 1 : 0;
    }

    static {
        messageTypeColorMap.put(Message.MessageType.INBOX.getValue(), R.color.message_type_inbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX.getValue(), R.color.message_type_outbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX_SENT_FROM_DEVICE.getValue(), R.color.message_type_outbox_sent_from_device);
        messageTypeColorMap.put(Message.MessageType.MT_INBOX.getValue(), R.color.message_type_mt_inbox);
        messageTypeColorMap.put(Message.MessageType.MT_OUTBOX.getValue(), R.color.message_type_mt_outbox);
        messageTypeColorMap.put(Message.MessageType.CALL_INCOMING.getValue(), R.color.message_type_incoming_call);
        messageTypeColorMap.put(Message.MessageType.CALL_OUTGOING.getValue(), R.color.message_type_outgoing_call);
    }
}

