/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.FullScreenImageActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicommons.commons.core.utils.ContactNumberUtils;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailedConversationAdapter
extends ArrayAdapter<Message> {
    private static final int FILE_THRESOLD_SIZE = 400;
    private static Map<Short, Integer> messageTypeColorMap = new HashMap<Short, Integer>();
    private ImageLoader contactImageLoader;
    private Context context;
    private Contact contact;
    private Group group;
    private boolean individual;
    private Drawable sentIcon;
    private Drawable deliveredIcon;
    private Drawable pendingIcon;
    private Drawable scheduledIcon;
    private ImageLoader imageThumbnailLoader;
    private TextView downloadSizeTextView;
    private EmojiconHandler emojiconHandler;
    private FileClientService fileClientService;
    private MessageDatabaseService messageDatabaseService;
    private BaseContactService contactService;
    private Contact senderContact;
    private long deviceTimeOffset = 0L;
    private Class<?> messageIntentClass;
    private MobiComConversationService conversationService;

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Group group, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, textViewResourceId, messageList, null, group, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Contact contact, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, textViewResourceId, messageList, contact, null, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(Context context, int textViewResourceId, List<Message> messageList, Contact contact, Group group, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        super(context, textViewResourceId, messageList);
        this.messageIntentClass = messageIntentClass;
        this.context = context;
        this.contact = contact;
        this.group = group;
        this.emojiconHandler = emojiconHandler;
        this.individual = contact != null || group != null;
        this.fileClientService = new FileClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.conversationService = new MobiComConversationService(context);
        this.contactService = new AppContactService(context);
        this.senderContact = this.contactService.getContactById(MobiComUserPreference.getInstance((Context)context).getUserId());
        this.contactImageLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.contactService.downloadContactImage((Context)((Activity)DetailedConversationAdapter.this.getContext()), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.imageThumbnailLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.fileClientService.loadThumbnailImage(DetailedConversationAdapter.this.getContext(), (FileMeta)data, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).width, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).height);
            }
        };
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.imageThumbnailLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.sentIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_sent);
        this.deliveredIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
        this.pendingIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_pending);
        this.scheduledIcon = this.getContext().getResources().getDrawable(R.drawable.applozic_ic_action_message_schedule);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Contact receiverContact;
        this.deviceTimeOffset = MobiComUserPreference.getInstance((Context)this.context).getDeviceTimeOffset();
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View customView = this.getItemViewType(position) == 0 ? inflater.inflate(R.layout.mobicom_received_message_list_view, parent, false) : inflater.inflate(R.layout.mobicom_sent_message_list_view, parent, false);
        final Message message = (Message)this.getItem(position);
        List<String> items = Arrays.asList(message.getTo().split("\\s*,\\s*"));
        List<String> userIds = null;
        if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
            userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
        }
        if (this.group != null) {
            receiverContact = null;
        } else if (this.individual) {
            receiverContact = this.contact;
            this.contact.setContactNumber(items.get(0));
            if (userIds != null) {
                this.contact.setUserId(userIds.get(0));
            }
            this.contact.setFormattedContactNumber(ContactNumberUtils.getPhoneNumber((String)items.get(0), (String)MobiComUserPreference.getInstance((Context)this.context).getCountryCode()));
        } else {
            receiverContact = this.contactService.getContactReceiver(items, userIds);
        }
        if (message != null) {
            View messageTextLayout = customView.findViewById(R.id.messageTextLayout);
            TextView smReceivers = (TextView)customView.findViewById(R.id.smReceivers);
            TextView createdAtTime = (TextView)customView.findViewById(R.id.createdAtTime);
            TextView messageTextView = (TextView)customView.findViewById(R.id.message);
            ImageView contactImage = (ImageView)customView.findViewById(R.id.contactImage);
            TextView alphabeticTextView = (TextView)customView.findViewById(R.id.alphabeticImage);
            ImageView sentOrReceived = (ImageView)customView.findViewById(R.id.sentOrReceivedIcon);
            TextView deliveryStatus = (TextView)customView.findViewById(R.id.status);
            TextView selfDestruct = (TextView)customView.findViewById(R.id.selfDestruct);
            ImageView preview = (ImageView)customView.findViewById(R.id.preview);
            final AttachmentView attachmentView = (AttachmentView)customView.findViewById(R.id.main_attachment_view);
            TextView attachedFile = (TextView)customView.findViewById(R.id.attached_file);
            ImageView attachmentIcon = (ImageView)customView.findViewById(R.id.attachmentIcon);
            this.downloadSizeTextView = (TextView)customView.findViewById(R.id.attachment_size_text);
            final LinearLayout attachmentDownloadLayout = (LinearLayout)customView.findViewById(R.id.attachment_download_layout);
            final LinearLayout attachmentRetry = (LinearLayout)customView.findViewById(R.id.attachment_retry_layout);
            final RelativeLayout attachmentDownloadProgressLayout = (RelativeLayout)customView.findViewById(R.id.attachment_download_progress_layout);
            RelativeLayout mainAttachmentLayout = (RelativeLayout)customView.findViewById(R.id.attachment_preview_layout);
            final ProgressBar mediaDownloadProgressBar = (ProgressBar)customView.findViewById(R.id.media_download_progress_bar);
            final ProgressBar mediaUploadProgressBar = (ProgressBar)customView.findViewById(R.id.media_upload_progress_bar);
            if (attachedFile != null) {
                attachedFile.setText((CharSequence)"");
                attachedFile.setVisibility(8);
            }
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
            attachmentDownloadLayout.setVisibility(8);
            preview.setVisibility(message.hasAttachment() ? 0 : 8);
            attachmentView.setVisibility(8);
            if (message.isTypeOutbox() && !message.isCanceled()) {
                mediaUploadProgressBar.setVisibility(message.isAttachmentUploadInProgress() ? 0 : 8);
            } else {
                mediaUploadProgressBar.setVisibility(8);
            }
            if (attachedFile != null) {
                attachedFile.setVisibility(message.hasAttachment() ? 0 : 8);
            }
            if (this.individual && message.getTimeToLive() != null) {
                selfDestruct.setText((CharSequence)("Self destruct in " + message.getTimeToLive() + " mins"));
                selfDestruct.setVisibility(0);
            } else {
                selfDestruct.setText((CharSequence)"");
                selfDestruct.setVisibility(8);
            }
            if (attachedFile != null) {
                attachedFile.setTextColor(-16777216);
            }
            if (sentOrReceived != null) {
                if (!message.isCall() || message.isDummyEmptyMessage()) {
                    sentOrReceived.setVisibility(8);
                } else if (message.isCall()) {
                    sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                } else if (this.getItemViewType(position) == 0) {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                } else {
                    sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                }
                if (message.isCall()) {
                    messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                }
            }
            if (message.isCall() || message.isDummyEmptyMessage()) {
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            } else if (message.getKeyString() == null && !message.isSentToServer() && message.isTypeOutbox()) {
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, message.getScheduledAt() != null ? this.scheduledIcon : this.pendingIcon, null);
            } else if (message.getKeyString() != null && message.isTypeOutbox() && message.isSentToServer()) {
                createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, message.getDelivered() != false || this.contact != null && new Support(this.context).isSupportNumber(this.contact.getFormattedContactNumber()) ? this.deliveredIcon : (message.getScheduledAt() != null ? this.scheduledIcon : this.sentIcon), null);
            }
            if (message.isCall()) {
                deliveryStatus.setText((CharSequence)"");
            }
            if (message.isTypeOutbox()) {
                this.loadContactImage(this.senderContact, contactImage, alphabeticTextView);
            } else {
                this.loadContactImage(receiverContact, contactImage, alphabeticTextView);
            }
            if (message.hasAttachment() && attachedFile != null) {
                mainAttachmentLayout.setLayoutParams(this.getImageLayoutParam(false));
                if (message.getFileMetas() != null && ((FileMeta)message.getFileMetas().get(0)).getContentType().contains("image")) {
                    attachedFile.setVisibility(8);
                }
                if (message.isAttachmentDownloaded()) {
                    preview.setVisibility(8);
                    String[] filePaths = new String[message.getFilePaths().size()];
                    int i = 0;
                    for (String filePath : message.getFilePaths()) {
                        filePaths[i++] = filePath;
                        String mimeType = FileUtils.getMimeType((String)filePath);
                        if (mimeType != null && mimeType.startsWith("image")) {
                            attachmentView.setMessage(message);
                            attachmentView.setProressBar(mediaDownloadProgressBar);
                            attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                            attachmentView.setVisibility(0);
                            attachedFile.setVisibility(8);
                            continue;
                        }
                        this.showAttachmentIconAndText(attachedFile, message, mimeType);
                    }
                } else if (message.isAttachmentUploadInProgress()) {
                    attachmentDownloadProgressLayout.setVisibility(0);
                    attachmentView.setProressBar(mediaDownloadProgressBar);
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    attachmentView.setMessage(message);
                    attachmentView.setVisibility(0);
                } else if (AttachmentManager.isAttachmentInProgress((String)message.getKeyString())) {
                    attachmentView.setMessage(message);
                    attachmentView.setVisibility(0);
                    attachmentView.setProressBar(mediaDownloadProgressBar);
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    this.showPreview(message, preview, attachmentDownloadLayout);
                    FileMeta fileMeta = (FileMeta)message.getFileMetas().get(0);
                    String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                    if (!fileMeta.getContentType().contains("image")) {
                        this.showAttachmentIconAndText(attachedFile, message, mimeType);
                    }
                    this.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                    attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                    attachmentDownloadProgressLayout.setVisibility(0);
                } else {
                    String[] fileKeys = new String[message.getFileMetaKeyStrings().size()];
                    int i = 0;
                    this.showPreview(message, preview, attachmentDownloadLayout);
                    for (String fileKey : message.getFileMetaKeyStrings()) {
                        fileKeys[i++] = fileKey;
                        if (message.getFileMetas() == null) continue;
                        FileMeta fileMeta = (FileMeta)message.getFileMetas().get(0);
                        attachmentDownloadLayout.setVisibility(0);
                        attachmentDownloadProgressLayout.setVisibility(8);
                        this.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                        String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                        if (fileMeta.getContentType().contains("image")) continue;
                        this.showAttachmentIconAndText(attachedFile, message, mimeType);
                    }
                }
            }
            if (message.isCanceled()) {
                attachmentRetry.setVisibility(0);
            }
            attachmentRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Toast.makeText((Context)DetailedConversationAdapter.this.context, (CharSequence)"Resending attachment....", (int)1).show();
                    mediaUploadProgressBar.setVisibility(0);
                    attachmentRetry.setVisibility(8);
                    message.setCanceled(false);
                    DetailedConversationAdapter.this.messageDatabaseService.updateCanceledFlag(message.getMessageId().longValue(), 0);
                    DetailedConversationAdapter.this.conversationService.sendMessage(message, DetailedConversationAdapter.this.messageIntentClass);
                }
            });
            attachmentDownloadProgressLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    attachmentView.setVisibility(8);
                    attachmentView.cancelDownload();
                    attachmentDownloadLayout.setVisibility(0);
                    attachmentDownloadProgressLayout.setVisibility(8);
                    message.setAttDownloadInProgress(false);
                }
            });
            preview.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (message.isAttachmentDownloaded()) {
                        DetailedConversationAdapter.this.showFullView(message);
                    } else {
                        attachmentDownloadLayout.setVisibility(8);
                        attachmentView.setProressBar(mediaDownloadProgressBar);
                        attachmentView.setDownloadProgressLayout(attachmentDownloadProgressLayout);
                        attachmentView.setMessage(message);
                        attachmentView.setVisibility(0);
                        attachmentDownloadProgressLayout.setVisibility(0);
                    }
                }
            });
            attachmentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DetailedConversationAdapter.this.showFullView(message);
                }
            });
            attachmentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
            if (attachedFile != null) {
                attachedFile.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        return false;
                    }
                });
            }
            if (message.getScheduledAt() != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getScheduledAt()));
            } else if (createdAtTime != null && message.isDummyEmptyMessage()) {
                createdAtTime.setText((CharSequence)"");
            } else if (createdAtTime != null) {
                createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)(message.getCreatedAtTime() - this.deviceTimeOffset)));
            }
            String mimeType = "";
            if (messageTextView != null) {
                messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)message.getMessage(), (EmojiconHandler)this.emojiconHandler));
                if (mimeType != null && attachmentIcon != null) {
                    if (mimeType.startsWith("image")) {
                        attachmentIcon.setImageResource(R.drawable.applozic_ic_action_camera);
                    } else if (mimeType.startsWith("video")) {
                        attachmentIcon.setImageResource(R.drawable.applozic_ic_action_video);
                    }
                }
                if (messageTextLayout != null) {
                    messageTextLayout.setBackgroundResource(messageTypeColorMap.get(message.getType()).intValue());
                    if (message.hasAttachment()) {
                        messageTextLayout.setLayoutParams(this.getImageLayoutParam(message.isTypeOutbox()));
                        customView.findViewById(R.id.messageTextInsideLayout).setBackgroundResource(R.color.attachment_background_color);
                    }
                }
            }
        }
        return customView;
    }

    private void loadContactImage(Contact contact, ImageView contactImage, TextView alphabeticTextView) {
        if (contact.isDrawableResources()) {
            int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
            contactImage.setImageResource(drawableResourceId);
        } else {
            this.contactImageLoader.loadImage((Object)contact, contactImage, alphabeticTextView);
        }
        if (alphabeticTextView != null) {
            String contactNumber = contact.getContactNumber().toUpperCase();
            char firstLetter = contact.getDisplayName().charAt(0);
            if (firstLetter != '+') {
                alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
            } else if (contactNumber.length() >= 2) {
                alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
            }
            Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
            alphabeticTextView.setTextColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetTextColorMap.get(colorKey).intValue()));
            alphabeticTextView.setBackgroundResource(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue());
        }
    }

    private void showAttachmentIconAndText(TextView attachedFile, final Message message, final String mimeType) {
        String fileName = "";
        fileName = message.isAttachmentDownloaded() ? ((String)message.getFilePaths().get(0)).substring(((String)message.getFilePaths().get(0)).lastIndexOf("/") + 1) : ((FileMeta)message.getFileMetas().get(0)).getName();
        attachedFile.setText((CharSequence)fileName);
        attachedFile.setVisibility(0);
        attachedFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.isAttachmentDownloaded()) {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    intent.setDataAndType(Uri.fromFile((File)new File((String)message.getFilePaths().get(0))), mimeType);
                    if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                        DetailedConversationAdapter.this.context.startActivity(intent);
                    } else {
                        Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                    }
                }
            }
        });
    }

    private void showPreview(Message smListItem, ImageView preview, LinearLayout attachmentDownloadLayout) {
        FileMeta fileMeta = (FileMeta)smListItem.getFileMetas().get(0);
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.imageThumbnailLoader.setLoadingImage(R.id.media_upload_progress_bar);
        this.imageThumbnailLoader.loadImage((Object)fileMeta, preview);
        attachmentDownloadLayout.setVisibility(8);
    }

    private void showFullView(Message smListItem) {
        Intent intent = new Intent(this.context, FullScreenImageActivity.class);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)smListItem, Message.class));
        ((MobiComKitActivityInterface)this.context).startActivityForResult(intent, 301);
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        return ((Message)this.getItem(position)).isTypeOutbox() ? 1 : 0;
    }

    public ViewGroup.LayoutParams getImageLayoutParam(boolean outBoxType) {
        RelativeLayout.LayoutParams params;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        float wt_px = TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        if (outBoxType) {
            params = new RelativeLayout.LayoutParams(metrics.widthPixels, -2);
            params.setMargins((int)wt_px, 0, (int)wt_px, 0);
        } else {
            params = new LinearLayout.LayoutParams(metrics.widthPixels - (int)wt_px * 2, -2);
            params.setMargins(0, 0, 0, 0);
        }
        return params;
    }

    static {
        messageTypeColorMap.put(Message.MessageType.INBOX.getValue(), R.color.message_type_inbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX.getValue(), R.color.message_type_outbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX_SENT_FROM_DEVICE.getValue(), R.color.message_type_outbox_sent_from_device);
        messageTypeColorMap.put(Message.MessageType.MT_INBOX.getValue(), R.color.message_type_mt_inbox);
        messageTypeColorMap.put(Message.MessageType.MT_OUTBOX.getValue(), R.color.message_type_mt_outbox);
        messageTypeColorMap.put(Message.MessageType.CALL_INCOMING.getValue(), R.color.message_type_incoming_call);
        messageTypeColorMap.put(Message.MessageType.CALL_OUTGOING.getValue(), R.color.message_type_outgoing_call);
    }
}

