/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.io.Serializable;

public class ConversationActivity
extends ActionBarActivity
implements MessageCommunicator,
MobiComKitActivityInterface,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final String TAKE_ORDER = "takeOrder";
    protected static final long UPDATE_INTERVAL = 5L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static Uri capturedImageUri;
    protected ConversationFragment conversation;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected ActionBar mActionBar;
    protected GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private Contact contact;

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commit();
        supportFragmentManager.executePendingTransactions();
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
    }

    protected void onPause() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        super.onPause();
    }

    protected void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        if (capturedImageUri != null) {
            savedInstanceState.putString("capturedImageUri", capturedImageUri.toString());
            savedInstanceState.putSerializable("contact", (Serializable)this.contact);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.quickconversion_activity);
        this.mActionBar = this.getSupportActionBar();
        if (savedInstanceState != null && !TextUtils.isEmpty((CharSequence)savedInstanceState.getString("capturedImageUri"))) {
            capturedImageUri = Uri.parse((String)savedInstanceState.getString("capturedImageUri"));
            this.contact = (Contact)savedInstanceState.getSerializable("contact");
            this.conversation = new ConversationFragment(this.contact);
            ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        } else {
            this.quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        InstructionUtil.showInfo((Context)this, R.string.info_message_sync, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                if (ConversationActivity.this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
                    ConversationActivity.this.finish();
                }
            }
        });
        this.mActionBar.setTitle(R.string.conversations);
        this.googleApiClient = new GoogleApiClient.Builder((Context)this).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        new ConversationUIService((FragmentActivity)this).checkForStartNewConversation(this.getIntent());
    }

    private void showActionBar() {
        this.mActionBar.setDisplayShowTitleEnabled(true);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.mobicom_basic_menu_for_normal_message, menu2);
        if (!ApplozicSetting.getInstance((Context)this).isStartNewButtonVisible()) {
            menu2.removeItem(R.id.start_new);
        }
        this.showActionBar();
        return true;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        new ConversationUIService((FragmentActivity)this).onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                this.googleApiClient.connect();
            } else {
                Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
            }
            return;
        }
    }

    public void processLocation() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    ConversationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)ConversationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.connect();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.start_new) {
            new ConversationUIService((FragmentActivity)this).startContactActivityForResult();
        } else if (id2 == R.id.refresh) {
            String message = this.getString(R.string.info_message_sync);
            new MobiComMessageService((Context)this, MessageIntentService.class).syncMessagesWithServer(message);
        } else {
            if (id2 == R.id.shareOptions) {
                Intent intent = new Intent("android.intent.action.SEND");
                String textToShare = this.getResources().getString(R.string.invite_message);
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", textToShare);
                this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share Via"));
                return super.onOptionsItemSelected(item);
            }
            if (id2 == R.id.deleteConversation) {
                this.conversation.deleteConversationThread();
            }
        }
        return false;
    }

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        this.conversation = new ConversationFragment(contact);
        ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        this.contact = contact;
    }

    @Override
    public void startContactActivityForResult() {
        new ConversationUIService((FragmentActivity)this).startContactActivityForResult();
    }

    public void onBackPressed() {
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        if (takeOrder.booleanValue()) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        new ConversationUIService((FragmentActivity)this).removeConversation(message, formattedContactNumber);
    }

    public void onConnected(Bundle bundle) {
        Location mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
        if (mCurrentLocation == null) {
            Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
            this.locationRequest = new LocationRequest();
            this.locationRequest.setPriority(100);
            this.locationRequest.setInterval(5L);
            this.locationRequest.setFastestInterval(1L);
            LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
        }
        if (mCurrentLocation != null) {
            this.conversation.attachLocation(mCurrentLocation);
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)this.getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onLocationChanged(Location location) {
        LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
        this.conversation.attachLocation(location);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult((Activity)this, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
        }
    }

    void showErrorDialog(int code) {
        GooglePlayServicesUtil.getErrorDialog((int)code, (Activity)this, (int)9000).show();
    }

    public Contact getContact() {
        return this.contact;
    }

    public static Uri getCapturedImageUri() {
        return capturedImageUri;
    }

    public static void setCapturedImageUri(Uri capturedImageUri) {
        ConversationActivity.capturedImageUri = capturedImageUri;
    }
}

